/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.imprt.cubingServices;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.FmUsage;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.Section;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.fmmd.util.CrnIDHelper;
import com.ibm.cognos.fmeng.imprt.cubingServices.CsDimensionBuilder;
import com.ibm.cognos.fmeng.imprt.cubingServices.CsMeasureDimensionBuilder;
import com.ibm.cognos.fmeng.imprt.cubingServices.CsModelImportFeedback;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdSource;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CsCubeBuilder {
    private FMMDSession mSession;
    private Section mParent;
    private Element mCSModelRoot;
    private CsModelImportFeedback mFeedback;
    private MdSource m_MasterSource;

    public static CsModelImportFeedback importAllCubes(FMMDSession session, MdSource cubeDataSrc, Section objParent, String csModelPath) {
        FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.CUBING_SERVICES_IMPORT, session, "Begin importing model: " + csModelPath);
        Element elmCSModelRoot = null;
        try {
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read(new File(csModelPath));
            elmCSModelRoot = document.getRootElement();
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        List elmCubes = elmCSModelRoot.selectNodes("//olap:cubeModel/olap:cube");
        CsCubeBuilder cubeBuilder = new CsCubeBuilder(session, cubeDataSrc, objParent, csModelPath, elmCSModelRoot);
        for (Element elmCube : elmCubes) {
            Cube objCube = cubeBuilder.importCube(elmCube);
            cubeBuilder.getFeedback().addImportedCube(objCube);
        }
        CsModelImportFeedback feedback = cubeBuilder.getFeedback();
        feedback.render(session.getActiveLocale());
        FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.CUBING_SERVICES_IMPORT, session, "End importing model");
        return feedback;
    }

    private CsCubeBuilder(FMMDSession session, MdSource cubeDataSrc, Section objParent, String csModelPath, Element elmCSModelRoot) {
        this.mSession = session;
        this.m_MasterSource = cubeDataSrc;
        this.mParent = objParent;
        this.mCSModelRoot = elmCSModelRoot;
        this.mFeedback = new CsModelImportFeedback(csModelPath);
    }

    private CsModelImportFeedback getFeedback() {
        return this.mFeedback;
    }

    private Cube importCube(Element elmCube) {
        if (elmCube.attribute("name") == null) {
            throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cubeModel/cube/@name");
        }
        if (elmCube.element("cubeFacts") == null) {
            throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cubeModel/cube/cubeFacts");
        }
        Cube objCube = this.mParent.createCube(elmCube.attributeValue("name"));
        objCube.createCustomProperty("cubingServicesCompatibility").setValue("false");
        Element elmCubeFacts = elmCube.element("cubeFacts");
        if (elmCubeFacts.attribute("name") == null) {
            throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cube/cubeFacts/@name");
        }
        CsMeasureDimensionBuilder builderMsrDim = new CsMeasureDimensionBuilder(this.mSession, this.m_MasterSource, objCube, this.mFeedback);
        MeasureDimension objMeasureDim = builderMsrDim.doImportMeasureDimension(elmCubeFacts);
        List elmHierarchyRefs = elmCube.elements("hierarchyRef");
        for (Element elmHryRef : elmHierarchyRefs) {
            String nameHrchy = elmHryRef.attributeValue("name");
            if (nameHrchy == null || nameHrchy.length() == 0) {
                throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cubeModel/cube/hierarchyRef/@name");
            }
            String nameDim = elmHryRef.attributeValue("dimensionName");
            if (nameDim == null || nameDim.length() == 0) {
                throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cubeModel/cube/hierarchyRef/@dimensionName");
            }
            Element elmDimSpec = this.findDimensionSpec(elmHryRef);
            BaseObject objDimParent = this.findOrCreateDimensionContainer(elmHryRef, objCube);
            RelationalDimension objDim = CsDimensionBuilder.findOrImportDimension(this.mSession, this.m_MasterSource, objDimParent, elmDimSpec, nameHrchy, this.mFeedback);
            Element elmJoin = (Element)elmCube.selectSingleNode("../olap:dimensionInfo[olap:dimensionRef/@name='" + nameDim + "']/olap:join");
            if (elmJoin != null) {
                this.joinDimensionToFacts(objCube, objDim, elmDimSpec, objMeasureDim, elmCubeFacts.getParent().getParent().element("facts"), elmJoin);
                continue;
            }
            this.joinForDegenerateDimenion(objCube, objDim, objMeasureDim);
        }
        builderMsrDim.fixUpMeasureAggregateRules();
        return objCube;
    }

    private void joinDimensionToFacts(Cube objCube, RelationalDimension objRegDim, Element elmDim, MeasureDimension objMsrDim, Element elmClubeFacts, Element elmJoin) {
        Element attrJoinElement = elmJoin.element("attributeJoin");
        String joinType = elmJoin.attributeValue("category");
        String cardinality = elmJoin.attributeValue("cardinality");
        if ("d:f".equals(joinType) && "n:1".equals(cardinality)) {
            String location = "cubeModel/dimensionInfo/join[@name='" + elmJoin.attributeValue("name") + "']";
            throw new FmMDException("BMT_MD_CS_INVALID_CARDINALITY", location, joinType, cardinality);
        }
        if ("f:d".equals(joinType) && "1:n".equals(cardinality)) {
            String location = "cubeModel/dimensionInfo/join[@name='" + elmJoin.attributeValue("name") + "']";
            throw new FmMDException("BMT_MD_CS_INVALID_CARDINALITY", location, joinType, cardinality);
        }
        if (attrJoinElement != null) {
            String operatorStr = attrJoinElement.attributeValue("operator");
            Element leftElement = attrJoinElement.element("leftAttributeRef");
            Element rightElement = attrJoinElement.element("rightAttributeRef");
            if (leftElement == null || rightElement == null) {
                throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cubeModel/dimensionInfo/join/{rightAttributeRef | rightAttributeRef}");
            }
            String dimensionAttributeName = null;
            String factAttributeName = null;
            if ("d:f".equals(joinType)) {
                dimensionAttributeName = leftElement.attributeValue("name");
                factAttributeName = rightElement.attributeValue("name");
            } else if ("f:d".equals(joinType)) {
                factAttributeName = leftElement.attributeValue("name");
                dimensionAttributeName = rightElement.attributeValue("name");
            }
            QueryItem dimAttrQueryItem = CsCubeBuilder.findQueryItem(objRegDim, dimensionAttributeName);
            QueryItem factAttrQueryItem = CsCubeBuilder.findQueryItem(objMsrDim, factAttributeName);
            if (dimAttrQueryItem == null) {
                dimAttrQueryItem = CsDimensionBuilder.importJoinAttribute(this.mSession, this.m_MasterSource, objRegDim, elmDim, dimensionAttributeName, this.mFeedback);
            }
            if (factAttrQueryItem == null) {
                throw new FmMDException("BMT_MD_CS_IMPORT_INVALID_JOIN_RIGHT_ATTR", factAttributeName);
            }
            QueryItemMapping dimAttrMapping = objRegDim.findMapping(dimAttrQueryItem);
            QueryItemMapping factAttrMapping = objMsrDim.findMapping(factAttrQueryItem);
            if (dimAttrMapping != null && factAttrMapping != null) {
                String joinName = elmJoin.attributeValue("name");
                ExpressionBuilder expressionBuilder = BuilderFactory.createExpressionBuilder();
                expressionBuilder.addExpressionPart(dimAttrMapping.getTable().getDataSource(), dimAttrMapping.getColumnName(), dimAttrMapping.getTable().getName(), objRegDim, null);
                expressionBuilder.addExpressionPart(operatorStr, null);
                expressionBuilder.addExpressionPart(factAttrMapping.getTable().getDataSource(), factAttrMapping.getColumnName(), factAttrMapping.getTable().getName(), objMsrDim, null);
                objCube.createRelationship(joinName, expressionBuilder, objRegDim, objMsrDim);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void joinForDegenerateDimenion(Cube objCube, RelationalDimension objRegDim, MeasureDimension objMsrDim) {
        void var9_12;
        List<Table> commonTables = objRegDim.getCommonTables(objMsrDim);
        if (commonTables.size() == 0) {
            return;
        }
        ArrayList<QueryItem> dimKeyItems = new ArrayList<QueryItem>();
        ArrayList<MdColumn> dimKeyCols = new ArrayList<MdColumn>();
        for (LevelReference levelRef : objRegDim.getDefaultHierarchy().getLevelReferences()) {
            for (QueryItem queryItem : levelRef.getLevel().getLevelKeys()) {
                MdColumn mdCol;
                QueryItemMapping qim;
                if (dimKeyItems.contains(queryItem) || (qim = objRegDim.findMapping(queryItem)) == null || qim.getTable() == null || (mdCol = qim.getTable().getPhysicalTable(true).findColumn(qim.getColumnName())) == null) continue;
                dimKeyItems.add(queryItem);
                dimKeyCols.add(mdCol);
            }
        }
        if (dimKeyCols.isEmpty()) {
            return;
        }
        ArrayList<QueryItem> msrKeyItems = new ArrayList<QueryItem>(dimKeyCols.size());
        for (MdColumn aCol : dimKeyCols) {
            QueryItem msrKey = objMsrDim.findQueryItem(aCol);
            if (msrKey == null) {
                msrKey = objMsrDim.createQueryItemFromColumn(aCol.getName(), aCol);
                objMsrDim.createQueryItemMapping(msrKey, aCol.getName(), commonTables.get(0));
                msrKey.setHidden(true);
                msrKey.setUsage(FmUsage.identifier);
            }
            msrKeyItems.add(msrKey);
        }
        FmMDException.ASSERT(dimKeyItems.size() == msrKeyItems.size(), "Expecting a 1:1 correspondence for items participating in a d:f join in case of degenerate dimensions");
        ExpressionBuilder expressionBuilder = BuilderFactory.createExpressionBuilder();
        boolean bl = false;
        while (var9_12 < msrKeyItems.size()) {
            QueryItemMapping dimKeyMapping = objRegDim.findMapping((QueryItemBase)dimKeyItems.get((int)var9_12));
            QueryItemMapping msrKeyMapping = objMsrDim.findMapping((QueryItemBase)msrKeyItems.get((int)var9_12));
            expressionBuilder.addExpressionPart(dimKeyMapping.getTable().getDataSource(), dimKeyMapping.getColumnName(), dimKeyMapping.getTable().getName(), objRegDim, null);
            expressionBuilder.addExpressionPart("=", null);
            expressionBuilder.addExpressionPart(msrKeyMapping.getTable().getDataSource(), msrKeyMapping.getColumnName(), msrKeyMapping.getTable().getName(), objMsrDim, null);
            if (var9_12 + true < msrKeyItems.size()) {
                expressionBuilder.addExpressionPart("and", null);
            }
            ++var9_12;
        }
        objCube.createRelationship(String.valueOf(objRegDim.getName()) + "--" + objMsrDim.getName(), expressionBuilder, objRegDim, objMsrDim);
    }

    static QueryItem findQueryItem(RelationalDimensionBase fmDim, String dimensionAttributeName) {
        QueryItem fndItem = null;
        List<QueryItem> queryItems = fmDim.getAllQueryItems();
        for (QueryItem qi : queryItems) {
            if (!qi.getName().equals(dimensionAttributeName)) continue;
            fndItem = qi;
            break;
        }
        return fndItem;
    }

    private Element findDimensionSpec(Element elmHierarchyRef) {
        List selDimensions;
        String dimName = elmHierarchyRef.attributeValue("dimensionName");
        String dimSchema = elmHierarchyRef.attributeValue("schema");
        boolean isPrivate = "private".equals(elmHierarchyRef.attributeValue("dimensionCategory"));
        List list = selDimensions = isPrivate ? elmHierarchyRef.selectNodes("../../olap:dimension[@name='" + dimName + "' and @schema='" + dimSchema + "']") : this.mCSModelRoot.selectNodes(".//olap:cubeModel[@name='Common']/olap:dimension[@name='" + dimName + "' and @schema='" + dimSchema + "']");
        if (selDimensions.size() != 1) {
            throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cubeModel/dimension[@name='" + dimName + "']");
        }
        return (Element)selDimensions.get(0);
    }

    private BaseObject findOrCreateDimensionContainer(Element elmHrchyRef, Cube objCube) {
        boolean isPrivate = "private".equals(elmHrchyRef.attributeValue("dimensionCategory"));
        if (isPrivate) {
            return objCube;
        }
        String common = FmMessage.render("BMT_MDN_COMMON_NAMESPACE", this.mSession.getActiveLocale());
        String id = CrnIDHelper.addEntryToID(null, common);
        TopLevelObject obj = FmModelFactory.getInstance().getById(this.mSession, id);
        if (obj != null) {
            return (Section)obj;
        }
        return this.mParent.createNamespace(common);
    }
}

