/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.imprt.cubingServices;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.model.Association;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.CalculatedMember;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.model.FmUsage;
import com.ibm.cognos.fmeng.fmmd.model.Join;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelStyle;
import com.ibm.cognos.fmeng.fmmd.model.MDXExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.MemberUniqueNameBuilder;
import com.ibm.cognos.fmeng.fmmd.model.Namespace;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemParent;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.Role;
import com.ibm.cognos.fmeng.fmmd.model.SortItem;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.fmmd.util.CrnIDHelper;
import com.ibm.cognos.fmeng.imprt.cubingServices.CsCubeBuilder;
import com.ibm.cognos.fmeng.imprt.cubingServices.CsDimensionBuilderBase;
import com.ibm.cognos.fmeng.imprt.cubingServices.CsModelImportFeedback;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdForeignKey;
import com.ibm.cognos.fmeng.metadata.MdPrimaryKey;
import com.ibm.cognos.fmeng.metadata.MdSource;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsDimensionBuilder
extends CsDimensionBuilderBase {
    public static final String gCS_MODEL_PARENT_LEVEL_NAME = "parentCSLevelName";
    public static final String gCS_MODEL_MEMBER_LEVEL_NAME = "memberCSLevelName";
    private static final String[] gCSJoinOperators = new String[]{"=", "<", ">", "<>", "<=", ">="};
    private static final Association.EOperator[] gFMJoinOperators = new Association.EOperator[]{Association.EOperator.equals, Association.EOperator.lessThan, Association.EOperator.greaterThan, Association.EOperator.notEquals, Association.EOperator.lessThanOrEquals, Association.EOperator.greaterThanOrEquals};
    private HashMap<String, QueryItemBase> mAttributes = new HashMap(20);
    private HashMap<String, RelationalHierarchy> mHierarchyMap = new HashMap();

    private CsDimensionBuilder(FMMDSession session, MdSource cubeDB, CsModelImportFeedback aFeedback) {
        super(session, cubeDB, aFeedback);
    }

    static RelationalDimension findOrImportDimension(FMMDSession session, MdSource masterSource, BaseObject objDimParent, Element elmDimSpec, String hierarchyName, CsModelImportFeedback aFeedback) {
        String bsName = elmDimSpec.attributeValue("name");
        if (bsName == null || bsName.length() == 0) {
            throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cubeModel/dimension/@name");
        }
        RelationalDimension objDim = CsDimensionBuilder.findDimensionInModel(session, objDimParent, bsName);
        if (objDim == null) {
            CsDimensionBuilder dimBuilder = new CsDimensionBuilder(session, masterSource, aFeedback);
            objDim = dimBuilder.importDimension(objDimParent, elmDimSpec, hierarchyName);
            RelationalHierarchy onjHrchy = dimBuilder.mHierarchyMap.get(hierarchyName);
            if (onjHrchy != null) {
                objDim.setDefaultHierarchy(onjHrchy);
            } else {
                FmMessage msg = new FmMessage("BMT_MD_CS_IMPORT_FDBK_SET_DEFAULT_HIERARCHY", hierarchyName, objDim.getID());
                FmEngApplicationLog.getApplicationLog().logWarning(FmEngApplicationLog.LOGGERS.CUBING_SERVICES_IMPORT, session, msg);
                aFeedback.addFeedback(objDim, msg);
            }
        } else {
            String currDefHrchy = objDim.getDefaultHierarchy().getName();
            if (!hierarchyName.equals(currDefHrchy)) {
                FmMessage msg = new FmMessage("BMT_MD_CS_IMPORT_FDBK_MULT_DEFAULT_HIERARCHY", currDefHrchy);
                FmEngApplicationLog.getApplicationLog().logWarning(FmEngApplicationLog.LOGGERS.CUBING_SERVICES_IMPORT, session, msg);
                aFeedback.addFeedback(objDim, msg);
            }
        }
        return objDim;
    }

    static QueryItem importJoinAttribute(FMMDSession session, MdSource masterSource, RelationalDimension objDim, Element elmDimSpec, String attrName, CsModelImportFeedback aFeedback) {
        CsDimensionBuilder dimBuilder = new CsDimensionBuilder(session, masterSource, aFeedback);
        QueryItem objQItem = dimBuilder.addJoinQueryItem(objDim, CsDimensionBuilder.findAttributeSpec(elmDimSpec, attrName));
        return objQItem;
    }

    private QueryItemParent findParentForJoinAttribute(RelationalDimension objDim) {
        QueryItemParent itemParent = null;
        List<Level> allLevels = objDim.getAllLevels();
        if (!allLevels.isEmpty()) {
            itemParent = allLevels.get(allLevels.size() - 1);
        } else {
            List objHierarchies = objDim.getAllHierarchies();
            FmMDException.ASSERT(objHierarchies.size() == 1 && ((RelationalHierarchy)objHierarchies.get(0)).getParentChild(), "Expecting a parent-child hierarchy");
            itemParent = (QueryItemParent)objHierarchies.get(0);
        }
        return itemParent;
    }

    private QueryItem addJoinQueryItem(RelationalDimension objDim, Element elmAttribute) {
        QueryItemParent objParent = this.findParentForJoinAttribute(objDim);
        QueryItem objQueryItem = (QueryItem)this.createItem(objDim, objParent, elmAttribute);
        objQueryItem.setHidden(true);
        return objQueryItem;
    }

    private static RelationalDimension findDimensionInModel(FMMDSession session, BaseObject objParent, String dimensionName) {
        String id = CrnIDHelper.addEntryToID(objParent.getID(), dimensionName);
        TopLevelObject obj = FmModelFactory.getInstance().getById(session, id);
        return (RelationalDimension)obj;
    }

    private RelationalDimension importDimension(BaseObject objDimParent, Element elmDimSpec, String cubeHierarchyName) {
        String dimType = "regular";
        if (elmDimSpec.attribute("type") != null) {
            dimType = elmDimSpec.attributeValue("type");
        }
        RelationalDimension newObjDim = null;
        newObjDim = objDimParent instanceof Namespace ? (dimType.equals("time") ? ((Namespace)objDimParent).createRelationalTimeDimension(elmDimSpec.attributeValue("name")) : ((Namespace)objDimParent).createRelationalDimension(elmDimSpec.attributeValue("name"))) : this.mSession.getProject().getRootNamespace().createRelationalDimension(elmDimSpec.attributeValue("name"));
        List elmHrchys = elmDimSpec.elements("hierarchy");
        if (elmHrchys == null || elmHrchys.size() == 0) {
            throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cubeModel/dimension/hierarchy");
        }
        Element elmHierarchy = this.findHierarchySpec(elmDimSpec, cubeHierarchyName);
        if (this.isParentChildHierarchy(newObjDim, elmHierarchy, elmHrchys)) {
            this.importParentChildHierarchy(newObjDim, elmDimSpec, elmHierarchy);
        } else {
            HashMap<String, Level> levelsMap = this.importLevels(newObjDim, elmDimSpec, elmHrchys);
            this.importHierarchies(newObjDim, elmHrchys, levelsMap);
        }
        this.importJoins(newObjDim, elmDimSpec);
        return newObjDim;
    }

    private boolean isParentChildHierarchy(RelationalDimension objDim, Element elmHierarchy, List<Element> elmHrchys) {
        boolean isPC = "recursive".equals(elmHierarchy.attributeValue("deployment"));
        if (isPC && elmHrchys.size() > 1) {
            FmMessage msg = new FmMessage("BMT_MD_CS_IMPORT_FDBK_MULT_PC_HRCHY", elmHierarchy.attributeValue("name"));
            FmEngApplicationLog.getApplicationLog().logWarning(FmEngApplicationLog.LOGGERS.CUBING_SERVICES_IMPORT, this.mSession, msg);
            this.mFeedback.addFeedback(objDim, msg);
        }
        return isPC;
    }

    private void importParentChildHierarchy(RelationalDimension objDim, Element elmDimSpec, Element elmHrchySpec) {
        String hirarchyName = elmHrchySpec.attributeValue("name");
        RelationalHierarchy objHierarchy = objDim.createParentChildHierarchy(hirarchyName);
        this.mHierarchyMap.put(hirarchyName, objHierarchy);
        String allMemberName = elmHrchySpec.attributeValue("allMemberName");
        if (allMemberName != null) {
            objHierarchy.setRootMember(allMemberName);
            objHierarchy.setRootCaption(objHierarchy.getSession().getDefaultLocale(), allMemberName);
        }
        String showMembers = elmHrchySpec.attributeValue("showMembers");
        objHierarchy.setShowDataMembers("yes".equals(showMembers));
        this.importCalculatedMembers(objHierarchy, elmHrchySpec);
        this.importHierarchyDefaultMember(objHierarchy, elmHrchySpec);
        List levelRefElements = elmHrchySpec.elements("levelRef");
        FmMDException.ASSERT(levelRefElements.size() == 2, "Exactly two levels are expected for parent-child hierarchies.");
        ArrayList<QueryItemBase> calculatedItems = new ArrayList<QueryItemBase>();
        ArrayList<Element> calculatedItemSpecs = new ArrayList<Element>();
        String sParentLevelName = ((Element)levelRefElements.get(0)).attributeValue("name");
        String sMemberLevelName = ((Element)levelRefElements.get(1)).attributeValue("name");
        objHierarchy.createCustomProperty(gCS_MODEL_PARENT_LEVEL_NAME).setValue(sParentLevelName);
        objHierarchy.createCustomProperty(gCS_MODEL_MEMBER_LEVEL_NAME).setValue(sMemberLevelName);
        this.importParentChildAttributes(objHierarchy, elmDimSpec, this.findLevelSpec(elmDimSpec, sParentLevelName), true, calculatedItems, calculatedItemSpecs);
        this.importParentChildAttributes(objHierarchy, elmDimSpec, this.findLevelSpec(elmDimSpec, sMemberLevelName), false, calculatedItems, calculatedItemSpecs);
        int idx = 0;
        while (idx < calculatedItemSpecs.size()) {
            this.setExpressionForCalculatedItems(objDim, (QueryItemBase)calculatedItems.get(idx), (Element)calculatedItemSpecs.get(idx), this.mAttributes);
            ++idx;
        }
    }

    private void importHierarchies(RelationalDimension objDim, List<Element> elmHrchys, HashMap<String, Level> levelsMap) {
        for (Element elmHrchy : elmHrchys) {
            String hirarchyName = elmHrchy.attributeValue("name");
            RelationalHierarchy objHierarchy = (RelationalHierarchy)objDim.createHierarchy(hirarchyName);
            this.mHierarchyMap.put(hirarchyName, objHierarchy);
            String hasAllLevel = elmHrchy.attributeValue("hasAllLevel");
            if ("yes".equals(hasAllLevel)) {
                objHierarchy.setMultiRoot(false);
                String allMemberName = elmHrchy.attributeValue("allMemberName");
                if (allMemberName != null) {
                    objHierarchy.setRootMember(allMemberName);
                    objHierarchy.setRootCaption(objHierarchy.getSession().getDefaultLocale(), allMemberName);
                }
            }
            List levelRefElements = elmHrchy.elements("levelRef");
            for (Element levelRefElement : levelRefElements) {
                String levelName = levelRefElement.attributeValue("name");
                Level objLevel = levelsMap.get(levelName);
                if (objLevel == null) {
                    throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cubeModel/dimension/level[@name='" + levelName + "']");
                }
                objHierarchy.addLevel(objLevel);
            }
            this.importCalculatedMembers(objHierarchy, elmHrchy);
            this.importHierarchyDefaultMember(objHierarchy, elmHrchy);
        }
    }

    private void importHierarchyDefaultMember(RelationalHierarchy objHierarchy, Element elmHrchySpec) {
        Element defaultMemberRef = elmHrchySpec.element("defaultMemberRef");
        if (defaultMemberRef != null) {
            String defaultMUN = defaultMemberRef.attributeValue("name");
            String parentName = defaultMemberRef.attributeValue("parentName");
            if (!"".equals(parentName) && !"NA".equals(parentName)) {
                defaultMUN = String.valueOf(parentName) + "." + defaultMUN;
            }
            FmMessage msg = new FmMessage("BMT_MD_CS_IMPORT_FDBK_IMPORT_DROPPED_DEFAULT_MEMBER", defaultMUN, objHierarchy.getName());
            FmEngApplicationLog.getApplicationLog().logWarning(FmEngApplicationLog.LOGGERS.CUBING_SERVICES_IMPORT, this.mSession, msg);
            this.mFeedback.addFeedback(objHierarchy, msg);
        }
    }

    private void importCalculatedMembers(RelationalHierarchy objHrchy, Element elmHrchy) {
        List elmCalcMembers = elmHrchy.elements("calculatedMember");
        for (Element elmCalcMem : elmCalcMembers) {
            String calcName = elmCalcMem.attributeValue("name");
            if (calcName == null || calcName.length() == 0) {
                throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cubeModel/dimension/hierarchy/calculatedMember/@name");
            }
            Element elmExpr = elmCalcMem.element("mdxExpression");
            if (elmExpr == null || elmExpr.attributeValue("template") == null || elmExpr.attributeValue("template").length() == 0) {
                throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cubeModel/dimension/hierarchy/calculatedMember/mdxExpression");
            }
            Element elmParent = elmCalcMem.element("parent");
            if (elmParent == null || elmParent.attributeValue("name") == null || elmParent.attributeValue("name").length() == 0) {
                throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cubeModel/dimension/hierarchy/calculatedMember/parent");
            }
            CalculatedMember objCalcMem = objHrchy.createCalculatedMember(calcName);
            MDXExpressionBuilder bldrExpr = BuilderFactory.createMDXExpressionBuilder();
            bldrExpr.addPart(elmExpr.attributeValue("template"), null);
            objCalcMem.setExpression(bldrExpr);
            MemberUniqueNameBuilder bldrParent = BuilderFactory.createMemberUniqueNameBuilder();
            bldrParent.addPart(elmParent.attributeValue("name"), null);
            objCalcMem.setParentMember(bldrParent);
            Element elmSolveOrder = elmCalcMem.element("solveOrder");
            if (elmSolveOrder == null || elmSolveOrder.attributeValue("value") == null || elmSolveOrder.attributeValue("value").length() == 0) continue;
            objCalcMem.setSolveOrder(Integer.parseInt(elmSolveOrder.attributeValue("value")));
        }
    }

    private HashMap<String, Level> importLevels(RelationalDimension objDim, Element elmDimSpec, List<Element> elmHrchys) {
        ArrayList<QueryItemBase> calculatedItems = new ArrayList<QueryItemBase>();
        ArrayList<Element> calculatedItemSpecs = new ArrayList<Element>();
        HashMap<String, Level> outLevelsMap = new HashMap<String, Level>();
        for (Element elmHrchy : elmHrchys) {
            List elmLevelRefs = elmHrchy.elements("levelRef");
            for (Element elmLevelRef : elmLevelRefs) {
                String levelName = elmLevelRef.attributeValue("name");
                if (outLevelsMap.containsKey(levelName)) continue;
                Element elmLevel = this.findLevelSpec(elmDimSpec, levelName);
                Level objLevel = objDim.createLevel(levelName);
                objLevel.setIsUnique(true);
                LevelStyle levelStyle = LevelStyle.regular;
                try {
                    levelStyle = LevelStyle.valueOf(elmLevel.attributeValue("type"));
                }
                catch (RuntimeException runtimeException) {}
                ((FmLevel)objLevel).setLevelStyle(levelStyle);
                this.importAttributes(elmDimSpec, objLevel, elmLevel, calculatedItems, calculatedItemSpecs);
                outLevelsMap.put(levelName, objLevel);
            }
        }
        int idx = 0;
        while (idx < calculatedItemSpecs.size()) {
            this.setExpressionForCalculatedItems(objDim, (QueryItemBase)calculatedItems.get(idx), (Element)calculatedItemSpecs.get(idx), this.mAttributes);
            ++idx;
        }
        return outLevelsMap;
    }

    private void importAttributes(Element elmDimSpec, Level objLevel, Element elmLevel, List<QueryItemBase> calculatedItems, List<Element> calculatedItemSpecs) {
        FmMessage msg;
        QueryItem objQItem;
        Element elmAttr;
        RelationalDimensionBase objDim = (RelationalDimensionBase)objLevel.getDimension();
        ArrayList<String> refAttributes = new ArrayList<String>();
        List keyRefs = elmLevel.elements("levelKeyRef");
        for (Element elmKeyRef : keyRefs) {
            Element elmAttr2 = CsDimensionBuilder.findAttributeSpec(elmDimSpec, elmKeyRef.attributeValue("name"));
            QueryItem objQItem2 = this.findOrAddQueryItem(objDim, objLevel, elmAttr2, calculatedItems, calculatedItemSpecs, refAttributes);
            objLevel.addLevelKey(objQItem2);
            objLevel.setIsUnique(true);
        }
        List relatedRefs = elmLevel.elements("relatedAttributeRef");
        for (Element elmRelRef : relatedRefs) {
            elmAttr = CsDimensionBuilder.findAttributeSpec(elmDimSpec, elmRelRef.attributeValue("name"));
            objQItem = this.findOrAddQueryItem(objDim, objLevel, elmAttr, calculatedItems, calculatedItemSpecs, refAttributes);
            if (!objQItem.getLevel().equals(objLevel)) {
                msg = new FmMessage("BMT_MD_CS_IMPORT_FDBK_RELATED_ATTR", elmRelRef.attributeValue("name"), objLevel.getName(), objQItem.getLevel().getName());
                FmEngApplicationLog.getApplicationLog().logWarning(FmEngApplicationLog.LOGGERS.CUBING_SERVICES_IMPORT, this.mSession, msg);
                this.mFeedback.addFeedback(objLevel.getDimension(), msg);
            }
            StringBuilder specialName = new StringBuilder(elmLevel.attributeValue("name"));
            specialName.append(".").append("MEMBER_KEY");
            if (!specialName.toString().equals(elmRelRef.attributeValue("name"))) continue;
            objQItem.addDefaultRole(Role.EDefaultRoles.kRoleBusinessKey);
        }
        List orderRefs = elmLevel.elements("orderAttributeRef");
        for (Element elmOrderRef : orderRefs) {
            Element elmAttr3 = CsDimensionBuilder.findAttributeSpec(elmDimSpec, elmOrderRef.attributeValue("name"));
            QueryItem objQItem3 = this.findOrAddQueryItem(objDim, objLevel, elmAttr3, calculatedItems, calculatedItemSpecs, refAttributes);
            boolean bFound = false;
            for (QueryItem item : objLevel.getAllQueryItems()) {
                if (!item.equals(objQItem3)) continue;
                objLevel.addMemberSortItem(objQItem3, this.convertOrder(elmOrderRef));
                bFound = true;
                break;
            }
            if (bFound) continue;
            FmMessage msg2 = new FmMessage("BMT_MD_CS_IMPORT_FDBK_BAD_SORT_ITEM_FOR_LEVEL", objQItem3.getName(), objLevel.getName());
            FmEngApplicationLog.getApplicationLog().logWarning(FmEngApplicationLog.LOGGERS.CUBING_SERVICES_IMPORT, this.mSession, msg2);
            this.mFeedback.addFeedback(objLevel, msg2);
        }
        Element elmDefaultAttr = elmLevel.element("defaultAttributeRef");
        if (elmDefaultAttr != null) {
            elmAttr = CsDimensionBuilder.findAttributeSpec(elmDimSpec, elmDefaultAttr.attributeValue("name"));
            objQItem = this.findOrAddQueryItem(objDim, objLevel, elmAttr, calculatedItems, calculatedItemSpecs, refAttributes);
            if (objQItem.getLevel().equals(objLevel)) {
                objQItem.addDefaultRole(Role.EDefaultRoles.kRoleBusinessKey);
                objQItem.addDefaultRole(Role.EDefaultRoles.kRoleMemberCaption);
                objQItem.addDefaultRole(Role.EDefaultRoles.kRoleMemberDescription);
            } else {
                msg = new FmMessage("BMT_MD_CS_IMPORT_FDBK_LEVE_DEF_ATTR", elmDefaultAttr.attributeValue("name"), objLevel.getName(), objQItem.getLevel().getName());
                FmEngApplicationLog.getApplicationLog().logWarning(FmEngApplicationLog.LOGGERS.CUBING_SERVICES_IMPORT, this.mSession, msg);
                this.mFeedback.addFeedback(objLevel.getDimension(), msg);
            }
        }
        for (String refAttr : refAttributes) {
            Element elmAttr4 = CsDimensionBuilder.findAttributeSpec(elmDimSpec, refAttr);
            this.findOrAddQueryItem(objDim, objLevel, elmAttr4, calculatedItems, calculatedItemSpecs, refAttributes);
        }
    }

    private void importParentChildAttributes(RelationalHierarchy objHierarchy, Element elmDimSpec, Element elmLevelSpec, boolean isParentLevel, List<QueryItemBase> calculatedItems, List<Element> calculatedItemSpecs) {
        Element elmAttr;
        RelationalDimension objDim = objHierarchy.getDimension();
        ArrayList<String> refAttributes = new ArrayList<String>();
        List keyRefs = elmLevelSpec.elements("levelKeyRef");
        for (Element elmKeyRef : keyRefs) {
            Element elmAttr2 = CsDimensionBuilder.findAttributeSpec(elmDimSpec, elmKeyRef.attributeValue("name"));
            QueryItem objQItem = this.findOrAddQueryItem(objDim, objHierarchy, elmAttr2, calculatedItems, calculatedItemSpecs, refAttributes);
            if (isParentLevel) {
                objHierarchy.setParentItem(objQItem);
                continue;
            }
            objHierarchy.setChildItem(objQItem);
        }
        List relatedRefs = elmLevelSpec.elements("relatedAttributeRef");
        for (Element elmRelRef : relatedRefs) {
            elmAttr = CsDimensionBuilder.findAttributeSpec(elmDimSpec, elmRelRef.attributeValue("name"));
            this.findOrAddQueryItem(objDim, objHierarchy, elmAttr, calculatedItems, calculatedItemSpecs, refAttributes);
        }
        List orderRefs = elmLevelSpec.elements("orderAttributeRef");
        for (Element elmOrderRef : orderRefs) {
            Element elmAttr3 = CsDimensionBuilder.findAttributeSpec(elmDimSpec, elmOrderRef.attributeValue("name"));
            QueryItem objQItem = this.findOrAddQueryItem(objDim, objHierarchy, elmAttr3, calculatedItems, calculatedItemSpecs, refAttributes);
            objHierarchy.addMemberSortItem(objQItem, this.convertOrder(elmOrderRef));
        }
        Element elmDefaultAttr = elmLevelSpec.element("defaultAttributeRef");
        if (elmDefaultAttr != null) {
            elmAttr = CsDimensionBuilder.findAttributeSpec(elmDimSpec, elmDefaultAttr.attributeValue("name"));
            QueryItem objQItem = this.findOrAddQueryItem(objDim, objHierarchy, elmAttr, calculatedItems, calculatedItemSpecs, refAttributes);
            if (!isParentLevel) {
                objQItem.addDefaultRole(Role.EDefaultRoles.kRoleBusinessKey);
                objQItem.addDefaultRole(Role.EDefaultRoles.kRoleMemberCaption);
                objQItem.addDefaultRole(Role.EDefaultRoles.kRoleMemberDescription);
            }
        }
        for (String refAttr : refAttributes) {
            Element elmAttr4 = CsDimensionBuilder.findAttributeSpec(elmDimSpec, refAttr);
            this.findOrAddQueryItem(objDim, objHierarchy, elmAttr4, calculatedItems, calculatedItemSpecs, refAttributes);
        }
    }

    private static Element findAttributeSpec(Element elmDimSpec, String attrName) {
        List selAttrNodes = elmDimSpec.selectNodes(".//olap:attribute[@name='" + attrName + "']");
        if (selAttrNodes.size() == 0) {
            throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cubeModel/dimension/attribute[@name='" + attrName + "']");
        }
        return (Element)selAttrNodes.get(0);
    }

    private Element findLevelSpec(Element elmDimSpec, String levelName) {
        List elmLevels = elmDimSpec.selectNodes(".//olap:level[@name='" + levelName + "']");
        if (elmLevels.size() == 0) {
            throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cubeModel/dimension/level[@name='" + levelName + "']");
        }
        return (Element)elmLevels.get(0);
    }

    private Element findHierarchySpec(Element elmDimSpec, String hierarchyName) {
        Element elmHierarchy = (Element)elmDimSpec.selectSingleNode("./olap:hierarchy[@name='" + hierarchyName + "']");
        if (elmHierarchy == null) {
            throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cubeModel/dimension/hierarchy[@name='" + hierarchyName + "']");
        }
        return elmHierarchy;
    }

    private QueryItem findOrAddQueryItem(RelationalDimensionBase objDim, QueryItemParent objItemParent, Element elmAttribute, List<QueryItemBase> calculatedItems, List<Element> calculatedItemSpecs, List<String> attributeRefs) {
        QueryItem objQueryItem = (QueryItem)this.mAttributes.get(elmAttribute.attributeValue("name"));
        if (objQueryItem != null) {
            return objQueryItem;
        }
        if (this.isColumnBased(elmAttribute)) {
            objQueryItem = (QueryItem)this.createItem(objDim, objItemParent, elmAttribute);
        } else {
            String attrName = elmAttribute.attributeValue("name");
            objQueryItem = objItemParent.createQueryItem(attrName, null);
            calculatedItems.add(objQueryItem);
            calculatedItemSpecs.add(elmAttribute);
            List attribureRefs = elmAttribute.selectNodes(".//olap:attributeRef");
            for (Element elmAttrRef : attribureRefs) {
                attributeRefs.add(elmAttrRef.attributeValue("name"));
            }
        }
        objQueryItem.setUsage(FmUsage.attribute);
        this.mAttributes.put(elmAttribute.attributeValue("name"), objQueryItem);
        return objQueryItem;
    }

    private void importJoins(RelationalDimension objDim, Element elmDimSpec) {
        List elmJoins = elmDimSpec.elements("join");
        for (Element elmJoin : elmJoins) {
            String joinName = elmJoin.attributeValue("name");
            Element elmAttrJoin = elmJoin.element("attributeJoin");
            if (elmAttrJoin == null) continue;
            QueryItem leftJoinAttr = this.findOrAddJoinItem(objDim, elmAttrJoin, "leftAttributeRef");
            QueryItem rightJoinAttr = this.findOrAddJoinItem(objDim, elmAttrJoin, "rightAttributeRef");
            QueryItemMapping pmLeftAttr = objDim.findMapping(leftJoinAttr);
            FmMDException.ASSERT(pmLeftAttr != null, "Expecting a valid mapping information for item:" + leftJoinAttr.getID());
            QueryItemMapping pmRightAttr = objDim.findMapping(rightJoinAttr);
            FmMDException.ASSERT(pmRightAttr != null, "Expecting a valid mapping information for item:" + rightJoinAttr.getID());
            Join objJoin = objDim.createJoin(joinName, pmLeftAttr.getTable(), pmRightAttr.getTable());
            objJoin.createAssociation(objDim.findMapping(leftJoinAttr).getColumnName(), objDim.findMapping(rightJoinAttr).getColumnName(), this.convertJoinOperator(elmAttrJoin));
            if (this.setCardinalityByExaminingJoinItems(objDim, objJoin, leftJoinAttr, rightJoinAttr)) continue;
            this.setCardinality(objJoin, elmJoin.attributeValue("cardinality"), elmJoin.attributeValue("type"));
            FmMessage msg = new FmMessage("BMT_MD_CS_IMPORT_FDBK_JOIN_CARDINALITY", elmJoin.attributeValue("name"));
            FmEngApplicationLog.getApplicationLog().logWarning(FmEngApplicationLog.LOGGERS.CUBING_SERVICES_IMPORT, this.mSession, msg);
            this.mFeedback.addFeedback(objDim, msg);
        }
    }

    private QueryItem findOrAddJoinItem(RelationalDimension objDim, Element elmJoinAttr, String tagName) {
        Element elmJoinEnd = elmJoinAttr.element(tagName);
        if (elmJoinEnd == null || elmJoinEnd.attribute("name") == null) {
            throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "dimension/join/attributeJoin/" + tagName + "/@name");
        }
        Element elmAttrSpec = CsDimensionBuilder.findAttributeSpec(elmJoinAttr.getParent().getParent(), elmJoinEnd.attributeValue("name"));
        QueryItem dimAttrQItem = CsCubeBuilder.findQueryItem(objDim, elmAttrSpec.attributeValue("name"));
        if (dimAttrQItem == null) {
            dimAttrQItem = this.addJoinQueryItem(objDim, elmAttrSpec);
        }
        return dimAttrQItem;
    }

    private SortItem.ESortItem convertOrder(Element almOrderAttrRef) {
        String order = almOrderAttrRef.attributeValue("order");
        if ("asc".equals(order)) {
            return SortItem.ESortItem.ascending;
        }
        if ("desc".equals(order)) {
            return SortItem.ESortItem.descending;
        }
        return SortItem.ESortItem.ascending;
    }

    private Association.EOperator convertJoinOperator(Element almAttrJoin) {
        String csOperator = almAttrJoin.attributeValue("operator");
        int idx = 0;
        while (idx < gCSJoinOperators.length) {
            if (gCSJoinOperators[idx].equals(csOperator)) {
                return gFMJoinOperators[idx];
            }
            ++idx;
        }
        return Association.EOperator.none;
    }

    private void setCardinality(Join objJoin, String csCardinality, String csJoinType) {
        if (csCardinality == null || csJoinType == null) {
            throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "dimension/join/{@cardinality | @type}");
        }
        if ("full outer".equals(csJoinType)) {
            objJoin.setLeftMincard(Cardinality.ECardinality.zero);
            objJoin.setRightMincard(Cardinality.ECardinality.zero);
        } else if ("left outer".equals(csJoinType)) {
            objJoin.setLeftMincard(Cardinality.ECardinality.zero);
            objJoin.setRightMincard(Cardinality.ECardinality.one);
        } else if ("right outer".equals(csJoinType)) {
            objJoin.setLeftMincard(Cardinality.ECardinality.one);
            objJoin.setRightMincard(Cardinality.ECardinality.zero);
        } else {
            objJoin.setLeftMincard(Cardinality.ECardinality.one);
            objJoin.setRightMincard(Cardinality.ECardinality.one);
        }
        if ("1:1".equals(csCardinality)) {
            objJoin.setLeftMaxcard(Cardinality.ECardinality.one);
            objJoin.setRightMaxcard(Cardinality.ECardinality.one);
        } else if ("1:n".equals(csCardinality)) {
            objJoin.setLeftMaxcard(Cardinality.ECardinality.one);
            objJoin.setRightMaxcard(Cardinality.ECardinality.many);
        } else if ("n:1".equals(csCardinality)) {
            objJoin.setLeftMaxcard(Cardinality.ECardinality.many);
            objJoin.setRightMaxcard(Cardinality.ECardinality.one);
        } else if ("n:m".equals(csCardinality)) {
            objJoin.setLeftMaxcard(Cardinality.ECardinality.many);
            objJoin.setRightMaxcard(Cardinality.ECardinality.many);
        }
    }

    private boolean setCardinalityByExaminingJoinItems(RelationalDimension objDim, Join objJoin, QueryItem leftJoinItem, QueryItem rightJoinItem) {
        boolean bSuccess = false;
        QueryItemMapping leftMapping = objDim.findMapping(leftJoinItem);
        QueryItemMapping rightMapping = objDim.findMapping(rightJoinItem);
        MdTable leftTable = leftMapping.getTable().getPhysicalTable(true);
        MdTable rightTable = rightMapping.getTable().getPhysicalTable(true);
        if (this.relatedThroughForeignKey(leftTable, leftMapping.getColumnName(), rightTable, rightMapping.getColumnName())) {
            objJoin.setLeftMincard(Cardinality.ECardinality.one);
            objJoin.setLeftMaxcard(Cardinality.ECardinality.many);
            objJoin.setRightMincard(Cardinality.ECardinality.one);
            objJoin.setRightMaxcard(Cardinality.ECardinality.one);
            bSuccess = true;
        } else if (this.relatedThroughForeignKey(rightTable, rightMapping.getColumnName(), leftTable, leftMapping.getColumnName())) {
            objJoin.setLeftMincard(Cardinality.ECardinality.one);
            objJoin.setLeftMaxcard(Cardinality.ECardinality.one);
            objJoin.setRightMincard(Cardinality.ECardinality.one);
            objJoin.setRightMaxcard(Cardinality.ECardinality.many);
            bSuccess = true;
        }
        return bSuccess;
    }

    private boolean relatedThroughForeignKey(MdTable table1, String colName1, MdTable table2, String colName2) {
        MdPrimaryKey t2PKey = table2.getPrimaryKey();
        if (t2PKey == null) {
            return false;
        }
        List<MdColumn> pkCols = t2PKey.getColumns();
        if (pkCols == null || pkCols.size() != 1 || !colName2.equals(pkCols.get(0).getName())) {
            return false;
        }
        List<MdForeignKey> fLeftKyes = table1.getForeignKeys();
        for (MdForeignKey fKey : fLeftKyes) {
            List<MdColumn> fkCols;
            if (!fKey.getPrimaryTable().equals(table2) || (fkCols = fKey.getColumns()) == null || fkCols.size() != 1 || !colName2.equals(fkCols.get(0).getName())) continue;
            return true;
        }
        return false;
    }
}

