/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.imprt.cubingServices;

import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.FmUsage;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemParent;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.RoleParent;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.fmmd.util.FmExpressionBuilder;
import com.ibm.cognos.fmeng.imprt.cubingServices.CsModelImportFeedback;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdDatabase;
import com.ibm.cognos.fmeng.metadata.MdSchema;
import com.ibm.cognos.fmeng.metadata.MdSource;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CsDimensionBuilderBase {
    protected FMMDSession mSession = null;
    private MdSource m_MasterSource;
    protected CsModelImportFeedback mFeedback;

    protected CsDimensionBuilderBase(FMMDSession aSession, MdSource cubeDB, CsModelImportFeedback aFeedback) {
        this.mSession = aSession;
        this.m_MasterSource = cubeDB;
        this.mFeedback = aFeedback;
    }

    private boolean doesColumnExist(String schemaNm, String tableName, String columnName) {
        MdTable mdTable;
        MdDatabase db = this.mSession.findOrLoadMetadataSource(this.m_MasterSource, "", schemaNm);
        MdSchema mdSchema = db.findSchema(null, schemaNm);
        if (mdSchema != null && (mdTable = mdSchema.findTable(tableName)) != null) {
            List<MdColumn> columns = mdTable.getColumns();
            for (MdColumn column : columns) {
                if (!column.getName().equals(columnName)) continue;
                return true;
            }
        }
        return false;
    }

    protected Table findOrCreateTable(RelationalDimensionBase objDim, String schemaNm, String tableNm) {
        MdDatabase db = this.mSession.findOrLoadMetadataSource(this.m_MasterSource, "", schemaNm);
        MdSchema mdSchema = db.findSchema(null, schemaNm);
        if (mdSchema == null) {
            throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_SCHEMA_INFO", schemaNm);
        }
        MdTable mdTable = mdSchema.findTable(tableNm);
        if (mdTable == null) {
            throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_TABLE_INFO", tableNm);
        }
        DataSource dataSource = this.mSession.getProject().findOrCreateDataSource(mdTable);
        Table objTable = objDim.findTable(dataSource, tableNm);
        if (objTable == null) {
            objTable = objDim.createTable(dataSource, tableNm);
        }
        return objTable;
    }

    protected QueryItemBase createItem(RelationalDimensionBase objDim, QueryItemParent parent, Element elmItem) {
        String attrName = elmItem.attributeValue("name");
        return this.createItemForColumn(objDim, attrName, parent, (Element)elmItem.selectSingleNode(".//olap:column"), "attribute".equals(elmItem.getName()));
    }

    private QueryItemBase createItemForColumn(RelationalDimensionBase objDim, String itemName, QueryItemParent parent, Element elmColumn, boolean isQueryItem) {
        if (elmColumn == null) {
            throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "item[@name='" + itemName + "']//column");
        }
        String columnName = elmColumn.attributeValue("name");
        String tableName = elmColumn.attributeValue("tableName");
        String schemaName = elmColumn.attributeValue("tableSchema");
        boolean columnExists = this.doesColumnExist(schemaName, tableName, columnName);
        QueryItemBase objQItem = null;
        if (columnExists) {
            Table objTable = this.findOrCreateTable(objDim, schemaName, tableName);
            MdTable mdTable = objTable.getPhysicalTable(true);
            if (mdTable == null) {
                throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_COLUMN_INFO", columnName, tableName);
            }
            MdColumn mdColumn = mdTable.findColumn(columnName);
            if (mdColumn == null) {
                throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_COLUMN_INFO", columnName, tableName);
            }
            if (isQueryItem) {
                objQItem = parent.createQueryItemFromColumn(itemName, mdColumn);
            } else {
                objQItem = ((MeasureDimension)objDim).createMeasureFromColumn(itemName, mdColumn);
                objQItem.setUsage(FmUsage.fact);
            }
            objDim.createQueryItemMapping(objQItem, columnName, objTable);
        } else if (isQueryItem) {
            ExpressionBuilder builder = BuilderFactory.createExpressionBuilder();
            builder.addExpressionPart("", null);
            objQItem = parent.createQueryItem(itemName, builder);
        } else {
            objQItem = ((MeasureDimension)objDim).createMeasure(itemName);
        }
        return objQItem;
    }

    protected boolean isColumnBased(Element elmItem) {
        Element elmExpr = elmItem.element("sqlExpression");
        if (elmExpr == null || elmExpr.attributeValue("template") == null) {
            throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "{measure | attribute}/sqlExpression/@template");
        }
        boolean outValue = "{$$1}".equals(elmExpr.attributeValue("template")) && elmItem.selectSingleNode(".//olap:column") != null;
        return outValue;
    }

    protected void setExpressionForCalculatedItems(RelationalDimensionBase objDimParent, QueryItemBase objItem, Element elmItem, HashMap<String, QueryItemBase> name2ObjMapping) {
        Element elmExpr = elmItem.element("sqlExpression");
        if (elmExpr == null || elmExpr.attributeValue("template") == null) {
            throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "{measure | attribute}/sqlExpression/@template");
        }
        String sExpr = elmExpr.attributeValue("template");
        sExpr = StringEscapeUtils.escapeXml((String)sExpr);
        int idxRef = 0;
        List elmExprRefs = elmExpr.elements();
        boolean datatypeSet = false;
        for (Element elmRef : elmExprRefs) {
            String sName = elmRef.getName();
            if (!"measureRef".equals(sName) && !"attributeRef".equals(sName) && !"column".equals(sName)) continue;
            ++idxRef;
            QueryItemBase objRefTarget = null;
            objRefTarget = "column".equals(sName) ? this.findOrAddItemForColumn(elmRef, objDimParent, objItem, elmItem) : name2ObjMapping.get(elmRef.attributeValue("name"));
            if (objRefTarget == null) continue;
            StringBuilder symbol = new StringBuilder("{$$");
            symbol.append(Integer.toString(idxRef));
            symbol.append("}");
            StringBuilder refobjStr = new StringBuilder("<refobj>");
            refobjStr.append(objRefTarget.getID());
            refobjStr.append("</refobj>");
            sExpr = sExpr.replaceAll(Pattern.quote(symbol.toString()), refobjStr.toString());
            if (datatypeSet || objRefTarget.getDatatype() == FmDatatype.UNKNOWN) continue;
            datatypeSet = true;
            objItem.setDatatype(objRefTarget.getDatatype());
            if (objRefTarget.getScale() != null) {
                objItem.setScale(objRefTarget.getScale());
            }
            if (objRefTarget.getPrecision() == null) continue;
            objItem.setPrecision(objRefTarget.getPrecision());
        }
        FmExpressionBuilder builder = (FmExpressionBuilder)BuilderFactory.createExpressionBuilder();
        builder.parse(this.mSession, sExpr);
        objItem.setExpression(builder);
        if (!"{$$1}".equals(elmExpr.attributeValue("template"))) {
            FmMessage msg = new FmMessage("BMT_MD_CS_IMPORT_FDBK_CALCULATED_ITEM", objItem.getID(), elmExpr.attributeValue("template"));
            FmEngApplicationLog.getApplicationLog().logWarning(FmEngApplicationLog.LOGGERS.CUBING_SERVICES_IMPORT, this.mSession, msg);
            this.mFeedback.addFeedback(objItem, msg);
        }
    }

    private QueryItemBase findOrAddItemForColumn(Element elmColumn, RelationalDimensionBase objDimParent, QueryItemBase objItem, Element elmItem) {
        RoleParent objParent;
        QueryItemBase outItem = null;
        String columnName = elmColumn.attributeValue("name");
        String tableName = elmColumn.attributeValue("tableName");
        String schemaName = elmColumn.attributeValue("tableSchema");
        RoleParent roleParent = objParent = objDimParent instanceof MeasureDimension ? (MeasureDimension)objDimParent : objItem.getLevel();
        if (this.doesColumnExist(schemaName, tableName, columnName)) {
            Table objTable = this.findOrCreateTable(objDimParent, schemaName, tableName);
            MdColumn mdColumn = objTable.getPhysicalTable(true).findColumn(columnName);
            if (mdColumn == null) {
                throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_COLUMN_INFO", columnName, tableName);
            }
            outItem = objDimParent.findQueryItemBase(mdColumn);
            if (outItem != null) {
                return outItem;
            }
        }
        outItem = this.createItemForColumn(objDimParent, columnName, objParent, elmColumn, "attribute".equals(elmItem.getName()));
        return outItem;
    }
}

