/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.imprt.cubingServices;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.CalculatedMember;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.FmRegularAggregate;
import com.ibm.cognos.fmeng.fmmd.model.FmUsage;
import com.ibm.cognos.fmeng.fmmd.model.MDXExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.MemberUniqueNameBuilder;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.SemiAggregate;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.fmmd.util.CrnIDHelper;
import com.ibm.cognos.fmeng.imprt.cubingServices.CsDimensionBuilderBase;
import com.ibm.cognos.fmeng.imprt.cubingServices.CsModelImportFeedback;
import com.ibm.cognos.fmeng.metadata.MdSource;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsMeasureDimensionBuilder
extends CsDimensionBuilderBase {
    private Cube mParentCube;
    private HashMap<Measure, Element> mFixupAggregateRules = new HashMap();

    CsMeasureDimensionBuilder(FMMDSession session, MdSource cubeDB, Cube parentCube, CsModelImportFeedback aFeedback) {
        super(session, cubeDB, aFeedback);
        this.mParentCube = parentCube;
    }

    MeasureDimension doImportMeasureDimension(Element elmCubeFacts) {
        List listRefFacts = elmCubeFacts.elements("measureRef");
        if (listRefFacts == null || listRefFacts.size() == 0) {
            throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cube/cubeFacts/measureRef");
        }
        ArrayList<String> refFacts = new ArrayList<String>(listRefFacts.size());
        for (Element elmRef : listRefFacts) {
            String aRef = elmRef.attributeValue("name");
            if (aRef == null || aRef.length() == 0) {
                throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cube/cubeFacts/measureRef/@name");
            }
            refFacts.add(aRef);
        }
        MeasureDimension objMsrDim = this.mParentCube.createMeasureDimension(elmCubeFacts.attributeValue("name"));
        Element elmFacts = elmCubeFacts.getParent().getParent().element("facts");
        if (elmFacts == null) {
            throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cubeModel/facts");
        }
        this.importFacts(objMsrDim, elmFacts, refFacts);
        List listRefCaclMsrs = elmCubeFacts.elements("calculatedMeasureRef");
        ArrayList<String> refCalcMeasures = new ArrayList<String>(listRefCaclMsrs.size());
        for (Element elmRef : listRefCaclMsrs) {
            String aRef = elmRef.attributeValue("name");
            if (aRef == null || aRef.length() == 0) {
                throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cube/cubeFacts/calculatedMeasureRef/@name");
            }
            refCalcMeasures.add(aRef);
        }
        this.importCalculatedMeasures(objMsrDim, elmFacts, refCalcMeasures);
        Element elmDefMsrRef = elmCubeFacts.element("defaultMeasureRef");
        if (elmDefMsrRef != null && elmDefMsrRef.attributeValue("name") != null) {
            String defMsrName = elmDefMsrRef.attributeValue("name");
            for (Measure objMsr : objMsrDim.getAllMeasures()) {
                if (!objMsr.getName().equals(defMsrName)) continue;
                objMsrDim.setDefaultMeasure(objMsr);
                break;
            }
        }
        return objMsrDim;
    }

    private void importCalculatedMeasures(MeasureDimension objMsrDim, Element elmCubeFacts, List<String> CubeRefCalcMeasures) {
        List elmCalcMembers = elmCubeFacts.elements("calculatedMeasure");
        for (Element elmCalcMem : elmCalcMembers) {
            String calcName = elmCalcMem.attributeValue("name");
            if (calcName == null || calcName.length() == 0) {
                throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cubeModel/dimension/hierarchy/calculatedMember/@name");
            }
            if (!CubeRefCalcMeasures.contains(calcName)) continue;
            Element elmExpr = elmCalcMem.element("mdxExpression");
            if (elmExpr == null || elmExpr.attributeValue("template") == null || elmExpr.attributeValue("template").length() == 0) {
                throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cubeModel/dimension/hierarchy/calculatedMember/mdxExpression");
            }
            Element elmParent = elmCalcMem.element("parent");
            if (elmParent == null || elmParent.attributeValue("name") == null || elmParent.attributeValue("name").length() == 0) {
                throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cubeModel/dimension/hierarchy/calculatedMember/parent");
            }
            CalculatedMember objCalcMem = objMsrDim.createCalculatedMeasure(calcName);
            MDXExpressionBuilder bldrExpr = BuilderFactory.createMDXExpressionBuilder();
            bldrExpr.addPart(elmExpr.attributeValue("template"), null);
            objCalcMem.setExpression(bldrExpr);
            MemberUniqueNameBuilder bldrParent = BuilderFactory.createMemberUniqueNameBuilder();
            bldrParent.addPart(elmParent.attributeValue("name"), null);
            objCalcMem.setParentMember(bldrParent);
            Element elmSolveOrder = elmCalcMem.element("solveOrder");
            if (elmSolveOrder == null || elmSolveOrder.attributeValue("value") == null || elmSolveOrder.attributeValue("value").length() == 0) continue;
            objCalcMem.setSolveOrder(Integer.parseInt(elmSolveOrder.attributeValue("value")));
        }
    }

    void fixUpMeasureAggregateRules() {
        for (Map.Entry<Measure, Element> entry : this.mFixupAggregateRules.entrySet()) {
            Measure objMsr = entry.getKey();
            Element elmMsr = entry.getValue();
            List elmAggrs = elmMsr.elements("aggregation");
            for (Element elmAggr : elmAggrs) {
                RelationalDimension objDim;
                Element dimRefEle = elmAggr.element("dimensionRef");
                if (dimRefEle == null || (objDim = this.findReferencedDimension(objMsr, dimRefEle)) == null || objMsr.findAggregateRule(objDim) != null) continue;
                objMsr.createAggregateRule(objDim, this.convertCSSemiAggregateToFM(elmAggr.attributeValue("function")));
            }
        }
    }

    private void importFacts(MeasureDimension objMsrDim, Element elmFacts, List<String> cubeReferencedFacts) {
        ArrayList<QueryItemBase> calculatedItems = new ArrayList<QueryItemBase>();
        ArrayList<Element> calculatedItemSpecs = new ArrayList<Element>();
        HashMap<String, QueryItemBase> name2ObjMapping = new HashMap<String, QueryItemBase>();
        List elmAttributes = elmFacts.elements("attribute");
        for (Element elmAttr : elmAttributes) {
            QueryItem newQItem = this.addQueryItem(objMsrDim, elmAttr, calculatedItems, calculatedItemSpecs);
            name2ObjMapping.put(elmAttr.attributeValue("name"), newQItem);
        }
        List elmMeasures = elmFacts.elements("measure");
        for (Element elmMsr : elmMeasures) {
            String msrName = elmMsr.attributeValue("name");
            if (!cubeReferencedFacts.contains(msrName)) continue;
            Measure newMSr = this.addMeasure(objMsrDim, elmMsr, calculatedItems, calculatedItemSpecs);
            name2ObjMapping.put(elmMsr.attributeValue("name"), newMSr);
        }
        int idx = 0;
        while (idx < calculatedItemSpecs.size()) {
            this.setExpressionForCalculatedItems(objMsrDim, (QueryItemBase)calculatedItems.get(idx), (Element)calculatedItemSpecs.get(idx), name2ObjMapping);
            this.handleMeasureAggregates((Measure)calculatedItems.get(idx), (Element)calculatedItemSpecs.get(idx));
            ++idx;
        }
    }

    private QueryItem addQueryItem(MeasureDimension objMsrDim, Element elmAttr, List<QueryItemBase> calculatedItems, List<Element> calculatedItemSpecs) {
        QueryItem objQueryItem = null;
        if (this.isColumnBased(elmAttr)) {
            objQueryItem = (QueryItem)this.createItem(objMsrDim, objMsrDim, elmAttr);
        } else {
            String bName = elmAttr.attributeValue("name");
            if (bName == null || bName.length() == 0) {
                throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cubeModel/facts/attribute/@name");
            }
            objQueryItem = objMsrDim.createQueryItem(bName, null);
            calculatedItems.add(objQueryItem);
            calculatedItemSpecs.add(elmAttr);
        }
        return objQueryItem;
    }

    private Measure addMeasure(MeasureDimension objMsrDim, Element elmMsr, List<QueryItemBase> calculatedItems, List<Element> calculatedItemSpecs) {
        Measure objMeasure = null;
        if (this.isColumnBased(elmMsr)) {
            objMeasure = (Measure)this.createItem(objMsrDim, objMsrDim, elmMsr);
        } else {
            String bName = elmMsr.attributeValue("name");
            if (bName == null || bName.length() == 0) {
                throw new FmMDException("BMT_MD_CS_IMPORT_MISSING_REQUIRED_INFO", "cubeModel/facts/measure/@name");
            }
            objMeasure = objMsrDim.createMeasure(bName);
            objMeasure.setUsage(FmUsage.fact);
            calculatedItems.add(objMeasure);
            calculatedItemSpecs.add(elmMsr);
        }
        this.handleMeasureAggregates(objMeasure, elmMsr);
        return objMeasure;
    }

    private void handleMeasureAggregates(Measure objMeasure, Element elmMsr) {
        List elmAggrs = elmMsr.elements("aggregation");
        for (Element elmAggr : elmAggrs) {
            Element elmDimRef = elmAggr.element("dimensionRef");
            if (elmDimRef != null) {
                this.mFixupAggregateRules.put(objMeasure, elmMsr);
                continue;
            }
            FmRegularAggregate regularAggr = this.convertCSAggregateToFM(elmAggr.attributeValue("function"));
            objMeasure.setRegularAggregate(regularAggr);
        }
    }

    private RelationalDimension findReferencedDimension(Measure objMsr, Element elmDimRef) {
        String dimName = elmDimRef.attributeValue("name");
        boolean isPrivate = "private".equals(elmDimRef.attributeValue("category"));
        String parentID = null;
        if (isPrivate) {
            parentID = this.mParentCube.getID();
        } else {
            String common = FmMessage.render("BMT_MDN_COMMON_NAMESPACE", this.mSession.getActiveLocale());
            parentID = CrnIDHelper.addEntryToID(null, common);
        }
        TopLevelObject obj = FmModelFactory.getInstance().getById(this.mSession, CrnIDHelper.addEntryToID(parentID, dimName));
        return (RelationalDimension)obj;
    }

    private FmRegularAggregate convertCSAggregateToFM(String aggregateValue) {
        FmRegularAggregate eFMAggr = FmRegularAggregate.unknown;
        if ("AVG".equals(aggregateValue)) {
            eFMAggr = FmRegularAggregate.average;
        } else if ("SUM".equals(aggregateValue)) {
            eFMAggr = FmRegularAggregate.sum;
        } else if ("COUNT".equals(aggregateValue) || "COUNT_BIG".equals(aggregateValue)) {
            eFMAggr = FmRegularAggregate.count;
        } else if ("MIN".equals(aggregateValue)) {
            eFMAggr = FmRegularAggregate.minimum;
        } else if ("MAX".equals(aggregateValue)) {
            eFMAggr = FmRegularAggregate.maximum;
        } else if ("STD".equals(aggregateValue) || "STDDEV".equals(aggregateValue)) {
            eFMAggr = FmRegularAggregate.standardDeviation;
        } else if ("VAR".equals(aggregateValue)) {
            eFMAggr = FmRegularAggregate.variance;
        }
        return eFMAggr;
    }

    private SemiAggregate convertCSSemiAggregateToFM(String aggregateValue) {
        SemiAggregate eFMAggr = SemiAggregate.unknown;
        if ("AVG".equals(aggregateValue)) {
            eFMAggr = SemiAggregate.average;
        } else if ("SUM".equals(aggregateValue)) {
            eFMAggr = SemiAggregate.sum;
        } else if ("COUNT".equals(aggregateValue) || "COUNT_BIG".equals(aggregateValue)) {
            eFMAggr = SemiAggregate.count;
        } else if ("MIN".equals(aggregateValue)) {
            eFMAggr = SemiAggregate.minimum;
        } else if ("MAX".equals(aggregateValue)) {
            eFMAggr = SemiAggregate.maximum;
        } else if ("STD".equals(aggregateValue) || "STDDEV".equals(aggregateValue)) {
            eFMAggr = SemiAggregate.standardDeviation;
        } else if ("VAR".equals(aggregateValue)) {
            eFMAggr = SemiAggregate.variance;
        }
        return eFMAggr;
    }
}

