/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.imprt.cubingServices;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CsModelImportFeedback {
    private static final String FEEDBACK_FILE_PATH = "../logs/CSImportFeedback.xml";
    private String mImportModelFilePath = null;
    private Map<FmRelationalDimensionBase, List<FeedbackItem>> mFeedbacks = new HashMap<FmRelationalDimensionBase, List<FeedbackItem>>();
    private List<Cube> mImportedCubes = new ArrayList<Cube>();
    private String mFeedbackFilePath = null;

    CsModelImportFeedback(String importFilePath) {
        this.mImportModelFilePath = importFilePath;
    }

    public boolean isEmpty() {
        return this.mFeedbacks.isEmpty();
    }

    public String getFilePath() {
        return this.mFeedbackFilePath;
    }

    public List<Cube> getImportedCubes() {
        return this.mImportedCubes;
    }

    void addImportedCube(Cube objCube) {
        this.mImportedCubes.add(objCube);
    }

    void addFeedback(ReportObject obj, FmMessage msg) {
        FmRelationalDimensionBase objDimParent = this.getRelDimParent(obj);
        List<FeedbackItem> listFeedbacks = this.mFeedbacks.get(objDimParent);
        if (listFeedbacks == null) {
            listFeedbacks = new ArrayList<FeedbackItem>();
            this.mFeedbacks.put(objDimParent, listFeedbacks);
        }
        listFeedbacks.add(new FeedbackItem(msg));
    }

    private FmRelationalDimensionBase getRelDimParent(BaseObject obj) {
        BaseObject parent = obj;
        while (parent != null && !(parent instanceof FmRelationalDimensionBase)) {
            parent = parent.getParent();
        }
        FmMDException.ASSERT(parent != null, "Failed to locate a parent of type relational dimension");
        return (FmRelationalDimensionBase)parent;
    }

    void render(Locale aLocale) {
        File file = new File(FEEDBACK_FILE_PATH);
        file.getParentFile().mkdirs();
        try {
            this.mFeedbackFilePath = file.getCanonicalPath();
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8"));
            osw.write("<CSImportFeedback><model filePath=\"");
            osw.write(StringEscapeUtils.escapeXml((String)this.mImportModelFilePath));
            osw.write("\"/>");
            for (Map.Entry<FmRelationalDimensionBase, List<FeedbackItem>> anEntry : this.mFeedbacks.entrySet()) {
                osw.write("<dimension ID=\"");
                osw.write(StringEscapeUtils.escapeXml((String)anEntry.getKey().getID()));
                osw.write("\">");
                for (FeedbackItem fi : anEntry.getValue()) {
                    osw.write("<note>");
                    osw.write(StringEscapeUtils.escapeXml((String)fi.mMsg.render(aLocale)));
                    osw.write("</note>");
                }
                osw.write("</dimension>");
            }
            osw.write("</CSImportFeedback>");
            osw.flush();
            osw.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private class FeedbackItem {
        FmMessage mMsg;

        FeedbackItem(FmMessage msg) {
            this.mMsg = msg;
        }
    }
}

