/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.imprt.relational.browse;

import com.ibm.cognos.fmeng.fmmd.helpers.DomHelper;
import com.ibm.cognos.fmeng.imprt.I_BrowseHandler;
import com.ibm.cognos.fmeng.imprt.ImportUtility;
import com.ibm.cognos.fmeng.imprt.relational.browse.I_RelationalBrowse;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

public class RelDbBrowser
implements I_BrowseHandler {
    FMMDSession m_session;
    I_RelationalBrowse m_handler;

    public RelDbBrowser(FMMDSession session, I_RelationalBrowse handler) {
        this.m_session = session;
        this.m_handler = handler;
    }

    public Element browse(Element browseSpec) {
        Element retElem = browseSpec;
        if (retElem == null) {
            retElem = DomHelper.stringToDom4j("<importSpec/>");
            this.m_handler.expandConnections(retElem);
        } else {
            List expandPatternList = browseSpec.selectNodes(ImportUtility.kNamePatternToken);
            int i = 0;
            while (i < expandPatternList.size()) {
                Node token = (Node)expandPatternList.get(i);
                Element itemElement = token.getParent();
                String type = itemElement.attributeValue("Type");
                String name = itemElement.attributeValue("Name");
                this.expandItem(itemElement, name, type);
                ++i;
            }
        }
        return retElem;
    }

    private void expandItem(Element itemElement, String name, String type) {
        if (type.equals("database")) {
            this.m_handler.expandDatabase(itemElement, name);
        } else if (type.equals("catalog")) {
            String dbName = this.getParentName(itemElement, "database");
            this.m_handler.expandCatalog(itemElement, dbName, name);
        } else if (type.equals("schema")) {
            RelDbBrowser.expandSchema(itemElement);
        } else if (type.equals("tables")) {
            String dbName = this.getParentName(itemElement, "database");
            String catName = this.getParentName(itemElement, "catalog");
            String schemaName = this.getParentName(itemElement, "schema");
            this.m_handler.expandTables(itemElement, dbName, catName, schemaName);
        } else if (type.equals("table")) {
            String dbName = this.getParentName(itemElement, "database");
            String catName = this.getParentName(itemElement, "catalog");
            String schemaName = this.getParentName(itemElement, "schema");
            this.m_handler.expandTable(itemElement, dbName, catName, schemaName, name);
        } else if (type.equals("views")) {
            String dbName = this.getParentName(itemElement, "database");
            String catName = this.getParentName(itemElement, "catalog");
            String schemaName = this.getParentName(itemElement, "schema");
            this.m_handler.expandViews(itemElement, dbName, catName, schemaName);
        } else if (type.equals("view")) {
            String dbName = this.getParentName(itemElement, "database");
            String catName = this.getParentName(itemElement, "catalog");
            String schemaName = this.getParentName(itemElement, "schema");
            this.m_handler.expandView(itemElement, dbName, catName, schemaName, name);
        } else if (type.equals("procedures")) {
            String dbName = this.getParentName(itemElement, "database");
            String catName = this.getParentName(itemElement, "catalog");
            String schemaName = this.getParentName(itemElement, "schema");
            this.m_handler.expandProcedures(itemElement, dbName, catName, schemaName);
        } else if (type.equals("procedure")) {
            String dbName = this.getParentName(itemElement, "database");
            String catName = this.getParentName(itemElement, "catalog");
            String schemaName = this.getParentName(itemElement, "schema");
            this.m_handler.expandProcedure(itemElement, dbName, catName, schemaName, name);
        } else if (type.equals("functions")) {
            String dbName = this.getParentName(itemElement, "database");
            String catName = this.getParentName(itemElement, "catalog");
            String schemaName = this.getParentName(itemElement, "schema");
            this.m_handler.expandFunctions(itemElement, dbName, catName, schemaName);
        } else if (type.equals("synonyms")) {
            String dbName = this.getParentName(itemElement, "database");
            String catName = this.getParentName(itemElement, "catalog");
            String schemaName = this.getParentName(itemElement, "schema");
            this.m_handler.expandSynonyms(itemElement, dbName, catName, schemaName);
        } else if (type.equals("synonym")) {
            String dbName = this.getParentName(itemElement, "database");
            String catName = this.getParentName(itemElement, "catalog");
            String schemaName = this.getParentName(itemElement, "schema");
            this.m_handler.expandSynonym(itemElement, dbName, catName, schemaName);
        } else {
            FmMDException.ASSERT(false, "expanding unknown element" + type);
        }
    }

    static Element expandSchema(Element itemElement) {
        Element updatedBrowseSpec = itemElement;
        ImportUtility.addChildItem(itemElement, "Tables", "tables", "false", "false", null);
        ImportUtility.addChildItem(itemElement, "Views", "views", "false", "false", null);
        ImportUtility.addChildItem(itemElement, "Synonyms", "synonyms", "false", "false", null);
        ImportUtility.addChildItem(itemElement, "Procedures", "procedures", "false", "false", null);
        ImportUtility.addChildItem(itemElement, "Functions", "functions", "false", "false", null);
        return updatedBrowseSpec;
    }

    private String getParentName(Element itemElement, String parentType) {
        String name = "";
        Element parentElement = itemElement;
        while (parentElement != null) {
            String type;
            if ((parentElement = parentElement.getParent()) == null || (type = parentElement.attributeValue("Type")) == null || !type.equals(parentType)) continue;
            name = parentElement.attributeValue("Name");
            break;
        }
        return name != null ? name : "";
    }
}

