/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.imprt.relational.browse;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEncoding;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.RelationalMetadataServiceSpecification;
import com.cognos.developer.schemas.bibus._3.RelationalMetadataService_PortType;
import com.cognos.developer.schemas.bibus._3.RelationalMetadataService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.Specification;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.ibm.cognos.fmeng.imprt.ImportUtility;
import com.ibm.cognos.fmeng.imprt.relational.browse.I_RelationalBrowse;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata.browse.BrowseMetadataRequest;
import com.ibm.cognos.relmd.metadata.browse.MetadataBrowseToolkit;
import com.ibm.cognos.relmd.metadata.browse.functions.BrowseMetadataFunction;
import com.ibm.cognos.relmd.metadata.browse.functions.BrowseQueryType;
import com.ibm.cognos.relmd.metadata.browse.functions.ColumnsBrowse;
import com.ibm.cognos.relmd.metadata.browse.functions.FunctionsBrowse;
import com.ibm.cognos.relmd.metadata.browse.functions.ProceduresBrowse;
import com.ibm.cognos.relmd.metadata.browse.functions.SynonymsBrowse;
import com.ibm.cognos.relmd.metadata.browse.functions.TablesBrowse;
import com.ibm.cognos.relmd.metadata.browse.functions.ViewsBrowse;
import com.ibm.cognos.relmd.metadata.objectPaths.ColumnParentPath;
import com.ibm.cognos.relmd.metadata.objectPaths.MetadataObjectPathsToolkit;
import com.ibm.cognos.relmd.metadata.objectPaths.SchemaParentPath;
import com.ibm.cognos.relmd.metadata.objectPaths.SchemaPath;
import com.ibm.cognos.relmd.metadata.source.MetadataSource;
import com.ibm.cognos.relmd.metadata.source.MetadataSourceToolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.activation.DataHandler;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.SOAPException;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPHeaderElement;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelmdBrowser
implements I_RelationalBrowse {
    Map<String, List<String>> m_map = new HashMap<String, List<String>>();
    List<String> m_databaseList = new ArrayList<String>();
    MetadataBrowseToolkit m_browseToolkit;
    FMMDSession m_session;
    String m_currentDB = "";
    StringBuffer m_key = new StringBuffer();
    private MetadataToolkit m_metadataToolkit;
    private MetadataObjectPathsToolkit m_objectPathsToolkit;

    public RelmdBrowser(FMMDSession session) {
        Relmd relmdGateway = RelmdGateway.relmd();
        this.m_metadataToolkit = relmdGateway.metadataToolkit();
        this.m_objectPathsToolkit = this.m_metadataToolkit.metadataObjectPathsToolkit();
        this.m_browseToolkit = this.m_metadataToolkit.metadataBrowseToolkit();
        this.m_session = session;
    }

    private ArrayList<String> processRequest(String requestXml, String passport) throws Exception {
        ICCLConfiguration configuration = CCLConfigurationFactory.getInstance();
        configuration.init();
        String sdkUri = configuration.getValue("sdk", false);
        URL c8Url = new URL(sdkUri);
        RelationalMetadataServiceSpecification relmdImportRequestSpec = new RelationalMetadataServiceSpecification();
        Specification spec = new Specification(requestXml);
        relmdImportRequestSpec.setValue(spec);
        RelationalMetadataService_PortType relmdPort = new RelationalMetadataService_ServiceLocator().getrelationalMetadataService(c8Url);
        Stub relmdPortStub = (Stub)relmdPort;
        BiBusHeader busHeader = new BiBusHeader();
        if (passport != null && passport.length() > 0) {
            CAM cam = new CAM();
            CAMPassport camPassport = new CAMPassport();
            camPassport.setId(passport);
            cam.setCAMPassport(camPassport);
            busHeader.setCAM(cam);
        }
        relmdPortStub.setHeader("", "biBusHeader", (Object)busHeader);
        Option[] options = new Option[1];
        AsynchOptionEncoding encoding = new AsynchOptionEncoding();
        encoding.setName(AsynchOptionEnum.attachmentEncoding);
        encoding.setValue(EncodingEnum.MIMECompressed);
        options[0] = encoding;
        AsynchReply reply = relmdPort.runSpecification((AsynchSpecification)relmdImportRequestSpec, null, options);
        while (reply.getStatus().equals((Object)AsynchReplyStatusEnum.working) || reply.getStatus().equals((Object)AsynchReplyStatusEnum.stillWorking)) {
            SOAPHeaderElement biBusResponseSoapHeader = relmdPortStub.getResponseHeader("", "biBusHeader");
            BiBusHeader biBusHeaderResponse = (BiBusHeader)biBusResponseSoapHeader.getObjectValue(BiBusHeader.class);
            BiBusHeader biBusHeaderStub = (BiBusHeader)relmdPortStub.getHeader("", "biBusHeader").getObjectValue(BiBusHeader.class);
            Tracking responseTracking = biBusHeaderResponse.getTracking();
            biBusHeaderStub.setTracking(responseTracking);
            reply = relmdPort.wait(reply.getPrimaryRequest(), null, null);
        }
        Object[] attachments = relmdPortStub.getAttachments();
        InputStream is = null;
        if (attachments.length > 0) {
            AttachmentPart attach = (AttachmentPart)attachments[0];
            DataHandler dataHandler = attach.getDataHandler();
            is = dataHandler.getInputStream();
            String[] contentEncodingHeader = attach.getMimeHeader("Content-Encoding");
            if (contentEncodingHeader != null && contentEncodingHeader.length > 0 && contentEncodingHeader[0].equals("gzip")) {
                is = new GZIPInputStream(is);
            }
        } else {
            AsynchDetail[] details = reply.getDetails();
            if (details.length > 0) {
                AsynchDetailMIMEAttachment detail = (AsynchDetailMIMEAttachment)details[0];
                String result = new String(detail.getData(), "UTF8");
                is = new ByteArrayInputStream(result.getBytes("UTF8"));
            }
        }
        ArrayList<String> resultList = new ArrayList<String>();
        if (is != null) {
            SAXReader reader = new SAXReader();
            Document document = reader.read(is);
            List browseElements = document.getRootElement().elements("browsedObject");
            int i = 0;
            while (i < browseElements.size()) {
                String browseObjectName = ((Element)browseElements.get(i)).attributeValue("name");
                if (browseObjectName != null) {
                    resultList.add(browseObjectName);
                }
                ++i;
            }
        }
        return resultList;
    }

    @Override
    public void expandCatalog(Element itemElement, String databaseName, String catalogName) {
        ArrayList<String> objectList = null;
        SchemaPath schemaPath = catalogName.length() == 0 ? this.m_objectPathsToolkit.schemaParentPath() : this.m_objectPathsToolkit.schemaParentPath(catalogName);
        objectList = this.getRelMDObjectList(databaseName, (BrowseMetadataFunction)this.m_browseToolkit.schemasBrowse((SchemaParentPath)schemaPath, BrowseQueryType.EQueryType.regular));
        if (objectList.size() > 0) {
            int i = 0;
            while (i < objectList.size()) {
                ImportUtility.addChildItem(itemElement, objectList.get(i), "schema", "false", "false", null);
                ++i;
            }
        }
    }

    @Override
    public void expandConnections(Element specElement) {
    }

    ArrayList<String> getRelMDObjectList(String databaseName, BrowseMetadataFunction browseFunction) {
        ArrayList<String> objectList = null;
        MetadataSourceToolkit sourceToolkit = this.m_metadataToolkit.metadataSourceToolkit();
        MetadataSource dataSource = sourceToolkit.dataSource(databaseName);
        BrowseMetadataRequest browseRequest = RelmdGateway.relmd().xmlApiToolkit().browseMetadataRequest(browseFunction, dataSource);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            browseRequest.write("relmdApi.xsd", (OutputStream)baos);
            String requestXml = baos.toString("UTF-8");
            objectList = this.processRequest(requestXml, this.m_session.getPassport());
        }
        catch (Exception e) {
            if (e instanceof ServiceException || e instanceof SOAPException) {
                throw new FmMDException("BMT_MD_IMPORT_RELMD_ERR", null, e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
        return objectList;
    }

    @Override
    public void expandDatabase(Element itemElement, String databaseName) {
        ArrayList<String> objectList = null;
        String objectType = "catalog";
        objectList = this.getRelMDObjectList(databaseName, (BrowseMetadataFunction)this.m_browseToolkit.catalogsBrowse(BrowseQueryType.EQueryType.regular));
        if (objectList.size() == 0) {
            SchemaPath schemaParentPath = this.m_objectPathsToolkit.schemaParentPath();
            objectList = this.getRelMDObjectList(databaseName, (BrowseMetadataFunction)this.m_browseToolkit.schemasBrowse((SchemaParentPath)schemaParentPath, BrowseQueryType.EQueryType.regular));
            objectType = "schema";
        }
        if (objectList.size() > 0) {
            int i = 0;
            while (i < objectList.size()) {
                ImportUtility.addChildItem(itemElement, objectList.get(i), objectType, "false", "false", null);
                ++i;
            }
        }
    }

    @Override
    public void expandFunction(Element itemElement, String databaseName, String catalogName, String schemaName, String functionName) {
    }

    @Override
    public void expandFunctions(Element itemElement, String databaseName, String catalogName, String schemaName) {
        SchemaPath schemaPath = this.m_objectPathsToolkit.schemaPath(null, catalogName, schemaName);
        FunctionsBrowse browseFunction = this.m_browseToolkit.functionsBrowse(schemaPath, BrowseQueryType.EQueryType.regular);
        ArrayList<String> objectList = this.getRelMDObjectList(databaseName, (BrowseMetadataFunction)browseFunction);
        if (objectList.size() > 0) {
            int i = 0;
            while (i < objectList.size()) {
                ImportUtility.addChildItem(itemElement, objectList.get(i), "function", "false", "false", null);
                ++i;
            }
        }
    }

    @Override
    public void expandProcedure(Element itemElement, String databaseName, String catalogName, String schemaName, String procedureName) {
    }

    @Override
    public void expandProcedures(Element itemElement, String databaseName, String catalogName, String schemaName) {
        SchemaPath schemaPath = this.m_objectPathsToolkit.schemaPath(null, catalogName, schemaName);
        ProceduresBrowse browseFunction = this.m_browseToolkit.proceduresBrowse(schemaPath, BrowseQueryType.EQueryType.regular);
        ArrayList<String> objectList = this.getRelMDObjectList(databaseName, (BrowseMetadataFunction)browseFunction);
        if (objectList.size() > 0) {
            int i = 0;
            while (i < objectList.size()) {
                ImportUtility.addChildItem(itemElement, objectList.get(i), "procedure", "false", "false", null);
                ++i;
            }
        }
    }

    @Override
    public void expandTable(Element itemElement, String databaseName, String catalogName, String schemaName, String tableName) {
        ColumnParentPath schemaPath = catalogName.length() == 0 ? this.m_objectPathsToolkit.columnParentPath(schemaName, tableName) : this.m_objectPathsToolkit.columnParentPath(catalogName, schemaName, tableName);
        ColumnsBrowse browseFunction = this.m_browseToolkit.columnsBrowse(schemaPath);
        ArrayList<String> objectList = this.getRelMDObjectList(databaseName, (BrowseMetadataFunction)browseFunction);
        if (objectList.size() > 0) {
            int i = 0;
            while (i < objectList.size()) {
                ImportUtility.addChildItem(itemElement, objectList.get(i), "column", "false", "true", null);
                ++i;
            }
        }
    }

    @Override
    public void expandTables(Element itemElement, String databaseName, String catalogName, String schemaName) {
        SchemaPath schemaPath = this.m_objectPathsToolkit.schemaPath(null, catalogName, schemaName);
        TablesBrowse browseFunction = this.m_browseToolkit.tablesBrowse(schemaPath, BrowseQueryType.EQueryType.regular);
        ArrayList<String> objectList = this.getRelMDObjectList(databaseName, (BrowseMetadataFunction)browseFunction);
        if (objectList.size() > 0) {
            int i = 0;
            while (i < objectList.size()) {
                ImportUtility.addChildItem(itemElement, objectList.get(i), "table", "false", "false", null);
                ++i;
            }
        }
    }

    @Override
    public void expandView(Element itemElement, String databaseName, String catalogName, String schemaName, String viewName) {
        ColumnParentPath schemaPath = catalogName.length() == 0 ? this.m_objectPathsToolkit.columnParentPath(schemaName, viewName) : this.m_objectPathsToolkit.columnParentPath(catalogName, schemaName, viewName);
        ColumnsBrowse browseFunction = this.m_browseToolkit.columnsBrowse(schemaPath);
        ArrayList<String> objectList = this.getRelMDObjectList(databaseName, (BrowseMetadataFunction)browseFunction);
        if (objectList.size() > 0) {
            int i = 0;
            while (i < objectList.size()) {
                ImportUtility.addChildItem(itemElement, objectList.get(i), "column", "false", "true", null);
                ++i;
            }
        }
    }

    @Override
    public void expandViews(Element itemElement, String databaseName, String catalogName, String schemaName) {
        SchemaPath schemaPath = this.m_objectPathsToolkit.schemaPath(null, catalogName, schemaName);
        ViewsBrowse browseFunction = this.m_browseToolkit.viewsBrowse(schemaPath, BrowseQueryType.EQueryType.regular);
        ArrayList<String> objectList = this.getRelMDObjectList(databaseName, (BrowseMetadataFunction)browseFunction);
        if (objectList.size() > 0) {
            int i = 0;
            while (i < objectList.size()) {
                ImportUtility.addChildItem(itemElement, objectList.get(i), "view", "false", "false", null);
                ++i;
            }
        }
    }

    @Override
    public void release() {
    }

    @Override
    public void expandSynonym(Element itemElement, String databaseName, String catalogName, String schemaName) {
    }

    @Override
    public void expandSynonyms(Element itemElement, String databaseName, String catalogName, String schemaName) {
        SchemaPath schemaPath = this.m_objectPathsToolkit.schemaPath(null, catalogName, schemaName);
        SynonymsBrowse browseFunction = this.m_browseToolkit.synonymsBrowse(schemaPath, BrowseQueryType.EQueryType.regular);
        ArrayList<String> objectList = this.getRelMDObjectList(databaseName, (BrowseMetadataFunction)browseFunction);
        if (objectList.size() > 0) {
            int i = 0;
            while (i < objectList.size()) {
                ImportUtility.addChildItem(itemElement, objectList.get(i), "view", "false", "false", null);
                ++i;
            }
        }
    }
}

