/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.imprt.relational.browse;

import com.ibm.cognos.fmeng.imprt.ImportUtility;
import com.ibm.cognos.fmeng.imprt.relational.browse.I_RelationalBrowse;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.utility.FmPreferences;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.Metadata;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.Catalog;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema.Schema;
import com.ibm.cognos.relmd.metadata._schema.StoredProcedure;
import com.ibm.cognos.relmd.metadata._schema.Synonym;
import com.ibm.cognos.relmd.metadata._schema.Table;
import com.ibm.cognos.relmd.metadata._schema.UserDefinedFunction;
import com.ibm.cognos.relmd.metadata._schema.View;
import com.ibm.cognos.relmd.metadata._schema._handlers.MetadataObjectHandler;
import com.ibm.cognos.relmd.metadata._schema.elements.Column;
import com.ibm.cognos.relmd.metadata._schema.elements.Index;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata._tools.xml.MetadataXmlToolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.Element;
import org.xml.sax.SAXException;

public class RelmdFileBrowser
implements I_RelationalBrowse,
MetadataObjectHandler {
    Map<String, List<String>> m_map = new HashMap<String, List<String>>();
    List<String> m_databaseList = new ArrayList<String>();
    String m_currentDB = "";
    String m_currentCat = "";
    String m_currentSchema = "";
    StringBuffer m_key = new StringBuffer();

    public static I_RelationalBrowse create() {
        RelmdFileBrowser phyHandler = new RelmdFileBrowser();
        FileInputStream phyFile = null;
        try {
            phyFile = new FileInputStream(new File(RelmdFileBrowser.getPhysicalFileLocation()));
            MetadataToolkit modelToolkit = RelmdGateway.relmd().metadataToolkit();
            MetadataXmlToolkit serializationToolkit = modelToolkit.metadataXmlToolkit();
            serializationToolkit.readModel((InputStream)phyFile, (MetadataObjectHandler)phyHandler);
        }
        catch (FileNotFoundException e) {
            FmEngApplicationLog.getApplicationLog().logException(e);
        }
        catch (SAXException e) {
            FmEngApplicationLog.getApplicationLog().logException(e);
        }
        catch (IOException e) {
            FmEngApplicationLog.getApplicationLog().logException(e);
        }
        catch (ParserConfigurationException e) {
            FmEngApplicationLog.getApplicationLog().logException(e);
        }
        return phyHandler;
    }

    private RelmdFileBrowser() {
    }

    private static String getPhysicalFileLocation() {
        String phyFilePath = FmPreferences.getInstance().getFMPreference("DebugOptions", "PhysicalFilePath");
        if (phyFilePath == null) {
            phyFilePath = "cannot_locate_the_physical_file";
        }
        return phyFilePath;
    }

    public void expandCatalog(Element itemElement, String databaseName, String catalogName) {
        String key = String.valueOf(databaseName) + catalogName;
        List<String> schemas = this.m_map.get(key);
        if (schemas != null) {
            int i = 0;
            while (i < schemas.size()) {
                ImportUtility.addChildItem(itemElement, schemas.get(i), "schema", "false", "false", null);
                ++i;
            }
        }
    }

    public void expandConnections(Element specElement) {
        int i = 0;
        while (i < this.m_databaseList.size()) {
            ImportUtility.addChildItem(specElement, this.m_databaseList.get(i), "database", "false", "false", "OL");
            ++i;
        }
    }

    public void expandDatabase(Element itemElement, String databaseName) {
        List<String> catalogs = this.m_map.get(databaseName);
        if (catalogs != null) {
            int i = 0;
            while (i < catalogs.size()) {
                ImportUtility.addChildItem(itemElement, catalogs.get(i), "catalog", "false", "false", null);
                ++i;
            }
        }
    }

    public void expandFunctions(Element itemElement, String databaseName, String catalogName, String schemaName) {
    }

    public void expandProcedures(Element itemElement, String databaseName, String catalogName, String schemaName) {
    }

    public void expandTables(Element itemElement, String databaseName, String catalogName, String schemaName) {
        String key = String.valueOf(databaseName) + catalogName + schemaName + "tables";
        List<String> tables = this.m_map.get(key);
        if (tables != null) {
            int i = 0;
            while (i < tables.size()) {
                ImportUtility.addChildItem(itemElement, tables.get(i), "table", "false", "false", null);
                ++i;
            }
        }
    }

    public void expandViews(Element itemElement, String databaseName, String catalogName, String schemaName) {
        String key = String.valueOf(databaseName) + catalogName + schemaName + "views";
        List<String> tables = this.m_map.get(key);
        if (tables != null) {
            int i = 0;
            while (i < tables.size()) {
                ImportUtility.addChildItem(itemElement, tables.get(i), "view", "false", "false", null);
                ++i;
            }
        }
    }

    public void expandFunction(Element itemElement, String databaseName, String catalogName, String schemaName, String functionName) {
    }

    public void expandProcedure(Element itemElement, String databaseName, String catalogName, String schemaName, String procedureName) {
    }

    public void expandTable(Element itemElement, String databaseName, String catalogName, String schemaName, String tableName) {
        String key = String.valueOf(databaseName) + catalogName + schemaName + "tables" + tableName;
        List<String> columns = this.m_map.get(key);
        if (columns != null) {
            int i = 0;
            while (i < columns.size()) {
                ImportUtility.addChildItem(itemElement, columns.get(i), "column", "false", "true", null);
                ++i;
            }
        }
    }

    public void expandView(Element itemElement, String databaseName, String catalogName, String schemaName, String viewName) {
        String key = String.valueOf(databaseName) + catalogName + schemaName + "tables" + viewName;
        List<String> columns = this.m_map.get(key);
        if (columns != null) {
            int i = 0;
            while (i < columns.size()) {
                ImportUtility.addChildItem(itemElement, columns.get(i), "column", "false", "true", null);
                ++i;
            }
        }
    }

    public void handleDatabase(Database database) {
        this.m_currentDB = database.dataSourceName();
        this.m_key.setLength(0);
        this.m_key.append(this.m_currentDB);
        this.m_map.put(this.m_key.toString(), new ArrayList());
        this.m_databaseList.add(this.m_currentDB);
    }

    public void handleMetadata(Metadata model) {
    }

    public void handleCatalog(Catalog catalog) {
        this.m_currentCat = catalog.objectName();
        this.m_key.setLength(0);
        this.m_key.append(this.m_currentDB);
        this.m_map.get(this.m_key.toString()).add(catalog.objectName());
    }

    public void handleSchema(Schema schema) {
        this.m_currentSchema = schema.objectName();
        this.m_key.setLength(0);
        this.m_key.append(this.m_currentDB);
        this.m_key.append(this.m_currentCat);
        List<String> schemaList = this.m_map.get(this.m_key.toString());
        if (schemaList == null) {
            schemaList = new ArrayList<String>();
            this.m_map.put(this.m_key.toString(), schemaList);
        }
        schemaList.add(schema.objectName());
    }

    public void handleTable(Table table) {
        this.m_key.setLength(0);
        this.m_key.append(this.m_currentDB);
        this.m_key.append(this.m_currentCat);
        this.m_key.append(this.m_currentSchema);
        this.m_key.append("tables");
        List<String> tableList = this.m_map.get(this.m_key.toString());
        if (tableList == null) {
            tableList = new ArrayList<String>();
            this.m_map.put(this.m_key.toString(), tableList);
        }
        tableList.add(table.objectName());
        this.m_key.append(table.objectName());
        ArrayList<String> colNameList = new ArrayList<String>();
        ReferenceableSet colList = table.columnsSet();
        Iterator i = colList.iterator();
        while (i.hasNext()) {
            colNameList.add(((Column)i.next()).objectName());
        }
        this.m_map.put(this.m_key.toString(), colNameList);
    }

    public void handleView(View view) {
        this.m_key.setLength(0);
        this.m_key.append(this.m_currentDB);
        this.m_key.append(this.m_currentCat);
        this.m_key.append(this.m_currentSchema);
        this.m_key.append("views");
        List<String> tableList = this.m_map.get(this.m_key.toString());
        if (tableList == null) {
            tableList = new ArrayList<String>();
            this.m_map.put(this.m_key.toString(), tableList);
        }
        tableList.add(view.objectName());
        this.m_key.append(view.objectName());
        ArrayList<String> colNameList = new ArrayList<String>();
        ReferenceableSet colList = view.columnsSet();
        Iterator i = colList.iterator();
        while (i.hasNext()) {
            colNameList.add(((Column)i.next()).objectName());
        }
        this.m_map.put(this.m_key.toString(), colNameList);
    }

    public void handleSynonym(Synonym synonym) {
    }

    public void handleIndex(Index index) {
    }

    public void handleStoredProcedure(StoredProcedure storedProcedure) {
    }

    public void handleUserDefinedFunction(UserDefinedFunction udf) {
    }

    public void release() {
    }

    public void done() {
    }

    public void expandSynonym(Element itemElement, String databaseName, String catalogName, String schemaName) {
    }

    public void expandSynonyms(Element itemElement, String databaseName, String catName, String schemaName) {
    }
}

