/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.imprt.relational.impl;

import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.imprt.relational.imprt.objects.I_RelImportDataSource;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.relmd.metadata._schema.Catalog;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema.Schema;
import java.util.HashMap;

public class RelImportDataSource
implements I_RelImportDataSource {
    private static final HashMap<Database.EVendorType, EInterfaceType> m_interfaceTypeMap = new HashMap();
    private DataSource m_dataSource;

    static {
        m_interfaceTypeMap.put(Database.EVendorType.db2, EInterfaceType.D2);
        m_interfaceTypeMap.put(Database.EVendorType.oracle, EInterfaceType.OR);
        m_interfaceTypeMap.put(Database.EVendorType.sqlserver, EInterfaceType.OL);
        m_interfaceTypeMap.put(Database.EVendorType.teradata, EInterfaceType.TD);
        m_interfaceTypeMap.put(Database.EVendorType.netezza, EInterfaceType.NZ);
        m_interfaceTypeMap.put(Database.EVendorType.generic, EInterfaceType.OD);
    }

    public RelImportDataSource(FMMDSession session, Database database, Catalog catalog, Schema schema) {
        String currentDataSourceName = database.dataSourceName();
        Database.EVendorType vendorType = database.vendorType();
        EInterfaceType interfaceType = m_interfaceTypeMap.get(vendorType);
        String interfaceTypeStr = interfaceType.toString();
        this.m_dataSource = session.getProject().findDataSource(currentDataSourceName);
        if (this.m_dataSource == null) {
            this.m_dataSource = session.getProject().createDataSource(currentDataSourceName, catalog.objectName(), schema.objectName(), null, "relational", interfaceTypeStr);
        }
    }

    public DataSource dataSource() {
        return this.m_dataSource;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EInterfaceType {
        OR,
        D2,
        OL,
        NZ,
        TD,
        OD;

    }
}

