/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.imprt.relational.impl;

import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.Determinant;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.FmUsage;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.Section;
import com.ibm.cognos.fmeng.fmmd.model.Status;
import com.ibm.cognos.fmeng.imprt.relational.imprt.objects.I_RelImportDbQuerySubject;
import com.ibm.cognos.fmeng.imprt.relational.imprt.objects.I_RelImportReportObjectNameConverter;
import com.ibm.cognos.fmeng.imprt.relational.imprt.objects.I_RelImportReportObjectRules;
import com.ibm.cognos.internal.relmd.xmlapi.XmlElement;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata._schema.Table;
import com.ibm.cognos.relmd.metadata._schema.View;
import com.ibm.cognos.relmd.metadata._schema.elements.Column;
import com.ibm.cognos.relmd.metadata._schema.elements.ForeignKey;
import com.ibm.cognos.relmd.metadata._schema.elements.Index;
import com.ibm.cognos.relmd.metadata._schema.elements.TableParameter;
import com.ibm.cognos.relmd.metadata._schema.elements.UniqueKey;
import com.ibm.cognos.relmd.metadata._schema.properties.ColumnRef;
import com.ibm.cognos.relmd.metadata._schema.properties.Referenceable;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata._schema.properties.SqlColumn;
import com.ibm.cognos.relmd.metadata._tools.sqlColumnConversions.MetadataSqlColumnConversionToolkit;
import com.ibm.cognos.relmd.metadata._tools.sqlColumnConversions.rules.SqlColumnConversionRules;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelImportDbQuerySubject
implements I_RelImportDbQuerySubject {
    private static final List<FmDatatype> g_factTypesSet = Arrays.asList(FmDatatype.DECIMAL, FmDatatype.FLOAT32, FmDatatype.FLOAT64, FmDatatype.INT16, FmDatatype.INT32, FmDatatype.INT64, FmDatatype.FLOAT, FmDatatype.NUMERIC);
    private QuerySubject m_qs;
    private LinkedHashMap<ColumnRef, QueryItem> m_columnQueryItemMap;
    private final Table m_sourceTable;
    private final I_RelImportReportObjectRules m_reportObjectRules;
    private final SqlColumnConversionRules m_columnConversionRules;

    public RelImportDbQuerySubject(Section parentContainer, Table table, DataSource dataSource, I_RelImportReportObjectRules reportObjectRules, SqlColumnConversionRules columnConversionRules) {
        this.m_columnConversionRules = columnConversionRules;
        this.m_sourceTable = table;
        this.m_reportObjectRules = reportObjectRules;
        this.m_columnQueryItemMap = new LinkedHashMap();
        if (this.m_reportObjectRules.doImport()) {
            this.m_qs = parentContainer.createDbQuerySubject(reportObjectRules.reportObjectName(), dataSource);
            this.m_qs.setStatus(Status.EStatus.valid);
            this.buildQueryItems();
            this.buildDeterminants();
        }
    }

    @Override
    public ColumnRef columnRef(final String columnName) {
        ColumnRef columnRef = new ColumnRef(){

            public String columnName() {
                return columnName;
            }

            public int hashCode() {
                return columnName.hashCode();
            }

            public boolean equals(Object rhs) {
                return columnName.equals(((ColumnRef)rhs).columnName());
            }
        };
        return columnRef;
    }

    public RelImportDbQuerySubject(Section parentContainer, View view, DataSource dataSource, I_RelImportReportObjectRules reportObjectRules, SqlColumnConversionRules columnConversionRules) {
        this(parentContainer, RelImportDbQuerySubject.viewToTable(view), dataSource, reportObjectRules, columnConversionRules);
    }

    @Override
    public QuerySubject dbQuerySubject() {
        return this.m_qs;
    }

    @Override
    public I_RelImportReportObjectRules reportObjectRules() {
        return this.m_reportObjectRules;
    }

    @Override
    public Table sourceTable() {
        return this.m_sourceTable;
    }

    @Override
    public LinkedHashMap<ColumnRef, QueryItem> columnRefQueryItemMap() {
        return this.m_columnQueryItemMap;
    }

    private static Table viewToTable(final View view) {
        Table table = new Table(){

            public String objectName() {
                return view.objectName();
            }

            public String description() {
                return view.description();
            }

            public ReferenceableSet<Column> columnsSet() {
                return view.columnsSet();
            }

            public ReferenceableSet<UniqueKey> uniqueKeysSet() {
                return new ReferenceableSet<UniqueKey>(){

                    public UniqueKey find(Referenceable arg0) {
                        return null;
                    }

                    public UniqueKey find(String arg0) {
                        return null;
                    }

                    public boolean add(UniqueKey e) {
                        return false;
                    }

                    public boolean addAll(Collection<? extends UniqueKey> c) {
                        return false;
                    }

                    public void clear() {
                    }

                    public boolean contains(Object o) {
                        return false;
                    }

                    public boolean containsAll(Collection<?> c) {
                        return false;
                    }

                    public boolean isEmpty() {
                        return true;
                    }

                    public Iterator<UniqueKey> iterator() {
                        return new Iterator<UniqueKey>(){

                            @Override
                            public boolean hasNext() {
                                return false;
                            }

                            @Override
                            public UniqueKey next() {
                                return null;
                            }

                            @Override
                            public void remove() {
                            }
                        };
                    }

                    public boolean remove(Object o) {
                        return false;
                    }

                    public boolean removeAll(Collection<?> c) {
                        return false;
                    }

                    public boolean retainAll(Collection<?> c) {
                        return false;
                    }

                    public int size() {
                        return 0;
                    }

                    public Object[] toArray() {
                        return null;
                    }

                    public <T> T[] toArray(T[] a) {
                        return null;
                    }
                };
            }

            public Collection<Index> indexesCollection() {
                return new ArrayList<Index>();
            }

            public Collection<ForeignKey> foreignKeysCollection() {
                return new ArrayList<ForeignKey>();
            }

            public Collection<String> aliasCollection() {
                return new ArrayList<String>();
            }

            public Collection<String> getAliasCollection() {
                return this.aliasCollection();
            }

            public XmlElement asXml() {
                return view.asXml();
            }

            public ReferenceableSet<TableParameter> tableParametersSet() {
                return null;
            }
        };
        return table;
    }

    private void buildQueryItems() {
        ReferenceableSet columns = this.m_sourceTable.columnsSet();
        for (Column column : columns) {
            Boolean isNullable;
            Integer scale;
            I_RelImportReportObjectNameConverter objectNameConverter = this.m_reportObjectRules.objectNameConverter();
            MetadataSqlColumnConversionToolkit m_columnConversionToolkit = RelmdGateway.relmd().metadataToolkit().metadataSqlColumnConversionToolkit();
            SqlColumn fmColumn = m_columnConversionToolkit.fmColumn((SqlColumn)column, this.m_columnConversionRules);
            String columnName = column.objectName();
            String qiName = objectNameConverter.fmName(columnName);
            QueryItem queryItem = this.m_qs.createExternalQueryItem(qiName, columnName);
            String fmDataType = fmColumn.datatype();
            queryItem.setDatatype(FmDatatype.getValueOf(fmDataType));
            queryItem.setSize(fmColumn.size().intValue());
            Integer precision = fmColumn.precision();
            if (precision != null) {
                queryItem.setPrecision(precision);
            }
            if ((scale = fmColumn.scale()) != null) {
                queryItem.setScale(scale);
            }
            if ((isNullable = fmColumn.isNullable()) != null) {
                queryItem.setNullable(isNullable);
            }
            ColumnRef columnRef = this.columnRef(columnName);
            this.m_columnQueryItemMap.put(columnRef, queryItem);
        }
    }

    private void buildDeterminants() {
        for (UniqueKey uniqueKey : this.m_sourceTable.uniqueKeysSet()) {
            String determinantName = uniqueKey.objectName();
            Collection uniqueKeyColumnRefCollection = uniqueKey.uniqueKeyColumnRefsCollection();
            this.importedDeterminant(determinantName, uniqueKeyColumnRefCollection);
        }
        for (Index index : this.m_sourceTable.indexesCollection()) {
            if (!index.isUnique().booleanValue()) continue;
            String determinantName = index.objectName();
            Collection indexedColumnRefCollection = index.indexedColumnRefsCollection();
            this.importedDeterminant(determinantName, indexedColumnRefCollection);
        }
    }

    private Determinant importedDeterminant(String objectName, Collection<? extends ColumnRef> indexColumnRefs) {
        Determinant determinant = this.m_qs.addDeterminant(objectName);
        determinant.setIdentifiesRow(true);
        determinant.setCanGroup(false);
        Iterator<? extends ColumnRef> columnRefsIter = indexColumnRefs.iterator();
        ArrayList<String> keyColNameList = new ArrayList<String>();
        while (columnRefsIter.hasNext()) {
            ColumnRef columnRef = columnRefsIter.next();
            String columnName = columnRef.columnName();
            QueryItem queryItem1 = this.m_columnQueryItemMap.get(this.columnRef(columnName));
            keyColNameList.add(queryItem1.getName());
        }
        ArrayList<String> keyQueryItemsList = keyColNameList;
        List<QueryItem> qItems = this.m_qs.getAllQueryItems();
        ArrayList<QueryItem> keyQItems = new ArrayList<QueryItem>();
        ArrayList<QueryItem> attrQItems = new ArrayList<QueryItem>();
        int iq = 0;
        while (iq < qItems.size()) {
            QueryItem queryItem = qItems.get(iq);
            String qiName = queryItem.getName();
            if (keyQueryItemsList.contains(qiName)) {
                queryItem.setUsage(FmUsage.identifier);
                keyQItems.add(queryItem);
            } else {
                attrQItems.add(queryItem);
                FmDatatype datatype = queryItem.getDatatype();
                FmUsage usage = g_factTypesSet.contains((Object)datatype) ? FmUsage.fact : FmUsage.attribute;
                queryItem.setUsage(usage);
            }
            ++iq;
        }
        determinant.setKeys(keyQItems);
        determinant.setAttributes(attrQItems);
        return determinant;
    }
}

