/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.imprt.relational.impl;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationship;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.model.Determinant;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.imprt.relational.imprt.objects.I_RelImportDbQuerySubject;
import com.ibm.cognos.fmeng.imprt.relational.imprt.relationships.I_RelImportRelationshipInfoBuilderAmongstImported;
import com.ibm.cognos.fmeng.imprt.relational.imprt.relationships.I_RelImportRelationshipOptions;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.relmd.metadata._schema.Table;
import com.ibm.cognos.relmd.metadata._schema.elements.ForeignKey;
import com.ibm.cognos.relmd.metadata._schema.elements.Index;
import com.ibm.cognos.relmd.metadata._schema.properties.ColumnRef;
import com.ibm.cognos.relmd.metadata._schema.properties.ExportedColumnRef;
import com.ibm.cognos.relmd.metadata._schema.properties.IndexedColumnRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RelImportRelationshipBuilder
implements I_RelImportRelationshipInfoBuilderAmongstImported {
    public static final String RELATIONAL_EXPRESSION_OPERATOR_EQUALS = " = ";
    public static final String RELATIONAL_EXPRESSION_OPERATOR_AND = " AND ";
    private final I_RelImportRelationshipOptions m_options;
    private final FMMDSession m_session;
    private final boolean m_byForeignKeys;
    private final boolean m_byIndexes;
    private LinkedHashMap<String, I_RelImportDbQuerySubject> m_importedTableQuerySubjects;
    private HashMap<ColumnRef, Collection<I_RelImportDbQuerySubject>> m_columnImportedQuerySubjectMap;

    public RelImportRelationshipBuilder(FMMDSession session, I_RelImportRelationshipOptions options) {
        this.m_session = session;
        this.m_options = options;
        this.m_importedTableQuerySubjects = new LinkedHashMap();
        this.m_byForeignKeys = this.m_options.byForeignKeys();
        this.m_byIndexes = this.m_options.byIndexes();
        this.m_columnImportedQuerySubjectMap = new HashMap();
    }

    public void handleImportedQuerySubject(I_RelImportDbQuerySubject relImportDbQuerySubject) {
        Table sourceTable = relImportDbQuerySubject.sourceTable();
        String qsName = sourceTable.objectName();
        this.m_importedTableQuerySubjects.put(qsName, relImportDbQuerySubject);
        if (this.m_byIndexes) {
            LinkedHashMap<ColumnRef, QueryItem> columnRefQueryItemMap = relImportDbQuerySubject.columnRefQueryItemMap();
            for (Map.Entry<ColumnRef, QueryItem> columnRefQueryItemMapEntry : columnRefQueryItemMap.entrySet()) {
                ColumnRef columnRef = columnRefQueryItemMapEntry.getKey();
                Collection<I_RelImportDbQuerySubject> foundQueryItems = this.m_columnImportedQuerySubjectMap.get(columnRef);
                if (foundQueryItems == null) {
                    foundQueryItems = new ArrayList<I_RelImportDbQuerySubject>();
                    this.m_columnImportedQuerySubjectMap.put(columnRef, foundQueryItems);
                }
                foundQueryItems.add(relImportDbQuerySubject);
            }
        }
    }

    public void handleExistingQuerySubject(FmQuerySubject querySubject) {
    }

    public void generateBasedOnKeys() {
        if (this.m_byForeignKeys) {
            for (I_RelImportDbQuerySubject relImportDbQuerySubject : this.m_importedTableQuerySubjects.values()) {
                QuerySubject dbQuerySubject = relImportDbQuerySubject.dbQuerySubject();
                Table sourceTable = relImportDbQuerySubject.sourceTable();
                Collection foreignKeyCollection = sourceTable.foreignKeysCollection();
                for (ForeignKey foreignKey : foreignKeyCollection) {
                    String importedTableName = foreignKey.importedTableRef();
                    I_RelImportDbQuerySubject importedKeyDbQuerySubject = this.m_importedTableQuerySubjects.get(importedTableName);
                    if (importedKeyDbQuerySubject == null) continue;
                    String importedUniqueKey = foreignKey.importedUniqueKeyRef();
                    Determinant importedKeyDeterminant = importedKeyDbQuerySubject.dbQuerySubject().getDeteriminant(importedUniqueKey);
                    if (importedKeyDeterminant == null) continue;
                    Collection exportedColumnRefCollection = foreignKey.exportedColumnRefsCollection();
                    List<QueryItem> keys = importedKeyDeterminant.getKeys();
                    if (exportedColumnRefCollection.size() != keys.size()) continue;
                    ExpressionBuilder expression = BuilderFactory.createExpressionBuilder();
                    Iterator exportedColumnRefIter = exportedColumnRefCollection.iterator();
                    Iterator<QueryItem> importedKeyQueryItemsIter = keys.iterator();
                    while (exportedColumnRefIter.hasNext()) {
                        ExportedColumnRef exportedColumnRef = (ExportedColumnRef)exportedColumnRefIter.next();
                        String exportedColumnName = exportedColumnRef.columnName();
                        LinkedHashMap<ColumnRef, QueryItem> columnRefQueryItemMap = relImportDbQuerySubject.columnRefQueryItemMap();
                        ColumnRef columnRef = relImportDbQuerySubject.columnRef(exportedColumnName);
                        QueryItem exportedQueryItem = columnRefQueryItemMap.get(columnRef);
                        while (exportedColumnRefIter.hasNext()) {
                            QueryItem importedKeyQueryItemRef = importedKeyQueryItemsIter.next();
                            if (!expression.isEmpty()) {
                                expression.addExpressionPart(RELATIONAL_EXPRESSION_OPERATOR_AND, null);
                            }
                            expression.addExpressionPart(exportedQueryItem, null, null);
                            expression.addExpressionPart(RELATIONAL_EXPRESSION_OPERATOR_EQUALS, null);
                            expression.addExpressionPart(importedKeyQueryItemRef, null, null);
                        }
                    }
                    Relationship relationship = this.m_session.getProject().getRootNamespace().createRelationship(expression, dbQuerySubject, importedKeyDbQuerySubject.dbQuerySubject());
                    relationship.setLeftMaxcard(Cardinality.ECardinality.many);
                    relationship.setLeftMincard(Cardinality.ECardinality.one);
                    relationship.setRightMaxcard(Cardinality.ECardinality.one);
                    relationship.setRightMincard(Cardinality.ECardinality.one);
                }
            }
        }
    }

    public void generateBasedOnIndexes() {
        if (this.m_byIndexes) {
            for (I_RelImportDbQuerySubject relImportDbQuerySubject : this.m_importedTableQuerySubjects.values()) {
                QuerySubject dbQuerySubject = relImportDbQuerySubject.dbQuerySubject();
                Table sourceTable = relImportDbQuerySubject.sourceTable();
                Collection indexCollection = sourceTable.indexesCollection();
                for (Index index : indexCollection) {
                    if (!index.isUnique().booleanValue()) continue;
                    for (I_RelImportDbQuerySubject rhsCandidate : this.m_importedTableQuerySubjects.values()) {
                        if (relImportDbQuerySubject == rhsCandidate) continue;
                        Collection indexedColumnRefCollection = index.indexedColumnRefsCollection();
                        LinkedHashMap<ColumnRef, QueryItem> rhsColumnRefQueryItemMap = rhsCandidate.columnRefQueryItemMap();
                        if (rhsColumnRefQueryItemMap.size() < indexedColumnRefCollection.size()) continue;
                        ExpressionBuilder expression = BuilderFactory.createExpressionBuilder();
                        boolean bAllFound = true;
                        Iterator indexedColumnRefCollectionIter = indexedColumnRefCollection.iterator();
                        while (indexedColumnRefCollectionIter.hasNext() && bAllFound) {
                            IndexedColumnRef indexedColumnRef = (IndexedColumnRef)indexedColumnRefCollectionIter.next();
                            QueryItem foundQI = rhsColumnRefQueryItemMap.get(indexedColumnRef.columnName());
                            if (foundQI == null) {
                                bAllFound = false;
                                continue;
                            }
                            if (!expression.isEmpty()) {
                                expression.addExpressionPart(RELATIONAL_EXPRESSION_OPERATOR_AND, null);
                            }
                            expression.addExpressionPart(foundQI, null, null);
                            expression.addExpressionPart(RELATIONAL_EXPRESSION_OPERATOR_EQUALS, null);
                            expression.addExpressionPart(foundQI, null, null);
                        }
                        if (!bAllFound) continue;
                        FmRelationship relationship = FmRelationship.createRelationship(this.m_session, expression, dbQuerySubject, rhsCandidate.dbQuerySubject());
                        relationship.setLeftMaxcard(Cardinality.ECardinality.many);
                        relationship.setLeftMincard(Cardinality.ECardinality.one);
                        relationship.setRightMaxcard(Cardinality.ECardinality.one);
                        relationship.setRightMincard(Cardinality.ECardinality.one);
                    }
                }
            }
        }
    }

    public void generateBasedOnColumns() {
    }
}

