/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.imprt.relational.impl;

import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.FmRegularAggregate;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.Section;
import com.ibm.cognos.fmeng.fmmd.model.StoredProcedure;
import com.ibm.cognos.fmeng.imprt.relational.imprt.objects.I_RelImportReportObjectRules;
import com.ibm.cognos.fmeng.imprt.relational.imprt.objects.I_RelImportStoredProcedureQuerySubject;
import com.ibm.cognos.internal.relmd.xmlapi.XmlElement;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata._schema.elements.Argument;
import com.ibm.cognos.relmd.metadata._schema.elements.NestedArgument;
import com.ibm.cognos.relmd.metadata._schema.elements.Signature;
import com.ibm.cognos.relmd.metadata._schema.properties.SqlColumn;
import com.ibm.cognos.relmd.metadata._tools.sqlColumnConversions.MetadataSqlColumnConversionToolkit;
import com.ibm.cognos.relmd.metadata._tools.sqlColumnConversions.rules.SqlColumnConversionRules;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelImportStoredProcedureQuerySubject
implements I_RelImportStoredProcedureQuerySubject {
    private Section m_parentContainer;
    private SqlColumnConversionRules m_columnConversionRules;
    private com.ibm.cognos.relmd.metadata._schema.StoredProcedure m_sourceRoutine;
    private QuerySubject m_qs;

    public RelImportStoredProcedureQuerySubject(Section parent, com.ibm.cognos.relmd.metadata._schema.StoredProcedure routine, DataSource dataSource, I_RelImportReportObjectRules reportObjectRules, SqlColumnConversionRules columnConversionRules) {
        this.m_sourceRoutine = routine;
        this.m_columnConversionRules = columnConversionRules;
        this.m_parentContainer = parent;
        if (reportObjectRules.doImport()) {
            String qsName = routine.objectName();
            Collection<Signature> routineSignatureCollection = routine.routineSignaturesCollection();
            routineSignatureCollection = this.cleanSignatures(routineSignatureCollection);
            for (Signature routineSignature : routineSignatureCollection) {
                this.m_qs = this.m_parentContainer.createStoredProcedure(qsName, dataSource, qsName);
                this.buildProcParameters(routineSignature, this.m_columnConversionRules);
            }
        }
    }

    @Override
    public QuerySubject dbQuerySubject() {
        return this.m_qs;
    }

    @Override
    public com.ibm.cognos.relmd.metadata._schema.StoredProcedure sourceRoutine() {
        return this.m_sourceRoutine;
    }

    private LinkedHashMap<String, QueryItem> buildProcParameters(Signature routineSignature, SqlColumnConversionRules columnConversionRules) {
        LinkedHashMap<String, QueryItem> columnQueryItemMap = new LinkedHashMap<String, QueryItem>();
        Collection arguments = routineSignature.routineArgumentsCollection();
        Iterator argumentsIter = arguments.iterator();
        StoredProcedure def = this.m_qs.getStoredProcedure();
        while (argumentsIter.hasNext()) {
            Argument argument = (Argument)argumentsIter.next();
            MetadataSqlColumnConversionToolkit columnConversionToolkit = RelmdGateway.relmd().metadataToolkit().metadataSqlColumnConversionToolkit();
            SqlColumn fmColumn = columnConversionToolkit.fmColumn((SqlColumn)argument, columnConversionRules);
            String columnName = argument.objectName();
            String fmDataType = fmColumn.datatype();
            Integer size = fmColumn.size();
            Integer precision = fmColumn.precision();
            Integer scale = fmColumn.scale();
            Boolean isNullable = fmColumn.isNullable();
            FmDatatype fmEngDataType = FmDatatype.getValueOf(fmDataType);
            Argument.EMode mode = argument.mode();
            StoredProcedure.EParamMode fmMode = StoredProcedure.EParamMode.valueOf(mode.toString());
            FmRegularAggregate agg = FmRegularAggregate.valueOf("unknown");
            def.addProcParameter(agg, fmEngDataType, fmMode, isNullable, columnName, precision == null ? 0 : precision, scale == null ? 0 : scale, size == null ? 0 : size);
            QueryItem qi = this.m_qs.createExternalQueryItem(columnName, columnName);
            qi.setDatatype(fmEngDataType);
            if (size != null) {
                qi.setSize(size.intValue());
            }
            if (precision != null) {
                qi.setPrecision(precision);
            }
            if (scale != null) {
                qi.setScale(scale);
            }
            if (isNullable != null) {
                qi.setNullable(isNullable);
            }
            columnQueryItemMap.put(columnName, qi);
        }
        return columnQueryItemMap;
    }

    private Collection<Signature> cleanSignatures(Collection<Signature> signatures) {
        Signature emptyFilteredSignature = null;
        for (Signature signature : signatures) {
            Collection routineArgumentCollection = signature.routineArgumentsCollection();
            ArrayList<Argument> filteredRoutineArgmentCollection = new ArrayList<Argument>();
            boolean bArgCollectionChanged = false;
            for (Argument argument : routineArgumentCollection) {
                Collection nestedArguments = argument.nestedArgumentsCollection();
                if (nestedArguments.size() == 0) {
                    filteredRoutineArgmentCollection.add(argument);
                } else {
                    bArgCollectionChanged = true;
                    Argument.EMode mode = argument.mode();
                    int ordinal = 0;
                    for (NestedArgument nestedArgument : nestedArguments) {
                        Argument newArgument = this.newArgument(mode, nestedArgument, ordinal++);
                        filteredRoutineArgmentCollection.add(newArgument);
                    }
                }
                if (!bArgCollectionChanged) continue;
                routineArgumentCollection.clear();
                routineArgumentCollection.addAll(filteredRoutineArgmentCollection);
                if (emptyFilteredSignature != null || filteredRoutineArgmentCollection.size() != 0) continue;
                emptyFilteredSignature = signature;
            }
        }
        ArrayList<Signature> reorderedSignatures = new ArrayList<Signature>();
        if (emptyFilteredSignature != null) {
            reorderedSignatures.add(emptyFilteredSignature);
        }
        reorderedSignatures.addAll(signatures);
        return reorderedSignatures;
    }

    private Argument newArgument(final Argument.EMode mode, final NestedArgument nestedArgument, final int ordinal) {
        return new Argument(){

            public String objectName() {
                return nestedArgument.objectName();
            }

            public String description() {
                return nestedArgument.description();
            }

            public Argument.EMode mode() {
                return mode;
            }

            public Argument.EMode getMode() {
                return this.mode();
            }

            public String datatype() {
                return nestedArgument.datatype();
            }

            public Boolean hasSize() {
                if (this.size() != null) {
                    return true;
                }
                return false;
            }

            public Integer size() {
                return nestedArgument.size();
            }

            public Boolean hasPrecision() {
                if (this.precision() != null) {
                    return true;
                }
                return false;
            }

            public Integer precision() {
                return nestedArgument.precision();
            }

            public Boolean hasScale() {
                if (this.scale() != null) {
                    return true;
                }
                return false;
            }

            public Integer scale() {
                return nestedArgument.scale();
            }

            public Boolean hasDefaultValue() {
                if (this.defaultValue() != null) {
                    return true;
                }
                return false;
            }

            public String defaultValue() {
                return nestedArgument.defaultValue();
            }

            public Boolean hasIsNullable() {
                if (this.isNullable() != null) {
                    return true;
                }
                return false;
            }

            public Boolean isNullable() {
                return nestedArgument.isNullable();
            }

            public Boolean hasCollationSequence() {
                if (this.collationSequence() != null) {
                    return true;
                }
                return false;
            }

            public String collationSequence() {
                return nestedArgument.collationSequence();
            }

            public Integer dataLevel() {
                return nestedArgument.dataLevel();
            }

            public Collection<NestedArgument> nestedArgumentsCollection() {
                return new ArrayList<NestedArgument>();
            }

            public XmlElement asXml() {
                return null;
            }

            public SqlColumn.SourceType sourceType() {
                return SqlColumn.SourceType.native_;
            }

            public Integer ordinalPosition() {
                return new Integer(ordinal);
            }
        };
    }
}

