/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.imprt.relational.impl;

import com.ibm.cognos.internal.relmd.xmlapi.XmlElement;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelectionsToolkit;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.SelectionChoice;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllCatalogsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllFunctionsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllProceduresSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllSchemasSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllSynonymsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllTablesSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllViewsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.SelectedAllObjects;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.CatalogSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.FunctionSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.ObjectSelectionsContainer;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.ProcedureSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SchemaSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SchemaSelectionsContainer;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SynonymSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SystemObjectSelections;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.TableSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.ViewSelection;
import java.util.HashMap;
import java.util.Iterator;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelmdImportSpecObjectSelections
implements MetadataObjectSelections {
    private MetadataObjectSelections m_databaseObjectSelections;
    private MetadataObjectSelectionsToolkit m_objectSelectionsToolkit;
    private static final HashMap<String, String> g_selectionTypeMappings = new HashMap();

    static {
        g_selectionTypeMappings.put("true", "all");
        g_selectionTypeMappings.put("partial", "partial");
        g_selectionTypeMappings.put("false", "none");
    }

    public RelmdImportSpecObjectSelections(Element importSpecElem) {
        MetadataToolkit metadataToolkit = RelmdGateway.relmd().metadataToolkit();
        this.m_objectSelectionsToolkit = metadataToolkit.metadataObjectSelectionsToolkit();
        this.m_databaseObjectSelections = this.m_objectSelectionsToolkit.metadataObjectSelections();
        EElementType elemType = this.elemType(importSpecElem);
        if (EElementType.database.equals((Object)elemType)) {
            this.visitDatabaseElem(importSpecElem);
        }
    }

    private void visitDatabaseElem(Element importSpecElem) {
        ESelectionType selectionType = this.selectionType(importSpecElem);
        boolean isSystem = this.isSystem(importSpecElem);
        switch (selectionType) {
            case all: {
                boolean bCatalogs = false;
                boolean bSchemas = false;
                Iterator elementIterator = importSpecElem.elementIterator();
                while (!(bCatalogs && bSchemas || !elementIterator.hasNext())) {
                    Element element = (Element)elementIterator.next();
                    EElementType elemType = this.elemType(element);
                    switch (elemType) {
                        case catalog: {
                            bCatalogs = true;
                            break;
                        }
                        case sysCatalog: {
                            bCatalogs = true;
                            isSystem = true;
                            break;
                        }
                        case schema: {
                            bSchemas = true;
                            break;
                        }
                        case sysSchema: {
                            bSchemas = true;
                            isSystem = true;
                        }
                    }
                    if (bCatalogs) {
                        AllCatalogsSelection newAllCatalogs = this.m_objectSelectionsToolkit.allCatalogsSelection(isSystem);
                        this.m_databaseObjectSelections.catalogSelections().setAll((SelectedAllObjects)newAllCatalogs);
                    }
                    if (!bSchemas) continue;
                    AllSchemasSelection newAllSchemas = this.m_objectSelectionsToolkit.allSchemasSelection(isSystem);
                    this.m_databaseObjectSelections.schemaSelections().setAll((SelectedAllObjects)newAllSchemas);
                }
                break;
            }
            case partial: {
                Iterator childElemIter = importSpecElem.elementIterator();
                while (childElemIter.hasNext()) {
                    Element element = (Element)childElemIter.next();
                    EElementType elemType = this.elemType(element);
                    switch (elemType) {
                        case catalog: {
                            this.visitCatalogElem(element, isSystem);
                            break;
                        }
                        case sysCatalog: {
                            this.visitCatalogElem(element, true);
                            break;
                        }
                        case schema: {
                            this.visitSchemaElem(element, (SchemaSelectionsContainer)this.m_databaseObjectSelections, isSystem);
                            break;
                        }
                        case sysSchema: {
                            this.visitSchemaElem(element, (SchemaSelectionsContainer)this.m_databaseObjectSelections, true);
                        }
                    }
                }
                break;
            }
        }
    }

    private void visitSchemaElem(Element schemaElem, SchemaSelectionsContainer schemaSelectionsContainer, boolean isSystemSchema) {
        String elemName = this.selectedObjectName(schemaElem);
        ESelectionType selectionType = this.selectionType(schemaElem);
        ReferenceableSet schemaSelections = schemaSelectionsContainer.schemaSelections().selectedObjects();
        SchemaSelection newSchemaSelection = null;
        switch (selectionType) {
            case partial: {
                newSchemaSelection = this.m_objectSelectionsToolkit.schemaSelection(elemName);
                schemaSelections.add((Object)newSchemaSelection);
                Element sysObjectsElem = this.visitObjectSelections(schemaElem, (ObjectSelectionsContainer)newSchemaSelection);
                if (sysObjectsElem == null) break;
                SystemObjectSelections newSystemObjectSelections = this.m_objectSelectionsToolkit.systemObjectSelections();
                newSchemaSelection.setSystemObjectSelections(newSystemObjectSelections);
                this.visitObjectSelections(sysObjectsElem, (ObjectSelectionsContainer)newSystemObjectSelections);
                break;
            }
            case all: {
                newSchemaSelection = this.m_objectSelectionsToolkit.schemaSelection(elemName);
                schemaSelections.add((Object)newSchemaSelection);
                this.m_objectSelectionsToolkit.selectAllChildren((ObjectSelectionsContainer)newSchemaSelection);
                if (!isSystemSchema) break;
                SystemObjectSelections newSystemObjectSelections = this.m_objectSelectionsToolkit.systemObjectSelections();
                newSchemaSelection.setSystemObjectSelections(newSystemObjectSelections);
                this.m_objectSelectionsToolkit.selectAllChildren((ObjectSelectionsContainer)newSystemObjectSelections);
            }
        }
    }

    private Element visitObjectSelections(Element schemaElem, ObjectSelectionsContainer objectSelectionsContainer) {
        Element sysObjectsElem = null;
        Iterator schemaChildElemIter = schemaElem.elementIterator();
        block28: while (schemaChildElemIter.hasNext()) {
            Element schemaChildElem = (Element)schemaChildElemIter.next();
            ESelectionType schemaElemSelectionType = this.selectionType(schemaChildElem);
            EElementType elemType = this.elemType(schemaChildElem);
            block0 : switch (elemType) {
                case sysObjects: {
                    if (ESelectionType.none.equals((Object)schemaElemSelectionType)) break;
                    sysObjectsElem = schemaChildElem;
                    break;
                }
                case tables: 
                case sysTables: {
                    SelectionChoice tableSelections = objectSelectionsContainer.tableSelections();
                    switch (schemaElemSelectionType) {
                        case all: {
                            AllTablesSelection newAllTables = this.m_objectSelectionsToolkit.allTablesSelection();
                            tableSelections.setAll((SelectedAllObjects)newAllTables);
                            break;
                        }
                        case partial: {
                            Iterator childElemIter = schemaChildElem.elementIterator();
                            while (childElemIter.hasNext()) {
                                Element childElem = (Element)childElemIter.next();
                                ESelectionType childElemSelectionType = this.selectionType(childElem);
                                if (ESelectionType.none.equals((Object)childElemSelectionType)) continue;
                                String selectedObjectName = this.selectedObjectName(childElem);
                                TableSelection newTableSelection = this.m_objectSelectionsToolkit.tableSelection(selectedObjectName);
                                tableSelections.selectedObjects().add((Object)newTableSelection);
                            }
                            break;
                        }
                    }
                    continue block28;
                }
                case views: 
                case sysViews: {
                    SelectionChoice viewSelections = objectSelectionsContainer.viewSelections();
                    switch (schemaElemSelectionType) {
                        case all: {
                            AllViewsSelection newAllViews = this.m_objectSelectionsToolkit.allViewsSelection();
                            viewSelections.setAll((SelectedAllObjects)newAllViews);
                            break;
                        }
                        case partial: {
                            Iterator childElemIter = schemaChildElem.elementIterator();
                            while (childElemIter.hasNext()) {
                                Element childElem = (Element)childElemIter.next();
                                ESelectionType childElemSelectionType = this.selectionType(childElem);
                                if (ESelectionType.none.equals((Object)childElemSelectionType)) continue;
                                String selectedObjectName = this.selectedObjectName(childElem);
                                ViewSelection newViewSelection = this.m_objectSelectionsToolkit.viewSelection(selectedObjectName);
                                viewSelections.selectedObjects().add((Object)newViewSelection);
                            }
                            break;
                        }
                    }
                    continue block28;
                }
                case procedures: {
                    SelectionChoice procedureSelections = objectSelectionsContainer.procedureSelections();
                    switch (schemaElemSelectionType) {
                        case all: {
                            AllProceduresSelection newAllProcedures = this.m_objectSelectionsToolkit.allProceduresSelection();
                            procedureSelections.setAll((SelectedAllObjects)newAllProcedures);
                            break;
                        }
                        case partial: {
                            Iterator childElemIter = schemaChildElem.elementIterator();
                            while (childElemIter.hasNext()) {
                                Element childElem = (Element)childElemIter.next();
                                ESelectionType childElemSelectionType = this.selectionType(childElem);
                                if (ESelectionType.none.equals((Object)childElemSelectionType)) continue;
                                String selectedObjectName = this.selectedObjectName(childElem);
                                ProcedureSelection newProcedureSelection = this.m_objectSelectionsToolkit.procedureSelection(selectedObjectName);
                                procedureSelections.selectedObjects().add((Object)newProcedureSelection);
                            }
                            break;
                        }
                    }
                    continue block28;
                }
                case functions: {
                    SelectionChoice functionSelections = objectSelectionsContainer.functionSelections();
                    switch (schemaElemSelectionType) {
                        case all: {
                            AllFunctionsSelection newAllFunctions = this.m_objectSelectionsToolkit.allFunctionsSelection();
                            functionSelections.setAll((SelectedAllObjects)newAllFunctions);
                            break;
                        }
                        case partial: {
                            Iterator childElemIter = schemaChildElem.elementIterator();
                            while (childElemIter.hasNext()) {
                                Element childElem = (Element)childElemIter.next();
                                ESelectionType childElemSelectionType = this.selectionType(childElem);
                                if (ESelectionType.none.equals((Object)childElemSelectionType)) continue;
                                String selectedObjectName = this.selectedObjectName(childElem);
                                FunctionSelection newFunctionSelection = this.m_objectSelectionsToolkit.functionSelection(selectedObjectName);
                                functionSelections.selectedObjects().add((Object)newFunctionSelection);
                            }
                            break;
                        }
                    }
                    continue block28;
                }
                case synonyms: 
                case sysSynonyms: {
                    SelectionChoice synonymSelections = objectSelectionsContainer.synonymSelections();
                    switch (schemaElemSelectionType) {
                        case all: {
                            AllSynonymsSelection newAllSynonyms = this.m_objectSelectionsToolkit.allSynonymsSelection();
                            synonymSelections.setAll((SelectedAllObjects)newAllSynonyms);
                            break block0;
                        }
                        case partial: {
                            Iterator childElemIter = schemaChildElem.elementIterator();
                            while (childElemIter.hasNext()) {
                                Element childElem = (Element)childElemIter.next();
                                ESelectionType childElemSelectionType = this.selectionType(childElem);
                                if (!ESelectionType.all.equals((Object)childElemSelectionType)) continue;
                                String selectedObjectName = this.selectedObjectName(childElem);
                                SynonymSelection newSynonymSelection = this.m_objectSelectionsToolkit.synonymSelection(selectedObjectName);
                                synonymSelections.selectedObjects().add((Object)newSynonymSelection);
                            }
                            break block0;
                        }
                    }
                }
            }
        }
        return sysObjectsElem;
    }

    private String selectedObjectName(Element selectedObjectElem) {
        String elemName = selectedObjectElem.attributeValue("Name");
        return elemName;
    }

    private void visitCatalogElem(Element catalogElem, boolean includeSystemObjects) {
        String elemName = this.selectedObjectName(catalogElem);
        CatalogSelection newCatalogSelection = this.m_objectSelectionsToolkit.catalogSelection(elemName);
        this.m_databaseObjectSelections.catalogSelections().selectedObjects().add((Object)newCatalogSelection);
        ESelectionType selectionType = this.selectionType(catalogElem);
        switch (selectionType) {
            case partial: {
                Iterator childElemIter = catalogElem.elementIterator();
                while (childElemIter.hasNext()) {
                    Element childElem = (Element)childElemIter.next();
                    this.visitSchemaElem(childElem, (SchemaSelectionsContainer)newCatalogSelection, includeSystemObjects);
                }
                break;
            }
            case all: {
                newCatalogSelection.schemaSelections().setAll((SelectedAllObjects)this.m_objectSelectionsToolkit.allSchemasSelection(includeSystemObjects));
            }
        }
    }

    private EElementType elemType(Element importSpecElem) {
        String typeValue = importSpecElem.attributeValue("Type");
        return EElementType.valueOf(typeValue);
    }

    private ESelectionType selectionType(Element importSpecElem) {
        String attributeValue = importSpecElem.attributeValue("Value");
        String selectionTypeValue = g_selectionTypeMappings.get(attributeValue);
        ESelectionType selectionType = ESelectionType.valueOf(selectionTypeValue);
        return selectionType;
    }

    private boolean isSystem(Element itemElem) {
        String isSystemStr = itemElem.attributeValue("isSystem");
        boolean isSystem = "true".equals(isSystemStr);
        return isSystem;
    }

    public SelectionChoice<CatalogSelection, AllCatalogsSelection> catalogSelections() {
        return this.m_databaseObjectSelections.catalogSelections();
    }

    public SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections() {
        return this.m_databaseObjectSelections.schemaSelections();
    }

    public XmlElement asXml() {
        return this.m_databaseObjectSelections.asXml();
    }

    public String toString() {
        return this.m_databaseObjectSelections.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EElementType {
        database,
        catalog,
        schema,
        tables,
        views,
        procedures,
        functions,
        synonyms,
        sysObjects,
        sysCatalog,
        sysSchema,
        sysTables,
        sysViews,
        sysSynonyms,
        sysTable,
        sysView,
        sysSynonym;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ESelectionType {
        none,
        partial,
        all;

    }
}

