/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.imprt.relational.impl;

import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEncoding;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.RelationalMetadataServiceSpecification;
import com.cognos.developer.schemas.bibus._3.RelationalMetadataService_PortType;
import com.cognos.developer.schemas.bibus._3.Specification;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.ibm.cognos.fmeng.imprt.relational.physical.I_RelmdServiceInvoker;
import com.ibm.cognos.fmeng.platform.ProgressCallbackHandler;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import com.ibm.cognos.relmd.metadata.browse.BrowseMetadataRequest;
import com.ibm.cognos.relmd.metadata.import_.ImportMetadataRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import javax.activation.DataHandler;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPHeaderElement;

public class RelmdServiceInvoker
implements I_RelmdServiceInvoker {
    private final RelationalMetadataService_PortType m_relmdPort;
    private final String m_passport;

    public RelmdServiceInvoker(RelationalMetadataService_PortType relmdPort, String passport) {
        this.m_passport = passport;
        this.m_relmdPort = relmdPort;
    }

    public InputStream invokeMetadataImport(ImportMetadataRequest importRequest, ProgressCallbackHandler progress) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.flush();
        os.close();
        importRequest.write("relmdApi.xsd", (OutputStream)os);
        String requestXml = os.toString("UTF-8");
        return this.invokeMetadataService(requestXml, progress);
    }

    public InputStream invokeMetadataBrowse(BrowseMetadataRequest browseRequest, ProgressCallbackHandler progress) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.flush();
        os.close();
        browseRequest.write("relmdApi.xsd", (OutputStream)os);
        String requestXml = os.toString("UTF-8");
        return this.invokeMetadataService(requestXml, progress);
    }

    private InputStream invokeMetadataService(String requestXml, ProgressCallbackHandler progress) throws Exception {
        RelationalMetadataServiceSpecification relmdImportRequestSpec = new RelationalMetadataServiceSpecification();
        Specification spec = new Specification(requestXml);
        relmdImportRequestSpec.setValue(spec);
        Stub relmdPortStub = (Stub)this.m_relmdPort;
        relmdPortStub.clearHeaders();
        BiBusHeader busHeader = new BiBusHeader();
        if (this.m_passport != null) {
            CAM cam = new CAM();
            CAMPassport camPassport = new CAMPassport();
            camPassport.setId(this.m_passport);
            cam.setCAMPassport(camPassport);
            busHeader.setCAM(cam);
        }
        relmdPortStub.setHeader("", "biBusHeader", (Object)busHeader);
        Option[] options = new Option[1];
        AsynchOptionEncoding encoding = new AsynchOptionEncoding();
        encoding.setName(AsynchOptionEnum.attachmentEncoding);
        encoding.setValue(EncodingEnum.MIMECompressed);
        options[0] = encoding;
        AsynchReply reply = this.m_relmdPort.runSpecification((AsynchSpecification)relmdImportRequestSpec, null, options);
        AsynchReplyStatusEnum status = reply.getStatus();
        while (status.equals((Object)AsynchReplyStatusEnum.working) || status.equals((Object)AsynchReplyStatusEnum.stillWorking)) {
            if (progress.isCancelRequested()) {
                throw new FmMDException("BMT_MD_CANCELED");
            }
            FmMessage progMess1 = new FmMessage("BMT_UIP_FETCHING_METADATA");
            progress.setProgressStatus(-1, progMess1.render(""));
            SOAPHeaderElement biBusResponseSoapHeader = relmdPortStub.getResponseHeader("", "biBusHeader");
            BiBusHeader biBusHeaderResponse = (BiBusHeader)biBusResponseSoapHeader.getObjectValue(BiBusHeader.class);
            BiBusHeader biBusHeaderStub = (BiBusHeader)relmdPortStub.getHeader("", "biBusHeader").getObjectValue(BiBusHeader.class);
            Tracking responseTracking = biBusHeaderResponse.getTracking();
            biBusHeaderStub.setTracking(responseTracking);
            AsynchRequest primaryRequest = reply.getPrimaryRequest();
            reply = this.m_relmdPort.wait(primaryRequest, null, null);
            status = reply.getStatus();
        }
        InputStream is = null;
        Object[] attachments = relmdPortStub.getAttachments();
        if (attachments.length > 0) {
            AttachmentPart attach = (AttachmentPart)attachments[0];
            DataHandler dataHandler = attach.getDataHandler();
            is = dataHandler.getInputStream();
            String[] contentEncodingHeader = attach.getMimeHeader("Content-Encoding");
            if (contentEncodingHeader != null && contentEncodingHeader.length > 0 && contentEncodingHeader[0].equals("gzip")) {
                is = new GZIPInputStream(is);
            }
        } else {
            AsynchDetail[] details = reply.getDetails();
            if (details.length > 0) {
                AsynchDetailMIMEAttachment detail = (AsynchDetailMIMEAttachment)details[0];
                String result = new String(detail.getData(), "UTF8");
                is = new ByteArrayInputStream(result.getBytes("UTF8"));
            }
        }
        return is;
    }

    public String passport() {
        return this.m_passport;
    }

    public RelationalMetadataService_PortType relmdServicePort() {
        return this.m_relmdPort;
    }
}

