/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.logging;

import com.ibm.cognos.fmeng.logging.FmEngLogger;
import com.ibm.cognos.fmeng.logging.LogManager;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.Hashtable;

public class FmEngApplicationLog {
    private Hashtable<FMMDSession, LogManager> loggerTable = new Hashtable();
    private static FmEngApplicationLog applicationLog;

    public static FmEngApplicationLog getApplicationLog() {
        if (applicationLog == null) {
            applicationLog = new FmEngApplicationLog();
        }
        return applicationLog;
    }

    public void createLoggersFor(FMMDSession session) {
        this.loggerTable.put(session, new LogManager(session));
    }

    public void dumpMemoryUsage(FMMDSession session) {
        LogManager manager = this.loggerTable.get(session);
        if (manager != null) {
            manager.dumpMemoryUsage();
        }
    }

    public boolean initialize() {
        return FmEngLogger.initialize();
    }

    public void logDebug(LOGGERS key, FMMDSession session, String string) {
        LogManager logger = this.loggerTable.get(session);
        if (logger != null) {
            logger.debug(key, string);
        }
    }

    public void logWarn(LOGGERS key, FMMDSession session, String string) {
        LogManager logger = this.loggerTable.get(session);
        if (logger != null) {
            logger.warn(key, string);
        }
    }

    public void logError(LOGGERS key, FMMDSession session, String msg) {
        LogManager logger = this.loggerTable.get(session);
        if (logger != null) {
            logger.error(key, msg);
        }
    }

    public void logException(Throwable th) {
        th.printStackTrace();
    }

    public void logInfo(LOGGERS key, FMMDSession session, String string) {
        LogManager logger = this.loggerTable.get(session);
        if (logger != null) {
            logger.info(key, string);
        }
    }

    public void logWarning(LOGGERS key, FMMDSession session, FmMessage msg) {
        LogManager logger = this.loggerTable.get(session);
        if (logger != null) {
            logger.warn(key, msg);
        }
    }

    public void logWarning(LOGGERS key, FMMDSession session, String string) {
        LogManager logger = this.loggerTable.get(session);
        if (logger != null) {
            logger.warn(key, string);
        }
    }

    public void stop() {
        FmEngLogger.stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LOGGERS {
        MEMORY,
        PLATFORM,
        METADATA,
        CUBING_SERVICES_IMPORT,
        FM_IMPORT,
        PUBLISH;

    }
}

