/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.metadata;

import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.metadata.MdDatabase;
import com.ibm.cognos.fmeng.metadata.MdSource;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseFactory;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseSource;
import com.ibm.cognos.fmeng.metadata.impl.MdDatabaseImpl;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.utility.FmMDException;

public class MetadataSourceFactory {
    public static MdDatabase createMetadataSource(FMMDSession session, MdSource source) {
        MdDatabaseImpl dataSource = null;
        FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.METADATA, session, "Start create metadata source: " + source.toString());
        dataSource = BrowseFactory.getInstance().createDatabase(session, source);
        if (dataSource != null) {
            dataSource.loadDatabase();
            if (!(dataSource instanceof BrowseSource)) {
                if (!source.getCatalogName().isEmpty() && dataSource.findCatalog(source.getCatalogName()) == null) {
                    throw new FmMDException("BMT_MD_CANNOT_FIND_CATALOG", source.getSchemaName(), source.getCatalogName());
                }
                if (!source.getSchemaName().isEmpty() && dataSource.findSchema(source.getCatalogName(), source.getSchemaName()) == null) {
                    throw new FmMDException("BMT_MD_CANNOT_FIND_SCHEMA", source.getSchemaName());
                }
            }
            if (dataSource instanceof BrowseSource && session.getClientType().equals((Object)FMMDSession.ClientType.CubeDesigner)) {
                if (!source.getSchemaName().isEmpty() || ((BrowseSource)dataSource).isHardcodedMetadataSource()) {
                    ((EMFSession)session).addDatabase(dataSource);
                }
            } else {
                ((EMFSession)session).addDatabase(dataSource);
            }
        } else {
            FmEngApplicationLog.getApplicationLog().logWarning(FmEngApplicationLog.LOGGERS.METADATA, session, "Failed to create metadata source");
        }
        FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.METADATA, session, "End create metadata source");
        return dataSource;
    }
}

