/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.metadata.adapters.physmd;

import com.ibm.cognos.fmeng.metadata.MdBase;
import com.ibm.cognos.fmeng.metadata.MdCatalog;
import com.ibm.cognos.fmeng.metadata.MdDatabase;
import com.ibm.cognos.fmeng.metadata.MdSchema;
import com.ibm.cognos.fmeng.metadata.MdSource;
import com.ibm.cognos.fmeng.metadata.VendorInfo;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseCatalog;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseSchema;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseTools;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.PhysmdTools;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.RelMdServiceBrowseTools;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.RelmdJDBCBrowseTools;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.StubBrowseTools;
import com.ibm.cognos.fmeng.metadata.impl.MdDatabaseImpl;
import com.ibm.cognos.fmeng.metadata.mdSource.RawMdSource;
import com.ibm.cognos.fmeng.metadata.mdSource.RelmdBrowseSource;
import com.ibm.cognos.fmeng.metadata.mdSource.RelmdServiceBrowseSource;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.CatalogType;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.DatabaseType;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.SchemaType;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.relmdcachePackage;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.util.relmdcacheResourceFactoryImpl;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._tools.sqlColumnConversions.rules.SqlColumnConversionRules;
import com.ibm.cognos.relmd.vendor.VendorRules;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowseSource
extends MdDatabaseImpl
implements MdDatabase {
    private String m_connection = null;
    private String m_signon = null;
    private List<MdSchema> m_schemas = null;
    private List<MdCatalog> m_catalogs = null;
    private File m_cachedSchemaFile = null;
    private Resource m_resource = null;
    private DatabaseType m_databaseType = null;
    private boolean m_hardcodedMetadataSource = false;
    private boolean m_canBeSaved = false;
    private BrowseTools m_browseHelper;
    private SqlColumnConversionRules m_columnConversionRules = null;
    private InputStream m_cacheFileStream = null;

    public BrowseSource(FMMDSession session, MdSource source) {
        super(session, null, source.getDatabaseName(), null);
        if (source instanceof RelmdServiceBrowseSource) {
            this.m_connection = ((RelmdServiceBrowseSource)source).getDataSourceConnectionName();
            this.m_signon = ((RelmdServiceBrowseSource)source).getDataSourceSignonName();
        }
        if (source instanceof RelmdBrowseSource) {
            this.m_browseHelper = new RelmdJDBCBrowseTools((RelmdBrowseSource)source);
            this.m_canBeSaved = false;
        } else if (source instanceof RelmdServiceBrowseSource) {
            this.m_browseHelper = new RelMdServiceBrowseTools((RelmdServiceBrowseSource)source);
            this.m_canBeSaved = !source.getSchemaName().isEmpty();
        } else if (source instanceof RawMdSource) {
            this.m_browseHelper = new StubBrowseTools();
            this.m_canBeSaved = false;
            this.m_hardcodedMetadataSource = true;
        }
        this.intializeCacheFile(source);
        if (source instanceof RawMdSource) {
            if (!"".equals(source.getDatabaseName())) {
                FmMDException.ASSERT(source.getDatabaseName().equals(this.m_databaseType.getDataSourceName()), "Source: " + source.getDatabaseName() + "\nPhysmd: " + this.m_databaseType.getDataSourceName());
            } else {
                this.setName(this.m_databaseType.getDataSourceName());
            }
            List<MdCatalog> cats = this.getCatalogs();
            if (cats.isEmpty()) {
                this.getSchemas();
            } else {
                for (MdCatalog cat : cats) {
                    cat.getSchemas();
                }
            }
        } else {
            String schemaName;
            String catalogName = source.getCatalogName();
            BrowseCatalog browseCatalog = null;
            if (catalogName != null && !catalogName.isEmpty()) {
                if (this.m_catalogs == null) {
                    this.m_catalogs = new ArrayList<MdCatalog>();
                }
                boolean catFnd = false;
                for (MdCatalog cat : this.m_catalogs) {
                    if (!catalogName.equals(cat.getName())) continue;
                    catFnd = true;
                    browseCatalog = (BrowseCatalog)cat;
                    break;
                }
                if (!catFnd) {
                    browseCatalog = new BrowseCatalog((MdBase)this, this.m_browseHelper, catalogName);
                    this.m_catalogs.add(browseCatalog);
                    this.m_databaseType.getCatalog().add((Object)browseCatalog.getInternal());
                }
            }
            if (!(schemaName = source.getSchemaName()).isEmpty()) {
                BrowseSchema browseSchema = null;
                boolean schemaFnd = false;
                if (browseCatalog != null) {
                    for (Object s : browseCatalog.getInternal().getSchema()) {
                        if (!schemaName.equals(((SchemaType)s).getName())) continue;
                        schemaFnd = true;
                        break;
                    }
                    if (!schemaFnd) {
                        browseSchema = new BrowseSchema((MdBase)browseCatalog, this.m_browseHelper, schemaName);
                        browseCatalog.addSchema(browseSchema);
                    }
                } else {
                    if (this.m_schemas == null) {
                        this.m_schemas = new ArrayList<MdSchema>();
                    }
                    schemaFnd = false;
                    for (MdSchema s : this.m_schemas) {
                        if (!s.getName().equals(schemaName)) continue;
                        schemaFnd = true;
                        break;
                    }
                    if (!schemaFnd) {
                        BrowseSchema schema = new BrowseSchema((MdBase)this, this.m_browseHelper, schemaName);
                        this.m_schemas.add(schema);
                        this.m_databaseType.getSchema().add((Object)schema.getInternal());
                    }
                }
            }
        }
    }

    @Override
    public void destroy() {
        EObject o = null;
        if (this.m_resource != null) {
            EList resContents = this.m_resource.getContents();
            if (resContents != null && !resContents.isEmpty()) {
                o = (EObject)resContents.get(0);
                EList contents = o.eContents();
                int i = contents.size() - 1;
                while (i >= 0) {
                    EObject child = (EObject)contents.get(i);
                    try {
                        EcoreUtil.remove((EObject)child);
                    }
                    catch (RuntimeException runtimeException) {}
                    --i;
                }
            }
            ResourceSet rs = this.m_resource.getResourceSet();
            rs.getResources().remove((Object)this.m_resource);
            this.m_resource = null;
            this.m_browseHelper.closeConnection();
        }
        try {
            this.m_cacheFileStream.close();
        }
        catch (IOException iOException) {}
        this.m_cacheFileStream = null;
    }

    @Override
    protected void doLoadDatabase() {
        this.m_browseHelper.openConnection();
    }

    @Override
    public boolean isBrowseSource() {
        return true;
    }

    @Override
    public List<MdCatalog> getCatalogs() {
        if (this.m_catalogs == null) {
            this.m_catalogs = new ArrayList<MdCatalog>();
        }
        if (this.m_schemas == null || this.m_schemas.isEmpty()) {
            if (this.m_catalogs.isEmpty()) {
                if (this.m_databaseType.getCatalog().isEmpty()) {
                    this.m_browseHelper.getCatalogs(this, this.m_catalogs);
                    for (MdCatalog cat : this.m_catalogs) {
                        this.m_databaseType.getCatalog().add((Object)((BrowseCatalog)cat).getInternal());
                    }
                } else {
                    for (Object cat : this.m_databaseType.getCatalog()) {
                        this.m_catalogs.add(new BrowseCatalog((MdBase)this, this.m_browseHelper, (CatalogType)cat));
                    }
                }
            }
            return new ArrayList<MdCatalog>(this.m_catalogs);
        }
        return new ArrayList<MdCatalog>();
    }

    @Override
    public List<MdSchema> getSchemas() {
        if (this.m_schemas == null) {
            this.m_schemas = new ArrayList<MdSchema>();
        }
        if (this.m_catalogs == null || this.m_catalogs.isEmpty()) {
            if (this.m_schemas.isEmpty()) {
                if (this.m_databaseType.getSchema().isEmpty()) {
                    this.m_browseHelper.getSchemas(this, this.m_schemas);
                    for (MdSchema schema : this.m_schemas) {
                        this.m_databaseType.getSchema().add((Object)((BrowseSchema)schema).getInternal());
                    }
                } else {
                    for (Object s : this.m_databaseType.getSchema()) {
                        this.m_schemas.add(new BrowseSchema((MdBase)this, this.m_browseHelper, (SchemaType)s));
                    }
                }
            }
            return new ArrayList<MdSchema>(this.m_schemas);
        }
        return new ArrayList<MdSchema>();
    }

    @Override
    public List<MdSchema> getSchemasInternal() {
        ArrayList<MdSchema> schemas = new ArrayList<MdSchema>();
        if (this.m_schemas != null) {
            schemas.addAll(this.m_schemas);
        }
        return schemas;
    }

    @Override
    public List<MdCatalog> getCatalogsInternal() {
        ArrayList<MdCatalog> catalogs = new ArrayList<MdCatalog>();
        if (this.m_catalogs != null) {
            catalogs.addAll(this.m_catalogs);
        }
        return catalogs;
    }

    @Override
    public String getUDAVendorCode() {
        String vender = this.m_databaseType.getVendorType().toString();
        VendorInfo vendorInfo = VendorInfo.getvalueOf(vender);
        return vendorInfo.getUDAVendorCode();
    }

    private void intializeCacheFile(MdSource source) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new relmdcacheResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://www.ibm.com/xmlns/prod/cognos/relmd/1/0", (Object)relmdcachePackage.eINSTANCE);
        String cacheFileName = source.getCacheFilename();
        this.m_cachedSchemaFile = new File(cacheFileName);
        if (this.m_cacheFileStream != null) {
            try {
                this.m_cacheFileStream.close();
            }
            catch (IOException iOException) {}
        }
        this.m_cacheFileStream = null;
        try {
            this.m_cacheFileStream = this.m_cachedSchemaFile.exists() ? new FileInputStream(this.m_cachedSchemaFile) : this.createRelmdCacheFile();
            this.m_resource = resourceSet.createResource(URI.createURI((String)"*.xml"));
            this.m_resource.load(this.m_cacheFileStream, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.m_schemas == null) {
            this.m_schemas = new ArrayList<MdSchema>();
        }
        BrowseCatalog currentCatalog = null;
        TreeIterator tree = this.m_resource.getAllContents();
        while (tree.hasNext()) {
            EObject obj = (EObject)tree.next();
            if (obj instanceof SchemaType) {
                BrowseSchema schema = null;
                if (currentCatalog != null) {
                    schema = new BrowseSchema(currentCatalog, this.m_browseHelper, (SchemaType)obj);
                    currentCatalog.addSchema(schema);
                    continue;
                }
                schema = new BrowseSchema((MdBase)this, this.m_browseHelper, (SchemaType)obj);
                if (this.m_schemas == null) {
                    this.m_schemas = new ArrayList<MdSchema>();
                }
                this.m_schemas.add(schema);
                continue;
            }
            if (obj instanceof CatalogType) {
                currentCatalog = new BrowseCatalog((MdBase)this, this.m_browseHelper, (CatalogType)obj);
                if (this.m_catalogs == null) {
                    this.m_catalogs = new ArrayList<MdCatalog>();
                }
                this.m_catalogs.add(currentCatalog);
                continue;
            }
            if (!(obj instanceof DatabaseType)) continue;
            this.m_databaseType = (DatabaseType)obj;
            Database.EVendorType vendorType = PhysmdTools.getVendorTypeFromType(((DatabaseType)obj).getVendorType().toString());
            if (vendorType == null) {
                vendorType = Database.EVendorType.generic;
            }
            VendorRules vendorRules = PhysmdTools.getVendorRules(vendorType);
            this.m_columnConversionRules = vendorRules.sqlColumnConversionRules();
        }
    }

    private InputStream createRelmdCacheFile() {
        String databaseName = StringEscapeUtils.escapeXml((String)this.getDatabase().getName());
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xml.append("<relmd:importMetadataResult xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:relmd=\"http://www.ibm.com/xmlns/prod/cognos/relmd/1/0\" xsi:schemaLocation=\"http://www.ibm.com/xmlns/prod/cognos/relmd/1/0 relmdApi.xsd/relmdApi.xsd\">\n");
        xml.append("<relmd:relationalMetadata relmd:applicationVersion=\"10_0\">\n");
        xml.append("<relmd:database relmd:dataSourceName=\"" + databaseName + "\"");
        xml.append(" relmd:vendorType=\"sqlserver\">\n");
        xml.append("</relmd:database>");
        xml.append("</relmd:relationalMetadata>");
        xml.append("</relmd:importMetadataResult>");
        return new ByteArrayInputStream(xml.toString().getBytes());
    }

    public boolean shouldBeSaved() {
        return this.m_canBeSaved;
    }

    public void saveCachedInfo() {
        try {
            this.m_cachedSchemaFile.getParentFile().mkdirs();
            FileOutputStream fout = new FileOutputStream(this.m_cachedSchemaFile);
            this.m_resource.save((OutputStream)fout, null);
            fout.flush();
            fout.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected SqlColumnConversionRules getSqlColumnConversionRules() {
        return this.m_columnConversionRules;
    }

    public boolean isHardcodedMetadataSource() {
        return this.m_hardcodedMetadataSource;
    }

    public DatabaseType getInternal() {
        return this.m_databaseType;
    }

    public String toString() {
        return "Data Source: " + this.getName();
    }
}

