/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.metadata.adapters.physmd;

import com.ibm.cognos.fmeng.metadata.MdBase;
import com.ibm.cognos.fmeng.metadata.MdCatalog;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdForeignKey;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseColumn;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseResultsHandler;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseSchema;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseSource;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseTools;
import com.ibm.cognos.fmeng.metadata.impl.MdTableImpl;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.ColumnType1;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.SchemaType;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.SynonymType;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.TableType;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.VendorTypeType;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.ViewType;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.relmdcacheFactory;
import com.ibm.cognos.relmd.metadata._schema.Synonym;
import com.ibm.cognos.relmd.metadata._schema.Table;
import com.ibm.cognos.relmd.metadata._schema.View;
import com.ibm.cognos.relmd.metadata._schema.elements.Column;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowseSynonym
extends MdTableImpl {
    private List<MdColumn> m_columns = new ArrayList<MdColumn>();
    private BrowseTools m_browseTools = null;
    private SynonymType m_synonymType = null;

    public BrowseSynonym(MdBase parent, BrowseTools browseTools, String name) {
        super(parent, name, null, MdTable.TablePhysicalType.synonym);
        this.m_browseTools = browseTools;
        this.m_synonymType = relmdcacheFactory.eINSTANCE.createSynonymType();
        this.m_synonymType.setName(name);
    }

    public BrowseSynonym(BrowseSchema browseSchema, SynonymType synonymType) {
        super(browseSchema, synonymType.getName(), null, MdTable.TablePhysicalType.synonym);
        this.m_synonymType = synonymType;
        this.m_browseTools = browseSchema.getBrowseTool();
    }

    private EObject findTable(SchemaType schemaType, String tableName) {
        EList<TableType> tables = schemaType.getTable();
        for (TableType table : tables) {
            if (!tableName.equals(table.getName())) continue;
            return table;
        }
        EList<ViewType> views = schemaType.getView();
        for (ViewType view : views) {
            if (!tableName.equals(view.getName())) continue;
            return view;
        }
        return null;
    }

    @Override
    public List<MdColumn> getColumns() {
        if (this.m_columns.isEmpty()) {
            this.loadColumnCache();
        }
        return this.m_columns;
    }

    @Override
    protected void loadColumnCache() {
        if (this.m_columns.isEmpty()) {
            EList<ColumnType1> synColumnList = this.m_synonymType.getColumn();
            EList<ColumnType1> targetColumnList = null;
            if (synColumnList.isEmpty()) {
                String targetName = this.m_synonymType.getTargetRef();
                if (targetName != null) {
                    Iterator obj = this.findTable(((BrowseSchema)this.getParent()).getInternal(), targetName);
                    if (obj != null) {
                        if (obj instanceof TableType) {
                            targetColumnList = ((TableType)((Object)obj)).getColumn();
                        } else if (obj instanceof ViewType) {
                            targetColumnList = ((ViewType)((Object)obj)).getColumn();
                        }
                    }
                    if (targetColumnList != null) {
                        for (Object c : targetColumnList) {
                            BrowseColumn col = new BrowseColumn(this, (ColumnType1)c, ((BrowseSchema)this.getParent()).getSqlColumnConversionRules(), true);
                            this.m_columns.add(col);
                            synColumnList.add((Object)((ColumnType1)col.getInternal()));
                        }
                    }
                }
            } else {
                for (ColumnType1 c : synColumnList) {
                    BrowseColumn col = new BrowseColumn(this, c, ((BrowseSchema)this.getParent()).getSqlColumnConversionRules(), false);
                    this.m_columns.add(col);
                }
            }
            if (this.m_synonymType.getColumn().isEmpty()) {
                BrowseResultsHandler synonymHandler = new BrowseResultsHandler();
                this.m_browseTools.importTable(this, synonymHandler);
                Synonym syn = synonymHandler.getPhysicalSynonym();
                String catalog = syn.externalCatalogRef();
                String schema = syn.externalSchemaRef();
                String table = syn.targetRef();
                if (schema == null) {
                    schema = this.getSchema().getName();
                }
                if (catalog == null && this.getParent().getParent() instanceof MdCatalog) {
                    catalog = this.getParent().getParent().getName();
                }
                this.m_browseTools.importTable(catalog, schema, table, MdTable.TablePhysicalType.table, synonymHandler);
                ReferenceableSet columnSet = null;
                Table tableObj = synonymHandler.getPhysicalTable();
                if (tableObj == null) {
                    this.m_browseTools.importTable(catalog, schema, table, MdTable.TablePhysicalType.view, synonymHandler);
                    View viewObj = synonymHandler.getPhysicalView();
                    if (viewObj != null) {
                        columnSet = viewObj.columnsSet();
                    }
                } else if (tableObj != null) {
                    columnSet = tableObj.columnsSet();
                }
                if (columnSet != null) {
                    for (Column column : columnSet) {
                        BrowseColumn browseColumn = new BrowseColumn((MdBase)this, column, synonymHandler.getSqlColumnConversionRules());
                        this.m_columns.add(browseColumn);
                        this.m_synonymType.getColumn().add((Object)((ColumnType1)browseColumn.getInternal()));
                    }
                }
                ((BrowseSource)this.getDatabase()).getInternal().setVendorType(VendorTypeType.getByName(synonymHandler.getVendorType().toString()));
            }
        }
    }

    @Override
    public boolean removeForeignKey(MdForeignKey fKey) {
        return false;
    }

    @Override
    public boolean isSynonym() {
        return true;
    }

    @Override
    public List<MdForeignKey> getForeignKeys() {
        return new ArrayList<MdForeignKey>();
    }

    public SynonymType getInternal() {
        return this.m_synonymType;
    }

    @Override
    public boolean hasForeignKeysLoaded() {
        return false;
    }
}

