/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.metadata.adapters.physmd;

import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.metadata.MdBase;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdForeignKey;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseColumn;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseForeignKey;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseIndex;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowsePrimaryKey;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseResultsHandler;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseSchema;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseSource;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseTools;
import com.ibm.cognos.fmeng.metadata.impl.MdTableImpl;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.ColumnType1;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.ForeignKeyType;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.IndexType;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.TableType;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.UniqueKeyType;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.VendorTypeType;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.relmdcacheFactory;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.relmd.metadata._schema.Table;
import com.ibm.cognos.relmd.metadata._schema.elements.Column;
import com.ibm.cognos.relmd.metadata._schema.elements.ForeignKey;
import com.ibm.cognos.relmd.metadata._schema.elements.Index;
import com.ibm.cognos.relmd.metadata._schema.elements.UniqueKey;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowseTable
extends MdTableImpl {
    private List<MdColumn> m_columns = new ArrayList<MdColumn>();
    private List<MdForeignKey> m_ForeignKeys = null;
    private BrowseTools m_browseTools = null;
    private TableType m_tableType = null;
    private boolean m_fkeysFixedUp = false;

    public BrowseTable(MdBase parent, BrowseTools browseTools, String name) {
        super(parent, name, null, MdTable.TablePhysicalType.table);
        this.m_browseTools = browseTools;
        this.m_tableType = relmdcacheFactory.eINSTANCE.createTableType();
        this.m_tableType.setName(name);
    }

    public BrowseTable(BrowseSchema browseSchema, TableType tableType) {
        super(browseSchema, tableType.getName(), null, MdTable.TablePhysicalType.table);
        EList<UniqueKeyType> ukeys;
        EList<IndexType> indexes;
        this.m_tableType = tableType;
        this.m_browseTools = browseSchema.getBrowseTool();
        EList<ColumnType1> columnList = this.m_tableType.getColumn();
        for (Object c : columnList) {
            this.m_columns.add(new BrowseColumn(this, (ColumnType1)c, ((BrowseSchema)this.getParent()).getSqlColumnConversionRules(), false));
        }
        EList<ForeignKeyType> fkeys = this.m_tableType.getForeignKey();
        if (!fkeys.isEmpty()) {
            this.m_ForeignKeys = new ArrayList<MdForeignKey>();
            for (Object fkey : fkeys) {
                this.m_ForeignKeys.add(new BrowseForeignKey(this, (ForeignKeyType)fkey));
            }
        }
        if (!(indexes = this.m_tableType.getIndex()).isEmpty()) {
            for (Object index : indexes) {
                this.addIndex(new BrowseIndex((MdBase)this, (IndexType)index));
            }
        }
        if (!(ukeys = this.m_tableType.getUniqueKey()).isEmpty()) {
            for (Object ukey : ukeys) {
                this.setPrimarykey(new BrowsePrimaryKey((MdBase)this, (UniqueKeyType)ukey));
            }
        }
    }

    @Override
    public boolean isSynonym() {
        return false;
    }

    @Override
    public List<MdColumn> getColumns() {
        if (this.m_columns.isEmpty() && this.m_tableType.getColumn().isEmpty()) {
            this.loadColumnCache();
        }
        return this.m_columns;
    }

    @Override
    public List<MdForeignKey> getForeignKeys() {
        if (this.m_ForeignKeys == null) {
            this.m_ForeignKeys = new ArrayList<MdForeignKey>();
            if (this.getTableType() == MdTable.TablePhysicalType.table && this.m_tableType.getForeignKey().isEmpty()) {
                this.loadForeignKeyCache();
            }
        }
        if (!this.m_fkeysFixedUp) {
            ArrayList<MdForeignKey> toRemoveList = new ArrayList<MdForeignKey>();
            for (MdForeignKey fkey : this.m_ForeignKeys) {
                if (fkey.getPrimaryTable() != null) continue;
                toRemoveList.add(fkey);
            }
            if (!toRemoveList.isEmpty()) {
                this.m_ForeignKeys.removeAll(toRemoveList);
            }
            this.m_fkeysFixedUp = true;
        }
        return this.m_ForeignKeys;
    }

    private void loadForeignKeyCache() {
        if (this.m_columns.isEmpty()) {
            this.loadColumnCache();
        }
    }

    @Override
    protected void loadColumnCache() {
        if (this.m_tableType.getColumn().isEmpty()) {
            FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.METADATA, this.getDatabase().getSession(), "Start fetching columns for table: " + this.getName());
            BrowseResultsHandler tableHandler = new BrowseResultsHandler();
            this.m_browseTools.importTable(this, tableHandler);
            Table table = tableHandler.getPhysicalTable();
            if (table == null) {
                this.m_ForeignKeys = new ArrayList<MdForeignKey>();
            } else {
                Iterator iterator;
                ReferenceableSet columnSet = table.columnsSet();
                if (columnSet != null) {
                    iterator = columnSet.iterator();
                    while (iterator.hasNext()) {
                        Column column = (Column)iterator.next();
                        BrowseColumn browseColumn = new BrowseColumn((MdBase)this, column, tableHandler.getSqlColumnConversionRules());
                        this.m_columns.add(browseColumn);
                        this.m_tableType.getColumn().add((Object)((ColumnType1)browseColumn.getInternal()));
                    }
                }
                if ((iterator = table.uniqueKeysSet().iterator()).hasNext()) {
                    UniqueKey key = (UniqueKey)iterator.next();
                    BrowsePrimaryKey pkey = new BrowsePrimaryKey((MdBase)this, key);
                    this.m_tableType.getUniqueKey().add((Object)pkey.getInternal());
                    this.setPrimarykey(pkey);
                }
                for (Index someIndex : table.indexesCollection()) {
                    BrowseIndex newIndex = new BrowseIndex((MdBase)this, someIndex);
                    this.addIndex(newIndex);
                    this.m_tableType.getIndex().add((Object)newIndex.getInternal());
                }
                if (this.m_ForeignKeys == null) {
                    this.m_ForeignKeys = new ArrayList<MdForeignKey>();
                }
                for (ForeignKey someKey : table.foreignKeysCollection()) {
                    BrowseForeignKey newfKey = new BrowseForeignKey((MdBase)this, someKey);
                    if (newfKey.getPrimaryTable() == null) continue;
                    this.m_ForeignKeys.add(newfKey);
                    this.m_tableType.getForeignKey().add((Object)newfKey.getInternal());
                }
                ((BrowseSource)this.getDatabase()).getInternal().setVendorType(VendorTypeType.getByName(tableHandler.getVendorType().toString()));
            }
            FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.METADATA, this.getDatabase().getSession(), "End fetching columns: " + Integer.toString(this.m_columns.size()) + " columns, " + Integer.toString(this.m_ForeignKeys.size()) + " foreign keys");
        }
    }

    public TableType getInternal() {
        return this.m_tableType;
    }

    @Override
    public boolean removeForeignKey(MdForeignKey fKey) {
        FmMDException.ASSERT(false, "removeForeignKey  not implemented - should not be called");
        return false;
    }

    @Override
    public boolean hasForeignKeysLoaded() {
        return this.m_ForeignKeys != null;
    }

    public List<MdForeignKey> getForeignKeysInternal() {
        return this.m_ForeignKeys;
    }

    public List<MdColumn> getColumnsInternal() {
        return this.m_columns;
    }
}

