/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.metadata.adapters.physmd;

import com.ibm.cognos.fmeng.metadata.MdBase;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdForeignKey;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseColumn;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseResultsHandler;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseSchema;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseSource;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseTools;
import com.ibm.cognos.fmeng.metadata.impl.MdTableImpl;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.ColumnType1;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.VendorTypeType;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.ViewType;
import com.ibm.cognos.fmeng.metadata.relmdcache._0.relmdcacheFactory;
import com.ibm.cognos.relmd.metadata._schema.View;
import com.ibm.cognos.relmd.metadata._schema.elements.Column;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.time.StopWatch;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowseView
extends MdTableImpl {
    private ViewType m_viewType = null;
    private BrowseTools m_browseTools = null;
    private List<MdColumn> m_columns = new ArrayList<MdColumn>();

    public BrowseView(MdBase parent, BrowseTools browseTools, String name) {
        super(parent, name, null, MdTable.TablePhysicalType.view);
        this.m_browseTools = browseTools;
        this.m_viewType = relmdcacheFactory.eINSTANCE.createViewType();
        this.m_viewType.setName(name);
    }

    public BrowseView(BrowseSchema browseSchema, ViewType tableType) {
        super(browseSchema, tableType.getName(), null, MdTable.TablePhysicalType.view);
        this.m_viewType = tableType;
        this.m_browseTools = browseSchema.getBrowseTool();
        EList<ColumnType1> columnList = this.m_viewType.getColumn();
        for (Object c : columnList) {
            this.m_columns.add(new BrowseColumn(this, (ColumnType1)c, ((BrowseSchema)this.getParent()).getSqlColumnConversionRules(), false));
        }
    }

    public ViewType getInternal() {
        return this.m_viewType;
    }

    @Override
    public boolean removeForeignKey(MdForeignKey fKey) {
        return false;
    }

    @Override
    public boolean isSynonym() {
        return false;
    }

    @Override
    public List<MdColumn> getColumns() {
        if (this.m_columns.isEmpty() && this.m_viewType.getColumn().isEmpty()) {
            this.loadColumnCache();
        }
        return this.m_columns;
    }

    @Override
    public List<MdForeignKey> getForeignKeys() {
        return new ArrayList<MdForeignKey>();
    }

    @Override
    protected void loadColumnCache() {
        if (this.m_viewType.getColumn().isEmpty()) {
            BrowseResultsHandler viewHandler = new BrowseResultsHandler();
            StopWatch t = new StopWatch();
            t.reset();
            t.start();
            this.m_browseTools.importTable(this, viewHandler);
            View view = viewHandler.getPhysicalView();
            ReferenceableSet columnSet = null;
            if (view != null) {
                columnSet = view.columnsSet();
            }
            if (columnSet != null) {
                for (Column column : columnSet) {
                    BrowseColumn browseColumn = new BrowseColumn((MdBase)this, column, viewHandler.getSqlColumnConversionRules());
                    this.m_columns.add(browseColumn);
                    this.m_viewType.getColumn().add((Object)((ColumnType1)browseColumn.getInternal()));
                }
            }
            if (viewHandler.getVendorType() != null) {
                ((BrowseSource)this.getDatabase()).getInternal().setVendorType(VendorTypeType.getByName(viewHandler.getVendorType().toString()));
            }
        }
    }

    @Override
    public boolean hasForeignKeysLoaded() {
        return false;
    }
}

