/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.metadata.adapters.physmd;

import com.ibm.cognos.fmeng.metadata.VendorInfo;
import com.ibm.cognos.internal.relmd.RelmdToolkits;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.vendor.VendorRules;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class PhysmdTools {
    private static final Relmd m_Relmd = RelmdGateway.relmd();
    private static final RelmdToolkits m_RelmdToolkits = (RelmdToolkits)m_Relmd.sessionToolkit();
    private static HashMap<Database.EVendorType, VendorRules> m_VendorRules = new HashMap();

    public static VendorRules getVendorRules(Database.EVendorType vendorType) {
        VendorRules vendorRules;
        if (m_VendorRules.containsKey(vendorType)) {
            return m_VendorRules.get(vendorType);
        }
        try {
            vendorRules = m_RelmdToolkits.vendorRules(vendorType);
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        m_VendorRules.put(vendorType, vendorRules);
        return vendorRules;
    }

    public static String getVendorType(Database database) {
        String vender = database.asXml().getAttribute("vendorType").getValue();
        VendorInfo vendorInfo = VendorInfo.getvalueOf(vender);
        return vendorInfo.getUDAVendorCode();
    }

    public static Database.EVendorType getVendorTypeFromType(String vendorTypeString) {
        VendorInfo[] vendorInfoArray = VendorInfo.values();
        int n = vendorInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            VendorInfo info = vendorInfoArray[n2];
            if (info.name().equals(vendorTypeString)) {
                return info.getVendorType();
            }
            ++n2;
        }
        return null;
    }

    public static Database.EVendorType getVendorTypeFromDatabase(Database database) {
        String vendorTypeString = database.asXml().getAttribute("vendorType").getValue();
        VendorInfo[] vendorInfoArray = VendorInfo.values();
        int n = vendorInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            VendorInfo info = vendorInfoArray[n2];
            if (info.getUDAVendorCode().equals(vendorTypeString)) {
                return info.getVendorType();
            }
            ++n2;
        }
        return database.vendorType();
    }
}

