/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.metadata.adapters.physmd;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.developer.schemas.bibus._3.RelationalMetadataService_PortType;
import com.cognos.developer.schemas.bibus._3.RelationalMetadataService_ServiceLocator;
import com.ibm.cognos.fmeng.fmmd.util.CmHelper;
import com.ibm.cognos.fmeng.imprt.relational.impl.RelmdServiceInvoker;
import com.ibm.cognos.fmeng.imprt.relational.physical.I_RelmdServiceInvoker;
import com.ibm.cognos.fmeng.metadata.MdBase;
import com.ibm.cognos.fmeng.metadata.MdCatalog;
import com.ibm.cognos.fmeng.metadata.MdSchema;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseCatalog;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseSchema;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseSynonym;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseTable;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseTools;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseView;
import com.ibm.cognos.fmeng.metadata.mdSource.RelmdServiceBrowseSource;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.soap.FmEngSoapRequest;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema._handlers.MetadataObjectHandler;
import com.ibm.cognos.relmd.metadata._tools.xml.MetadataLoader;
import com.ibm.cognos.relmd.metadata._tools.xml.MetadataXmlToolkit;
import com.ibm.cognos.relmd.metadata.browse.BrowseMetadataRequest;
import com.ibm.cognos.relmd.metadata.import_.ImportMetadataRequest;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelMdServiceBrowseTools
implements BrowseTools {
    private String m_datasourceName;
    private String m_dataSourceConnectionName;
    private String m_dataSourceSignonName;
    private String m_credentialsXml;
    private FMMDSession m_session;
    private Relmd m_relmd = RelmdGateway.relmd();
    private RelationalMetadataService_PortType m_relmdPort = null;
    private boolean m_includeSysObjects = false;

    public RelMdServiceBrowseTools(RelmdServiceBrowseSource source) {
        this.m_datasourceName = source.getDatabaseName();
        this.m_dataSourceConnectionName = source.getDataSourceConnectionName();
        this.m_dataSourceSignonName = source.getDataSourceSignonName();
        this.m_credentialsXml = source.getCredentialsXml();
        this.m_session = source.getSession();
        this.m_includeSysObjects = source.getIncludeSystemObjects();
    }

    private String getCatalogBrowseRequest() {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<relmd:browseMetadataRequest xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:relmd=\"http://www.ibm.com/xmlns/prod/cognos/relmd/1/0\" xsi:schemaLocation=\"http://www.ibm.com/xmlns/prod/cognos/relmd/1/0 ../webcontent/relmd/relmdApi.xsd\">\n\t<relmd:metadataSource relmd:dataSourceName=\"" + this.m_datasourceName + "\"" + (this.m_dataSourceConnectionName != null ? " relmd:dataSourceConnectionName=\"" + this.m_dataSourceConnectionName + "\"" : "") + (this.m_dataSourceSignonName != null ? " relmd:dataSourceSignonName=\"" + this.m_dataSourceSignonName + "\"" : "") + (this.m_credentialsXml != null ? " relmd:encryptedCredentialsXml=\"" + this.m_credentialsXml + "\"" : "") + "/>" + "\n\t<relmd:catalogsBrowse" + (this.m_includeSysObjects ? " relmd:browseQueryType=\"systemObjects\"" : "") + "/>" + "\n</relmd:browseMetadataRequest>\n";
        return request;
    }

    private String getSchemaBrowseRequest(MdBase parent) {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<relmd:browseMetadataRequest xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:relmd=\"http://www.ibm.com/xmlns/prod/cognos/relmd/1/0\" xsi:schemaLocation=\"http://www.ibm.com/xmlns/prod/cognos/relmd/1/0 ../webcontent/relmd/relmdApi.xsd\">\n\t<relmd:metadataSource relmd:dataSourceName=\"" + this.m_datasourceName + "\"" + (this.m_dataSourceConnectionName != null ? " relmd:dataSourceConnectionName=\"" + this.m_dataSourceConnectionName + "\"" : "") + (this.m_dataSourceSignonName != null ? " relmd:dataSourceSignonName=\"" + this.m_dataSourceSignonName + "\"" : "") + (this.m_credentialsXml != null ? " relmd:encryptedCredentialsXml=\"" + this.m_credentialsXml + "\"" : "") + "/>";
        request = parent instanceof MdCatalog ? String.valueOf(request) + "\n\t<relmd:schemasBrowse relmd:parentCatalogName=\"" + parent.getName() + "\"" + (this.m_includeSysObjects ? " relmd:browseQueryType=\"systemObjects\"" : "") + "/>" : String.valueOf(request) + "\n\t<relmd:schemasBrowse/>";
        request = String.valueOf(request) + "\n</relmd:browseMetadataRequest>\n";
        return request;
    }

    private String getTableBrowseRequest(MdBase parent) {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<relmd:browseMetadataRequest xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:relmd=\"http://www.ibm.com/xmlns/prod/cognos/relmd/1/0\" xsi:schemaLocation=\"http://www.ibm.com/xmlns/prod/cognos/relmd/1/0 ../webcontent/relmd/relmdApi.xsd\">\n\t<relmd:metadataSource relmd:dataSourceName=\"" + this.m_datasourceName + "\"" + (this.m_dataSourceConnectionName != null ? " relmd:dataSourceConnectionName=\"" + this.m_dataSourceConnectionName + "\"" : "") + (this.m_dataSourceSignonName != null ? " relmd:dataSourceSignonName=\"" + this.m_dataSourceSignonName + "\"" : "") + (this.m_credentialsXml != null ? " relmd:encryptedCredentialsXml=\"" + this.m_credentialsXml + "\"" : "") + "/>";
        MdBase grandParent = parent.getParent();
        request = grandParent instanceof MdCatalog ? String.valueOf(request) + "\n\t<relmd:tablesBrowse relmd:parentCatalogName=\"" + grandParent.getName() + "\"" + " relmd:parentSchemaName=\"" + parent.getName() + "\"" + (this.m_includeSysObjects ? " relmd:browseQueryType=\"systemObjects\"" : "") + "/>" : String.valueOf(request) + "\n\t<relmd:tablesBrowse relmd:parentSchemaName=\"" + parent.getName() + "\"" + (this.m_includeSysObjects ? " relmd:browseQueryType=\"systemObjects\"" : "") + "/>";
        request = String.valueOf(request) + "\n</relmd:browseMetadataRequest>\n";
        return request;
    }

    private String getViewBrowseRequest(MdBase parent) {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<relmd:browseMetadataRequest xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:relmd=\"http://www.ibm.com/xmlns/prod/cognos/relmd/1/0\" xsi:schemaLocation=\"http://www.ibm.com/xmlns/prod/cognos/relmd/1/0 ../webcontent/relmd/relmdApi.xsd\">\n\t<relmd:metadataSource relmd:dataSourceName=\"" + this.m_datasourceName + "\"" + (this.m_dataSourceConnectionName != null ? " relmd:dataSourceConnectionName=\"" + this.m_dataSourceConnectionName + "\"" : "") + (this.m_dataSourceSignonName != null ? " relmd:dataSourceSignonName=\"" + this.m_dataSourceSignonName + "\"" : "") + (this.m_credentialsXml != null ? " relmd:encryptedCredentialsXml=\"" + this.m_credentialsXml + "\"" : "") + "/>";
        MdBase grandParent = parent.getParent();
        request = grandParent instanceof MdCatalog ? String.valueOf(request) + "\n\t<relmd:viewsBrowse relmd:parentCatalogName=\"" + grandParent.getName() + "\"" + " relmd:parentSchemaName=\"" + parent.getName() + "\"" + (this.m_includeSysObjects ? " relmd:browseQueryType=\"systemObjects\"" : "") + "/>" : String.valueOf(request) + "\n\t<relmd:viewsBrowse relmd:parentSchemaName=\"" + parent.getName() + "\"" + (this.m_includeSysObjects ? " relmd:browseQueryType=\"systemObjects\"" : "") + "/>";
        request = String.valueOf(request) + "\n</relmd:browseMetadataRequest>\n";
        return request;
    }

    private String getSynonymBrowseRequest(MdBase parent) {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<relmd:browseMetadataRequest xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:relmd=\"http://www.ibm.com/xmlns/prod/cognos/relmd/1/0\" xsi:schemaLocation=\"http://www.ibm.com/xmlns/prod/cognos/relmd/1/0 ../webcontent/relmd/relmdApi.xsd\">\n\t<relmd:metadataSource relmd:dataSourceName=\"" + this.m_datasourceName + "\"" + (this.m_dataSourceConnectionName != null ? " relmd:dataSourceConnectionName=\"" + this.m_dataSourceConnectionName + "\"" : "") + (this.m_dataSourceSignonName != null ? " relmd:dataSourceSignonName=\"" + this.m_dataSourceSignonName + "\"" : "") + (this.m_credentialsXml != null ? " relmd:encryptedCredentialsXml=\"" + this.m_credentialsXml + "\"" : "") + "/>";
        MdBase grandParent = parent.getParent();
        request = grandParent instanceof MdCatalog ? String.valueOf(request) + "\n\t<relmd:synonymsBrowse relmd:parentCatalogName=\"" + grandParent.getName() + "\"" + " relmd:parentSchemaName=\"" + parent.getName() + "\"" + (this.m_includeSysObjects ? " relmd:browseQueryType=\"systemObjects\"" : "") + "/>" : String.valueOf(request) + "\n\t<relmd:synonymsBrowse relmd:parentSchemaName=\"" + parent.getName() + "\"" + (this.m_includeSysObjects ? " relmd:browseQueryType=\"systemObjects\"" : "") + "/>";
        request = String.valueOf(request) + "\n</relmd:browseMetadataRequest>\n";
        return request;
    }

    public synchronized I_RelmdServiceInvoker getServiceInvoker() {
        if (this.m_session.getPassport() == null) {
            this.m_session.setPassport();
        }
        if (this.m_relmdPort == null) {
            try {
                ICCLConfiguration configuration = CCLConfigurationFactory.getInstance();
                configuration.init();
                String sdkUriValue = configuration.getValue("sdk", false);
                URL sdkUrI = new URL(sdkUriValue);
                RelationalMetadataService_ServiceLocator relmdServiceLocator = new RelationalMetadataService_ServiceLocator();
                this.m_relmdPort = relmdServiceLocator.getrelationalMetadataService(sdkUrI);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        RelmdServiceInvoker serviceInvoker = new RelmdServiceInvoker(this.m_relmdPort, this.m_session.getPassport());
        return serviceInvoker;
    }

    @Override
    public void getSchemas(MdBase parent, List<MdSchema> schemasList) {
        String browseRequestXml = this.getSchemaBrowseRequest(parent);
        List<String> names = this.getObjectNames(browseRequestXml);
        for (String name : names) {
            schemasList.add(new BrowseSchema(parent, (BrowseTools)this, name));
        }
    }

    @Override
    public void getCatalogs(MdBase parent, List<MdCatalog> catalogList) {
        String browseRequestXml = this.getCatalogBrowseRequest();
        List<String> names = this.getObjectNames(browseRequestXml);
        for (String name : names) {
            catalogList.add(new BrowseCatalog(parent, (BrowseTools)this, name));
        }
    }

    private List<String> getObjectNames(String browseRequestXml) {
        this.validatePassport();
        I_RelmdServiceInvoker relmdServiceInvoker = this.getServiceInvoker();
        SAXReader saxReader = new SAXReader();
        InputStream relmdResponseStream = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            Document doc = saxReader.read((Reader)new StringReader(browseRequestXml));
            Element requestElement = doc.getRootElement();
            BrowseMetadataRequest browseRequest = this.m_relmd.xmlApiToolkit().browseMetadataRequest(requestElement);
            relmdResponseStream = relmdServiceInvoker.invokeMetadataBrowse(browseRequest, this.m_session.getProgressCallbackHandler());
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(relmdResponseStream, (DefaultHandler)new BrowsedHandler(names));
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return names;
    }

    @Override
    public void getTables(MdSchema schema, List<MdTable> tableList) {
        String browseRequestXml = this.getTableBrowseRequest(schema);
        List<String> names = this.getObjectNames(browseRequestXml);
        for (String name : names) {
            tableList.add(new BrowseTable((MdBase)schema, this, name));
        }
    }

    @Override
    public void getViews(MdSchema schema, List<MdTable> viewList) {
        String browseRequestXml = this.getViewBrowseRequest(schema);
        List<String> names = this.getObjectNames(browseRequestXml);
        for (String name : names) {
            viewList.add(new BrowseView((MdBase)schema, this, name));
        }
    }

    @Override
    public void getSynonyms(MdSchema schema, List<MdTable> synonymList) {
        String browseRequestXml = this.getSynonymBrowseRequest(schema);
        List<String> names = this.getObjectNames(browseRequestXml);
        for (String name : names) {
            synonymList.add(new BrowseSynonym((MdBase)schema, this, name));
        }
    }

    @Override
    public String getUDAVendorCode() {
        return null;
    }

    @Override
    public void openConnection() {
    }

    @Override
    public void closeConnection() {
    }

    private String getColumnsImportRequest(MdTable table) {
        String catalogName = "";
        if (table.getParent().getParent() instanceof MdCatalog) {
            catalogName = table.getParent().getParent().getName();
        }
        String schemaName = table.getParent().getName();
        String tableName = table.getName();
        return this.getColumnsImportRequest(catalogName, schemaName, tableName, table.getTableType());
    }

    private String getColumnsImportRequest(String catalogName, String schemaName, String tableName, MdTable.TablePhysicalType type) {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<relmd:importMetadataRequest xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:relmd=\"http://www.ibm.com/xmlns/prod/cognos/relmd/1/0\" xsi:schemaLocation=\"http://www.ibm.com/xmlns/prod/cognos/relmd/1/0 ../webcontent/relmd/relmdApi.xsd\">\n\t<relmd:metadataSource relmd:dataSourceName=\"" + this.m_datasourceName + "\"" + (this.m_dataSourceConnectionName != null ? " relmd:dataSourceConnectionName=\"" + this.m_dataSourceConnectionName + "\"" : "") + (this.m_dataSourceSignonName != null ? " relmd:dataSourceSignonName=\"" + this.m_dataSourceSignonName + "\"" : "") + (this.m_credentialsXml != null ? " relmd:encryptedCredentialsXml=\"" + this.m_credentialsXml + "\"" : "") + "/>";
        boolean hasCatalog = false;
        if (catalogName != null && !catalogName.isEmpty()) {
            hasCatalog = true;
        }
        request = String.valueOf(request) + "<relmd:metadataObjectSelections>";
        if (hasCatalog) {
            request = String.valueOf(request) + "<relmd:catalogSelection name=\"" + catalogName + "\">";
        }
        request = String.valueOf(request) + "<relmd:schemaSelection name=\"" + schemaName + "\"" + " relmd:importForeignKeysUsingGenericMethod=\"true\"" + ">";
        request = type == MdTable.TablePhysicalType.table ? String.valueOf(request) + "<relmd:tableSelection name=\"" + tableName + "\"/>" : (type == MdTable.TablePhysicalType.view ? String.valueOf(request) + "<relmd:viewSelection name=\"" + tableName + "\"/>" : String.valueOf(request) + "<relmd:synonymSelection name=\"" + tableName + "\"/>");
        request = String.valueOf(request) + "</relmd:schemaSelection>";
        if (hasCatalog) {
            request = String.valueOf(request) + "</relmd:catalogSelection>";
        }
        request = String.valueOf(request) + "</relmd:metadataObjectSelections>";
        request = String.valueOf(request) + "</relmd:importMetadataRequest>";
        return request;
    }

    @Override
    public void importTable(MdTable mdTable, MetadataObjectHandler tableHandler) {
        this._import(this.getColumnsImportRequest(mdTable), tableHandler);
    }

    @Override
    public void importTable(String catalog, String schema, String table, MdTable.TablePhysicalType type, MetadataObjectHandler tableHandler) {
        this._import(this.getColumnsImportRequest(catalog, schema, table, type), tableHandler);
    }

    private void validatePassport() {
        CmHelper helper = CmHelper.get(this.m_session, this.m_session.getPassport());
        helper.validatePassport();
    }

    private void _import(String requestXml, MetadataObjectHandler tableHandler) {
        this.validatePassport();
        I_RelmdServiceInvoker relmdServiceInvoker = this.getServiceInvoker();
        SAXReader saxReader = new SAXReader();
        try {
            Document doc = saxReader.read((Reader)new StringReader(requestXml));
            Element requestElement = doc.getRootElement();
            ImportMetadataRequest browseRequest = this.m_relmd.xmlApiToolkit().importMetadataRequest(requestElement);
            InputStream relmdResponseStream = relmdServiceInvoker.invokeMetadataImport(browseRequest, this.m_session.getProgressCallbackHandler());
            MetadataToolkit metadataToolkit = this.m_relmd.metadataToolkit();
            MetadataXmlToolkit metadataSerializationToolkit = metadataToolkit.metadataXmlToolkit();
            MetadataLoader newMetadataBuilder = metadataSerializationToolkit.metadataLoader();
            MetadataObjectHandler chainedMetadataObjectHandler = metadataSerializationToolkit.chainedMetadataObjectHandler(new MetadataObjectHandler[]{tableHandler, newMetadataBuilder});
            metadataSerializationToolkit.readModel(relmdResponseStream, chainedMetadataObjectHandler);
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BrowsedHandler
    extends DefaultHandler {
        List<String> m_names = null;

        public BrowsedHandler(List<String> names) {
            this.m_names = names;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("relmd:browsedObject")) {
                this.m_names.add(attributes.getValue("relmd:name"));
            }
        }
    }
}

