/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.metadata.adapters.physmd;

import com.ibm.cognos.fmeng.metadata.MdBase;
import com.ibm.cognos.fmeng.metadata.MdCatalog;
import com.ibm.cognos.fmeng.metadata.MdSchema;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseCatalog;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseSchema;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseSynonym;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseTable;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseTools;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseView;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.PhysmdDatabaseEventCollector;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.PhysmdTools;
import com.ibm.cognos.fmeng.metadata.mdSource.RelmdBrowseSource;
import com.ibm.cognos.internal.relmd.RelmdToolkits;
import com.ibm.cognos.internal.relmd.metadata.browse.BrowseFunction;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata._schema.Catalog;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema.Schema;
import com.ibm.cognos.relmd.metadata._schema.Synonym;
import com.ibm.cognos.relmd.metadata._schema.Table;
import com.ibm.cognos.relmd.metadata._schema.View;
import com.ibm.cognos.relmd.metadata._schema._handlers.MetadataObjectHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.MetadataElementHandler;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata._tools.xml.ImportResultsMetadataBuilder;
import com.ibm.cognos.relmd.metadata.browse.MetadataBrowseRules;
import com.ibm.cognos.relmd.metadata.browse._handlers.BrowsedObjectHandler;
import com.ibm.cognos.relmd.metadata.browse.functions.BrowseMetadataFunction;
import com.ibm.cognos.relmd.metadata.browse.functions.BrowseQueryType;
import com.ibm.cognos.relmd.metadata.browse.rules.CatalogsBrowseRules;
import com.ibm.cognos.relmd.metadata.browse.rules.query.BrowsedObject;
import com.ibm.cognos.relmd.metadata.import_.ImportMetadataResult;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportRules;
import com.ibm.cognos.relmd.metadata.import_.functions.DatabaseImport;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.CatalogSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SchemaSelection;
import com.ibm.cognos.relmd.metadata.source.MetadataSource;
import com.ibm.cognos.relmd.session.query.SessionQueryRules;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.VendorRules;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.connection.ConnectionParameters;
import com.ibm.cognos.relmd.vendor.connection.ConnectionStringParameters;
import com.ibm.cognos.relmd.vendor.connection.ExtendedParameterLookup;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelmdJDBCBrowseTools
implements BrowseTools {
    private RelmdBrowseSource m_source = null;
    private static final RelmdToolkits m_RelmdToolkits = (RelmdToolkits)RelmdGateway.relmd();
    private MetadataBrowseRules m_browseRules;
    private VendorAccessConnection m_vendorAccessConnection;
    private Database.EVendorType m_vendorType = null;
    private Connection m_Connection;

    public RelmdJDBCBrowseTools(RelmdBrowseSource source) {
        this.m_source = source;
    }

    @Override
    public void openConnection() {
        String relmdConnectionString = this.m_source.buildRelmdConnectionString();
        String userName = this.m_source.getUserID();
        String password = this.m_source.getPassword();
        if (relmdConnectionString == null) {
            return;
        }
        ConnectionStringParameters parseConnectionString = m_RelmdToolkits.parseConnectionString(relmdConnectionString);
        this.m_vendorType = parseConnectionString.vendorType();
        String jdbcConnectionString = parseConnectionString.jdbcConnectionString();
        String driverClass = parseConnectionString.driverClass();
        ExtendedParameterLookup lookup = new ExtendedParameterLookup(){

            public Object parameter(String parameterName) {
                return null;
            }
        };
        ConnectionParameters connectionParameters = m_RelmdToolkits.connectionParameters(this.m_vendorType, jdbcConnectionString, driverClass, userName, password, lookup, "en");
        try {
            this.m_Connection = m_RelmdToolkits.connection(connectionParameters);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        VendorRules vendorRules = PhysmdTools.getVendorRules(this.m_vendorType);
        SessionQueryRules sessionQueryRules = vendorRules.sessionQueryRules();
        PhysmdDatabaseEventCollector vendorAccessHandler = new PhysmdDatabaseEventCollector();
        this.m_vendorAccessConnection = m_RelmdToolkits.vendorAccessConnection(this.m_Connection, (VendorAccessHandler)vendorAccessHandler, sessionQueryRules);
        this.m_browseRules = vendorRules.metadataBrowseRules();
    }

    @Override
    public void closeConnection() {
        try {
            this.m_Connection.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void getSchemas(MdBase parent, List<MdSchema> schemasList) {
        this.getSchemas(parent, schemasList, BrowseQueryType.EQueryType.regular);
        if (this.m_source.getIncludeSystemObjects()) {
            this.getSchemas(parent, schemasList, BrowseQueryType.EQueryType.systemObjects);
        }
    }

    protected void getSchemas(MdBase parent, List<MdSchema> schemasList, BrowseQueryType.EQueryType objectType) {
        CatalogsBrowseRules rules = this.m_browseRules.catalogsBrowseRules();
        if (rules != null && !(parent instanceof MdCatalog)) {
            return;
        }
        ArrayList<BrowsedObject> objs = new ArrayList<BrowsedObject>();
        ExpectedObjects expectedExtractedObjects = new ExpectedObjects(objs);
        BrowseFunction browser = new BrowseFunction(BrowseMetadataFunction.EBrowseFunctionType.schemasBrowse, parent instanceof MdCatalog ? parent.getName() : null, null, null, objectType);
        browser.setVendorType(this.m_vendorType);
        browser.run(this.m_vendorAccessConnection, this.m_browseRules, (BrowsedObjectHandler)expectedExtractedObjects);
        for (BrowsedObject obj : objs) {
            schemasList.add(new BrowseSchema(parent, (BrowseTools)this, obj.objectName()));
        }
    }

    @Override
    public void getCatalogs(MdBase parent, List<MdCatalog> catalogList) {
        this.getCatalogs(parent, catalogList, BrowseQueryType.EQueryType.regular);
        if (this.m_source.getIncludeSystemObjects()) {
            this.getCatalogs(parent, catalogList, BrowseQueryType.EQueryType.systemObjects);
        }
    }

    protected void getCatalogs(MdBase parent, List<MdCatalog> catalogList, BrowseQueryType.EQueryType objectType) {
        ArrayList<BrowsedObject> objs = new ArrayList<BrowsedObject>();
        ExpectedObjects expectedExtractedObjects = new ExpectedObjects(objs);
        BrowseFunction browser = new BrowseFunction(BrowseMetadataFunction.EBrowseFunctionType.catalogsBrowse, null, null, null, objectType);
        browser.setVendorType(this.m_vendorType);
        browser.run(this.m_vendorAccessConnection, this.m_browseRules, (BrowsedObjectHandler)expectedExtractedObjects);
        for (BrowsedObject obj : objs) {
            catalogList.add(new BrowseCatalog(parent, (BrowseTools)this, obj.objectName()));
        }
    }

    @Override
    public void getTables(MdSchema schema, List<MdTable> tableList) {
        ArrayList<BrowsedObject> objs = new ArrayList<BrowsedObject>();
        ExpectedObjects expectedExtractedObjects = new ExpectedObjects(objs);
        BrowseFunction browser = new BrowseFunction(BrowseMetadataFunction.EBrowseFunctionType.tablesBrowse, schema.getParent() instanceof MdCatalog ? schema.getParent().getName() : null, schema.getName(), null, BrowseQueryType.EQueryType.regular);
        browser.setVendorType(this.m_vendorType);
        browser.run(this.m_vendorAccessConnection, this.m_browseRules, (BrowsedObjectHandler)expectedExtractedObjects);
        for (BrowsedObject obj : objs) {
            tableList.add(new BrowseTable((MdBase)schema, this, obj.objectName()));
        }
    }

    @Override
    public void getViews(MdSchema schema, List<MdTable> viewList) {
        ArrayList<BrowsedObject> objs = new ArrayList<BrowsedObject>();
        ExpectedObjects expectedExtractedObjects = new ExpectedObjects(objs);
        BrowseFunction browser = new BrowseFunction(BrowseMetadataFunction.EBrowseFunctionType.viewsBrowse, schema.getParent() instanceof MdCatalog ? schema.getParent().getName() : null, schema.getName(), null, BrowseQueryType.EQueryType.regular);
        browser.setVendorType(this.m_vendorType);
        browser.run(this.m_vendorAccessConnection, this.m_browseRules, (BrowsedObjectHandler)expectedExtractedObjects);
        for (BrowsedObject obj : objs) {
            viewList.add(new BrowseView((MdBase)schema, this, obj.objectName()));
        }
    }

    @Override
    public void getSynonyms(MdSchema schema, List<MdTable> synonymList) {
        ArrayList<BrowsedObject> objs = new ArrayList<BrowsedObject>();
        ExpectedObjects expectedExtractedObjects = new ExpectedObjects(objs);
        BrowseFunction browser = new BrowseFunction(BrowseMetadataFunction.EBrowseFunctionType.synonymsBrowse, schema.getParent() instanceof MdCatalog ? schema.getParent().getName() : null, schema.getName(), null, BrowseQueryType.EQueryType.regular);
        browser.setVendorType(this.m_vendorType);
        browser.run(this.m_vendorAccessConnection, this.m_browseRules, (BrowsedObjectHandler)expectedExtractedObjects);
        for (BrowsedObject obj : objs) {
            synonymList.add(new BrowseSynonym((MdBase)schema, this, obj.objectName()));
        }
    }

    private Schema getSchemaObject(Collection<Database> dbList, boolean hasCatalog) {
        for (Database db : dbList) {
            if (hasCatalog) {
                ReferenceableSet catalogSet = db.catalogsSet();
                for (Catalog someCatalog : catalogSet) {
                    Iterator iterator = someCatalog.schemasSet().iterator();
                    if (!iterator.hasNext()) continue;
                    Schema someSchema = (Schema)iterator.next();
                    return someSchema;
                }
                continue;
            }
            ReferenceableSet schemaSet = db.schemasSet();
            Iterator iterator = schemaSet.iterator();
            if (!iterator.hasNext()) continue;
            Schema someSchema = (Schema)iterator.next();
            return someSchema;
        }
        return null;
    }

    @Override
    public String getUDAVendorCode() {
        return this.m_source.getVendorType().getUDAVendorCode();
    }

    @Override
    public void importTable(String catalog, String schema, String table, MdTable.TablePhysicalType type, MetadataObjectHandler tableHandler) {
        this._importTable(catalog, schema, table, type, tableHandler);
    }

    private void _importTable(String catalog, String schema, String table, MdTable.TablePhysicalType type, MetadataObjectHandler tableHandler) {
        MetadataSource dataSource = m_RelmdToolkits.dataSource(this.m_source.getDatabaseName());
        VendorRules vendorRules = PhysmdTools.getVendorRules(this.m_vendorType);
        ImportResultsMetadataBuilder modelBuilder = m_RelmdToolkits.importMetadataResultBuilder(dataSource, this.m_vendorType);
        MetadataImportRules rules = vendorRules.metadataImportRules();
        MetadataObjectSelections objectSelections = m_RelmdToolkits.metadataObjectSelections();
        SchemaSelection schemaSelection = null;
        if (catalog == null || catalog.isEmpty()) {
            schemaSelection = m_RelmdToolkits.schemaSelection(schema);
            objectSelections.schemaSelections().selectedObjects().add((Object)schemaSelection);
        } else {
            CatalogSelection catalogSelection = m_RelmdToolkits.catalogSelection(catalog);
            schemaSelection = m_RelmdToolkits.schemaSelection(schema);
            catalogSelection.schemaSelections().selectedObjects().add((Object)schemaSelection);
            objectSelections.catalogSelections().selectedObjects().add((Object)catalogSelection);
        }
        schemaSelection.setImportForeignKeysUsingGenericMethod(true);
        if (type == MdTable.TablePhysicalType.table) {
            schemaSelection.tableSelections().selectedObjects().add((Object)m_RelmdToolkits.tableSelection(table));
        } else if (type == MdTable.TablePhysicalType.view) {
            schemaSelection.viewSelections().selectedObjects().add((Object)m_RelmdToolkits.viewSelection(table));
        } else if (type == MdTable.TablePhysicalType.synonym) {
            schemaSelection.synonymSelections().selectedObjects().add((Object)m_RelmdToolkits.synonymSelection(table));
        }
        DatabaseImport request = m_RelmdToolkits.databaseImport();
        request.setVendorType(this.m_vendorType);
        ImportSummary summary = request.run(this.m_vendorAccessConnection, rules, objectSelections, (MetadataElementHandler)modelBuilder);
        ImportMetadataResult result = m_RelmdToolkits.importMetadataResult(modelBuilder.metadata(), summary);
        Database db = (Database)result.metadata().databaseCollection().iterator().next();
        tableHandler.handleDatabase(db);
        Schema theSchema = null;
        ReferenceableSet cats = db.catalogsSet();
        if (cats.isEmpty()) {
            if (!db.schemasSet().isEmpty()) {
                theSchema = (Schema)db.schemasSet().iterator().next();
            }
        } else {
            theSchema = (Schema)((Catalog)cats.iterator().next()).schemasSet().iterator().next();
        }
        if (theSchema != null) {
            for (Table t : theSchema.tablesSet()) {
                tableHandler.handleTable(t);
            }
            for (View view : theSchema.viewsSet()) {
                tableHandler.handleView(view);
            }
            for (Synonym synonym : theSchema.synonymsSet()) {
                tableHandler.handleSynonym(synonym);
            }
        }
    }

    @Override
    public void importTable(MdTable mdTable, MetadataObjectHandler tableHandler) {
        String catName = "";
        if (mdTable.getParent() instanceof MdCatalog) {
            catName = mdTable.getParent().getName();
        }
        this._importTable(catName, mdTable.getParent().getName(), mdTable.getName(), mdTable.getTableType(), tableHandler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExpectedObjects
    implements BrowsedObjectHandler {
        private List<BrowsedObject> m_Expected;

        public ExpectedObjects(List<BrowsedObject> objs) {
            this.m_Expected = objs;
        }

        public void done() {
        }

        public void handleBrowsedObject(BrowsedObject arg) {
            this.m_Expected.add(arg);
        }
    }
}

