/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.metadata.impl;

import com.ibm.cognos.fmeng.fmmd.helpers.DomHelper;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.FmRegularAggregate;
import com.ibm.cognos.fmeng.metadata.MdCube;
import com.ibm.cognos.fmeng.metadata.MdDimension;
import com.ibm.cognos.fmeng.metadata.MdLevel;
import com.ibm.cognos.fmeng.metadata.MdMeasureDimension;
import com.ibm.cognos.fmeng.metadata.MdOLAPBase;
import com.ibm.cognos.fmeng.metadata.impl.MdDimensionImpl;
import com.ibm.cognos.fmeng.metadata.impl.MdHierarchyImpl;
import com.ibm.cognos.fmeng.metadata.impl.MdLevelImpl;
import com.ibm.cognos.fmeng.metadata.impl.MdMeasureDimensionImpl;
import com.ibm.cognos.fmeng.metadata.impl.MdMeasureFolderImpl;
import com.ibm.cognos.fmeng.metadata.impl.MdMeasureImpl;
import com.ibm.cognos.fmeng.metadata.impl.MdMeasureParentImpl;
import com.ibm.cognos.fmeng.metadata.impl.MdOLAPBaseImpl;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.utility.QueryRolapDataSource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MdCubeImpl
extends MdOLAPBaseImpl
implements MdCube {
    private String m_cmRolapDatasourcePath;
    private String m_defaultLocale;
    private List<MdDimension> m_dimensions = new ArrayList<MdDimension>();
    private MdMeasureDimension m_measureDim = null;

    public MdCubeImpl(String cubeName, String cmRolapDatasourcePath, String defaultLocale) {
        super(null, cubeName, defaultLocale);
        this.m_cmRolapDatasourcePath = cmRolapDatasourcePath;
        this.m_defaultLocale = defaultLocale;
    }

    @Override
    public String getDefaultLocale() {
        return this.m_defaultLocale;
    }

    @Override
    public String getCMPath() {
        return this.m_cmRolapDatasourcePath;
    }

    @Override
    public List<MdDimension> getDimensions() {
        return this.m_dimensions;
    }

    public void addDimension(MdDimension dimension) {
        this.m_dimensions.add(dimension);
    }

    @Override
    public MdMeasureDimension getMeasureDimension() {
        return this.m_measureDim;
    }

    public void setMeasureDimension(MdMeasureDimension measureDim) {
        this.m_measureDim = measureDim;
    }

    public static MdCube queryRolapDatasourceForCube(EMFSession emfSession, String cmRolapDatasourcePath) {
        EMFSession fmmdSession = emfSession;
        QueryRolapDataSource qrds = new QueryRolapDataSource(fmmdSession, cmRolapDatasourcePath);
        qrds.connect();
        qrds.exec();
        return MdCubeImpl.processQueryResults(qrds);
    }

    protected static MdCube processQueryResults(QueryRolapDataSource qrds) {
        MdCubeImpl mdCube = null;
        String defaultLocale = qrds.getDefaultLocale();
        String datasourceName = qrds.getDatasourceName();
        List<Element> folders = qrds.getFolderNodes();
        for (Element elFolder : folders) {
            mdCube = new MdCubeImpl(elFolder.attributeValue("name"), datasourceName, defaultLocale);
            List elDimensions = elFolder.elements("dimension");
            for (Element elDimension : elDimensions) {
                String dimType = elDimension.attributeValue("type");
                if ("regular".equals(dimType) || "time".equals(dimType)) {
                    DimensionBase.DimensionStyle dimStyle = DimensionBase.DimensionStyle.regular;
                    if ("time".equals(dimType)) {
                        dimStyle = DimensionBase.DimensionStyle.time;
                    }
                    MdDimensionImpl mdDim = new MdDimensionImpl((MdOLAPBaseImpl)mdCube, elDimension.attributeValue("name"), dimStyle);
                    List elHierarchies = elDimension.elements("hierarchy");
                    for (Element elHierarchy : elHierarchies) {
                        MdHierarchyImpl mdHierarchy = new MdHierarchyImpl(mdDim, elHierarchy.attributeValue("name"));
                        boolean isParentChild = "1".equals(elHierarchy.attributeValue("parentChild"));
                        mdHierarchy.setParentChild(isParentChild);
                        if (!isParentChild) {
                            ArrayList<MdLevel> mdLevels = new ArrayList<MdLevel>();
                            List<String> lvlNames = qrds.getLevelNames(mdHierarchy.getId());
                            for (String lvlName : lvlNames) {
                                MdLevelImpl mdLevel = new MdLevelImpl(mdHierarchy, lvlName);
                                mdLevels.add(mdLevel);
                            }
                            mdHierarchy.setLevels(mdLevels);
                        }
                        mdDim.addHierarchy(mdHierarchy);
                    }
                    mdCube.addDimension(mdDim);
                    continue;
                }
                if (!"measure".equals(dimType)) continue;
                MdMeasureDimensionImpl mdMeasureDim = new MdMeasureDimensionImpl(mdCube, elDimension.attributeValue("name"));
                mdCube.setMeasureDimension(mdMeasureDim);
                MdCubeImpl.handleMeasureChildren(elDimension, mdMeasureDim);
            }
        }
        return mdCube;
    }

    private static void handleMeasureChildren(Element elMeasureParent, MdMeasureParentImpl mdMeasureParent) {
        List elMeasures = elMeasureParent.elements();
        for (Element elMeasure : elMeasures) {
            String elType = elMeasure.getName();
            if ("measure".equals(elType)) {
                String expression = elMeasure.attributeValue("expression");
                if (expression != null && !"".equals(expression)) continue;
                FmRegularAggregate regularAggregate = FmRegularAggregate.valueOf(elMeasure.attributeValue("regularAggregate"));
                FmRegularAggregate semiAggr = FmRegularAggregate.unknown;
                if (elMeasure.attributeValue("semiAggregate") != null) {
                    semiAggr = FmRegularAggregate.valueOf(elMeasure.attributeValue("semiAggregate"));
                }
                StringBuilder format = new StringBuilder();
                Element elFormat = DomHelper.stringToDom4j(elMeasure.attributeValue("format"));
                if (elFormat != null) {
                    Node child;
                    StringBuilder tempFormat = new StringBuilder();
                    Iterator it = elFormat.nodeIterator();
                    while (it.hasNext()) {
                        child = (Node)it.next();
                        if (child.getNodeType() != 3) continue;
                        tempFormat.append(child.getText());
                    }
                    elFormat = DomHelper.stringToDom4j("<format>" + tempFormat.toString() + "</format>");
                    it = elFormat.nodeIterator();
                    while (it.hasNext()) {
                        child = (Node)it.next();
                        if (child.getNodeType() != 3) continue;
                        format.append(child.getText());
                    }
                }
                MdMeasureImpl mdMeasure = new MdMeasureImpl(mdMeasureParent, elMeasure.attributeValue("name"), format.toString(), regularAggregate, semiAggr);
                mdMeasureParent.addMeasure(mdMeasure);
                continue;
            }
            if (!"measureFolder".equals(elType)) continue;
            MdMeasureFolderImpl mdFolder = new MdMeasureFolderImpl(mdMeasureParent, elMeasure.attributeValue("name"));
            mdMeasureParent.addMeasureFolder(mdFolder);
            MdCubeImpl.handleMeasureChildren(elMeasure, mdFolder);
        }
    }

    public String toString() {
        ArrayList<String> names = new ArrayList<String>();
        for (MdDimension dimension : this.getDimensions()) {
            names.add(dimension.getName());
        }
        String mdimName = this.m_measureDim == null ? "null" : this.m_measureDim.getName();
        return "MdCube [Name='" + this.getName() + "', measureDimension='" + mdimName + "', dimensions=" + ((Object)names).toString() + "]";
    }

    @Override
    public List<MdOLAPBase> getChildObjects() {
        ArrayList<MdOLAPBase> children = new ArrayList<MdOLAPBase>();
        for (MdDimension measure : this.getDimensions()) {
            children.add(measure);
        }
        children.add(this.getMeasureDimension());
        return children;
    }
}

