/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.metadata.impl;

import com.ibm.cognos.fmeng.metadata.MdBase;
import com.ibm.cognos.fmeng.metadata.MdCatalog;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdDatabase;
import com.ibm.cognos.fmeng.metadata.MdSchema;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.metadata.MdTableContainer;
import com.ibm.cognos.fmeng.metadata.impl.MdBaseImpl;
import com.ibm.cognos.fmeng.metadata.impl.MdCatalogImpl;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MdDatabaseImpl
extends MdBaseImpl
implements MdDatabase {
    protected final FMMDSession m_Session;
    private HashMap<String, MdTable> m_PrimaryKeyMap = null;
    protected List<SynonymInfo> m_SynonymInfo = new ArrayList<SynonymInfo>();

    public MdDatabaseImpl(FMMDSession session, MdBase parent, String name, String description) {
        super(parent, name, description);
        this.m_Session = session;
        this.m_PrimaryKeyMap = new HashMap();
    }

    @Override
    public MdColumn findColumn(String catalog, String schema, String table, String column) {
        MdTable tableOfInterest;
        MdColumn colOfInterest = null;
        MdSchema schemaOfInterest = this.findSchema(catalog, schema);
        if (schemaOfInterest != null && (tableOfInterest = schemaOfInterest.findTable(table)) != null) {
            colOfInterest = tableOfInterest.findColumn(column);
        }
        return colOfInterest;
    }

    @Override
    public MdSchema findSchema(String catalogName, String schemaName) {
        if (catalogName != null && !"".equals(catalogName)) {
            MdCatalog catalog = this.findCatalog(catalogName);
            if (catalog != null) {
                return catalog.findSchema(schemaName);
            }
        } else {
            for (MdSchema schema : this.getSchemas()) {
                if (!(schema.getName() == null ? schemaName == null || "".equals(schemaName) : schema.getName().equals(schemaName))) continue;
                return schema;
            }
        }
        return null;
    }

    @Override
    public MdTableContainer findTableContainer(String catalogName, String schemaName) {
        if (catalogName != null && !"".equals(catalogName)) {
            MdCatalog catalog = this.findCatalog(catalogName);
            if (catalog != null) {
                return catalog.findSchema(schemaName);
            }
        } else {
            for (MdSchema schema : this.getSchemas()) {
                if (!(schema.getName() == null ? schemaName == null || "".equals(schemaName) : schema.getName().equals(schemaName))) continue;
                return schema;
            }
        }
        return null;
    }

    @Override
    public MdTableContainer findTableContainerInternal(String catalogName, String schemaName) {
        for (MdSchema schema : this.getAllSchemasInternal()) {
            MdCatalog cat;
            if (!schema.getName().equals(schemaName) || !(catalogName == null || "".equals(catalogName) ? schema.getCatalog() == null : (cat = schema.getCatalog()) != null && catalogName.equals(cat.getName()))) continue;
            return schema;
        }
        return null;
    }

    @Override
    public List<MdSchema> getAllSchemas() {
        ArrayList<MdSchema> allSchemas = new ArrayList<MdSchema>();
        List<MdSchema> schemas = this.getSchemas();
        if (schemas.size() > 0) {
            allSchemas.addAll(schemas);
        } else {
            for (MdCatalog catalog : this.getCatalogs()) {
                allSchemas.addAll(catalog.getSchemas());
            }
        }
        return allSchemas;
    }

    @Override
    public List<MdTableContainer> getAllTableContainers() {
        ArrayList<MdTableContainer> allSchemas = new ArrayList<MdTableContainer>();
        List<MdSchema> schemas = this.getSchemas();
        if (schemas.size() > 0) {
            allSchemas.addAll(schemas);
        } else {
            for (MdCatalog catalog : this.getCatalogs()) {
                allSchemas.addAll(catalog.getSchemas());
            }
        }
        return allSchemas;
    }

    public List<MdSchema> getAllSchemasInternal() {
        ArrayList<MdSchema> allSchemas = new ArrayList<MdSchema>();
        List<MdSchema> schemas = this.getSchemasInternal();
        if (schemas.size() > 0) {
            allSchemas.addAll(schemas);
        } else {
            for (MdCatalog catalog : this.getCatalogsInternal()) {
                allSchemas.addAll(((MdCatalogImpl)catalog).getSchemasInternal());
            }
        }
        return allSchemas;
    }

    @Override
    public abstract List<MdCatalog> getCatalogs();

    @Override
    public abstract List<MdSchema> getSchemas();

    public abstract List<MdSchema> getSchemasInternal();

    public abstract List<MdCatalog> getCatalogsInternal();

    @Override
    public MdCatalog findCatalog(String catalogName) {
        for (MdCatalog catalog : this.getCatalogs()) {
            if (!catalog.getName().equals(catalogName)) continue;
            return catalog;
        }
        return null;
    }

    public void registerPrimaryKey(String primaryKey, MdTable table) {
        if (primaryKey == null || "".equals(primaryKey)) {
            return;
        }
        this.m_PrimaryKeyMap.put(primaryKey, table);
    }

    public MdTable getTable(String primaryKey) {
        return this.m_PrimaryKeyMap.get(primaryKey);
    }

    public abstract boolean isBrowseSource();

    public final void loadDatabase() {
        this.doLoadDatabase();
        if (this.isBrowseSource()) {
            return;
        }
    }

    @Override
    public FMMDSession getSession() {
        return this.m_Session;
    }

    protected abstract void doLoadDatabase();

    protected class SynonymInfo {
        String m_Name;
        String m_Description;
        String m_TargetRef;
        String m_ExternalSchema;
        String m_Catalog;
        String m_Server;
        MdSchema m_Schema;

        public SynonymInfo(String name, String description, String targetRef, String externalSchema, String catalog, String server, MdSchema schema) {
            this.m_Name = name;
            this.m_Description = description;
            this.m_TargetRef = targetRef;
            this.m_ExternalSchema = externalSchema;
            this.m_Catalog = catalog;
            this.m_Server = server;
            this.m_Schema = schema;
        }
    }
}

