/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.metadata.impl;

import com.ibm.cognos.fmeng.fmmd.model.Association;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.util.FmJoinHelper;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdForeignKey;
import com.ibm.cognos.fmeng.metadata.MdJoin;
import com.ibm.cognos.fmeng.metadata.MdPrimaryKey;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.metadata.impl.MdAssocImpl;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MdJoinImpl
implements MdJoin {
    private String m_Name;
    private MdTable m_LeftTable;
    private Cardinality.ECardinality m_LeftMin;
    private Cardinality.ECardinality m_LeftMax;
    private MdTable m_RightTable;
    private MdForeignKey m_fKey;
    private Cardinality.ECardinality m_RightMin;
    private Cardinality.ECardinality m_RightMax;
    private List<Association> m_Associations;

    public static List<MdJoin> getJoins(MdTable primaryTable, MdTable foreignTable) {
        ArrayList<MdJoin> joins = new ArrayList<MdJoin>();
        return joins;
    }

    public static List<MdJoin> getJoins(MdTable table) {
        ArrayList<MdJoin> joins = new ArrayList<MdJoin>();
        for (MdForeignKey fKey : table.getReferringForeignKeys()) {
            MdJoinImpl.createJoins(fKey, joins);
        }
        if (table.hasForeignKeysLoaded()) {
            for (MdForeignKey fKey : table.getForeignKeys()) {
                MdJoinImpl.createJoins(fKey, joins);
            }
        }
        return joins;
    }

    private static void createJoins(MdForeignKey fKey, List<MdJoin> joins) {
        MdJoinImpl newJoin = new MdJoinImpl(fKey, fKey.getPrimaryTable(), Cardinality.ECardinality.one, Cardinality.ECardinality.one, fKey.getTable(), Cardinality.ECardinality.one, Cardinality.ECardinality.many);
        joins.add(newJoin);
    }

    public static List<MdJoin> getNextJoins(MdTable table) {
        ArrayList<MdJoin> joins = new ArrayList<MdJoin>();
        for (MdForeignKey fKey : table.getReferringForeignKeys()) {
            MdJoinImpl.createJoins(fKey, joins);
        }
        return joins;
    }

    private MdJoinImpl(MdForeignKey fkey, MdTable leftTable, Cardinality.ECardinality leftMin, Cardinality.ECardinality leftMax, MdTable rightTable, Cardinality.ECardinality rightMin, Cardinality.ECardinality rightMax) {
        this.m_fKey = fkey;
        this.m_Name = fkey.getName();
        this.m_LeftTable = leftTable;
        this.m_LeftMin = leftMin;
        this.m_LeftMax = leftMax;
        this.m_RightTable = rightTable;
        this.m_RightMin = rightMin;
        this.m_RightMax = rightMax;
        this.m_Associations = new ArrayList<Association>();
    }

    @Override
    public MdTable getEnd() {
        if (this.m_RightMax == Cardinality.ECardinality.many) {
            return this.m_RightTable;
        }
        return this.m_LeftTable;
    }

    @Override
    public MdTable getLeft() {
        return this.m_LeftTable;
    }

    @Override
    public Cardinality.ECardinality getLeftMaxcard() {
        return this.m_LeftMax;
    }

    @Override
    public Cardinality.ECardinality getLeftMincard() {
        return this.m_LeftMin;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public MdTable getRight() {
        return this.m_RightTable;
    }

    @Override
    public Cardinality.ECardinality getRightMaxcard() {
        return this.m_RightMax;
    }

    @Override
    public Cardinality.ECardinality getRightMincard() {
        return this.m_RightMin;
    }

    @Override
    public MdTable getStart() {
        if (this.m_RightMax == Cardinality.ECardinality.many) {
            return this.m_LeftTable;
        }
        return this.m_RightTable;
    }

    @Override
    public boolean equals(MdJoinImpl right) {
        return this.getName().equals(right.getName());
    }

    @Override
    public Association createAssociation(String leftColumn, String rightColumn, Association.EOperator operator) {
        MdAssocImpl assoc = new MdAssocImpl(leftColumn, rightColumn, operator);
        this.m_Associations.add(assoc);
        return assoc;
    }

    @Override
    public List<Association> getAssociations() {
        if (this.m_Associations.isEmpty()) {
            MdPrimaryKey pkey = this.m_LeftTable.getPrimaryKey();
            if (this.m_fKey != null && pkey != null) {
                List<MdColumn> fkColumns = this.m_fKey.getColumns();
                List<MdColumn> pkColumns = pkey.getColumns();
                int i = 0;
                while (i < Math.min(pkColumns.size(), fkColumns.size())) {
                    this.createAssociation(pkColumns.get(i).getName(), fkColumns.get(i).getName(), Association.EOperator.equals);
                    ++i;
                }
            }
        }
        return this.m_Associations;
    }

    @Override
    public void setLeftMaxcard(Cardinality.ECardinality leftMaxcard) {
    }

    @Override
    public void setLeftMincard(Cardinality.ECardinality leftMincard) {
    }

    @Override
    public void setRightMaxcard(Cardinality.ECardinality rightMaxcard) {
    }

    @Override
    public void setRightMincard(Cardinality.ECardinality rightMincard) {
    }

    @Override
    public boolean equals(MdJoin right) {
        return this.getName().equals(right.getName());
    }

    public String toString() {
        String stuff = String.valueOf(this.getName()) + ": " + this.getStart().getName() + "-->" + this.getEnd().getName();
        return stuff;
    }

    @Override
    public MdTable getOtherSide(MdTable table) {
        return new FmJoinHelper<MdTable, MdJoinImpl>().getOtherSide(this, table);
    }

    @Override
    public void copyCardinality(Cardinality right) {
        FmJoinHelper.copyCardinality(this, right);
    }

    @Override
    public boolean equals(Cardinality.ECardinality leftMinCard, Cardinality.ECardinality leftMaxCard, Cardinality.ECardinality rightMinCard, Cardinality.ECardinality rightMaxCard) {
        return leftMinCard.equals((Object)this.getLeftMincard()) && leftMaxCard.equals((Object)this.getLeftMaxcard()) && rightMinCard.equals((Object)this.getRightMincard()) && rightMaxCard.equals((Object)this.getRightMaxcard());
    }
}

