/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.metadata.impl;

import com.ibm.cognos.fmeng.metadata.MdBase;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdForeignKey;
import com.ibm.cognos.fmeng.metadata.MdIndex;
import com.ibm.cognos.fmeng.metadata.MdJoin;
import com.ibm.cognos.fmeng.metadata.MdPrimaryKey;
import com.ibm.cognos.fmeng.metadata.MdSchema;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.metadata.impl.MdBaseImpl;
import com.ibm.cognos.fmeng.metadata.impl.MdDatabaseImpl;
import com.ibm.cognos.fmeng.metadata.impl.MdJoinImpl;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MdTableImpl
extends MdBaseImpl
implements MdTable {
    MdTable.TablePhysicalType m_type;
    List<MdForeignKey> m_ReferringForeignKeys = null;
    MdPrimaryKey m_PrimaryKey = null;
    List<MdJoin> m_Joins = null;
    boolean m_ReferringForeignKeysChecked = false;
    List<MdIndex> m_Indices = null;

    public MdTableImpl(MdBase parent, String name, String description, MdTable.TablePhysicalType type) {
        super(parent, name, description);
        this.m_type = type;
        this.m_ReferringForeignKeys = new ArrayList<MdForeignKey>();
        this.m_Indices = new ArrayList<MdIndex>();
    }

    @Override
    public MdColumn findColumn(String columnName) {
        for (MdColumn column : this.getColumns()) {
            if (!column.getName().equals(columnName)) continue;
            return column;
        }
        return null;
    }

    @Override
    public abstract List<MdColumn> getColumns();

    @Override
    public abstract List<MdForeignKey> getForeignKeys();

    protected abstract void loadColumnCache();

    public void setPrimarykey(MdPrimaryKey key) {
        this.m_PrimaryKey = key;
        MdDatabaseImpl db = (MdDatabaseImpl)this.getDatabase();
        db.registerPrimaryKey(key.getName(), this);
    }

    @Override
    public MdPrimaryKey getPrimaryKey() {
        if (this.m_PrimaryKey == null) {
            this.loadColumnCache();
        }
        return this.m_PrimaryKey;
    }

    @Override
    public List<MdForeignKey> getReferringForeignKeys() {
        return this.m_ReferringForeignKeys;
    }

    public void addReferringForeignKey(MdForeignKey fKey) {
        for (MdForeignKey somefKey : this.m_ReferringForeignKeys) {
            if (!somefKey.equals(fKey)) continue;
            return;
        }
        this.m_ReferringForeignKeys.add(fKey);
    }

    @Override
    public MdSchema getSchema() {
        return (MdSchema)this.getParent();
    }

    @Override
    public MdTable.TablePhysicalType getTableType() {
        return this.m_type;
    }

    @Override
    public List<MdJoin> getJoins() {
        if (this.m_Joins == null || this.m_Joins.isEmpty()) {
            this.m_Joins = MdJoinImpl.getJoins(this);
        }
        return this.m_Joins;
    }

    public void addIndex(MdIndex index) {
        this.m_Indices.add(index);
    }

    @Override
    public List<MdIndex> getIndices() {
        this.loadColumnCache();
        return this.m_Indices;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder("MdTable: ");
        ret.append(this.getId());
        ret.append("\n");
        MdPrimaryKey pKey = this.getPrimaryKey();
        if (pKey == null) {
            ret.append("\tPrimary Key: null\n");
        } else {
            ret.append("\tPrimary Key: ");
            ret.append(pKey.getName());
            ret.append("\n");
            for (MdColumn column : pKey.getColumns()) {
                ret.append("\t\tColumn: ");
                ret.append(column.getName());
                ret.append("\n");
            }
            for (MdForeignKey fKey : this.getForeignKeys()) {
                ret.append("\tForeign Key: ");
                ret.append(fKey.getName());
                ret.append("\n");
                MdTable primTable = fKey.getPrimaryTable();
                String primTableName = primTable == null ? "null" : primTable.getName();
                ret.append("\t\tPrimary Table: ");
                ret.append(primTableName);
                ret.append("\n");
                for (MdColumn column : fKey.getColumns()) {
                    ret.append("\t\tColumn: ");
                    ret.append(column.getName());
                    ret.append("\n");
                }
            }
        }
        return ret.toString();
    }
}

