/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.metadata.mdSource;

import com.ibm.cognos.fmeng.metadata.VendorInfo;

public abstract class MdSourceBase {
    public abstract String getConnectionString();

    public abstract String getCacheFilename();

    public abstract VendorInfo getVendorType();

    public abstract String getDriver();

    public String buildRelmdConnectionString() {
        String connectionString = this.getConnectionString();
        if (connectionString == null) {
            return null;
        }
        if (connectionString.startsWith("^User ID:^?Password:;LOCAL;JD-")) {
            return connectionString;
        }
        String[] connStringParts = connectionString.split(";");
        VendorInfo vendor = this.getVendorType();
        if (vendor == VendorInfo.unknown || vendor == null) {
            VendorInfo[] vendorInfoArray = VendorInfo.values();
            int n = vendorInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                VendorInfo someVendor = vendorInfoArray[n2];
                String jdbcPrefix = "jdbc:" + someVendor.getJDBCPrefix();
                if (connStringParts[0].startsWith(jdbcPrefix)) {
                    vendor = someVendor;
                    break;
                }
                ++n2;
            }
        }
        StringBuilder jdbcConnection = new StringBuilder();
        int i = 0;
        while (i < connStringParts.length) {
            if (!connStringParts[i].startsWith("DRIVER_NAME")) {
                if (jdbcConnection.length() > 0) {
                    jdbcConnection.append(";");
                }
                jdbcConnection.append(connStringParts[i]);
            }
            ++i;
        }
        String driver = this.getDriver();
        if (driver == null) {
            driver = vendor.getDefaultDriver();
        }
        return "^User ID:^?Password:;LOCAL;JD-" + vendor.getUDAVendorCode() + ";URL=" + jdbcConnection.toString() + ";DRIVER_NAME=" + driver;
    }
}

