/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.metadata.mdSource;

import com.ibm.cognos.fmeng.metadata.MdSource;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RawMdSource
implements MdSource {
    private String m_databaseName;
    private String m_catalogName;
    private String m_schemaName;
    private String m_metadataCacheFileName;

    public RawMdSource(String metadataCacheFileName, String databaseName, String catalogName, String schemaName) {
        this.m_databaseName = databaseName;
        this.m_catalogName = catalogName;
        this.m_schemaName = schemaName;
        this.m_metadataCacheFileName = metadataCacheFileName;
    }

    public RawMdSource(String metadataCacheFileName) {
        this.m_databaseName = "";
        this.m_catalogName = "";
        this.m_schemaName = "";
        this.m_metadataCacheFileName = metadataCacheFileName;
    }

    public String getCatalogName() {
        return this.m_catalogName;
    }

    public String getSchemaName() {
        return this.m_schemaName;
    }

    public String getDatabaseName() {
        File file = new File(this.m_metadataCacheFileName);
        if ("".equals(this.m_databaseName) && file.exists()) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(new File(this.m_metadataCacheFileName), (DefaultHandler)new BrowsedHandler());
            }
            catch (SAXException se) {
                if (!se.getMessage().equals("Done")) {
                    Object[] msgParams = new Object[]{se.getLocalizedMessage()};
                    throw new FmMDException("BMT_MD_GENERIC_INTERNAL_ERROR", msgParams, se);
                }
            }
            catch (ParserConfigurationException e) {
                Object[] msgParams = new Object[]{e.getLocalizedMessage()};
                throw new FmMDException("BMT_MD_GENERIC_INTERNAL_ERROR", msgParams, e);
            }
            catch (IOException e) {
                Object[] msgParams = new Object[]{e.getLocalizedMessage()};
                throw new FmMDException("BMT_MD_GENERIC_INTERNAL_ERROR", msgParams, e);
            }
        }
        return this.m_databaseName;
    }

    public boolean getIncludeSystemObjects() {
        return true;
    }

    public boolean isBrowse() {
        return false;
    }

    public String getCacheFilename() {
        return this.m_metadataCacheFileName;
    }

    public MdSource copy(String catalog, String schema) {
        return new RawMdSource(this.m_metadataCacheFileName, this.m_databaseName, catalog, schema);
    }

    public String toString() {
        return "Physical metadata file:\n\tName: " + this.m_databaseName + "\n\tFile: " + this.m_metadataCacheFileName;
    }

    class BrowsedHandler
    extends DefaultHandler {
        BrowsedHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("relmd:database")) {
                RawMdSource.this.m_databaseName = attributes.getValue("relmd:dataSourceName");
                throw new SAXException("Done");
            }
        }
    }
}

