/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.platform;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmTaskAggregateCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTaskAggregateCube2;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTaskAnalyseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTaskCubeBuilder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTaskDMRtoROLAP;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTaskDimensionBuilder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTaskExportPowerCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTaskExportToCognosROLAP;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTaskExpressionValidation;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTaskFindRelatedDimensions;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTaskGenerateDDL;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTaskGenerateStarSchema;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTaskParameterMapImportExport;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTaskPublisher;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTaskROLAPtoDMR;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTaskReadGovernorsDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTaskVirtualCubeBuilder;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskSuggestFixes.FmTaskSuggestFixes;
import com.ibm.cognos.fmeng.fmmd.model.ColumnReference;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.FmUsage;
import com.ibm.cognos.fmeng.fmmd.model.Namespace;
import com.ibm.cognos.fmeng.fmmd.model.NonReportObject;
import com.ibm.cognos.fmeng.fmmd.model.Project;
import com.ibm.cognos.fmeng.fmmd.model.Property;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.RelationalQuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.SourceObject;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.fmmd.model.TaskAggregateCube;
import com.ibm.cognos.fmeng.fmmd.model.TaskAggregateCube2;
import com.ibm.cognos.fmeng.fmmd.model.TaskAnalyseObject;
import com.ibm.cognos.fmeng.fmmd.model.TaskCubeBuilder;
import com.ibm.cognos.fmeng.fmmd.model.TaskDMRtoROLAP;
import com.ibm.cognos.fmeng.fmmd.model.TaskDimensionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.TaskExportPowerCube;
import com.ibm.cognos.fmeng.fmmd.model.TaskExportToCognosROLAP;
import com.ibm.cognos.fmeng.fmmd.model.TaskExpressionValidation;
import com.ibm.cognos.fmeng.fmmd.model.TaskFindRelatedDimensions;
import com.ibm.cognos.fmeng.fmmd.model.TaskGenerateDDL;
import com.ibm.cognos.fmeng.fmmd.model.TaskGenerateStarSchema;
import com.ibm.cognos.fmeng.fmmd.model.TaskParameterMapImportExport;
import com.ibm.cognos.fmeng.fmmd.model.TaskPublisher;
import com.ibm.cognos.fmeng.fmmd.model.TaskROLAPtoDMR;
import com.ibm.cognos.fmeng.fmmd.model.TaskReadGovernorsDefinition;
import com.ibm.cognos.fmeng.fmmd.model.TaskSuggestFixes;
import com.ibm.cognos.fmeng.fmmd.model.TaskVirtualCubeBuilder;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdCube;
import com.ibm.cognos.fmeng.metadata.MdDatabase;
import com.ibm.cognos.fmeng.metadata.MdMeasure;
import com.ibm.cognos.fmeng.metadata.MdMeasureDimension;
import com.ibm.cognos.fmeng.metadata.MdOLAPBase;
import com.ibm.cognos.fmeng.metadata.MdSource;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.metadata.MdTableContainer;
import com.ibm.cognos.fmeng.platform.EventCallbackHandler;
import com.ibm.cognos.fmeng.platform.FMMDSessionPool;
import com.ibm.cognos.fmeng.platform.FmParameterBoolean;
import com.ibm.cognos.fmeng.platform.FmParameterInteger;
import com.ibm.cognos.fmeng.platform.ProgressCallbackHandler;
import com.ibm.cognos.fmeng.platform.ProjectAccess;
import com.ibm.cognos.fmeng.platform.SessionPool;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.platform.impl.FMMDConfigurations;
import com.ibm.cognos.fmeng.platform.impl.project.ProjectManager;
import com.ibm.cognos.fmeng.platform.transaction.FmParameterListString;
import com.ibm.cognos.fmeng.platform.transaction.ModelChanges;
import com.ibm.cognos.fmeng.platform.transaction.Transaction;
import com.ibm.cognos.fmeng.platform.transaction.TransactionSession;
import com.ibm.cognos.fmeng.platform.transaction.TransactionWork;
import com.ibm.cognos.fmeng.utility.soap.ContentManagerServiceRequest;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FMMDSession {
    private static final String FMT_DYNAMIC_SOURCE_PROPERTY = "&lt;item Name=&quot;%s&quot; Type=&quot;database&quot; Value=&quot;true&quot; dbType=&quot;RO&quot; isSystem=&quot;false&quot;&gt;&lt;item Name=&quot;ROLAP Catalog&quot; Type=&quot;catalog&quot; Value=&quot;partial&quot; uniqueName=&quot;ROLAP Catalog&quot;&gt;&lt;item Name=&quot;%s&quot; Type=&quot;cube&quot; Value=&quot;true&quot; uniqueName=&quot;%s&quot;/&gt;&lt;/item&gt;&lt;/item&gt;";
    private String m_passport;
    private EventCallbackHandler m_eventCallbackHandler;
    private ProgressCallbackHandler m_progressCallbackHandler;
    private ClientType m_clientType;
    private FMMDConfigurations m_config;
    private FmParameterBoolean m_DisplayPerformanceIcons;
    public FmParameterListString m_DisabledTests;
    public FmParameterInteger m_RoutesGovernor;

    @Deprecated
    public static FMMDSession createFMMDSession(ClientType clientType) {
        return new EMFSession(clientType, new Locale("en-us"));
    }

    public static FMMDSession createFMMDSession(ClientType clientType, Locale activeLocale) {
        return new EMFSession(clientType, activeLocale);
    }

    public static FMMDSession createFMMDSession(FMMDSession srcSession) {
        EMFSession newSession = new EMFSession(srcSession.getClientType(), srcSession.getActiveLocale());
        newSession.setPassport(srcSession.getPassport());
        return newSession;
    }

    protected FMMDSession(ClientType clientType) {
        if (!FmEngApplicationLog.getApplicationLog().initialize()) {
            System.out.println("Failed to start IPF logging.");
        }
        ((FMMDSessionPool)FMMDSessionPool.GetSessionPool()).registerSession(this);
        FmEngApplicationLog.getApplicationLog().createLoggersFor(this);
        FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.PLATFORM, this, "New session for client: " + clientType.toString());
        this.m_config = new FMMDConfigurations(this, "../configuration/FmEngConfig.xml");
        this.m_clientType = clientType;
        this.m_DisplayPerformanceIcons = this.m_config.registerParameter("DisplayPerformanceIcons", true);
        this.m_DisabledTests = this.m_config.registerParameter("DisableTest", new String[0]);
        this.m_RoutesGovernor = this.m_config.registerParameter("RoutesGovernor", 10000);
    }

    public ClientType getClientType() {
        return this.m_clientType;
    }

    public void setClientType(ClientType clientType) {
        this.m_clientType = clientType;
    }

    public abstract void delete(TopLevelObject var1);

    public abstract void delete(List<? extends TopLevelObject> var1);

    public abstract void delete(RemoveListener var1, TopLevelObject var2);

    public abstract void delete(RemoveListener var1, List<TopLevelObject> var2);

    public abstract Transaction createTransaction(TransactionWork var1);

    public abstract TransactionSession createTransactionSession();

    public abstract boolean canUndo();

    public abstract boolean canRedo();

    public abstract ModelChanges undo();

    public abstract ModelChanges redo();

    public abstract Locale getActiveLocale();

    public abstract void create(ProjectAccess var1);

    public abstract void load(ProjectAccess var1);

    public abstract void save() throws IOException;

    public abstract void saveAs(ProjectAccess var1) throws IOException;

    public abstract void saveCachedMetadata();

    public abstract String saveAs(String var1, String var2) throws FileNotFoundException, IOException;

    public abstract ProjectAccess getProjectAccess();

    public abstract void dumpModelXMLToStream(Object var1, OutputStream var2) throws IOException;

    public abstract void setActiveLocale(String var1);

    public abstract String getDefaultLocale();

    public abstract Project getProject();

    public void destroy() {
        this.m_config.save();
        FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.PLATFORM, this, "End of destroy");
        ((FMMDSessionPool)SessionPool.GetSessionPool()).deregisterSession(this);
        FmEngApplicationLog.getApplicationLog().stop();
    }

    public String getPassport() {
        return this.m_passport;
    }

    public void setPassport(String passport) {
        this.m_passport = passport;
    }

    public void setPassport() {
        String passport;
        if (this.getClientType().equals((Object)ClientType.QueryBuilder)) {
            this.m_passport = null;
            return;
        }
        ContentManagerServiceRequest req = new ContentManagerServiceRequest(this.getActiveLocale());
        this.m_passport = passport = req.queryForPassport();
    }

    public TaskDMRtoROLAP getTaskDMRtoROLAP() {
        return FmTaskDMRtoROLAP.getInstance();
    }

    public TaskROLAPtoDMR getTaskROLAPtoDMR() {
        return FmTaskROLAPtoDMR.getInstance();
    }

    public FMMDConfigurations getFMMDConfigurations() {
        return this.m_config;
    }

    public TaskParameterMapImportExport getTaskParameterMapImportExport() {
        return FmTaskParameterMapImportExport.getInstance(this);
    }

    public TaskPublisher getTaskPublisher() {
        return FmTaskPublisher.getInstance(this);
    }

    public abstract ProjectManager getProjectManager();

    public TaskFindRelatedDimensions getTaskFindRelatedDimensions() {
        return FmTaskFindRelatedDimensions.getInstance();
    }

    public TaskReadGovernorsDefinition getTaskReadGovernorsDefinition() {
        return FmTaskReadGovernorsDefinition.getInstance();
    }

    public TaskAnalyseObject getTaskAnalyseObject() {
        return FmTaskAnalyseObject.getInstance(this);
    }

    public TaskSuggestFixes getTaskSuggestFixes() {
        return FmTaskSuggestFixes.getInstance(this);
    }

    public TaskDimensionBuilder getTaskDimensionBuilder(RelationalObject relationalObject) {
        return FmTaskDimensionBuilder.getInstance(relationalObject);
    }

    public TaskGenerateStarSchema getTaskGenerateStarSchema(boolean useSMD) {
        return FmTaskGenerateStarSchema.getInstance(useSMD);
    }

    public TaskAggregateCube getTaskCreateAggregateCube() {
        return FmTaskAggregateCube.getInstance();
    }

    public TaskAggregateCube2 getTaskCreateAggregateCube2() {
        return FmTaskAggregateCube2.getInstance();
    }

    public TaskExportToCognosROLAP getTaskExportToCognosROLAP() {
        return FmTaskExportToCognosROLAP.getInstance(this);
    }

    public TaskExpressionValidation getTaskExpressionValidator() {
        return FmTaskExpressionValidation.getInstance(this);
    }

    public TaskExportPowerCube getTaskExportPowerCube() {
        return FmTaskExportPowerCube.getInstance();
    }

    public TaskCubeBuilder getTaskCubeBuilder() {
        return FmTaskCubeBuilder.getInstance(this);
    }

    public TaskVirtualCubeBuilder getTaskVirtualCubeBuilder() {
        return FmTaskVirtualCubeBuilder.getInstance();
    }

    public TaskGenerateDDL getTaskGenerateDDL() {
        return FmTaskGenerateDDL.getInstance(this);
    }

    public abstract String getSessionId();

    public abstract List<MdDatabase> getMetadataSources();

    public abstract MdDatabase findOrLoadMetadataSource(MdSource var1, String var2, String var3);

    public abstract MdDatabase findMetadataSource(String var1, String var2, String var3);

    public abstract MdTableContainer findTableContainerInternal(String var1, String var2, String var3);

    public abstract MdTable findPhysicalTable(DataSource var1, String var2, boolean var3);

    public abstract MdTable findPhysicalTable(String var1, String var2, String var3, String var4);

    public abstract MdColumn findPhysicalColumn(ColumnReference var1, boolean var2);

    public abstract MdCube findPhysicalCube(String var1);

    public abstract void removeMetadataSource(MdDatabase var1);

    public abstract TopLevelObject get(Object var1);

    public abstract NonReportObject getImplementationObject(Object var1);

    public abstract TopLevelObject findById(String var1);

    public abstract void resetChildValidationStatus();

    public abstract void propagateStatus();

    public void setProjectLocales(Project sourceProj) {
        Project proj = this.getProject();
        boolean removeEnUs = true;
        for (String locale : sourceProj.getSupportedLocales()) {
            if (!locale.equals(this.getDefaultLocale())) {
                proj.addLocale(locale);
            }
            if (!locale.equalsIgnoreCase("en-us")) continue;
            removeEnUs = false;
        }
        if (removeEnUs) {
            ArrayList<String> toRemove = new ArrayList<String>(1);
            toRemove.add("en-us");
            proj.removeLocales(toRemove);
        }
    }

    public void createLWMDynamicModel(String cubeName, String defaultLocale) {
        Project proj = this.getProject();
        proj.setDefaultLocale(defaultLocale);
        proj.setDynamicQueryMode(true);
        proj.setUseMFW(Project.UseMFW.eTrue);
        Namespace rootNamespace = proj.getRootNamespace();
        rootNamespace.setName(defaultLocale, cubeName);
        Property propertyDynamicContent = rootNamespace.createCustomProperty("dynamicContent");
        propertyDynamicContent.setType(Property.PropType.HIDDEN_TYPE);
        propertyDynamicContent.setValue("true");
        Property propertyDynamicSource = rootNamespace.createCustomProperty("dynamicSource");
        propertyDynamicSource.setType(Property.PropType.HIDDEN_TYPE);
        propertyDynamicSource.setValue(String.format(FMT_DYNAMIC_SOURCE_PROPERTY, cubeName, cubeName, cubeName));
    }

    public RelationalQuerySubject createViewDataModel(String passport, MdTable table, List<MdColumn> columnsToProject) {
        if (passport == null) {
            this.setPassport();
        } else {
            this.setPassport(passport);
        }
        Project project = this.getProject();
        DataSource dataSource = this.getProject().findOrCreateDataSource(table);
        RelationalQuerySubject qs = project.getRootNamespace().createRelationalQuerySubject(table.getName());
        Table mdTable = qs.createTable(dataSource, table.getName());
        if (columnsToProject == null) {
            columnsToProject = table.getColumns();
        }
        for (MdColumn col : columnsToProject) {
            if (col.getDatatype() == FmDatatype.BLOB || col.getDatatype() == FmDatatype.BLOBARRAY) continue;
            QueryItem qi = qs.createQueryItemFromColumn(col.getName(), col);
            qs.createQueryItemMapping(qi, col.getName(), mdTable);
            qi.setUsage(FmUsage.attribute);
        }
        return qs;
    }

    public abstract MdDatabase refreshMetadataSource(String var1, String var2, String var3, String var4, String var5, boolean var6);

    public abstract void deleteMetadataSource(String var1, String var2, String var3);

    public abstract void prefetchMetadata();

    public MdOLAPBase findMetadataObject(SourceObject sourceObject) {
        block6: {
            SourceObject sourceParent = sourceObject.getSourceParent();
            if (sourceParent == null) {
                String sourceName = sourceObject.getSourceName();
                if (sourceName == null || "".equals(sourceName)) {
                    return null;
                }
                return this.findPhysicalCube(sourceObject.getSourceName());
            }
            MdOLAPBase mdParent = this.findMetadataObject(sourceParent);
            if (mdParent == null) break block6;
            if (mdParent instanceof MdMeasureDimension) {
                for (MdMeasure meas : ((MdMeasureDimension)mdParent).getAllMeasures()) {
                    if (!meas.getName().equals(sourceObject.getSourceName())) continue;
                    return meas;
                }
            } else {
                for (MdOLAPBase child : mdParent.getChildObjects()) {
                    if (!child.getName().equals(sourceObject.getSourceName())) continue;
                    return child;
                }
            }
        }
        return null;
    }

    public void setEventCallbackHandler(EventCallbackHandler handler) {
        this.m_eventCallbackHandler = handler;
    }

    public EventCallbackHandler getEventCallbackHandler() {
        return this.m_eventCallbackHandler;
    }

    public void setProgressCallbackHandler(ProgressCallbackHandler handler) {
        this.m_progressCallbackHandler = handler;
    }

    public ProgressCallbackHandler getProgressCallbackHandler() {
        if (this.m_progressCallbackHandler == null) {
            this.m_progressCallbackHandler = new DummyProgressHandler();
        }
        return this.m_progressCallbackHandler;
    }

    public void setDisplayPerformanceIcon(boolean displayIcon) {
        this.m_DisplayPerformanceIcons.set(displayIcon);
    }

    public boolean getDisplayPerformanceIcon() {
        return this.m_DisplayPerformanceIcons.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClientType {
        CubeDesigner,
        QueryBuilder,
        SDK,
        SelfService,
        FrameworkManager,
        Unknown;

    }

    private class DummyProgressHandler
    implements ProgressCallbackHandler {
        private DummyProgressHandler() {
        }

        public void setProgressStatus(int percentageComplete, String progressText) {
        }

        public boolean isCancelRequested() {
            return false;
        }

        public void setProgressStatus(int progress, int total, String progressText) {
        }
    }
}

