/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.platform;

import com.ibm.cognos.fmeng.platform.ProjectAccess;
import com.ibm.cognos.fmeng.platform.impl.project.FMProjectCMAccessImpl;
import com.ibm.cognos.fmeng.platform.impl.project.FMProjectFileAccessImpl;
import com.ibm.cognos.fmeng.platform.impl.project.FmInMemoryProjectAccessImpl;
import com.ibm.cognos.fmeng.platform.impl.project.FmProjectFileAccessInputStreamImpl;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.io.File;
import java.io.InputStream;
import java.util.Locale;

public class ProjectFactory {
    public static ProjectAccess createInMemoryProject() {
        return new FmInMemoryProjectAccessImpl(false);
    }

    public static ProjectAccess createInMemoryProject(boolean ignoreCache) {
        return new FmInMemoryProjectAccessImpl(ignoreCache);
    }

    public static ProjectAccess createFileProject(String baseLocation) {
        return new FMProjectFileAccessImpl(baseLocation);
    }

    public static ProjectAccess createFileProject(String modelFile, String metadataFile) {
        return new FMProjectFileAccessImpl(null, modelFile, metadataFile);
    }

    public static ProjectAccess createFileProject(String projectFile, String modelFile, String metadataFile, boolean shouldExist) throws FmMDException {
        File fileResource = new File(modelFile);
        if (shouldExist && !fileResource.exists()) {
            throw new FmMDException("BMT_MD_MODEL_FILE_NOT_FOUND", modelFile);
        }
        return new FMProjectFileAccessImpl(projectFile, modelFile, metadataFile);
    }

    public static ProjectAccess createCMProject(Locale locale, String cmModelPath, String passport) {
        return new FMProjectCMAccessImpl(locale, cmModelPath, passport);
    }

    public static ProjectAccess createInputStreamProject(InputStream modelFile, String modelFileDesc) {
        return new FmProjectFileAccessInputStreamImpl(modelFile, modelFileDesc);
    }
}

