/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.platform.impl;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.impl.task.DefaultImpactListener;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.fmmd.util.CrnIDHelper;
import com.ibm.cognos.fmeng.fmmd.util.EmfHelper;
import com.ibm.cognos.fmeng.genmodel.CubeStyleType;
import com.ibm.cognos.fmeng.genmodel.CubeType;
import com.ibm.cognos.fmeng.genmodel.LevelReferenceType;
import com.ibm.cognos.fmeng.genmodel.NameType;
import com.ibm.cognos.fmeng.genmodel.RelationshipType;
import com.ibm.cognos.fmeng.genmodel.ReportObjectType;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubeChanges {
    private EMFSession mSession;

    public CubeChanges(EMFSession session) {
        this.mSession = session;
    }

    public void destroy() {
    }

    public void synchNameChange(EObject po, String oldName, String newName) {
        if (this.requiresRenameSynch(po)) {
            this.handleRename(po, oldName, newName);
        }
    }

    public void synchRemoveObject(EObject objParent, EObject objRemoved) {
        if (this.requiresRemoveSynch(objParent, objRemoved)) {
            this.handleRemove(objParent, objRemoved);
        }
    }

    public void synchReorderObject(EObject objParent, EObject objReorder, EObject objBefore) {
        if (this.requiresReorderSynch(objParent, objReorder, objBefore)) {
            this.handleReorder(objParent, objReorder, objBefore);
        }
    }

    private EObject findParentDimension(EObject o) {
        EObject parent = o;
        while (parent != null) {
            int parentType = parent.eClass().getClassifierID();
            if (parentType == 128 || parentType == 73) {
                return parent;
            }
            parent = parent.eContainer();
        }
        return parent;
    }

    private List<CubeType> findAllImpactedCubes(EObject o) {
        HashSet<Integer> recurseInto = new HashSet<Integer>();
        recurseInto.add(88);
        recurseInto.add(148);
        ArrayList objCubes = new ArrayList();
        HashMap<Integer, List<Object>> collect = new HashMap<Integer, List<Object>>();
        collect.put(28, objCubes);
        EmfHelper.collect(this.mSession.getProject().getRootNamespace().getInternal(), recurseInto, collect);
        ArrayList<CubeType> outCubes = new ArrayList<CubeType>(objCubes.size());
        if (!(o instanceof CubeType)) {
            for (Object obj : objCubes) {
                CubeType objCube = (CubeType)obj;
                if (objCube.getAggregateCubes().getCube().isEmpty() || !this.isIncludedInCube(this.findParentDimension(o), objCube)) continue;
                outCubes.add(objCube);
            }
        }
        return outCubes;
    }

    private boolean isIncludedInCube(EObject objDim, CubeType objCube) {
        if (objDim == null) {
            return false;
        }
        for (RelationshipType objRel : objCube.getRelationship()) {
            if (!objDim.equals(objRel.getLeft().getRefobj()) && !objDim.equals(objRel.getRight().getRefobj())) continue;
            return true;
        }
        return false;
    }

    private boolean requiresRenameSynch(EObject po) {
        int eType = po.eContainer().eClass().getClassifierID();
        return eType == 66 || eType == 130 || eType == 76 || eType == 128 || eType == 73 || eType == 119;
    }

    private boolean handleRename(EObject po, String oldName, String newName) {
        NameType nt = (NameType)po;
        EObject parent = po.eContainer();
        for (CubeType parentCube : this.findAllImpactedCubes(parent)) {
            for (CubeType aggrCube : parentCube.getAggregateCubes().getCube()) {
                TopLevelObject tlo;
                EObject aggrObj = this.lookupCorrespondingAggrObj(po.eContainer(), aggrCube, oldName);
                if (aggrObj == null || !((tlo = this.mSession.get(aggrObj)) instanceof FmReportObject)) continue;
                if (newName != null) {
                    ((FmReportObject)tlo).setName(nt.getLocale(), newName);
                    continue;
                }
                ((FmReportObject)tlo).removeNameLocale(nt.getLocale());
            }
        }
        return true;
    }

    private boolean requiresRemoveSynch(EObject po, EObject ro) {
        if (ro == null) {
            return false;
        }
        boolean out = false;
        int eParentType = po.eClass().getClassifierID();
        int eChildType = ro.eClass().getClassifierID();
        switch (eParentType) {
            case 28: {
                out = eChildType == 128 || eChildType == 73;
                break;
            }
            case 128: {
                out = eChildType == 130;
                break;
            }
            case 65: {
                out = eChildType == 66;
                break;
            }
            case 130: {
                out = eChildType == 64;
                break;
            }
            case 73: {
                out = eChildType == 76 || eChildType == 74;
                break;
            }
            case 66: {
                out = eChildType == 119;
            }
        }
        return out;
    }

    private boolean handleRemove(EObject parentObject, EObject removeObj) {
        int removeChildType = removeObj.eClass().getClassifierID();
        ArrayList<CubeType> cubes = new ArrayList<CubeType>();
        NameType removeChildName = this.getFirstName(removeObj);
        if (removeChildName == null) {
            return false;
        }
        if (parentObject instanceof CubeType) {
            CubeType cube = (CubeType)parentObject;
            if (!cube.getCubeStyle().equals((Object)CubeStyleType.AGGREGATE)) {
                cubes.add((CubeType)parentObject);
                this.remove(cubes, removeChildType, removeChildName, parentObject);
            }
        } else {
            cubes.addAll(this.findAllImpactedCubes(parentObject));
            this.remove(cubes, removeChildType, removeChildName, parentObject);
        }
        return true;
    }

    public void remove(List<CubeType> cubes, int removeChildType, NameType removeChildName, EObject parentObject) {
        for (CubeType parentCube : cubes) {
            block1: for (CubeType aggrCube : parentCube.getAggregateCubes().getCube()) {
                EObject aggrParent = this.lookupCorrespondingAggrObj(parentObject, aggrCube, null);
                if (aggrParent == null) continue;
                for (EObject ec : aggrParent.eContents()) {
                    NameType aChildName;
                    if (ec.eClass().getClassifierID() != removeChildType || (aChildName = this.getFirstName(ec)) == null || !aChildName.getLocale().equals(removeChildName.getLocale()) || !aChildName.getValue().equals(removeChildName.getValue())) continue;
                    this.mSession.delete((RemoveListener)new DefaultImpactListener(){

                        public void reportError(FmMDException errorMessage) {
                        }
                    }, this.mSession.get(ec));
                    continue block1;
                }
            }
        }
    }

    private boolean requiresReorderSynch(EObject po, EObject ro, EObject rb) {
        if (ro == null) {
            return false;
        }
        int eParentType = po.eClass().getClassifierID();
        int eReorderType = ro.eClass().getClassifierID();
        return eParentType == 130 && eReorderType == 64 && (rb == null || rb.eClass().getClassifierID() == 64);
    }

    private EObject lookupCorrespondingLevelRef(EObject po, EObject refTarget) {
        for (EObject ec : po.eContents()) {
            if (ec.eClass().getClassifierID() != 64 || !((LevelReferenceType)ec).getRefObj().equals(refTarget)) continue;
            return ec;
        }
        return null;
    }

    private boolean handleReorder(EObject objParent, EObject objReorder, EObject objBefore) {
        EObject detailedHierarchy = objReorder.eContainer();
        EObject detailedLevelRO = ((LevelReferenceType)objReorder).getRefObj();
        EObject detailedLevelRB = objBefore != null ? ((LevelReferenceType)objBefore).getRefObj() : null;
        for (CubeType parentCube : this.findAllImpactedCubes(objParent)) {
            for (CubeType aggrCube : parentCube.getAggregateCubes().getCube()) {
                EObject aggrLevelRO;
                EObject aggrHierarchy = this.lookupCorrespondingAggrObj(detailedHierarchy, aggrCube, null);
                if (aggrHierarchy == null || (aggrLevelRO = this.lookupCorrespondingAggrObj(detailedLevelRO, aggrCube, null)) == null) continue;
                EObject aggRO = this.lookupCorrespondingLevelRef(aggrHierarchy, aggrLevelRO);
                TopLevelObject tloAggrObjReorder = this.mSession.get(aggRO);
                TopLevelObject tloAggrObjBefore = null;
                if (detailedLevelRB != null) {
                    EObject aggrLevelRB = this.lookupCorrespondingAggrObj(detailedLevelRB, aggrCube, null);
                    if (aggrLevelRB == null) continue;
                    EObject aggRB = this.lookupCorrespondingLevelRef(aggrHierarchy, aggrLevelRB);
                    tloAggrObjBefore = aggRB == null ? null : this.mSession.get(aggRB);
                }
                tloAggrObjReorder.getParent().reorderBefore(tloAggrObjReorder, tloAggrObjBefore);
            }
        }
        return true;
    }

    private NameType getFirstName(EObject o) {
        ReportObjectType rot;
        EList<NameType> names;
        if (o instanceof LevelReferenceType) {
            LevelReferenceType lrt = (LevelReferenceType)o;
            o = lrt.getRefObj();
        }
        if ((names = (rot = (ReportObjectType)o).getName()) != null && !names.isEmpty()) {
            return (NameType)names.get(0);
        }
        return null;
    }

    private EObject lookupCorrespondingAggrObj(EObject detailedObj, CubeType aggrCube, String sOldName) {
        String detailedID = this.mSession.get(detailedObj).getID();
        List<String> detailedObjIdParts = CrnIDHelper.parseID(detailedID, true);
        String aggrCubeID = this.mSession.get(aggrCube).getID();
        String lastPart = null;
        lastPart = sOldName == null ? detailedObjIdParts.get(detailedObjIdParts.size() - 1) : CrnIDHelper.addEntryToID(null, sOldName);
        if (!(detailedObj instanceof CubeType)) {
            StringBuilder outID = new StringBuilder(aggrCubeID);
            int idx = 1;
            while (idx < detailedObjIdParts.size() - 1) {
                outID.append('.').append(detailedObjIdParts.get(idx));
                ++idx;
            }
            outID.append('.').append(lastPart);
            Object obj = this.mSession.getObjectById(outID.toString());
            return (EObject)obj;
        }
        StringBuilder outID = new StringBuilder(aggrCubeID);
        Object obj = this.mSession.getObjectById(outID.toString());
        return (EObject)obj;
    }
}

