/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.platform.impl;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.util.CrnIDHelper;
import com.ibm.cognos.fmeng.genmodel.AggregateCubesType;
import com.ibm.cognos.fmeng.genmodel.AttributeReferenceType;
import com.ibm.cognos.fmeng.genmodel.CubeType;
import com.ibm.cognos.fmeng.genmodel.DimensionType;
import com.ibm.cognos.fmeng.genmodel.FilterFolderType;
import com.ibm.cognos.fmeng.genmodel.HierarchyType;
import com.ibm.cognos.fmeng.genmodel.LevelReferenceType;
import com.ibm.cognos.fmeng.genmodel.LevelType;
import com.ibm.cognos.fmeng.genmodel.LocaleMappingType;
import com.ibm.cognos.fmeng.genmodel.MeasureDimensionType;
import com.ibm.cognos.fmeng.genmodel.MeasureFolderType;
import com.ibm.cognos.fmeng.genmodel.ModelObjectType;
import com.ibm.cognos.fmeng.genmodel.MultilingualAttributeMapType;
import com.ibm.cognos.fmeng.genmodel.MultilingualAttributeType;
import com.ibm.cognos.fmeng.genmodel.NameType;
import com.ibm.cognos.fmeng.genmodel.NamespaceType;
import com.ibm.cognos.fmeng.genmodel.PackageViewType;
import com.ibm.cognos.fmeng.genmodel.QueryItemType;
import com.ibm.cognos.fmeng.genmodel.QuerySubjectBaseType;
import com.ibm.cognos.fmeng.genmodel.RelationalDimensionType;
import com.ibm.cognos.fmeng.genmodel.RelationalHierarchyType;
import com.ibm.cognos.fmeng.genmodel.RelationalObjectType;
import com.ibm.cognos.fmeng.genmodel.RelativeTimeMembersType;
import com.ibm.cognos.fmeng.genmodel.ReportObjectType;
import com.ibm.cognos.fmeng.genmodel.ShortcutType;
import com.ibm.cognos.fmeng.genmodel.VirtualCubeType;
import com.ibm.cognos.fmeng.genmodel.VirtualDimensionType;
import com.ibm.cognos.fmeng.genmodel.VirtualHierarchyType;
import com.ibm.cognos.fmeng.genmodel.VirtualLevelType;
import com.ibm.cognos.fmeng.genmodel.VirtualMeasureDimensionType;
import com.ibm.cognos.fmeng.genmodel.VirtualMeasureFolderType;
import com.ibm.cognos.fmeng.genmodel.VirtualMeasureType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFIDGenerator {
    private static final String kPackagesID = "[].[packages]";
    private static final String kSecurityViewsID = "[].[securityViews]";
    private static final String kDataSourcesID = "[].[dataSources]";
    private static final String kParamterMapID = "[].[parameterMaps]";

    public static void setID(EObject obj, String locale, boolean overwrite) {
        String id = ((XMLResource)obj.eResource()).getID(obj);
        if (id != null && !overwrite) {
            return;
        }
        id = EMFIDGenerator.generateID(obj, locale);
        if (id != null) {
            ((XMLResource)obj.eResource()).setID(obj, id);
        }
    }

    public static void setIDUsingName(EObject obj, String name) {
        String id = EMFIDGenerator.generateIDUsingName(obj.eContainer(), obj, name);
        if (id != null) {
            ((XMLResource)obj.eResource()).setID(obj, id);
        }
    }

    public static String generateID(EObject obj, String locale) {
        if (obj instanceof ReportObjectType) {
            ReportObjectType mot = (ReportObjectType)obj;
            String name = EMFIDGenerator.getNameInLocale(mot.getName(), locale);
            if (name != null) {
                return EMFIDGenerator.generateIDUsingName(obj.eContainer(), obj, name);
            }
            return null;
        }
        if (obj instanceof ModelObjectType) {
            ModelObjectType mot = (ModelObjectType)obj;
            return EMFIDGenerator.generateIDUsingName(obj.eContainer(), obj, mot.getName());
        }
        if (obj instanceof LevelReferenceType) {
            LevelReferenceType lrt = (LevelReferenceType)obj;
            ReportObjectType mot = (ReportObjectType)lrt.getRefObj();
            String name = EMFIDGenerator.getNameInLocale(mot.getName(), locale);
            return EMFIDGenerator.generateIDUsingName(obj.eContainer(), mot, name);
        }
        if (obj instanceof AttributeReferenceType) {
            AttributeReferenceType art = (AttributeReferenceType)obj;
            ReportObjectType mot = (ReportObjectType)art.getRefobj();
            String name = EMFIDGenerator.getNameInLocale(mot.getName(), locale);
            return EMFIDGenerator.generateIDUsingName(obj.eContainer(), obj, name);
        }
        if (obj instanceof LocaleMappingType) {
            LocaleMappingType mapping = (LocaleMappingType)obj;
            String name = mapping.getLocale();
            return EMFIDGenerator.generateIDUsingName(obj.eContainer(), mapping, name);
        }
        if (obj instanceof MultilingualAttributeType) {
            String name;
            MultilingualAttributeType attr = (MultilingualAttributeType)obj;
            QueryItemType queryItem = (QueryItemType)attr.getSourceQueryItemForMultilingualValues();
            if (queryItem != null && (name = EMFIDGenerator.getNameInLocale(queryItem.getName(), locale)) != null) {
                return EMFIDGenerator.generateIDUsingName(obj.eContainer(), attr, name);
            }
            return null;
        }
        return EMFIDGenerator.generateIDUsingName(obj.eContainer(), obj, null);
    }

    public static String generateIDUsingName(EObject parent, EObject obj, String name) {
        String targetType;
        int objClassifier = obj.eClass().getClassifierID();
        if (objClassifier == 157 && (targetType = ((ShortcutType)obj).getTargetType()) != null && targetType.equals("namespace")) {
            objClassifier = 88;
        }
        return EMFIDGenerator.generateIDUsingName(parent, objClassifier, name);
    }

    public static String generateIDUsingName(EObject parent, int objClassifier, String name) {
        String id = null;
        switch (objClassifier) {
            case 33: {
                id = kDataSourcesID;
                break;
            }
            case 155: {
                id = kSecurityViewsID;
                break;
            }
            case 97: {
                id = kParamterMapID;
                break;
            }
            case 94: {
                id = kPackagesID;
                break;
            }
            case 34: {
                id = EMFIDGenerator.generateDataSourceID(name);
                break;
            }
            case 28: 
            case 87: 
            case 88: 
            case 172: {
                id = EMFIDGenerator.generateNamespaceID(name);
                break;
            }
            case 52: {
                id = EMFIDGenerator.generateFunctionID(name);
                break;
            }
            case 24: 
            case 49: 
            case 122: 
            case 124: 
            case 133: 
            case 134: 
            case 135: 
            case 146: 
            case 148: 
            case 157: {
                id = EMFIDGenerator.generateIDForObjectInNamespace(parent, name);
                break;
            }
            case 42: 
            case 73: 
            case 128: {
                id = EMFIDGenerator.generateDimensionID(parent, name);
                break;
            }
            case 56: 
            case 57: {
                id = EMFIDGenerator.generateIDForObjectInDimension(parent, name);
                break;
            }
            case 130: {
                id = EMFIDGenerator.generateIDForObjectInRelationalDimension(parent, name);
                break;
            }
            case 74: 
            case 76: {
                id = EMFIDGenerator.generateMeasureID(parent, name);
                break;
            }
            case 85: {
                id = EMFIDGenerator.generateIDForNamedSetFolder(parent, name);
                break;
            }
            case 86: {
                id = EMFIDGenerator.generateIDForNamedSet(parent, name);
                break;
            }
            case 47: {
                id = EMFIDGenerator.generateIDForFilterFolder(parent, name);
                break;
            }
            case 129: {
                id = EMFIDGenerator.generateObjectID(name, parent, FilterFolderType.class);
                break;
            }
            case 65: {
                String pId = ((XMLResource)parent.eResource()).getID(parent);
                id = CrnIDHelper.addEntryToID(pId, "levels");
                break;
            }
            case 66: {
                id = EMFIDGenerator.generateLevelID(parent, name);
                break;
            }
            case 114: 
            case 115: 
            case 119: {
                id = EMFIDGenerator.generateQueryItemID(parent, name);
                break;
            }
            case 108: {
                id = EMFIDGenerator.generateProjectID();
                break;
            }
            case 95: {
                id = EMFIDGenerator.generatePackageID(name);
                break;
            }
            case 156: {
                id = EMFIDGenerator.generateSecurityID(name);
                break;
            }
            case 98: 
            case 132: {
                id = EMFIDGenerator.generateParameterMapID(name);
                break;
            }
            case 22: {
                String pId = ((XMLResource)parent.eResource()).getID(parent);
                id = CrnIDHelper.addEntryToID(pId, "calculatedMembers");
                break;
            }
            case 161: {
                id = CrnIDHelper.addEntryToID(((XMLResource)parent.eResource()).getID(parent), "sourceObjects");
                break;
            }
            case 162: {
                id = EMFIDGenerator.generateSourceObjectID(parent, name);
                break;
            }
            case 23: {
                id = EMFIDGenerator.generateCalculatedMemberID(parent, name);
                break;
            }
            case 1: {
                String pId = ((XMLResource)parent.eResource()).getID(parent);
                id = CrnIDHelper.addEntryToID(pId, "accessRules");
                break;
            }
            case 2: {
                id = EMFIDGenerator.generateAccessRuleID(parent, name);
                break;
            }
            case 4: {
                String pId = ((XMLResource)parent.eResource()).getID(parent);
                id = CrnIDHelper.addEntryToID(pId, "accessViews");
                break;
            }
            case 5: {
                id = EMFIDGenerator.generateAccessViewID(parent, name);
                break;
            }
            case 173: 
            case 176: {
                id = EMFIDGenerator.generateObjectID(name, parent, VirtualCubeType.class);
                break;
            }
            case 174: {
                id = EMFIDGenerator.generateObjectID(name, parent, VirtualDimensionType.class);
                break;
            }
            case 175: {
                id = EMFIDGenerator.generateObjectID(name, parent, VirtualHierarchyType.class);
                break;
            }
            case 177: 
            case 178: {
                id = EMFIDGenerator.generateVirtualMeasureID(parent, name);
                break;
            }
            case 69: {
                id = EMFIDGenerator.generateObjectID(name, parent, MultilingualAttributeType.class);
                break;
            }
            case 83: {
                id = EMFIDGenerator.generateObjectID(name, parent, MultilingualAttributeMapType.class);
                break;
            }
            case 82: {
                String pId = ((XMLResource)parent.eResource()).getID(parent);
                id = CrnIDHelper.addEntryToID(pId, "multilingualAttributeMap");
                break;
            }
            case 179: {
                String pId = ((XMLResource)parent.eResource()).getID(parent);
                id = CrnIDHelper.addEntryToID(pId, "virtualMembers");
                break;
            }
            case 64: {
                id = EMFIDGenerator.generateObjectID(name, parent, RelationalHierarchyType.class);
                break;
            }
            case 18: {
                id = EMFIDGenerator.generateObjectID(name, parent, LevelReferenceType.class);
                break;
            }
            case 137: {
                id = EMFIDGenerator.generateObjectID(name, parent, RelativeTimeMembersType.class);
                break;
            }
            case 10: {
                id = EMFIDGenerator.generateObjectID(name, parent, AggregateCubesType.class);
                break;
            }
            case 136: {
                String pId = ((XMLResource)parent.eResource()).getID(parent);
                id = CrnIDHelper.addEntryToID(pId, "relativeTimeMembers");
                break;
            }
            case 9: {
                String pId = ((XMLResource)parent.eResource()).getID(parent);
                id = CrnIDHelper.addEntryToID(pId, "aggregateCubes");
                break;
            }
            case 154: {
                id = EMFIDGenerator.generateObjectID(name, parent, PackageViewType.class);
            }
        }
        return id;
    }

    private static String generateDataSourceID(String name) {
        return CrnIDHelper.addEntryToID(kDataSourcesID, name);
    }

    private static String generateParameterMapID(String name) {
        return CrnIDHelper.addEntryToID(kParamterMapID, name);
    }

    private static String generateSecurityID(String name) {
        String id = CrnIDHelper.addEntryToID(kSecurityViewsID, name);
        return id;
    }

    private static String generatePackageID(String name) {
        String id = CrnIDHelper.addEntryToID(kPackagesID, name);
        return id;
    }

    private static String generateProjectID() {
        return "[]";
    }

    private static String generateQueryItemID(EObject parent, String name) {
        while (!(parent instanceof QuerySubjectBaseType || parent instanceof LevelType || parent instanceof RelationalHierarchyType || parent instanceof RelationalObjectType || parent instanceof MeasureDimensionType || parent instanceof LocaleMappingType)) {
            parent = parent.eContainer();
        }
        String pId = ((XMLResource)parent.eResource()).getID(parent);
        String id = CrnIDHelper.addEntryToID(pId, name);
        return id;
    }

    private static String generateCalculatedMemberID(EObject parent, String name) {
        while (!(parent instanceof VirtualHierarchyType || parent instanceof MeasureDimensionType || parent instanceof RelationalHierarchyType || parent instanceof VirtualMeasureDimensionType && !(parent instanceof MeasureFolderType) && !(parent instanceof VirtualMeasureFolderType))) {
            parent = parent.eContainer();
        }
        String pId = ((XMLResource)parent.eResource()).getID(parent);
        String idCalculatedMembers = parent instanceof RelationalHierarchyType || parent instanceof VirtualHierarchyType ? CrnIDHelper.addEntryToID(pId, "calculatedMembers") : pId;
        String id = CrnIDHelper.addEntryToID(idCalculatedMembers, name);
        return id;
    }

    private static String generateVirtualMeasureID(EObject parent, String name) {
        while (!(parent instanceof VirtualMeasureDimensionType)) {
            parent = parent.eContainer();
        }
        String pId = ((XMLResource)parent.eResource()).getID(parent);
        String id = CrnIDHelper.addEntryToID(pId, name);
        return id;
    }

    private static String generateAccessRuleID(EObject parent, String name) {
        while (!(parent instanceof MeasureDimensionType || parent instanceof RelationalHierarchyType || parent instanceof CubeType)) {
            parent = parent.eContainer();
        }
        String pId = ((XMLResource)parent.eResource()).getID(parent);
        String idAccessViews = CrnIDHelper.addEntryToID(pId, "accessRules");
        String id = CrnIDHelper.addEntryToID(idAccessViews, name);
        return id;
    }

    private static String generateSourceObjectID(EObject parent, String name) {
        while (!(parent instanceof VirtualCubeType || parent instanceof VirtualDimensionType || parent instanceof VirtualHierarchyType || parent instanceof VirtualLevelType || parent instanceof VirtualMeasureType || parent instanceof VirtualMeasureDimensionType)) {
            parent = parent.eContainer();
        }
        String pId = ((XMLResource)parent.eResource()).getID(parent);
        String idAccessViews = CrnIDHelper.addEntryToID(pId, "sourceObjects");
        String id = CrnIDHelper.addEntryToID(idAccessViews, name);
        return id;
    }

    private static String generateAccessViewID(EObject parent, String name) {
        while (!(parent instanceof CubeType)) {
            parent = parent.eContainer();
        }
        String pId = ((XMLResource)parent.eResource()).getID(parent);
        String idAccessViews = CrnIDHelper.addEntryToID(pId, "accessViews");
        String id = CrnIDHelper.addEntryToID(idAccessViews, name);
        return id;
    }

    private static String generateDimensionID(EObject parent, String name) {
        while (!(parent instanceof NamespaceType) && !(parent instanceof CubeType)) {
            parent = parent.eContainer();
        }
        String pId = ((XMLResource)parent.eResource()).getID(parent);
        String id = CrnIDHelper.addEntryToID(pId, name);
        return id;
    }

    private static String generateMeasureID(EObject parent, String name) {
        while (!(parent instanceof DimensionType) && !(parent instanceof MeasureDimensionType)) {
            parent = parent.eContainer();
        }
        String pId = ((XMLResource)parent.eResource()).getID(parent);
        String id = CrnIDHelper.addEntryToID(pId, name);
        return id;
    }

    private static String generateIDForFilterFolder(EObject parent, String name) {
        while (!(parent instanceof FilterFolderType) && !(parent instanceof RelationalObjectType)) {
            parent = parent.eContainer();
        }
        String pId = ((XMLResource)parent.eResource()).getID(parent);
        String id = CrnIDHelper.addEntryToID(pId, name);
        return id;
    }

    private static String generateIDForNamedSet(EObject parent, String name) {
        while (!(parent instanceof CubeType) && !(parent instanceof VirtualCubeType)) {
            parent = parent.eContainer();
        }
        String pId = ((XMLResource)parent.eResource()).getID(parent);
        String id = CrnIDHelper.addEntryToID(pId, name);
        return id;
    }

    private static String generateIDForNamedSetFolder(EObject parent, String name) {
        while (!(parent instanceof CubeType) && !(parent instanceof VirtualCubeType)) {
            parent = parent.eContainer();
        }
        String pId = ((XMLResource)parent.eResource()).getID(parent);
        String id = CrnIDHelper.addEntryToID(pId, name);
        return id;
    }

    private static String generateIDForObjectInNamespace(EObject parent, String name) {
        while (!(parent instanceof NamespaceType) && !(parent instanceof CubeType)) {
            parent = parent.eContainer();
        }
        String pId = ((XMLResource)parent.eResource()).getID(parent);
        String id = CrnIDHelper.addEntryToID(pId, name);
        return id;
    }

    private static String generateIDForObjectInDimension(EObject parent, String name) {
        return EMFIDGenerator.generateObjectID(name, parent, DimensionType.class);
    }

    private static String generateIDForObjectInRelationalDimension(EObject parent, String name) {
        return EMFIDGenerator.generateObjectID(name, parent, RelationalDimensionType.class);
    }

    private static String generateNamespaceID(String name) {
        String id = CrnIDHelper.addEntryToID(null, name);
        return id;
    }

    private static String generateFunctionID(String name) {
        String id = CrnIDHelper.addEntryToID(null, name);
        return id;
    }

    private static String generateLevelID(EObject parent, String name) {
        while (!(parent instanceof DimensionType || parent instanceof HierarchyType || parent instanceof RelationalDimensionType || parent instanceof RelationalHierarchyType)) {
            parent = parent.eContainer();
        }
        String pId = ((XMLResource)parent.eResource()).getID(parent);
        String idLevels = parent instanceof RelationalDimensionType ? CrnIDHelper.addEntryToID(pId, "levels") : pId;
        String id = CrnIDHelper.addEntryToID(idLevels, name);
        return id;
    }

    private static String generateObjectID(String name, EObject parent, Class<?> parentClass) {
        while (!parentClass.isInstance(parent)) {
            parent = parent.eContainer();
        }
        String pId = ((XMLResource)parent.eResource()).getID(parent);
        String id = CrnIDHelper.addEntryToID(pId, name);
        return id;
    }

    public static String getNameInLocale(List<NameType> names, String locale) {
        for (NameType nt : names) {
            if (!EMFIDGenerator.localeMatches(nt.getLocale(), locale)) continue;
            return nt.getValue();
        }
        return null;
    }

    public static boolean localeMatches(String locale1, String locale2) {
        return locale1.equalsIgnoreCase(locale2);
    }

    public static String getLocalizedReferencePath(FMMDSession session, String sourceReference, String locale) {
        String localizedReference = null;
        List<String> sourceRefElements = CrnIDHelper.parseID(sourceReference, false);
        String innerPath = null;
        for (String idPart : sourceRefElements) {
            innerPath = CrnIDHelper.addEntryToID(innerPath, idPart);
            FmReportObject reportObj = (FmReportObject)FmModelFactory.getInstance().getById(session, innerPath);
            localizedReference = CrnIDHelper.addEntryToID(localizedReference, reportObj.getName(locale));
        }
        return localizedReference;
    }
}

