/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.platform.impl;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.platform.transaction.ModelChanges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFModelChanges
implements ModelChanges {
    private EMFSession m_session;
    private Map<TopLevelObject, ChangeImpl> m_changes;
    private EContentAdapter m_contentAdapter;

    public EMFModelChanges(EMFSession session) {
        this.m_session = session;
        this.m_changes = new HashMap<TopLevelObject, ChangeImpl>();
        this.m_contentAdapter = new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                EMFModelChanges.this.handleChange(notification);
            }
        };
        Resource r = session.getResource();
        r.eAdapters().add((Object)this.m_contentAdapter);
    }

    public void destroy() {
    }

    protected void disconnect() {
        Resource r = this.m_session.getResource();
        r.eAdapters().remove((Object)this.m_contentAdapter);
    }

    @Override
    public Collection<? extends ModelChanges.Change> getDirtyObjects() {
        return this.m_changes.values();
    }

    private void handleChange(Notification notification) {
        int et = notification.getEventType();
        TopLevelObject tlo = null;
        ChangeImpl change = null;
        boolean wasComplex = false;
        if (et == 3 || et == 5 || et == 4 || et == 6 || et == 1 || et == 2 || et == 7) {
            Object obj = notification.getNotifier();
            tlo = FmModelFactory.getInstance().get(this.m_session, obj);
            if (tlo == null && obj instanceof EObject) {
                wasComplex = true;
                obj = ((EObject)obj).eContainer();
                while (obj != null && tlo == null) {
                    tlo = FmModelFactory.getInstance().get(this.m_session, obj);
                    if (tlo != null) continue;
                    obj = ((EObject)obj).eContainer();
                }
            }
            if (tlo == null) {
                return;
            }
            change = this.m_changes.get(tlo);
            if (change == null) {
                change = new ChangeImpl(tlo);
                this.m_changes.put(tlo, change);
            }
        }
        switch (et) {
            case 3: 
            case 5: {
                if (wasComplex) {
                    this.handleSet(notification, tlo, change);
                    break;
                }
                this.handleAdd(notification, tlo, change);
                break;
            }
            case 4: 
            case 6: {
                if (wasComplex) {
                    this.handleSet(notification, tlo, change);
                    break;
                }
                this.handleRemove(notification, tlo, change);
                break;
            }
            case 1: 
            case 2: {
                this.handleSet(notification, tlo, change);
                break;
            }
            case 7: {
                this.handleMove(notification, tlo, change);
            }
        }
    }

    private void handleAdd(Notification notify, TopLevelObject notifier, ChangeImpl change) {
        Object newObj = notify.getNewValue();
        List<Object> newChildren = this.getTopLevelEObjects(newObj);
        if (newChildren.size() > 0) {
            ChangeImpl changeImpl = change;
            changeImpl.m_reason = changeImpl.m_reason | 1;
        } else {
            this.handleSet(notify, notifier, change);
        }
    }

    private void handleMove(Notification notify, TopLevelObject notifier, ChangeImpl change) {
        ChangeImpl changeImpl = change;
        changeImpl.m_reason = changeImpl.m_reason | 0x1000;
    }

    private List<Object> getTopLevelEObjects(Object obj) {
        ArrayList<Object> children = new ArrayList<Object>();
        if (obj instanceof List) {
            List list = (List)obj;
            for (Object childObj : list) {
                TopLevelObject child = FmModelFactory.getInstance().get(this.m_session, childObj);
                if (child == null) continue;
                children.add(childObj);
            }
        } else {
            TopLevelObject child = FmModelFactory.getInstance().get(this.m_session, obj);
            if (child != null) {
                children.add(obj);
            }
        }
        return children;
    }

    private void handleRemove(Notification notify, TopLevelObject notifier, ChangeImpl change) {
        Object newObj = notify.getOldValue();
        List<Object> oldChildren = this.getTopLevelEObjects(newObj);
        if (oldChildren.size() > 0) {
            for (Object tlo : oldChildren) {
                change.addRemovedObject(tlo);
            }
            ChangeImpl changeImpl = change;
            changeImpl.m_reason = changeImpl.m_reason | 0x10;
        } else {
            this.handleSet(notify, notifier, change);
        }
    }

    private void handleSet(Notification notify, TopLevelObject notifier, ChangeImpl change) {
        List<Object> oldChildren;
        EReference feature;
        Object oldValue = notify.getOldValue();
        Object newValue = notify.getNewValue();
        Object objFeature = notify.getFeature();
        boolean isContainment = false;
        if (objFeature instanceof EReference && (feature = (EReference)objFeature).isContainment()) {
            isContainment = true;
        }
        if ((oldChildren = this.getTopLevelEObjects(oldValue)).size() == 1 && isContainment) {
            change.addRemovedObject(oldChildren.get(0));
            ChangeImpl changeImpl = change;
            changeImpl.m_reason = changeImpl.m_reason | 0x10;
        } else {
            List<Object> newChildren = this.getTopLevelEObjects(newValue);
            if (newChildren.size() == 1 && isContainment) {
                ChangeImpl changeImpl = change;
                changeImpl.m_reason = changeImpl.m_reason | 1;
            } else {
                change.addChangedFeature(notify);
                ChangeImpl changeImpl = change;
                changeImpl.m_reason = changeImpl.m_reason | 0x100;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChangeImpl
    implements ModelChanges.Change {
        private TopLevelObject m_object;
        private int m_reason = 0;
        private List<Object> m_removedObjects;
        private HashMap<Object, String> m_changedFeatures;
        protected static final int CHILD_ADDED = 1;
        protected static final int CHILD_REMOVED = 16;
        protected static final int PROPERTY_CHANGE = 256;
        protected static final int CHILD_MOVED = 4096;

        public ChangeImpl(TopLevelObject object) {
            this.m_object = object;
            this.m_removedObjects = new ArrayList<Object>();
            this.m_changedFeatures = new HashMap();
        }

        @Override
        public TopLevelObject getObject() {
            return this.m_object;
        }

        @Override
        public List<Object> getRemovedObjects() {
            return this.m_removedObjects;
        }

        void addRemovedObject(Object obj) {
            this.m_removedObjects.add(obj);
        }

        @Override
        public Set<Object> getChangedFeatures() {
            return this.m_changedFeatures.keySet();
        }

        @Override
        public boolean childAdded() {
            return (this.m_reason & 1) == 1;
        }

        @Override
        public boolean childRemoved() {
            return (this.m_reason & 0x10) == 16;
        }

        @Override
        public boolean childMoved() {
            return (this.m_reason & 0x1000) == 4096;
        }

        @Override
        public boolean propertyModified() {
            return (this.m_reason & 0x100) == 256;
        }

        public void addChangedFeature(Notification notify) {
            this.m_changedFeatures.put(notify, this.getFeatureNameImpl(notify));
        }

        @Override
        public Object getOldValue(Object feature) {
            TopLevelObject child;
            Notification notify = (Notification)feature;
            Object value = notify.getOldValue();
            if (value != null && value instanceof EObject && (child = FmModelFactory.getInstance().get(EMFModelChanges.this.m_session, value)) != null) {
                return child;
            }
            return value;
        }

        @Override
        public Object getNewValue(Object feature) {
            TopLevelObject child;
            Notification notify = (Notification)feature;
            Object value = notify.getNewValue();
            if (value != null && value instanceof EObject && (child = FmModelFactory.getInstance().get(EMFModelChanges.this.m_session, value)) != null) {
                return child;
            }
            return value;
        }

        @Override
        public String getFeatureName(Object obj) {
            return this.m_changedFeatures.get(obj);
        }

        private String getFeatureNameImpl(Notification notify) {
            ArrayList<String> featureNames = new ArrayList<String>();
            featureNames.add(((EStructuralFeature)notify.getFeature()).getName());
            EObject o = (EObject)notify.getNotifier();
            while (o != null && o != this.m_object.getInternal()) {
                EStructuralFeature feature = o.eContainingFeature();
                if (feature == null) {
                    return null;
                }
                featureNames.add(feature.getName());
                o = o.eContainer();
            }
            StringBuilder builder = new StringBuilder();
            int i = featureNames.size() - 1;
            while (i > -1) {
                builder.append("/");
                builder.append((String)featureNames.get(i));
                --i;
            }
            return builder.toString();
        }
    }
}

