/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.platform.impl;

import com.ibm.cognos.fmeng.genmodel.util.GenmodelResourceImpl;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.platform.impl.GCManager;
import com.ibm.cognos.fmeng.platform.impl.ObjectLookup;
import com.ibm.cognos.fmeng.utility.DebugUtil;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;

public class EMFModelLoader {
    private EMFSession m_session;

    public EMFModelLoader(EMFSession session) {
        this.m_session = session;
    }

    public void destroy() {
        this.m_session = null;
    }

    public Resource load(InputStream stream, String xmlpath) {
        Resource r = this.m_session.createResource(xmlpath);
        try {
            EContentAdapter idAdaptor = new EContentAdapter(){
                private GCManager m_gcManager = new GCManager();

                public void notifyChanged(Notification notification) {
                    super.notifyChanged(notification);
                    this.m_gcManager.checkForGC();
                }
            };
            r.eAdapters().add((Object)idAdaptor);
            ObjectLookup idLookup = new ObjectLookup(r, this.m_session);
            idLookup.setLoading(true);
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
            ((GenmodelResourceImpl)r).setUnresolvedReferenceHandler(this.m_session);
            r.load(stream, options);
            idLookup.setLoading(false);
            r.eAdapters().remove((Object)idAdaptor);
        }
        catch (NullPointerException ex) {
            DebugUtil.GetInstance().debug(ex);
            Object[] newMsgParams = new Object[]{xmlpath};
            throw new FmMDException("BMT_MD_UNABLE_TO_OPEN_MODEL", newMsgParams, ex);
        }
        catch (IOException io) {
            DebugUtil.GetInstance().debug(io);
            Object[] newMsgParams = new Object[]{xmlpath};
            throw new FmMDException("BMT_MD_UNABLE_TO_OPEN_MODEL", newMsgParams, io);
        }
        this.m_session.setUpCubeChangeListener();
        return r;
    }
}

