/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.platform.impl;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmAccessRule;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmJoin;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSQLObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTable;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTableDeterminant;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.impl.task.DefaultImpactListener;
import com.ibm.cognos.fmeng.fmmd.impl.task.FmDeleteManager;
import com.ibm.cognos.fmeng.fmmd.impl.task.OneToOneModelSerializer;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.ColumnReference;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.NonReportObject;
import com.ibm.cognos.fmeng.fmmd.model.Project;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.genmodel.AccessRuleType;
import com.ibm.cognos.fmeng.genmodel.AccessRulesType;
import com.ibm.cognos.fmeng.genmodel.AccessViewType;
import com.ibm.cognos.fmeng.genmodel.AggregateCubesType;
import com.ibm.cognos.fmeng.genmodel.AttributeReferenceType;
import com.ibm.cognos.fmeng.genmodel.CalculatedMemberType;
import com.ibm.cognos.fmeng.genmodel.CubeType;
import com.ibm.cognos.fmeng.genmodel.DocumentRoot;
import com.ibm.cognos.fmeng.genmodel.ExpressionType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.GenmodelPackage;
import com.ibm.cognos.fmeng.genmodel.IntentType;
import com.ibm.cognos.fmeng.genmodel.JoinType;
import com.ibm.cognos.fmeng.genmodel.LevelReferenceType;
import com.ibm.cognos.fmeng.genmodel.LevelType;
import com.ibm.cognos.fmeng.genmodel.ModelObjectType;
import com.ibm.cognos.fmeng.genmodel.NamespaceType;
import com.ibm.cognos.fmeng.genmodel.PackageViewType;
import com.ibm.cognos.fmeng.genmodel.ProjectType;
import com.ibm.cognos.fmeng.genmodel.QueryItemMappingType;
import com.ibm.cognos.fmeng.genmodel.QueryItemType;
import com.ibm.cognos.fmeng.genmodel.RegularAggregateType;
import com.ibm.cognos.fmeng.genmodel.RelationalDimensionType;
import com.ibm.cognos.fmeng.genmodel.RelationalHierarchyType;
import com.ibm.cognos.fmeng.genmodel.RelationalObjectType;
import com.ibm.cognos.fmeng.genmodel.RelationalParameterMapType;
import com.ibm.cognos.fmeng.genmodel.ReportObjectType;
import com.ibm.cognos.fmeng.genmodel.RuleStyleType;
import com.ibm.cognos.fmeng.genmodel.SqlObjectType;
import com.ibm.cognos.fmeng.genmodel.StatusType;
import com.ibm.cognos.fmeng.genmodel.TableDeterminantType;
import com.ibm.cognos.fmeng.genmodel.TableType;
import com.ibm.cognos.fmeng.genmodel.VirtualCubeType;
import com.ibm.cognos.fmeng.genmodel.util.GenmodelAdapterFactory;
import com.ibm.cognos.fmeng.genmodel.util.GenmodelResourceFactoryImpl;
import com.ibm.cognos.fmeng.genmodel.util.GenmodelResourceImpl;
import com.ibm.cognos.fmeng.genmodel.util.UnresolvedReferenceHandler;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdCube;
import com.ibm.cognos.fmeng.metadata.MdDatabase;
import com.ibm.cognos.fmeng.metadata.MdSchema;
import com.ibm.cognos.fmeng.metadata.MdSource;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.metadata.MdTableContainer;
import com.ibm.cognos.fmeng.metadata.MetadataSourceFactory;
import com.ibm.cognos.fmeng.metadata.adapters.physmd.BrowseSource;
import com.ibm.cognos.fmeng.metadata.impl.MdCubeImpl;
import com.ibm.cognos.fmeng.metadata.mdSource.RawMdSource;
import com.ibm.cognos.fmeng.metadata.mdSource.RelmdServiceBrowseSource;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.FMMDSessionPool;
import com.ibm.cognos.fmeng.platform.ProgressCallbackHandler;
import com.ibm.cognos.fmeng.platform.ProjectAccess;
import com.ibm.cognos.fmeng.platform.SessionPool;
import com.ibm.cognos.fmeng.platform.impl.CubeChanges;
import com.ibm.cognos.fmeng.platform.impl.CustomCommandStack;
import com.ibm.cognos.fmeng.platform.impl.EMFModelChanges;
import com.ibm.cognos.fmeng.platform.impl.EMFModelLoader;
import com.ibm.cognos.fmeng.platform.impl.EMFTransaction;
import com.ibm.cognos.fmeng.platform.impl.ObjectLookup;
import com.ibm.cognos.fmeng.platform.impl.SegmentProcessor;
import com.ibm.cognos.fmeng.platform.impl.TransactionWorkCommand;
import com.ibm.cognos.fmeng.platform.impl.UnresolvedReference;
import com.ibm.cognos.fmeng.platform.impl.gateway.EMFModelGateway;
import com.ibm.cognos.fmeng.platform.impl.project.ProjectManager;
import com.ibm.cognos.fmeng.platform.impl.project.Segment;
import com.ibm.cognos.fmeng.platform.transaction.ModelChanges;
import com.ibm.cognos.fmeng.platform.transaction.Transaction;
import com.ibm.cognos.fmeng.platform.transaction.TransactionSession;
import com.ibm.cognos.fmeng.platform.transaction.TransactionWork;
import com.ibm.cognos.fmeng.utility.CAMFaultException;
import com.ibm.cognos.fmeng.utility.DebugUtil;
import com.ibm.cognos.fmeng.utility.EMFCustomModelSerializer;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.WeakHashMap;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFSession
extends FMMDSession
implements UnresolvedReferenceHandler {
    private Resource m_resource;
    private EMFModelGateway m_gateway;
    private EditingDomain m_editingDomain;
    private Stack<TransactionWorkCommand> m_transactions;
    private String m_localeStr;
    private ProjectAccess m_projectAccess;
    private ProjectManager m_projectManager;
    private Set<UnresolvedReference> m_unresolvedReferences;
    private WeakHashMap<EObject, WeakReference<EObject>> m_linkedSegments = new WeakHashMap();
    private Set<MdDatabase> m_physicalDatabases;
    private List<MdCube> m_physicalCubes;
    private CubeChanges m_cubeChanges;

    public EMFSession(FMMDSession.ClientType clientType, Locale activeLocale) {
        super(clientType);
        GenmodelAdapterFactory adapterFactory = new GenmodelAdapterFactory();
        CustomCommandStack commandStack = new CustomCommandStack();
        this.m_editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack);
        ResourceSet resourceSet = this.m_editingDomain.getResourceSet();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new GenmodelResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://www.developer.cognos.com/schemas/bmt/60/13", (Object)GenmodelPackage.eINSTANCE);
        this.m_transactions = new Stack();
        this.m_unresolvedReferences = new HashSet<UnresolvedReference>();
        this.m_physicalDatabases = new HashSet<MdDatabase>();
        this.m_physicalCubes = new ArrayList<MdCube>();
        this.m_localeStr = activeLocale.toString();
    }

    @Override
    public void destroy() {
        FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.PLATFORM, this, "Start of destroy");
        for (MdDatabase db : this.m_physicalDatabases) {
            db.destroy();
        }
        this.m_physicalDatabases.clear();
        this.m_physicalCubes.clear();
        EObject o = null;
        if (this.m_resource != null) {
            EList resContents = this.m_resource.getContents();
            if (resContents != null && !resContents.isEmpty()) {
                o = (EObject)resContents.get(0);
                EList contents = o.eContents();
                int i = contents.size() - 1;
                while (i >= 0) {
                    EObject child = (EObject)contents.get(i);
                    try {
                        EcoreUtil.remove((EObject)child);
                    }
                    catch (RuntimeException runtimeException) {}
                    --i;
                }
            }
            ResourceSet rs = this.m_resource.getResourceSet();
            rs.getResources().remove((Object)this.m_resource);
        }
        if (this.m_gateway != null) {
            this.m_gateway.destroy();
        }
        this.m_gateway = null;
        if (this.m_cubeChanges != null) {
            this.m_cubeChanges.destroy();
        }
        this.m_cubeChanges = null;
        if (this.m_resource != null) {
            this.m_resource.getContents().clear();
            this.m_resource.getErrors().clear();
            this.m_resource.getWarnings().clear();
            this.m_resource = null;
        }
        if (o != null) {
            EcoreUtil.remove((EObject)o);
        }
        if (this.m_editingDomain != null && this.m_editingDomain.getCommandStack() != null) {
            this.m_editingDomain.getCommandStack().flush();
        }
        this.m_editingDomain = null;
        if (this.m_transactions != null) {
            this.m_transactions.removeAllElements();
        }
        this.m_transactions = null;
        this.m_projectAccess = null;
        super.destroy();
        System.gc();
        DebugUtil.GetInstance().debug("Destroyed session", DebugUtil.CATEGORY.LIFECYCLE);
        DebugUtil.GetInstance().dumpMemory();
    }

    public EObject getNullObject() {
        return new UnresolvedReference("", null, null);
    }

    public EObject createBrokenReference(BaseObject obj) {
        return new UnresolvedReference(obj.getID(), null, null);
    }

    public boolean isBrokenReference(Object obj) {
        return obj instanceof UnresolvedReference;
    }

    @Override
    public TransactionSession createTransactionSession() {
        return new TransactionWorkCommand(this.m_editingDomain, "", this);
    }

    private void initializeTransaction(List<String> inParams) {
        String transName = inParams.get(0);
        this.m_transactions.push(new TransactionWorkCommand(this.m_editingDomain, transName, this));
    }

    private void completeTransaction() {
        TransactionWorkCommand cmd = this.m_transactions.pop();
        cmd.commitTransaction();
    }

    private void rollbackTransaction() {
        TransactionWorkCommand cmd = this.m_transactions.pop();
        cmd.rollbackTransaction();
    }

    private TransactionWorkCommand getActiveTransaction() {
        if (this.m_transactions.size() > 0) {
            return this.m_transactions.peek();
        }
        return null;
    }

    Resource createResource(Object identifier) {
        Resource r = null;
        if (this.m_resource == null) {
            r = this.m_resource = this.m_editingDomain.createResource(identifier.toString());
            this.m_gateway = new EMFModelGateway(this);
        } else if (!identifier.equals(this.m_resource.getURI().toString())) {
            EList resources = this.m_editingDomain.getResourceSet().getResources();
            for (Resource curResource : resources) {
                if (!identifier.equals(curResource.getURI().toString())) continue;
                r = curResource;
                r.getContents().clear();
                break;
            }
            if (r == null) {
                r = this.m_editingDomain.createResource(identifier.toString());
            }
        }
        return r;
    }

    void setUpCubeChangeListener() {
        if (this.m_cubeChanges != null) {
            this.m_cubeChanges.destroy();
        }
        this.m_cubeChanges = new CubeChanges(this);
    }

    public final CubeChanges getCubeSynchronizer() {
        return this.m_cubeChanges;
    }

    @Override
    public Transaction createTransaction(TransactionWork work) {
        return new EMFTransaction(this, this.m_editingDomain, work);
    }

    @Override
    public boolean canUndo() {
        return this.m_editingDomain.getCommandStack().canUndo();
    }

    @Override
    public boolean canRedo() {
        return this.m_editingDomain.getCommandStack().canRedo();
    }

    public String getUndoTransactionName() {
        String tempStr = "";
        Command tempComm = this.m_editingDomain.getCommandStack().getUndoCommand();
        if (tempComm != null) {
            tempStr = tempComm.getLabel();
        }
        return tempStr;
    }

    public String getRedoTransactionName() {
        String tempStr = "";
        Command tempComm = this.m_editingDomain.getCommandStack().getRedoCommand();
        if (tempComm != null) {
            tempStr = tempComm.getLabel();
        }
        return tempStr;
    }

    @Override
    public ModelChanges undo() {
        EMFModelChanges modelChanges = new EMFModelChanges(this);
        this.m_editingDomain.getCommandStack().undo();
        modelChanges.disconnect();
        return modelChanges;
    }

    @Override
    public ModelChanges redo() {
        EMFModelChanges modelChanges = new EMFModelChanges(this);
        this.m_editingDomain.getCommandStack().redo();
        modelChanges.disconnect();
        return modelChanges;
    }

    public Resource getResource() {
        return this.m_resource;
    }

    public EMFModelGateway getGateway() {
        return this.m_gateway;
    }

    @Override
    public void load(ProjectAccess access) {
        FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.PLATFORM, this, "Start of model load: " + access.toString());
        DebugUtil.GetInstance().debug("Start of load", DebugUtil.CATEGORY.LOAD);
        DebugUtil.GetInstance().dumpMemory();
        this.m_projectManager = new ProjectManager(access);
        this.m_projectManager.init();
        this.m_projectAccess = access;
        EMFModelLoader loader = new EMFModelLoader(this);
        Resource r = loader.load(this.m_projectManager.getModelStream(), access.getFileName(ProjectAccess.ProjectFile.MODEL_XML));
        SegmentProcessor segProcessor = new SegmentProcessor(this);
        segProcessor.installLinks(r, this.m_projectManager);
        loader.destroy();
        this.resolveCrossDocumentReferences();
        FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.PLATFORM, this, "End of model load");
        DebugUtil.GetInstance().debug("End of load", DebugUtil.CATEGORY.LOAD);
        DebugUtil.GetInstance().dumpMemory();
        FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.PLATFORM, this, "Start of metada load");
        if (access.hasHardCodedMetadataFile()) {
            RawMdSource mdSource = new RawMdSource(access.getFileName(ProjectAccess.ProjectFile.TEST_PHYSICAL_FILE_RELATIONAL));
            MetadataSourceFactory.createMetadataSource(this, mdSource);
        } else {
            List<DataSource> dsList = this.getProject().getDataSources();
            for (DataSource ds : dsList) {
                String cmDsName = ds.getCmDataSourceName();
                if (this.findTableContainerInternal(cmDsName, ds.getCatalogName(), ds.getSchemaName()) != null || this.getClientType() == FMMDSession.ClientType.QueryBuilder) continue;
                try {
                    RelmdServiceBrowseSource mdSource = new RelmdServiceBrowseSource(this, cmDsName, ds.getCatalogName(), ds.getSchemaName(), false);
                    MetadataSourceFactory.createMetadataSource(this, mdSource);
                }
                catch (CAMFaultException cfe) {
                    throw cfe;
                }
                catch (Exception exception) {}
            }
        }
        FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.PLATFORM, this, "End of metada load");
        FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.PLATFORM, this, "Start of post-load processing");
        if (access.getSourceVersion() <= 2) {
            this.do2to3PostUpgrade();
        }
        if (access.getSourceVersion() <= 7) {
            this.do7to8PostUpgrade();
        }
        if (access.getSourceVersion() <= 9) {
            this.do9to10PostUpgrade();
        }
        this.postLoadFixup();
        FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.PLATFORM, this, "End of post-load processing");
    }

    private void do9to10PostUpgrade() {
        TreeIterator allContents = ((EObject)this.getProject().getInternal()).eAllContents();
        while (allContents.hasNext()) {
            EObject currentObj = (EObject)allContents.next();
            if (!(currentObj instanceof RelationalObjectType)) continue;
            RelationalObjectType ro = (RelationalObjectType)currentObj;
            ro.setIntent(IntentType.DYNAMIC_CUBES);
        }
    }

    private void do7to8PostUpgrade() {
        TreeIterator allContents = ((EObject)this.getProject().getInternal()).eAllContents();
        ArrayList<ReportObjectType> cubesToProcess = new ArrayList<ReportObjectType>();
        while (allContents.hasNext()) {
            EObject currentObj = (EObject)allContents.next();
            if (currentObj instanceof RelationalDimensionType) {
                RelationalDimensionType ro = (RelationalDimensionType)currentObj;
                ro.setUsePathBasedMUNs(true);
                continue;
            }
            if (currentObj instanceof CubeType) {
                if (((CubeType)currentObj).getNamedSetFolder() != null) continue;
                cubesToProcess.add((CubeType)currentObj);
                continue;
            }
            if (!(currentObj instanceof VirtualCubeType) || ((VirtualCubeType)currentObj).getNamedSetFolder() != null) continue;
            cubesToProcess.add((ReportObjectType)currentObj);
        }
        if (!cubesToProcess.isEmpty()) {
            for (ReportObjectType c : cubesToProcess) {
                FmReportObject cube = null;
                if (c instanceof CubeType) {
                    FmCube fmCube = FmCube.get(this, c);
                    if (fmCube.isAggregateCube()) continue;
                    cube = fmCube;
                } else if (c instanceof VirtualCubeType) {
                    cube = FmVirtualCube.get(this, c);
                }
                if (cube == null) continue;
                cube.createOrGetNamedSetFolder();
            }
        }
    }

    private void do2to3PostUpgrade() {
        Object obj;
        EObject currentObj;
        TreeIterator allContents = ((EObject)this.getProject().getInternal()).eAllContents();
        while (allContents.hasNext()) {
            currentObj = (EObject)allContents.next();
            if (currentObj instanceof AccessRuleType) {
                obj = (AccessRuleType)currentObj;
                obj.setRuleStyle(RuleStyleType.ROLE);
                continue;
            }
            if (currentObj instanceof AccessViewType) {
                obj = (AccessViewType)currentObj;
                if (obj.isSetRuleStyle()) continue;
                obj.setRuleStyle(RuleStyleType.ROLE);
                continue;
            }
            if (currentObj instanceof LevelReferenceType) {
                obj = (LevelReferenceType)currentObj;
                LevelType lvl = (LevelType)obj.getRefObj();
                for (QueryItemType qi : lvl.getQueryItem()) {
                    AttributeReferenceType attr = GenmodelFactory.eINSTANCE.createAttributeReferenceType();
                    attr.setRefobj(qi);
                    obj.getAttributeReference().add((Object)attr);
                }
                continue;
            }
            if (!(currentObj instanceof RelationalHierarchyType)) continue;
            RelationalHierarchyType hier = (RelationalHierarchyType)currentObj;
            boolean injectAllAccess = true;
            EObject parent = hier.eContainer();
            while (parent != null) {
                if (parent instanceof AggregateCubesType) {
                    injectAllAccess = false;
                    break;
                }
                parent = parent.eContainer();
            }
            if (!injectAllAccess) continue;
            AccessRulesType rules = hier.getAccessRules();
            if (rules == null) {
                rules = GenmodelFactory.eINSTANCE.createAccessRulesType();
                hier.setAccessRules(rules);
            }
            boolean hasAllAccess = false;
            for (AccessRuleType rule : rules.getAccessRule()) {
                if (!rule.isAllAccess()) continue;
                hasAllAccess = true;
            }
            if (hasAllAccess) continue;
            FmAccessRule.createAllAccessRule(this, FmRelationalHierarchy.get(this, hier));
        }
        allContents = ((EObject)this.getProject().getInternal()).eAllContents();
        while (allContents.hasNext()) {
            currentObj = (EObject)allContents.next();
            if (currentObj instanceof CalculatedMemberType) {
                obj = (CalculatedMemberType)currentObj;
                this.upgrade2to3MDXExpression(obj.getExpression());
                continue;
            }
            if (!(currentObj instanceof AccessRuleType) || (obj = (AccessRuleType)currentObj).isAllAccess()) continue;
            this.upgrade2to3MDXExpression(obj.getExpression());
        }
    }

    private void postLoadFixup() {
        int i;
        EObject currentObj;
        TreeIterator allContents = ((EObject)this.getProject().getInternal()).eAllContents();
        ArrayList<AttributeReferenceType> toDelete = new ArrayList<AttributeReferenceType>();
        while (allContents.hasNext()) {
            currentObj = (EObject)allContents.next();
            if (!(currentObj instanceof LevelReferenceType)) continue;
            boolean deleteEm = false;
            LevelReferenceType lvlRef = (LevelReferenceType)currentObj;
            EList<AttributeReferenceType> attrRefs = lvlRef.getAttributeReference();
            i = 0;
            while (i < attrRefs.size()) {
                AttributeReferenceType attrRef = (AttributeReferenceType)attrRefs.get(i);
                if (attrRef.getRefobj() == null) {
                    deleteEm = true;
                    break;
                }
                boolean duplicate = false;
                int j = 0;
                while (j < i) {
                    AttributeReferenceType attrRefPrior = (AttributeReferenceType)attrRefs.get(j);
                    if (attrRefPrior.getRefobj() != null && attrRefPrior.getRefobj().equals(attrRef.getRefobj())) {
                        duplicate = true;
                        break;
                    }
                    ++j;
                }
                if (duplicate) {
                    deleteEm = true;
                    break;
                }
                if (!deleteEm) {
                    EObject refParent = attrRef.getRefobj().eContainer();
                    if (!lvlRef.getRefObj().equals(refParent)) {
                        deleteEm = true;
                        break;
                    }
                }
                ++i;
            }
            if (!deleteEm) continue;
            toDelete.addAll((Collection<AttributeReferenceType>)attrRefs);
        }
        for (AttributeReferenceType attrRef : toDelete) {
            this.getGateway().delete(attrRef);
        }
        allContents = ((EObject)this.getProject().getInternal()).eAllContents();
        while (allContents.hasNext()) {
            AccessRuleType obj;
            currentObj = (EObject)allContents.next();
            if (currentObj instanceof LevelReferenceType) {
                LevelReferenceType lvlRef = (LevelReferenceType)currentObj;
                LevelType lvl = (LevelType)lvlRef.getRefObj();
                EList<QueryItemType> qis = lvl.getQueryItem();
                i = 0;
                while (i < qis.size()) {
                    AttributeReferenceType attrRef;
                    EList<AttributeReferenceType> attrRefs = lvlRef.getAttributeReference();
                    QueryItemType qi = (QueryItemType)qis.get(i);
                    boolean bFound = false;
                    if (attrRefs.size() > i && (attrRef = (AttributeReferenceType)attrRefs.get(i)).getRefobj().equals(qis.get(i))) {
                        bFound = true;
                    }
                    if (!bFound) {
                        AttributeReferenceType attr = GenmodelFactory.eINSTANCE.createAttributeReferenceType();
                        attr.setRefobj(qi);
                        lvlRef.getAttributeReference().add(i, (Object)attr);
                    }
                    ++i;
                }
                continue;
            }
            if (!(currentObj instanceof AccessRuleType) || (obj = (AccessRuleType)currentObj).isSetRuleStyle() || !obj.isAllAccess()) continue;
            obj.setRuleStyle(RuleStyleType.ROLE);
        }
        allContents = ((EObject)this.getProject().getInternal()).eAllContents();
        block6: while (allContents.hasNext()) {
            currentObj = (EObject)allContents.next();
            if (!(currentObj instanceof QueryItemType)) continue;
            EObject ancestor = currentObj.eContainer();
            while (ancestor != null) {
                if (ancestor instanceof RelationalDimensionType || ancestor instanceof RelationalParameterMapType) {
                    QueryItemType currentQI = (QueryItemType)currentObj;
                    currentQI.setRegularAggregate(RegularAggregateType.UNSUPPORTED);
                    continue block6;
                }
                ancestor = ancestor.eContainer();
            }
        }
    }

    private void upgrade2to3MDXExpression(ExpressionType expr) {
        if (expr != null) {
            RelationalHierarchyType hier = null;
            EObject obj = expr.eContainer();
            while (obj != null) {
                if (obj instanceof RelationalHierarchyType) {
                    hier = (RelationalHierarchyType)obj;
                    break;
                }
                obj = obj.eContainer();
            }
            if (hier == null) {
                return;
            }
            if (hier.isParentChild()) {
                return;
            }
            FeatureMap compList = expr.getMixed();
            int iStart = 0;
            while (iStart < compList.size()) {
                QueryItemType queryItem = null;
                int i = iStart;
                while (i < compList.size()) {
                    Object obj2 = compList.getValue(i);
                    if (obj2 instanceof QueryItemType) {
                        queryItem = (QueryItemType)obj2;
                        iStart = i;
                        break;
                    }
                    ++i;
                }
                if (queryItem != null) {
                    AttributeReferenceType attrRefOfInterest = null;
                    LevelType level = (LevelType)queryItem.eContainer();
                    block3: for (LevelReferenceType levelRef : hier.getLevelReference()) {
                        for (AttributeReferenceType attrRef : levelRef.getAttributeReference()) {
                            if (!levelRef.getRefObj().equals(level) || !attrRef.getRefobj().equals(queryItem)) continue;
                            attrRefOfInterest = attrRef;
                            continue block3;
                        }
                    }
                    if (attrRefOfInterest == null) continue;
                    EMFModelGateway.substituteFeatureInExpression(expr, 3, iStart, attrRefOfInterest);
                    continue;
                }
                iStart = compList.size();
            }
        }
    }

    @Override
    public MdDatabase refreshMetadataSource(String cmDsName, String connection, String signon, String catalog, String schema, boolean includeSysObjs) {
        DataSource ds;
        MdDatabase newdb;
        FmMDException.ASSERT(this.getClientType() != FMMDSession.ClientType.QueryBuilder, "Refreshing metadata isn't supported by Query Builder.");
        Iterator<MdDatabase> it = this.m_physicalDatabases.iterator();
        while (it.hasNext()) {
            MdDatabase db = it.next();
            if (!db.getName().equals(cmDsName) || db.findSchema(catalog, schema) == null) continue;
            it.remove();
            break;
        }
        this.getProjectAccess().deletePhysicalMetadataFile(cmDsName, catalog, schema);
        RelmdServiceBrowseSource mdSource = new RelmdServiceBrowseSource(this, cmDsName, catalog, schema, includeSysObjs);
        if (connection != null) {
            mdSource.setDataSourceConnectionName(connection);
        }
        if (signon != null) {
            mdSource.setDataSourceSignonName(signon);
        }
        if ((newdb = MetadataSourceFactory.createMetadataSource(this, mdSource)) != null) {
            this.addDatabase(newdb);
        }
        if ((ds = this.getProject().findDataSource(cmDsName, catalog, schema, null)) != null) {
            for (RelationalObject ro : this.getProject().getRootNamespace().getAllRelationalObjects()) {
                ro.updateObject(ds);
            }
        }
        this.saveCachedMetadata();
        return newdb;
    }

    @Override
    public void deleteMetadataSource(String cmDsName, String catalog, String schema) {
        for (MdDatabase db : this.m_physicalDatabases) {
            if (!db.getName().equals(cmDsName) || db.findSchema(catalog, schema) == null) continue;
            this.m_physicalDatabases.remove(db);
            break;
        }
    }

    @Override
    public MdDatabase findMetadataSource(String cmDsName, String catalog, String schema) {
        if (catalog == null) {
            catalog = "";
        }
        if (!catalog.isEmpty() || !schema.isEmpty()) {
            for (MdDatabase db : this.m_physicalDatabases) {
                if (!db.getName().equals(cmDsName) || db.findSchema(catalog, schema) == null) continue;
                return db;
            }
        }
        return null;
    }

    @Override
    public MdTableContainer findTableContainerInternal(String dbName, String catalog, String schema) {
        for (MdDatabase db : this.m_physicalDatabases) {
            MdTableContainer tc;
            if (!db.getName().equals(dbName) || (tc = db.findTableContainerInternal(catalog, schema)) == null) continue;
            return tc;
        }
        return null;
    }

    @Override
    public void prefetchMetadata() {
        ProgressCallbackHandler callback = this.getProgressCallbackHandler();
        int total = 0;
        int progress = 0;
        if (callback != null) {
            for (MdDatabase db : this.m_physicalDatabases) {
                try {
                    for (MdSchema schema : db.getAllSchemas()) {
                        total += schema.getTables().size();
                        total += schema.getViews().size();
                    }
                }
                catch (RuntimeException runtimeException) {}
            }
        }
        for (MdDatabase db : this.m_physicalDatabases) {
            try {
                for (MdSchema schema : db.getAllSchemas()) {
                    for (MdTable table : schema.getTables()) {
                        if (callback != null) {
                            callback.setProgressStatus(progress, total, table.getName());
                            ++progress;
                            if (callback.isCancelRequested()) {
                                return;
                            }
                        }
                        table.getColumns();
                        table.getForeignKeys();
                    }
                    for (MdTable view : schema.getViews()) {
                        if (callback != null) {
                            callback.setProgressStatus(progress, total, view.getName());
                            ++progress;
                            if (callback.isCancelRequested()) {
                                return;
                            }
                        }
                        view.getColumns();
                    }
                }
            }
            catch (RuntimeException runtimeException) {}
        }
        this.saveCachedMetadata();
    }

    @Override
    public MdDatabase findOrLoadMetadataSource(MdSource source, String catalog, String schema) {
        MdDatabase db = this.findMetadataSource(source.getDatabaseName(), catalog, schema);
        if (db != null) {
            return db;
        }
        MdSource newSrc = source.copy(catalog, schema);
        return MetadataSourceFactory.createMetadataSource(this, newSrc);
    }

    public Project getProject(BaseObject obj) {
        return FmProject.get(this, this.getProjectForResource(((EObject)obj.getInternal()).eResource()));
    }

    @Override
    public Project getProject() {
        return FmProject.get(this, this.getProjectForResource(this.m_resource));
    }

    @Override
    public String getDefaultLocale() {
        ProjectType proj = this.getProjectForResource(this.m_resource);
        if (proj != null) {
            return proj.getDefaultLocale();
        }
        return null;
    }

    ProjectType getProjectForResource(Resource resource) {
        DocumentRoot mainResourcedocRoot = (DocumentRoot)resource.getContents().get(0);
        return mainResourcedocRoot.getProject();
    }

    public void registerLinkedObject(Object link, Object objectWeAreLinkingTo) {
        EObject obj = (EObject)objectWeAreLinkingTo;
        this.m_resource.getResourceSet().getResources().add((Object)obj.eResource());
    }

    public void installSegmentLinkNode(BaseObject from, String toCpfProject, String toObjectID) {
        Segment toSegment = new Segment(Segment.SegmentType.eProjectSegement);
        toSegment.setHrefId(String.valueOf(toCpfProject) + "#" + toObjectID);
        String id = from.getID();
        Segment fromSegment = new Segment(Segment.SegmentType.eModelSegment);
        fromSegment.setHrefId("model.xml#" + id);
        SegmentProcessor segProcessor = new SegmentProcessor(this);
        segProcessor.installLinkNode(fromSegment, toSegment, this.m_projectManager);
    }

    public void createSegmentToProject(ProjectManager projManager, BaseObject from) {
        SegmentProcessor segProcessor = new SegmentProcessor(this);
        segProcessor.createSegmentToProject(projManager, from);
    }

    private void resolveCrossDocumentReferences() {
        for (UnresolvedReference ref : this.m_unresolvedReferences) {
            Object obj = this.getObjectById(ref.getReference());
            if (obj == null) continue;
            EcoreUtil.replace((EObject)ref, (EObject)((EObject)obj));
            DebugUtil.GetInstance().debug("Resolved, unresolved reference: " + ref.getReference(), DebugUtil.CATEGORY.REFERENCES);
        }
    }

    public Object getLinkedParent(EObject obj) {
        WeakReference<EObject> value = this.m_linkedSegments.get(obj);
        if (value == null) {
            return null;
        }
        return value.get();
    }

    @Override
    public ProjectManager getProjectManager() {
        return this.m_projectManager;
    }

    public void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable t) {
            DebugUtil.GetInstance().debug(t);
        }
        DebugUtil.GetInstance().debug("Finally method of session called", DebugUtil.CATEGORY.LIFECYCLE);
    }

    @Override
    public Locale getActiveLocale() {
        if (this.m_localeStr != null) {
            return new Locale(this.m_localeStr);
        }
        Project proj = this.getProject();
        FmMDException.ASSERT(proj != null, "Locale has not been specified.");
        return new Locale(proj.getDefaultLocale());
    }

    @Override
    public void setActiveLocale(String localeString) {
        FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.PLATFORM, this, "Setting the active locale for the session: " + localeString);
        this.m_localeStr = localeString;
    }

    public void setActiveLocale(Locale locale) {
        this.setActiveLocale(locale.toString());
    }

    @Override
    public void saveAs(ProjectAccess fileAccess) throws IOException {
        this.m_projectAccess = fileAccess;
        this.m_projectManager.updateAccess(fileAccess);
        this.save();
    }

    @Override
    public void save() throws IOException {
        OutputStream outStream = this.m_projectAccess.getOutputStream(ProjectAccess.ProjectFile.MODEL_XML);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("PROCESS_DANGLING_HREF", "DISCARD");
        this.getResource().save(outStream, options);
        outStream.close();
        this.saveCachedMetadata();
    }

    @Override
    public void saveCachedMetadata() {
        for (MdDatabase database : this.getMetadataSources()) {
            if (!(database instanceof BrowseSource) || !((BrowseSource)database).shouldBeSaved()) continue;
            ((BrowseSource)database).saveCachedInfo();
        }
    }

    public Object getObjectById(String id) {
        if (id == null) {
            return null;
        }
        EList resources = this.m_resource.getResourceSet().getResources();
        EObject obj = null;
        for (Resource r : resources) {
            obj = ((XMLResource)r).getEObject(id);
            if (obj != null) break;
        }
        return obj;
    }

    public Object getObjectById(String id, Object ignore) {
        if (id == null) {
            return null;
        }
        EList resources = this.m_resource.getResourceSet().getResources();
        EObject obj = null;
        for (Resource r : resources) {
            ObjectLookup lookup = (ObjectLookup)((GenmodelResourceImpl)r).getIDHelper();
            obj = lookup.getObjectById(id, (EObject)ignore);
            if (obj != null) break;
        }
        return obj;
    }

    @Override
    public TopLevelObject findById(String id) {
        Object obj = this.getObjectById(id);
        return this.get(obj);
    }

    @Override
    public void dumpModelXMLToStream(Object exclusionList, OutputStream outStream) throws IOException {
        this.getResource().save(outStream, null);
    }

    @Override
    public void create(ProjectAccess fileAccess) {
        fileAccess.create();
        this.load(fileAccess);
    }

    @Override
    public ProjectAccess getProjectAccess() {
        return this.m_projectAccess;
    }

    @Override
    public EObject handleUnresolvedReference(String id, EStructuralFeature feature, int position, EObject parent) {
        UnresolvedReference ref = new UnresolvedReference(id, feature, parent);
        this.m_unresolvedReferences.add(ref);
        return ref;
    }

    public void registerSegmentLinkedNode(EObject linkedObj, NamespaceType nst) {
        this.m_linkedSegments.put(linkedObj, new WeakReference<NamespaceType>(nst));
    }

    public void deregisterSegmentLinkedNode(EObject nst) {
        if (nst.eIsProxy()) {
            Set<Map.Entry<EObject, WeakReference<EObject>>> nodes = this.m_linkedSegments.entrySet();
            for (Map.Entry<EObject, WeakReference<EObject>> entry : nodes) {
                WeakReference<EObject> value = entry.getValue();
                if (value.get() != nst) continue;
                this.m_linkedSegments.remove(entry.getKey());
                break;
            }
        }
    }

    public Boolean breakObjectReferences(FmBaseObject object, List<EObject> refs) {
        Boolean ret = false;
        int i = 0;
        while (i < refs.size()) {
            EObject ref = refs.get(i);
            if (ref == object.getInternal()) {
                refs.set(i, this.createBrokenReference(object));
                ret = true;
            }
            ++i;
        }
        return ret;
    }

    @Override
    public String getSessionId() {
        return ((FMMDSessionPool)SessionPool.GetSessionPool()).getSessionIdentifier(this);
    }

    @Override
    public void delete(TopLevelObject tlo) {
        this.delete((RemoveListener)new DefaultImpactListener(), tlo);
    }

    @Override
    public void delete(List<? extends TopLevelObject> objects) {
        FmDeleteManager delMgr = new FmDeleteManager(this, objects);
        delMgr.removeObjects(new DefaultImpactListener());
    }

    @Override
    public void delete(RemoveListener listener, TopLevelObject tlo) {
        ArrayList<TopLevelObject> toDelete = new ArrayList<TopLevelObject>();
        toDelete.add(tlo);
        this.delete(listener, toDelete);
    }

    @Override
    public void delete(RemoveListener listener, List<TopLevelObject> objects) {
        FmDeleteManager delMgr = new FmDeleteManager(this, objects);
        delMgr.removeObjects(listener);
    }

    public void addDatabase(MdDatabase database) {
        this.m_physicalDatabases.add(database);
    }

    @Override
    public MdTable findPhysicalTable(DataSource ds, String tableName, boolean allowException) {
        block5: {
            FmMDException.ASSERT(ds != null, "Bad data source");
            try {
                String dsName = ds.getCmDataSourceName();
                for (MdDatabase db : this.m_physicalDatabases) {
                    MdTable someTable;
                    MdTableContainer someSchema;
                    if (!db.getName().equals(dsName) || (someSchema = db.findTableContainer(ds.getCatalogName(), ds.getSchemaName())) == null || (someTable = someSchema.findTable(tableName)) == null) continue;
                    return someTable;
                }
            }
            catch (CAMFaultException e) {
                throw e;
            }
            catch (Exception e) {
                FmEngApplicationLog.getApplicationLog().logException(e);
                FmEngApplicationLog.getApplicationLog().logError(FmEngApplicationLog.LOGGERS.METADATA, this, "Error finding table " + tableName + " in datasource " + ds.getName() + ": " + e.getMessage());
                if (!allowException) break block5;
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return null;
    }

    @Override
    public MdTable findPhysicalTable(String dbName, String catalogName, String schemaName, String tableName) {
        MdTable table = null;
        for (MdDatabase db : this.getMetadataSources()) {
            MdTableContainer tblContainer;
            if (!dbName.equals(db.getName()) || (tblContainer = db.findTableContainer(catalogName, schemaName)) == null) continue;
            return tblContainer.findTable(tableName);
        }
        return table;
    }

    @Override
    public MdColumn findPhysicalColumn(ColumnReference cref, boolean allowException) {
        MdColumn column;
        MdTable table = this.findPhysicalTable(cref.getDataSource(), cref.getTableName(), allowException);
        if (table != null && (column = table.findColumn(cref.getColumnName())) != null) {
            return column;
        }
        return null;
    }

    @Override
    public void removeMetadataSource(MdDatabase db) {
        if (this.m_physicalDatabases.contains(db)) {
            this.m_physicalDatabases.remove(db);
        }
    }

    @Override
    public TopLevelObject get(Object obj) {
        return FmModelFactory.getInstance().get(this, obj);
    }

    @Override
    public NonReportObject getImplementationObject(Object obj) {
        if (obj instanceof TableDeterminantType) {
            return FmTableDeterminant.get(this, obj);
        }
        if (obj instanceof QueryItemMappingType) {
            return FmQueryItemMapping.get(this, obj);
        }
        if (obj instanceof TableType) {
            return FmTable.get(this, obj);
        }
        if (obj instanceof SqlObjectType) {
            return FmSQLObject.get(this, obj);
        }
        if (obj instanceof JoinType) {
            return FmJoin.get(this, obj);
        }
        return null;
    }

    @Override
    public List<MdDatabase> getMetadataSources() {
        return new ArrayList<MdDatabase>(this.m_physicalDatabases);
    }

    @Override
    public void resetChildValidationStatus() {
        TreeIterator iter = this.m_resource.getAllContents();
        while (iter.hasNext()) {
            EObject obj = (EObject)iter.next();
            for (EAttribute attr : obj.eClass().getEAllAttributes()) {
                if (attr.getEType().getClassifierID() != 229) continue;
                StatusType type = (StatusType)((Object)obj.eGet((EStructuralFeature)attr));
                if (type == StatusType.CHILD_INVALID || type == StatusType.CHILD_WARNING) {
                    obj.eUnset((EStructuralFeature)attr);
                }
                if (type != StatusType.CHILD_INVALID_THIS_WARNING) continue;
                obj.eSet((EStructuralFeature)attr, (Object)StatusType.WARNING);
            }
        }
    }

    @Override
    public void propagateStatus() {
        HashSet<CubeType> cubes = new HashSet<CubeType>();
        HashSet<PackageViewType> packages = new HashSet<PackageViewType>();
        TreeIterator iter = this.m_resource.getAllContents();
        while (iter.hasNext()) {
            EObject obj = (EObject)iter.next();
            if (obj instanceof CubeType) {
                cubes.add((CubeType)obj);
            } else if (obj instanceof PackageViewType) {
                packages.add((PackageViewType)obj);
            }
            EList contents = obj.eContents();
            if (contents.size() != 0) continue;
            this.updateParentStatus(obj, StatusType.VALID);
        }
        for (CubeType cubeType : cubes) {
            FmCube cube = FmCube.get(this, cubeType);
            for (RelationalDimensionBase dim : cube.getReferencedDimensions()) {
                RelationalObjectType dimType = (RelationalObjectType)dim.getInternal();
                StatusType dimStatus = dimType.getStatus();
                this.updateParentStatus(cubeType, dimStatus);
            }
        }
        for (PackageViewType packageType : packages) {
            EList<EObject> refObjects = packageType.getRefobj();
            for (EObject refObject : refObjects) {
                EAttribute statusAttr = this.getStatusAttribute(refObject);
                if (statusAttr == null) continue;
                StatusType status = (StatusType)((Object)refObject.eGet((EStructuralFeature)statusAttr));
                this.updateParentStatus(packageType, status);
            }
        }
    }

    private void updateParentStatus(EObject parent, StatusType childStatus) {
        boolean bRecurse = true;
        StatusType escalateStatus = childStatus;
        if (parent == null) {
            return;
        }
        if (parent instanceof ProjectType) {
            return;
        }
        EAttribute statusAttr = this.getStatusAttribute(parent);
        if (statusAttr != null) {
            StatusType parentStatus = (StatusType)((Object)parent.eGet((EStructuralFeature)statusAttr));
            if (parentStatus == StatusType.VALID) {
                if (childStatus == StatusType.WARNING || childStatus == StatusType.CHILD_WARNING) {
                    escalateStatus = StatusType.CHILD_WARNING;
                    parent.eSet((EStructuralFeature)statusAttr, (Object)escalateStatus);
                }
                if (childStatus == StatusType.INVALID || childStatus == StatusType.CHILD_INVALID) {
                    escalateStatus = StatusType.CHILD_INVALID;
                    parent.eSet((EStructuralFeature)statusAttr, (Object)escalateStatus);
                }
                if (childStatus == StatusType.PERFORMANCE) {
                    escalateStatus = StatusType.PERFORMANCE;
                    parent.eSet((EStructuralFeature)statusAttr, (Object)escalateStatus);
                }
            }
            if (parentStatus == StatusType.PERFORMANCE) {
                if (childStatus == StatusType.WARNING || childStatus == StatusType.CHILD_WARNING) {
                    escalateStatus = StatusType.CHILD_WARNING;
                    parent.eSet((EStructuralFeature)statusAttr, (Object)escalateStatus);
                }
                if (childStatus == StatusType.INVALID || childStatus == StatusType.CHILD_INVALID) {
                    escalateStatus = StatusType.CHILD_INVALID;
                    parent.eSet((EStructuralFeature)statusAttr, (Object)escalateStatus);
                }
            }
            if (parentStatus == StatusType.WARNING && (childStatus == StatusType.INVALID || childStatus == StatusType.CHILD_INVALID)) {
                parent.eSet((EStructuralFeature)statusAttr, (Object)StatusType.CHILD_INVALID_THIS_WARNING);
                escalateStatus = StatusType.CHILD_INVALID;
            }
            if (parentStatus == StatusType.CHILD_WARNING && (childStatus == StatusType.INVALID || childStatus == StatusType.CHILD_INVALID)) {
                escalateStatus = StatusType.CHILD_INVALID;
                parent.eSet((EStructuralFeature)statusAttr, (Object)escalateStatus);
            }
            if (parentStatus == StatusType.INVALID) {
                escalateStatus = StatusType.CHILD_INVALID;
            }
            if (parentStatus == StatusType.CHILD_INVALID) {
                bRecurse = false;
            }
        }
        if (bRecurse) {
            this.updateParentStatus(parent.eContainer(), escalateStatus);
        }
    }

    private EAttribute getStatusAttribute(EObject obj) {
        for (EAttribute attr : obj.eClass().getEAllAttributes()) {
            if (attr.getEType().getClassifierID() != 229) continue;
            return attr;
        }
        return null;
    }

    @Override
    public String saveAs(String location, String name) throws FileNotFoundException, IOException {
        FileOutputStream outStream = new FileOutputStream(new File(location, name));
        OneToOneModelSerializer publishSerializer = new OneToOneModelSerializer(this);
        EMFCustomModelSerializer serializer = new EMFCustomModelSerializer(outStream, (XMLResource)this.getResource(), publishSerializer);
        Project root = this.getProject();
        serializer.serialize((EObject)root.getInternal(), true);
        outStream.flush();
        outStream.close();
        return "";
    }

    @Override
    public MdCube findPhysicalCube(String cmRolapDatasourcePath) {
        for (MdCube cube : this.m_physicalCubes) {
            if (!cube.getCMPath().equals(cmRolapDatasourcePath)) continue;
            return cube;
        }
        MdCube mdCube = MdCubeImpl.queryRolapDatasourceForCube(this, cmRolapDatasourcePath);
        this.m_physicalCubes.add(mdCube);
        return mdCube;
    }

    public void resetGuids() {
        ProjectType proj = (ProjectType)this.getProject().getInternal();
        proj.setGuid(UUID.randomUUID().toString());
        TreeIterator it = proj.eAllContents();
        while (it.hasNext()) {
            EObject descendant = (EObject)it.next();
            if (descendant instanceof ModelObjectType) {
                ModelObjectType modelObj = (ModelObjectType)descendant;
                modelObj.setGuid(UUID.randomUUID().toString());
            }
            if (!(descendant instanceof ReportObjectType)) continue;
            ReportObjectType reportObj = (ReportObjectType)descendant;
            reportObj.setGuid(UUID.randomUUID().toString());
        }
    }
}

