/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.platform.impl;

import com.ibm.cognos.fmeng.platform.impl.CustomCommandStack;
import com.ibm.cognos.fmeng.platform.impl.EMFModelChanges;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.platform.transaction.Transaction;
import com.ibm.cognos.fmeng.platform.transaction.TransactionWork;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class EMFTransaction
extends ChangeCommand
implements Transaction {
    EditingDomain m_tranactionDomain;
    private TransactionWork m_work;
    private Throwable m_exception;
    private EMFSession m_session;

    protected EMFTransaction(EMFSession session, EditingDomain domain, TransactionWork work) {
        super((Notifier)domain.getResourceSet());
        this.m_tranactionDomain = domain;
        this.m_work = work;
        this.m_session = session;
    }

    public void executeTransaction() {
        CommandStack tStack = this.m_tranactionDomain.getCommandStack();
        tStack.execute((Command)this);
        CustomCommandStack custom = (CustomCommandStack)tStack;
        Throwable e = custom.getException();
        if (e == null) {
            e = this.m_exception;
        }
        if (e != null) {
            custom.resetException();
            tStack.undo();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected void doExecute() {
        try {
            EMFModelChanges modelChanges = new EMFModelChanges(this.m_session);
            this.m_work.work();
            modelChanges.disconnect();
            this.m_work.setModelChanges(modelChanges);
        }
        catch (Throwable t) {
            this.m_exception = t;
        }
    }
}

