/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.platform.impl;

import com.ibm.cognos.fmeng.platform.FMEngConfiguration;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.FmParameter;
import com.ibm.cognos.fmeng.platform.FmParameterBoolean;
import com.ibm.cognos.fmeng.platform.FmParameterInteger;
import com.ibm.cognos.fmeng.platform.FmParameterString;
import com.ibm.cognos.fmeng.platform.transaction.FmParameterListString;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FMMDConfigurations
implements FMEngConfiguration {
    public XMLConfiguration m_config;
    public String m_ConfigFile;
    private List<FmParameter> m_parameters;
    private FMMDSession m_Session;

    public FMMDConfigurations(FMMDSession session, String fileName) {
        this.m_Session = session;
        this.m_ConfigFile = fileName;
        this.m_parameters = new ArrayList<FmParameter>();
        this.m_config = new XMLConfiguration();
        try {
            this.m_config.load(this.m_ConfigFile);
        }
        catch (ConfigurationException configurationException) {}
    }

    public List<String> getMruList() {
        List mruList = null;
        String appKey = "MruList.ListItem";
        Object value = this.m_config.getProperty(appKey);
        if (value != null) {
            mruList = this.m_config.getList(appKey);
        }
        return mruList;
    }

    public void setMruList(List<String> mruList) {
        String appKey = "MruList.ListItem";
        this.m_config.setProperty(appKey, mruList);
    }

    public void save() {
        try {
            this.m_config.save(this.m_ConfigFile);
        }
        catch (ConfigurationException configurationException) {}
    }

    @Override
    public FmParameter findParameter(String name) {
        for (FmParameter param : this.m_parameters) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    @Override
    public FmParameterBoolean registerParameter(String name, boolean defaultValue) {
        FmParameterBooleanImpl boolParam = new FmParameterBooleanImpl(name, defaultValue);
        this.addParameter(boolParam);
        return boolParam;
    }

    @Override
    public FmParameterString registerParameter(String name, String defaultValue) {
        FmParameterStringImpl stringParam = new FmParameterStringImpl(name, defaultValue);
        this.addParameter(stringParam);
        return stringParam;
    }

    public FmParameterListString registerParameter(String name, String[] defaultValues) {
        FmParameterListStringImpl listParam = new FmParameterListStringImpl(name, defaultValues);
        this.addParameter(listParam);
        return listParam;
    }

    private void addParameter(FmParameter param) {
        FmParameter oldParam = this.findParameter(param.getName());
        if (oldParam != null) {
            this.m_parameters.remove(oldParam);
        }
        this.m_parameters.add(param);
    }

    @Override
    public FmParameterInteger registerParameter(String name, int defaultValue) {
        FmParameterIntegerImpl intParam = new FmParameterIntegerImpl(name, defaultValue);
        this.addParameter(intParam);
        return intParam;
    }

    class FmParameterBooleanImpl
    extends FmParameterImpl
    implements FmParameterBoolean {
        private boolean m_default;

        FmParameterBooleanImpl(String name, boolean defaultValue) {
            super(name);
            this.m_default = defaultValue;
        }

        public boolean get() {
            String appKey = this.getAppKey();
            Object value = FMMDConfigurations.this.m_config.getProperty(appKey);
            if (value == null) {
                return FMMDConfigurations.this.m_config.getBoolean(this.m_name, this.m_default);
            }
            return FMMDConfigurations.this.m_config.getBoolean(appKey);
        }

        public void set(boolean value) {
            FMMDConfigurations.this.m_config.setProperty(this.getAppKey(), (Object)value);
        }
    }

    abstract class FmParameterImpl
    implements FmParameter {
        protected String m_name;

        public FmParameterImpl(String name) {
            this.m_name = name;
        }

        public String getName() {
            return this.m_name;
        }

        protected String getAppKey() {
            return String.valueOf(FMMDConfigurations.this.m_Session.getClientType().toString()) + "." + this.m_name;
        }
    }

    class FmParameterIntegerImpl
    extends FmParameterImpl
    implements FmParameterInteger {
        private int m_default;

        FmParameterIntegerImpl(String name, int defaultValue) {
            super(name);
            this.m_default = defaultValue;
        }

        public int get() {
            String appKey = this.getAppKey();
            Object value = FMMDConfigurations.this.m_config.getProperty(appKey);
            if (value == null) {
                return FMMDConfigurations.this.m_config.getInt(this.m_name, this.m_default);
            }
            return FMMDConfigurations.this.m_config.getInt(appKey);
        }

        public void set(int value) {
            FMMDConfigurations.this.m_config.setProperty(this.getAppKey(), (Object)value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FmParameterListStringImpl
    extends FmParameterImpl
    implements FmParameterListString {
        private List<String> m_default;

        public FmParameterListStringImpl(String name, String[] defaultValues) {
            super(name);
            this.m_default = new ArrayList<String>();
            String[] stringArray = defaultValues;
            int n = defaultValues.length;
            int n2 = 0;
            while (n2 < n) {
                String val = stringArray[n2];
                this.m_default.add(val);
                ++n2;
            }
        }

        @Override
        public List<String> get() {
            String appKey = this.getAppKey();
            Object value = FMMDConfigurations.this.m_config.getProperty(appKey);
            if (value == null) {
                return FMMDConfigurations.this.m_config.getList(this.m_name, this.m_default);
            }
            return FMMDConfigurations.this.m_config.getList(appKey);
        }

        @Override
        public void set(List<String> value) {
            FMMDConfigurations.this.m_config.setProperty(this.getAppKey(), value);
        }
    }

    class FmParameterStringImpl
    extends FmParameterImpl
    implements FmParameterString {
        private String m_default;

        FmParameterStringImpl(String name, String defaultValue) {
            super(name);
            this.m_default = defaultValue;
        }

        public String get() {
            String appKey = String.valueOf(FMMDConfigurations.this.m_Session.getClientType().toString()) + "." + this.m_name;
            Object value = FMMDConfigurations.this.m_config.getProperty(appKey);
            if (value == null) {
                return FMMDConfigurations.this.m_config.getString(this.m_name, this.m_default);
            }
            return FMMDConfigurations.this.m_config.getString(appKey);
        }

        public void set(String value) {
            FMMDConfigurations.this.m_config.setProperty(this.getAppKey(), (Object)value);
        }
    }
}

