/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.platform.impl;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmCollector;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.fmmd.util.CrnIDHelper;
import com.ibm.cognos.fmeng.fmmd.util.EmfHelper;
import com.ibm.cognos.fmeng.fmmd.util.SearchFilter;
import com.ibm.cognos.fmeng.genmodel.AttributeReferenceType;
import com.ibm.cognos.fmeng.genmodel.LevelReferenceType;
import com.ibm.cognos.fmeng.genmodel.LevelType;
import com.ibm.cognos.fmeng.genmodel.LocaleMappingType;
import com.ibm.cognos.fmeng.genmodel.MeasureFolderType;
import com.ibm.cognos.fmeng.genmodel.ModelObjectType;
import com.ibm.cognos.fmeng.genmodel.MultilingualAttributeType;
import com.ibm.cognos.fmeng.genmodel.NameType;
import com.ibm.cognos.fmeng.genmodel.NamedSetFolderType;
import com.ibm.cognos.fmeng.genmodel.NamespaceType;
import com.ibm.cognos.fmeng.genmodel.ProjectType;
import com.ibm.cognos.fmeng.genmodel.QueryItemFolderType;
import com.ibm.cognos.fmeng.genmodel.QueryItemType;
import com.ibm.cognos.fmeng.genmodel.ReportObjectType;
import com.ibm.cognos.fmeng.genmodel.SectionType;
import com.ibm.cognos.fmeng.genmodel.ShortcutType;
import com.ibm.cognos.fmeng.genmodel.VirtualMeasureFolderType;
import com.ibm.cognos.fmeng.genmodel.util.GenmodelResourceImpl;
import com.ibm.cognos.fmeng.genmodel.util.IDHelper;
import com.ibm.cognos.fmeng.platform.impl.EMFIDGenerator;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.utility.DebugUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectLookup
extends EContentAdapter
implements IDHelper {
    private HashMap<String, EObject> m_allObjectsMap = new HashMap();
    private boolean m_loadInProgress = false;
    ProjectType m_projectType;
    private EMFSession m_session;

    public ObjectLookup(Resource r, EMFSession session) {
        r.eAdapters().add((Object)this);
        this.m_session = session;
        ((GenmodelResourceImpl)r).setIDHelper(this);
    }

    private String getDefaultLocale() {
        if (this.m_projectType != null) {
            return this.m_projectType.getDefaultLocale();
        }
        return null;
    }

    public void setLoading(boolean loading) {
        this.m_loadInProgress = loading;
        if (!loading) {
            this.m_allObjectsMap.clear();
        }
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        boolean idProcessed = false;
        if (notification.getNotifier() instanceof ProjectType) {
            this.m_projectType = (ProjectType)notification.getNotifier();
        } else if (notification.getNotifier() instanceof ModelObjectType) {
            if (notification.getFeatureID(null) == 0) {
                ModelObjectType mot = (ModelObjectType)notification.getNotifier();
                this.setID(mot, mot.getName());
                idProcessed = true;
            }
        } else if (notification.getNotifier() instanceof NameType) {
            NameType nt = (NameType)notification.getNotifier();
            EStructuralFeature sf = nt.eContainingFeature();
            if (sf != null && "name".equalsIgnoreCase(sf.getName()) && nt.getValue() != null) {
                EObject eObj = nt.eContainer();
                String locale = nt.getLocale();
                if (locale != null && locale.equalsIgnoreCase(this.getDefaultLocale())) {
                    this.setID(eObj, nt.getValue());
                    idProcessed = true;
                }
            }
        } else if (notification.getNotifier() instanceof ShortcutType) {
            ShortcutType sct = (ShortcutType)notification.getNotifier();
            EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
            if (feature != null && feature.getFeatureID() == 10 && "namespace".equals(notification.getNewValue())) {
                this.setID(sct, this.getNameWithLocale(this.getDefaultLocale(), sct).getValue());
                idProcessed = true;
            }
        }
        if (notification.getEventType() == 3 && !idProcessed) {
            this.processAddNotificationForID(notification);
        }
        if (notification.getEventType() == 3 || notification.getEventType() == 1) {
            this.processAddForNestedElements(notification);
        }
        if (notification.getEventType() == 4) {
            this.processRemoveForNestedElements(notification);
        }
    }

    private void processAddNotificationForID(Notification notification) {
        Object notifier = notification.getNotifier();
        Object newValue = notification.getNewValue();
        ReportObjectType rot = null;
        if (newValue != null) {
            if (newValue instanceof NamespaceType) {
                rot = (ReportObjectType)newValue;
            } else if (newValue instanceof ShortcutType) {
                ShortcutType sct = (ShortcutType)newValue;
                if ("namespace".equals(sct.getTargetType())) {
                    rot = sct;
                }
            } else if (newValue instanceof NameType) {
                ShortcutType sct;
                if (notifier instanceof NamespaceType) {
                    rot = (ReportObjectType)notifier;
                } else if (notifier instanceof ShortcutType && "namespace".equals((sct = (ShortcutType)notifier).getTargetType())) {
                    rot = sct;
                }
            }
            this.setIDForReportObject(rot);
        }
    }

    private void processAddForNestedElements(Notification notification) {
        Object newValue = notification.getNewValue();
        if (newValue instanceof SectionType) {
            SectionType st = (SectionType)newValue;
            HashSet<Integer> recurseInto = new HashSet<Integer>();
            recurseInto.add(88);
            recurseInto.add(148);
            recurseInto.add(28);
            ArrayList<SectionType> folders = new ArrayList<SectionType>();
            ArrayList<SectionType> namespaces = new ArrayList<SectionType>();
            ArrayList<SectionType> cubes = new ArrayList<SectionType>();
            HashMap<Integer, List<Object>> collect = new HashMap<Integer, List<Object>>();
            collect.put(88, namespaces);
            collect.put(148, folders);
            collect.put(28, cubes);
            if (newValue instanceof NamespaceType) {
                namespaces.add(st);
            } else if (newValue instanceof SectionType) {
                folders.add(st);
            } else {
                cubes.add(st);
            }
            EmfHelper.collect(st, recurseInto, collect);
            for (Object e : namespaces) {
                NamespaceType nst = (NamespaceType)e;
                this.setIDForReportObject(nst);
                if (!nst.eIsProxy()) continue;
                EObject refdObject = EcoreUtil.resolve((EObject)nst, (Resource)nst.eResource());
                this.m_session.registerSegmentLinkedNode(refdObject, nst);
            }
        }
    }

    private void processRemoveForNestedElements(Notification notification) {
        Object newValue = notification.getOldValue();
        if (newValue instanceof SectionType) {
            SectionType st = (SectionType)newValue;
            HashSet<Integer> recurseInto = new HashSet<Integer>();
            recurseInto.add(88);
            recurseInto.add(148);
            recurseInto.add(28);
            ArrayList<SectionType> folders = new ArrayList<SectionType>();
            ArrayList<SectionType> namespaces = new ArrayList<SectionType>();
            ArrayList<SectionType> cubes = new ArrayList<SectionType>();
            HashMap<Integer, List<Object>> collect = new HashMap<Integer, List<Object>>();
            collect.put(88, namespaces);
            collect.put(148, folders);
            collect.put(28, cubes);
            if (newValue instanceof NamespaceType) {
                namespaces.add(st);
            } else if (newValue instanceof SectionType) {
                folders.add(st);
            } else {
                cubes.add(st);
            }
            EmfHelper.collect(st, recurseInto, collect);
            for (Object e : namespaces) {
                NamespaceType nst = (NamespaceType)e;
                this.m_session.deregisterSegmentLinkedNode(nst);
            }
        }
    }

    private void setIDForReportObject(ReportObjectType rot) {
        String nm;
        NameType name;
        if (rot != null && (name = this.getNameWithLocale(this.getDefaultLocale(), rot)) != null && (nm = name.getValue()) != null) {
            this.setID(rot, nm);
        }
    }

    private ReportObjectType lookupNamespaceShortCutOrFunction(String name, EObject ignore) {
        HashSet<Integer> recurseInto = new HashSet<Integer>();
        recurseInto.add(new Integer(88));
        recurseInto.add(new Integer(148));
        recurseInto.add(new Integer(85));
        recurseInto.add(new Integer(28));
        recurseInto.add(new Integer(9));
        HashSet<Integer> lookingFor = new HashSet<Integer>();
        lookingFor.add(new Integer(88));
        lookingFor.add(new Integer(157));
        lookingFor.add(new Integer(52));
        lookingFor.add(new Integer(28));
        lookingFor.add(new Integer(172));
        LookupFilter filter = new LookupFilter(name, ignore);
        EmfHelper.traverse(this.m_projectType, recurseInto, lookingFor, filter, true);
        return filter.m_found;
    }

    private EObject getObjectByAdvancedLookup(String namedId, EObject ignore) {
        List<String> idParts = CrnIDHelper.parseID(namedId, false);
        int numParts = idParts.size();
        EObject ret = null;
        if (numParts > 0) {
            String firstPart = idParts.get(0);
            Object obj = null;
            obj = firstPart.equals("") ? this.m_projectType : this.lookupNamespaceShortCutOrFunction(firstPart, ignore);
            if (numParts == 1) {
                return obj;
            }
            boolean typeMatch = false;
            if (obj != null && obj instanceof ShortcutType) {
                obj = ((ShortcutType)obj).getRefobj();
            }
            if (!(obj instanceof NamespaceType)) {
                if (obj instanceof ProjectType) {
                    typeMatch = true;
                } else {
                    DebugUtil.GetInstance().debug("Unexpected ID: " + namedId, DebugUtil.CATEGORY.REFERENCES);
                }
            }
            if (obj != null) {
                ret = this.solveId((EObject)obj, idParts, 1, this.getDefaultLocale(), typeMatch, ignore);
            }
        }
        return ret;
    }

    private EObject solveId(EObject obj, List<String> idParts, int index, String defaultLocale, boolean typeMatch, EObject ignore) {
        String id = idParts.get(index);
        List<EObject> children = this.getPossibleChildren(obj, index, idParts.size());
        EObject idPart = null;
        ArrayList<EObject> collectors = new ArrayList<EObject>();
        int numChildren = children.size();
        int i = 0;
        while (i < numChildren) {
            LocaleMappingType localeMappingType;
            String locale;
            NameType matchingLocale;
            EObject child = children.get(i);
            if (child instanceof ModelObjectType) {
                ModelObjectType mot = (ModelObjectType)child;
                if (id.equals(mot.getName()) && child != ignore) {
                    idPart = child;
                    break;
                }
            } else if (child instanceof ReportObjectType) {
                ReportObjectType rot = (ReportObjectType)child;
                NameType matchingLocale2 = this.getNameWithValue(rot, id);
                if (matchingLocale2 != null && child != ignore) {
                    idPart = child;
                    break;
                }
                if ((child instanceof SectionType || child instanceof MeasureFolderType || child instanceof NamedSetFolderType || child instanceof QueryItemFolderType && !(child instanceof LevelType) || child instanceof VirtualMeasureFolderType) && !(child instanceof NamespaceType)) {
                    collectors.add(child);
                }
            } else if (child instanceof LevelReferenceType) {
                LevelReferenceType lrt = (LevelReferenceType)child;
                LevelType lt = (LevelType)lrt.getRefObj();
                matchingLocale = this.getNameWithValue(lt, id);
                if (matchingLocale != null && child != ignore) {
                    idPart = lrt;
                    break;
                }
            } else if (child instanceof AttributeReferenceType) {
                AttributeReferenceType art = (AttributeReferenceType)child;
                QueryItemType qit = (QueryItemType)art.getRefobj();
                matchingLocale = this.getNameWithValue(qit, id);
                if (matchingLocale != null && child != ignore) {
                    idPart = art;
                    break;
                }
            } else if (typeMatch || this.isCollector(child)) {
                String elmName = child.eContainingFeature().getName();
                if (id.equals(elmName) && child != ignore) {
                    idPart = child;
                    break;
                }
            } else if (child instanceof MultilingualAttributeType) {
                MultilingualAttributeType attrType = (MultilingualAttributeType)child;
                QueryItemType queryItemType = (QueryItemType)attrType.getSourceQueryItemForMultilingualValues();
                matchingLocale = this.getNameWithValue(queryItemType, id);
                if (matchingLocale != null && child != ignore) {
                    idPart = attrType;
                    break;
                }
            } else if (child instanceof LocaleMappingType && (locale = (localeMappingType = (LocaleMappingType)child).getLocale()).equals(id)) {
                idPart = localeMappingType;
                break;
            }
            ++i;
        }
        if (idPart == null) {
            i = 0;
            while (i < collectors.size()) {
                EObject st = (EObject)collectors.get(i);
                idPart = this.solveId(st, idParts, index, defaultLocale, false, ignore);
                if (idPart == null) {
                    ++i;
                    continue;
                }
                break;
            }
        } else if (idParts.size() > index + 1) {
            if (idPart instanceof ShortcutType) {
                idPart = ((ShortcutType)idPart).getRefobj();
            }
            idPart = this.solveId(idPart, idParts, index + 1, defaultLocale, false, ignore);
        }
        return idPart;
    }

    private boolean isCollector(EObject child) {
        TopLevelObject fmObj = FmObjectType.get(this.m_session, child);
        return fmObj != null && fmObj instanceof FmCollector;
    }

    private NameType getNameWithLocale(String locale, ReportObjectType rot) {
        EList<NameType> names = rot.getName();
        int nIdx = 0;
        while (nIdx < names.size()) {
            NameType nt = (NameType)names.get(nIdx);
            if (locale.equalsIgnoreCase(nt.getLocale())) {
                return nt;
            }
            ++nIdx;
        }
        return null;
    }

    private NameType getNameWithValue(ReportObjectType rot, String value) {
        EList<NameType> names = rot.getName();
        int nIdx = 0;
        while (nIdx < names.size()) {
            NameType nt = (NameType)names.get(nIdx);
            if (nt.getValue().equals(value)) {
                return nt;
            }
            ++nIdx;
        }
        return null;
    }

    @Override
    public String getID(EObject obj) {
        return EMFIDGenerator.generateID(obj, this.getDefaultLocale());
    }

    @Override
    public void setID(EObject obj, String name) {
        if (this.m_loadInProgress) {
            String id = this.getID(obj);
            this.m_allObjectsMap.put(id, obj);
        }
    }

    @Override
    public EObject getObjectById(String id) {
        return this.getObjectById(id, null);
    }

    public EObject getObjectById(String id, EObject ignore) {
        if (this.m_loadInProgress) {
            return this.getObjectByIdFromLoadMap(id);
        }
        return this.getObjectByAdvancedLookup(id, ignore);
    }

    private EObject getObjectByIdFromLoadMap(String id) {
        return this.m_allObjectsMap.get(id);
    }

    private List<EObject> getPossibleChildren(EObject parent, int index, int totalParts) {
        if (parent instanceof ProjectType) {
            ArrayList<EObject> children = new ArrayList<EObject>();
            ProjectType proj = (ProjectType)parent;
            children.add(proj.getSecurityViews());
            children.add(proj.getDataSources());
            children.add(proj.getParameterMaps());
            children.add(proj.getPackages());
            return children;
        }
        switch (index) {
            case 1: {
                if (parent instanceof SectionType) {
                    ArrayList<EObject> children = new ArrayList<EObject>();
                    SectionType st = (SectionType)parent;
                    children.addAll((Collection<EObject>)st.getDimension());
                    children.addAll((Collection<EObject>)st.getQuerySubject());
                    children.addAll((Collection<EObject>)st.getShortcut());
                    children.addAll((Collection<EObject>)st.getUpdateSubject());
                    children.addAll((Collection<EObject>)st.getObject());
                    children.addAll((Collection<EObject>)st.getCube());
                    children.addAll((Collection<EObject>)st.getRelationalQuerySubject());
                    children.addAll((Collection<EObject>)st.getRelationalDimension());
                    children.addAll((Collection<EObject>)st.getMeasureDimension());
                    if (totalParts <= 2) {
                        children.addAll((Collection<EObject>)st.getFilter());
                        children.addAll((Collection<EObject>)st.getRelationship());
                        children.addAll((Collection<EObject>)st.getRelationshipShortcut());
                        children.addAll((Collection<EObject>)st.getCalculation());
                        children.addAll((Collection<EObject>)st.getScopeRelationship());
                    }
                    children.addAll((Collection<EObject>)st.getFolder());
                    return children;
                }
                return parent.eContents();
            }
        }
        return parent.eContents();
    }

    private class LookupFilter
    implements SearchFilter {
        public ReportObjectType m_found;
        private String m_name;
        private EObject m_ignore;

        public LookupFilter(String name, EObject ignore) {
            this.m_name = name;
            this.m_ignore = ignore;
        }

        public boolean foundElement(Object obj) {
            ReportObjectType ro = (ReportObjectType)obj;
            EList<NameType> names = ro.getName();
            for (NameType name : names) {
                if (!name.getValue().equals(this.m_name) || this.m_ignore == obj) continue;
                this.m_found = ro;
                return true;
            }
            return false;
        }
    }
}

