/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.platform.impl;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDataSource;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmNamespace;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmParameterMap;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProject;
import com.ibm.cognos.fmeng.fmmd.impl.task.FmCopyManager;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.ParameterMapBase;
import com.ibm.cognos.fmeng.fmmd.model.Project;
import com.ibm.cognos.fmeng.fmmd.util.EmfHelper;
import com.ibm.cognos.fmeng.genmodel.DataSourceType;
import com.ibm.cognos.fmeng.genmodel.DataSourcesType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.NamespaceType;
import com.ibm.cognos.fmeng.genmodel.ParameterMapType;
import com.ibm.cognos.fmeng.genmodel.ProjectType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.ProjectAccess;
import com.ibm.cognos.fmeng.platform.impl.EMFModelLoader;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.platform.impl.project.ProjectManager;
import com.ibm.cognos.fmeng.platform.impl.project.Segment;
import com.ibm.cognos.fmeng.platform.impl.project.SegmentXLink;
import com.ibm.cognos.fmeng.utility.DebugUtil;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class SegmentProcessor {
    private EMFSession m_session;

    public SegmentProcessor(EMFSession session) {
        this.m_session = session;
    }

    public void installLinks(Resource r, ProjectManager projManager) {
        List<SegmentXLink> links = projManager.getModelSegments();
        for (SegmentXLink link : links) {
            Segment fromSeg = projManager.getSegmentWithLabel(link.getFrom());
            Segment toSeg = projManager.getSegmentWithLabel(link.getTo());
            this.installLinkNode(fromSeg, toSeg, projManager);
        }
    }

    void installLinkNode(Segment from, Segment to, ProjectManager projManager) {
        String hrefId;
        int idx;
        String hrefIdTo = to.getHrefID();
        String idOfLinkedNode = null;
        Resource linkedResource = null;
        int toIdx = hrefIdTo.lastIndexOf(35);
        if (toIdx != -1) {
            idOfLinkedNode = hrefIdTo.substring(toIdx + 1);
            String projectPart = hrefIdTo.substring(0, toIdx);
            linkedResource = this.loadDependentProject(projectPart, projManager);
        }
        if ((idx = (hrefId = from.getHrefID()).lastIndexOf(35)) != -1) {
            String fromId = hrefId.substring(idx + 1);
            if (from.getSegmentType() == Segment.SegmentType.eModelSegment) {
                this.installProxyNode(fromId, this.m_session.getResource(), idOfLinkedNode, linkedResource);
            }
        }
    }

    private Resource loadDependentProject(String projectPath, ProjectManager manager) {
        DebugUtil.GetInstance().debug("Start of load", DebugUtil.CATEGORY.LOAD);
        DebugUtil.GetInstance().dumpMemory();
        ResourceSet rs = this.m_session.getResource().getResourceSet();
        EList resources = rs.getResources();
        for (Resource r : resources) {
            if (r.getURI().toString() != projectPath) continue;
            return r;
        }
        ProjectManager dependentManager = manager.getSegementManager(projectPath);
        EMFModelLoader loader = new EMFModelLoader(this.m_session);
        Resource r = loader.load(dependentManager.getModelStream(), dependentManager.getAccess().getFileName(ProjectAccess.ProjectFile.MODEL_XML));
        this.installLinks(r, dependentManager);
        loader.destroy();
        DebugUtil.GetInstance().debug("End of load", DebugUtil.CATEGORY.LOAD);
        DebugUtil.GetInstance().dumpMemory();
        return r;
    }

    void installProxyNode(String fromId, Resource fromResource, String linkedNodeId, Resource linkedResource) {
        Project proj = this.m_session.getProject();
        String defaultLocale = proj.getDefaultLocale();
        ProjectType fromProj = this.m_session.getProjectForResource(fromResource);
        ProjectType toProj = this.m_session.getProjectForResource(linkedResource);
        if (!defaultLocale.equals(fromProj.getDefaultLocale()) || !defaultLocale.equals(toProj.getDefaultLocale())) {
            FmMDException linkException = new FmMDException("BMT_MD_LINK_LOCALE_MISMATCH");
            throw linkException;
        }
        EObject eObj = ((XMLResource)fromResource).getEObject(fromId);
        InternalEObject proxy = (InternalEObject)GenmodelFactory.eINSTANCE.createNamespaceType();
        proxy.eSetProxyURI(linkedResource.getURI().appendFragment(linkedNodeId));
        if (eObj instanceof NamespaceType) {
            NamespaceType nst = (NamespaceType)eObj;
            nst.getNamespace().add((Object)((NamespaceType)proxy));
        }
        this.installDependentProxies(linkedResource);
    }

    private void installDependentProxies(Resource linkedResource) {
        this.installProxyDataSourcesFor(linkedResource);
        this.installProxyParamterMapsFor(linkedResource);
    }

    private void installProxyDataSourcesFor(Resource linkedResource) {
        ProjectType projType = this.m_session.getProjectForResource(linkedResource);
        DataSourcesType dst = projType.getDataSources();
        EList<DataSourceType> dataSources = dst.getDataSource();
        for (DataSourceType dataSource : dataSources) {
            FmDataSource source = FmDataSource.get(this.m_session, dataSource);
            EObject obj = ((XMLResource)this.m_session.getResource()).getEObject(source.getID());
            if (obj != null) {
                FmDataSource existing = FmDataSource.get(this.m_session, obj);
                if (existing.doesMatch(source)) continue;
                Object[] msgParams = new Object[]{source.getID()};
                FmMDException linkException = new FmMDException("BMT_MD_LINK_ERROR_SAME_DS_NAME_DIFF_STRUCT", msgParams);
                throw linkException;
            }
            InternalEObject proxy = (InternalEObject)dataSource.eClass().getEPackage().getEFactoryInstance().create(dataSource.eClass());
            proxy.eSetProxyURI(linkedResource.getURI().appendFragment(source.getID()));
            ((ProjectType)this.m_session.getProject().getInternal()).getDataSources().getDataSource().add((Object)((DataSourceType)proxy));
        }
    }

    private void installProxyParamterMapsFor(Resource linkedResource) {
        ProjectType projType = this.m_session.getProjectForResource(linkedResource);
        EList<ParameterMapType> parameterMaps = projType.getParameterMaps().getParameterMap();
        for (ParameterMapType pm : parameterMaps) {
            FmParameterMap map = FmParameterMap.get(this.m_session, pm);
            EObject obj = ((XMLResource)this.m_session.getResource()).getEObject(map.getID());
            if (obj != null) continue;
            InternalEObject proxy = (InternalEObject)pm.eClass().getEPackage().getEFactoryInstance().create(pm.eClass());
            proxy.eSetProxyURI(linkedResource.getURI().appendFragment(map.getID()));
            ((ProjectType)this.m_session.getProject().getInternal()).getParameterMaps().getParameterMap().add((Object)((ParameterMapType)proxy));
        }
    }

    public void createSegmentToProject(ProjectManager projManager, BaseObject from) {
        EMFModelLoader loader = new EMFModelLoader(this.m_session);
        Resource r = loader.load(projManager.getModelStream(), projManager.getAccess().getFileName(ProjectAccess.ProjectFile.MODEL_XML));
        ProjectType targetProj = this.m_session.getProjectForResource(r);
        ProjectType sourceProj = this.m_session.getProjectForResource(this.m_session.getResource());
        FmProject sourceFmProj = FmProject.get(this.m_session, sourceProj);
        FmProject targetFmProj = FmProject.get(this.m_session, targetProj);
        EObject sourceNamespace = null;
        if (from instanceof FmNamespace) {
            sourceNamespace = (EObject)from.getInternal();
        } else if (from instanceof FmFolder) {
            FmFolder folder = (FmFolder)from;
            sourceNamespace = (EObject)folder.getParentNamespace().getInternal();
        }
        List<BaseObject> sourceChildObjects = from.getChildObjects();
        HashSet<Integer> classifiers = new HashSet<Integer>();
        classifiers.add(89);
        EmfHelper.copyProperties(sourceProj, targetProj, classifiers);
        EmfHelper.copyProperties(sourceNamespace, targetProj.getNamespace(), classifiers);
        targetFmProj.setDefaultLocale(sourceProj.getDefaultLocale());
        InternalEObject proxy = (InternalEObject)targetProj.getNamespace().eClass().getEPackage().getEFactoryInstance().create(targetProj.getNamespace().eClass());
        proxy.eSetProxyURI(targetProj.getNamespace().eResource().getURI().appendFragment(targetFmProj.getRootNamespace().getID()));
        EcoreUtil.replace((EObject)((EObject)from.getInternal()), (EObject)proxy);
        for (FmBaseObject fmBaseObject : sourceChildObjects) {
            fmBaseObject.moveObject((FmNamespace)targetFmProj.getRootNamespace(), null);
        }
        List<FmDataSource> list = sourceFmProj.getDataSourcesFolder().getDataSourceCollection();
        ArrayList<FmDataSource> sourceDataSources = new ArrayList<FmDataSource>(list.size());
        sourceDataSources.addAll(list);
        FmCopyManager.copy((FMMDSession)this.m_session, (BaseObject)targetFmProj.getDataSourcesFolder(), sourceDataSources);
        List<ParameterMapBase> parameterMaps = sourceFmProj.getParameterMapsFolder().getParameterMaps();
        ArrayList<ParameterMapBase> sourceParameterMaps = new ArrayList<ParameterMapBase>(parameterMaps.size());
        sourceParameterMaps.addAll(parameterMaps);
        FmCopyManager.copy((FMMDSession)this.m_session, (BaseObject)targetFmProj.getParameterMapsFolder(), sourceParameterMaps);
        try {
            OutputStream outStream = projManager.getAccess().getOutputStream(ProjectAccess.ProjectFile.MODEL_XML);
            r.save(outStream, null);
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io);
        }
    }
}

