/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.platform.impl;

import com.ibm.cognos.fmeng.platform.impl.EMFModelChanges;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.platform.transaction.ModelChanges;
import com.ibm.cognos.fmeng.platform.transaction.TransactionSession;
import com.ibm.cognos.fmeng.platform.transaction.TransactionWork;
import com.ibm.cognos.fmeng.utility.DebugUtil;
import java.util.Vector;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class TransactionWorkCommand
extends ChangeCommand
implements Runnable,
TransactionSession {
    private Vector<TransactionWork> m_work;
    private Thread m_thread;
    EditingDomain m_transactionDomain;
    private boolean m_transactionValid;
    private boolean m_rollbackTransaction;
    private Throwable m_error;
    private EMFSession m_session;

    public TransactionWorkCommand(EditingDomain domain, String name, EMFSession session) {
        super((Notifier)domain.getResourceSet());
        this.m_transactionDomain = domain;
        this.m_work = new Vector();
        this.m_thread = new Thread(this);
        this.m_thread.setDaemon(true);
        this.m_transactionValid = true;
        this.m_rollbackTransaction = false;
        this.m_session = session;
        this.m_thread.start();
        super.setLabel(name);
    }

    public void destroy() {
        this.m_transactionDomain = null;
        this.m_work.removeAllElements();
        this.m_work = null;
        this.m_thread = null;
        this.m_transactionValid = false;
        this.m_error = null;
        this.m_session = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelChanges waitForWorkToBeDone(TransactionWork work) {
        if (Thread.holdsLock(this.m_work)) {
            work.work();
            return work.getModelChanges();
        }
        Object object = this.m_work;
        synchronized (object) {
            this.m_work.add(work);
            this.m_work.notifyAll();
        }
        try {
            object = work;
            synchronized (object) {
                if (!work.isComplete()) {
                    work.wait();
                    if (this.m_error != null) {
                        Throwable t = this.m_error;
                        this.m_error = null;
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        throw new RuntimeException(t.getMessage(), t);
                    }
                    return work.getModelChanges();
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction() {
        Thread t = this.m_thread;
        Vector<TransactionWork> vector = this.m_work;
        synchronized (vector) {
            this.m_transactionValid = false;
            this.m_work.notifyAll();
        }
        try {
            t.join();
        }
        catch (InterruptedException ie) {
            DebugUtil.GetInstance().debug(ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction() {
        Thread t = this.m_thread;
        Vector<TransactionWork> vector = this.m_work;
        synchronized (vector) {
            this.m_transactionValid = false;
            this.m_rollbackTransaction = true;
            this.m_work.notifyAll();
        }
        try {
            t.join();
        }
        catch (InterruptedException ie) {
            DebugUtil.GetInstance().debug(ie);
        }
    }

    public void run() {
        CommandStack tStack = this.m_transactionDomain.getCommandStack();
        tStack.execute((Command)this);
        if (this.m_rollbackTransaction) {
            this.undo();
        }
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute() {
        while (this.m_transactionValid) {
            Vector<TransactionWork> vector = this.m_work;
            synchronized (vector) {
                if (this.m_transactionValid) {
                    if (this.m_work.size() > 0) {
                        TransactionWork work = this.m_work.elementAt(0);
                        this.m_work.remove(0);
                        try {
                            EMFModelChanges modelChanges = new EMFModelChanges(this.m_session);
                            work.work();
                            modelChanges.disconnect();
                            work.setModelChanges(modelChanges);
                        }
                        catch (Throwable t) {
                            this.m_error = t;
                        }
                        TransactionWork transactionWork = work;
                        synchronized (transactionWork) {
                            work.setComplete(true);
                            work.notifyAll();
                        }
                    }
                    try {
                        this.m_work.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
            }
        }
    }
}

