/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.platform.impl;

import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public abstract class UpgradeBase {
    protected OutputStream m_OutputStream = null;
    DefaultHandler handler = new DefaultHandler(){

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            AttributesImpl impl = new AttributesImpl();
            impl.setAttributes(attributes);
            UpgradeBase.this.upgradeStartElement(uri, localName, qName, impl);
        }

        public void endElement(String uri, String localName, String qName) {
            UpgradeBase.this.upgradeEndElement(uri, localName, qName);
        }

        public void characters(char[] ch, int start, int length) {
            UpgradeBase.this.upgradeCharacters(ch, start, length);
        }

        public void processingInstruction(String target, String data) {
            UpgradeBase.this.upgradeProcessingInstruction(target, data);
        }

        public void notationDecl(String name, String publicId, String systemId) {
        }

        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
        }
    };

    public abstract String getDestinationURI();

    public abstract String getSchemaLocation();

    public abstract int getDestinationVersion();

    public int upgrade(InputStream is, File of) {
        String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        try {
            this.m_OutputStream = new FileOutputStream(of);
            this.m_OutputStream.write(header.getBytes("UTF-8"));
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(is, this.handler);
            this.m_OutputStream.close();
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io);
        }
        catch (SAXException se) {
            throw new RuntimeException(se.getMessage(), se);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce.getMessage(), pce);
        }
        return this.getDestinationVersion();
    }

    public void upgradeStartElement(String uri, String localName, String qName, AttributesImpl attributes) {
        StringBuilder builder = new StringBuilder("<");
        builder.append(qName);
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getQName(i);
            String value = StringEscapeUtils.escapeXml((String)attributes.getValue(i));
            builder.append(" ");
            builder.append(name);
            builder.append("=\"");
            builder.append(value);
            builder.append("\"");
            ++i;
        }
        builder.append(">");
        this.write(builder.toString());
    }

    public void upgradeEndElement(String uri, String localName, String qName) {
        String endElement = "</" + qName + ">";
        this.write(endElement);
    }

    public void upgradeCharacters(char[] ch, int start, int length) {
        StringBuffer out = new StringBuffer();
        out.append(StringEscapeUtils.escapeXml((String)String.copyValueOf(ch, start, length)));
        this.write(out.toString());
    }

    public void upgradeProcessingInstruction(String target, String data) {
    }

    protected AttributesImpl upgradeURI(AttributesImpl attributes) {
        AttributesImpl newAttr = new AttributesImpl();
        int i = 0;
        while (i < attributes.getLength()) {
            String attrqname = attributes.getQName(i);
            String value = attributes.getValue(i);
            if (attrqname.equals("xmlns")) {
                value = this.getDestinationURI();
            }
            if (attrqname.equals("xsi:schemaLocation")) {
                value = this.getSchemaLocation();
            }
            newAttr.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attrqname, attributes.getType(i), value);
            ++i;
        }
        return newAttr;
    }

    protected void write(String toWrite) {
        try {
            this.m_OutputStream.write(toWrite.getBytes("UTF-8"));
        }
        catch (IOException e) {
            FmEngApplicationLog.getApplicationLog().logException(e);
        }
    }
}

