/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.platform.impl.action;

import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;

public class EMFHandle {
    private EObject m_emfObject;
    private EAttribute m_emfAttribute;
    private String m_emfPropertyName;
    private EObject m_referencedEMFObject;
    private EStructuralFeature m_feature;

    public EMFHandle(EObject obj, EAttribute att) {
        this.m_emfObject = obj;
        this.m_emfAttribute = att;
        this.m_emfPropertyName = att.getName();
    }

    public EMFHandle(EObject obj, String propertyName) {
        this.m_emfObject = obj;
        this.m_emfPropertyName = propertyName;
    }

    public EMFHandle(EObject obj) {
        this.m_emfObject = obj;
    }

    public EMFHandle(EObject parentObject, EReference structFeature, EObject referencedObject) {
        this.m_emfObject = parentObject;
        this.m_emfPropertyName = structFeature.getName();
        this.m_referencedEMFObject = referencedObject;
    }

    public EMFHandle(EObject parent, EStructuralFeature feature) {
        this.m_emfObject = parent;
        this.m_feature = feature;
    }

    public EObject getEObject() {
        return this.m_emfObject;
    }

    public EAttribute getEAttribute() {
        return this.m_emfAttribute;
    }

    public boolean isProperty() {
        return this.m_emfPropertyName != null || this.m_feature != null;
    }

    public boolean isReference() {
        return this.m_referencedEMFObject != null;
    }

    public EObject getReferencedObject() {
        return this.m_referencedEMFObject;
    }

    public String getElementName() {
        if (this.isProperty()) {
            if (this.isOptional()) {
                return this.m_feature.getName();
            }
            return this.m_emfPropertyName;
        }
        return this.m_emfObject.eContainingFeature().getName();
    }

    public boolean isOptional() {
        return this.m_feature != null;
    }

    public void createOptional(String activeLocale) {
        EFactory factory = this.m_emfObject.eClass().getEPackage().getEFactoryInstance();
        EObject value = factory.create((EClass)this.m_feature.getEType());
        Object obj = this.m_emfObject.eGet(this.m_feature);
        if (obj instanceof List) {
            List l = (List)obj;
            l.add(value);
        } else {
            this.m_emfObject.eSet(this.m_feature, (Object)value);
        }
        EStructuralFeature localeFeature = value.eClass().getEStructuralFeature("locale");
        if (localeFeature != null) {
            value.eSet(localeFeature, (Object)activeLocale);
        }
        this.m_emfObject = value;
        this.m_emfPropertyName = this.m_feature.getName();
        this.m_feature = null;
    }

    public static EMFHandle SolveForPropertyHandle(String propertyName, int propertyIndex, EObject parent, EMFSession session) {
        EClassifier classifier;
        EReference ref;
        if (parent == null) {
            return null;
        }
        EStructuralFeature feature = ExtendedMetaData.INSTANCE.getElement(parent.eClass(), "http://www.developer.cognos.com/schemas/bmt/60/13", propertyName);
        if (feature == null) {
            feature = parent.eClass().getEStructuralFeature(propertyName);
        }
        FmMDException.ASSERT(feature != null, "Bad property name in EMFHandle::SolveForPropertyHandle(): " + propertyName);
        Object res = parent.eGet(feature);
        if (feature instanceof EReference && !(ref = (EReference)feature).isContainment()) {
            return new EMFHandle(parent, ref, (EObject)res);
        }
        EMFHandle retValue = null;
        if (res instanceof List) {
            Object eObj;
            List l = (List)res;
            if (l.size() == 0) {
                return new EMFHandle(parent, feature);
            }
            if (propertyIndex < l.size() && (eObj = l.get(propertyIndex)) instanceof EObject) {
                retValue = new EMFHandle((EObject)eObj, propertyName);
            }
        } else if (res instanceof EObject) {
            retValue = new EMFHandle((EObject)res, propertyName);
        } else if (res == null && EObject.class.isAssignableFrom((classifier = feature.getEType()).getInstanceClass())) {
            retValue = new EMFHandle(parent, feature);
        }
        if (retValue == null) {
            retValue = new EMFHandle(parent, propertyName);
        }
        return retValue;
    }
}

