/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.platform.impl.gateway;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.genmodel.DeterminantType;
import com.ibm.cognos.fmeng.genmodel.DimensionType;
import com.ibm.cognos.fmeng.genmodel.ExpressionType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.MacroType;
import com.ibm.cognos.fmeng.genmodel.MeasureType;
import com.ibm.cognos.fmeng.genmodel.MunType;
import com.ibm.cognos.fmeng.genmodel.PropertyType;
import com.ibm.cognos.fmeng.genmodel.QueryItemType;
import com.ibm.cognos.fmeng.genmodel.QuerySubjectType;
import com.ibm.cognos.fmeng.genmodel.ShortcutType;
import com.ibm.cognos.fmeng.genmodel.SqlType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.EMFIDGenerator;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.platform.impl.ObjectLookup;
import com.ibm.cognos.fmeng.utility.EMFCustomModelSerializer;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.SerializationListener;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EMFModelGateway {
    private Resource m_resource;
    private EMFSession m_session;

    public EMFModelGateway(FMMDSession session) {
        this.m_resource = ((EMFSession)session).getResource();
        this.m_session = (EMFSession)session;
        EList adaptors = this.m_resource.eAdapters();
        for (Adapter a : adaptors) {
            if (a instanceof ObjectLookup) break;
        }
    }

    public void destroy() {
        this.m_resource = null;
    }

    public void delete(Object obj) {
        EcoreUtil.delete((EObject)((EObject)obj));
    }

    public Object getParent(Object obj) {
        EObject res = ((EObject)obj).eContainer();
        Object lp = this.m_session.getLinkedParent(res);
        if (lp != null) {
            return lp;
        }
        return res;
    }

    public String getTagName(Object obj) {
        return ((EObject)obj).eContainingFeature().getName();
    }

    public boolean isAncestor(Object obj1, Object obj2) {
        return EcoreUtil.isAncestor((EObject)((EObject)obj1), (EObject)((EObject)obj2));
    }

    public boolean canContain(Object obj, Object childObject) {
        EClass parentClass = ((EObject)obj).eClass();
        EObject childObj = (EObject)childObject;
        EClass childClass = childObj.eClass();
        EList features = parentClass.getEAllStructuralFeatures();
        for (EStructuralFeature feature : features) {
            if (feature.getEType().getClassifierID() != childClass.getClassifierID()) continue;
            return true;
        }
        return false;
    }

    public String getID(Object obj) {
        EObject eObj = (EObject)obj;
        return ((XMLResource)eObj.eResource()).getID(eObj);
    }

    public String generateID(Object obj, String name) {
        EObject eObj = (EObject)obj;
        return EMFIDGenerator.generateIDUsingName(eObj.eContainer(), eObj, name);
    }

    public String generateIDForObjectUsingName(Object obj, String name) {
        EObject eObj = (EObject)obj;
        return EMFIDGenerator.generateIDUsingName(eObj.eContainer(), eObj, name);
    }

    public String generateIDUsingName(Object obj, FmObjectType objType, String name) {
        return EMFIDGenerator.generateIDUsingName((EObject)obj, objType.getClassType(), name);
    }

    public List<?> getChildren(Object obj) {
        EObject eObj = (EObject)obj;
        return eObj.eContents();
    }

    public String asXML(Object obj, boolean includeRoot) {
        EObject eObj = (EObject)obj;
        String definitionXml = null;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        SerializationListener sl = null;
        XMLResource res = (XMLResource)eObj.eResource();
        if (res == null) {
            return "<corrupted/>";
        }
        EMFCustomModelSerializer serializer = new EMFCustomModelSerializer(outStream, res, sl);
        serializer.serialize(eObj, includeRoot);
        try {
            definitionXml = outStream.toString("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return definitionXml;
    }

    public int getClassifierType(Object obj) {
        EObject eObj = (EObject)obj;
        return eObj.eClass().getClassifierID();
    }

    public void clearProperty(Object obj, int featureType) {
        EObject eObj = (EObject)obj;
        eObj.eUnset(eObj.eClass().getEStructuralFeature(featureType));
    }

    public Object copyObject(Object obj) {
        EObject emfObject = EcoreUtil.copy((EObject)((EObject)obj));
        return emfObject;
    }

    public static void copyChidrenFrom(Object source, Object destination) {
        ChildCopier copier = new ChildCopier();
        copier.copySourceChildren((EObject)source, (EObject)destination);
        copier.copyReferences();
    }

    public List<Object> getAncestorList(Object start, Object end) {
        EObject startObj = (EObject)start;
        EObject endObject = (EObject)end;
        ArrayList<Object> retList = new ArrayList<Object>();
        if (startObj != endObject) {
            EObject parent = (EObject)this.getParent(startObj);
            while (parent != null) {
                retList.add(parent);
                if (parent == endObject) break;
                parent = parent.eContainer();
            }
            if (parent == null) {
                retList.clear();
            }
        }
        return retList;
    }

    public List<Object> getAncestorList(Object obj) {
        ArrayList<Object> al = new ArrayList<Object>();
        EObject parent = (EObject)obj;
        while (parent != null && parent.eClass().getClassifierID() != 108) {
            al.add(parent);
            parent = (EObject)this.getParent(parent);
        }
        return al;
    }

    public Object getAncestorOfType(Object obj, int ancestorClassifierId) {
        EObject parent = (EObject)obj;
        while (parent != null) {
            if (parent.eClass().getClassifierID() == ancestorClassifierId) {
                return parent;
            }
            parent = parent.eContainer();
        }
        return null;
    }

    public Object getCommonAncestor(Object obj1, Object obj2) {
        if (obj1.equals(obj2)) {
            return this.getParent(obj1);
        }
        List<Object> list1 = this.getAncestorList(obj1);
        List<Object> list2 = this.getAncestorList(obj2);
        ListIterator<Object> list1Iter = list1.listIterator(list1.size() - 1);
        ListIterator<Object> list2Iter = list2.listIterator(list2.size() - 1);
        while (list1Iter.hasPrevious() && list2Iter.hasPrevious()) {
            EObject list2Item;
            EObject list1Item = (EObject)list1Iter.previous();
            if (list1Item == (list2Item = (EObject)list2Iter.previous()) || !list1Iter.hasNext()) continue;
            list1Iter.next();
            return list1Iter.next();
        }
        return null;
    }

    public static MacroType createMacroType(String value) {
        MacroType macType = GenmodelFactory.eINSTANCE.createMacroType();
        FeatureMap map = macType.getMixed();
        FeatureMap.Entry entry = FeatureMapUtil.createTextEntry((String)value);
        map.add((Object)entry);
        return macType;
    }

    public static String getMacroTypeValue(MacroType mt) {
        FeatureMap map = mt.getMixed();
        if (map.size() > 0) {
            return map.getValue(0).toString();
        }
        return null;
    }

    public static String getPropertyTypeValue(PropertyType type) {
        FeatureMap map = type.getMixed();
        if (map.size() > 0) {
            return map.getValue(0).toString();
        }
        return null;
    }

    public static void setPropertyTypeValue(PropertyType mt, String str) {
        FeatureMap map = mt.getMixed();
        FeatureMap.Entry entry = FeatureMapUtil.createTextEntry((String)str);
        map.clear();
        map.add((Object)entry);
    }

    public static void setMacroTypeValue(MacroType mt, String str) {
        FeatureMap map = mt.getMixed();
        FeatureMap.Entry entry = FeatureMapUtil.createTextEntry((String)str);
        map.clear();
        map.add((Object)entry);
    }

    public static void setSqlTypeValue(SqlType sql, String sqlStr) {
        FeatureMap mixed = sql.getMixed();
        if (sqlStr == null) {
            sqlStr = "";
        }
        FeatureMap.Entry entry = FeatureMapUtil.createTextEntry((String)sqlStr);
        mixed.clear();
        mixed.add((Object)entry);
    }

    public static void addTextValueToSQL(SqlType sql, String value) {
        FeatureMap featureMap = sql.getMixed();
        FeatureMap.Entry entry = FeatureMapUtil.createTextEntry((String)value);
        featureMap.add((Object)entry);
    }

    public static void addFeatureToSQL(SqlType sqltype, int featureValue, Object value) {
        FeatureMap featureMap = sqltype.getMixed();
        FeatureMap.Entry entry = FeatureMapUtil.createEntry((EStructuralFeature)sqltype.eClass().getEStructuralFeature(featureValue), (Object)value);
        featureMap.add((Object)entry);
    }

    public static void addTextValueToExpression(ExpressionType expressionType, String value) {
        FeatureMap featureMap = expressionType.getMixed();
        FeatureMap.Entry entry = FeatureMapUtil.createTextEntry((String)value);
        featureMap.add((Object)entry);
    }

    public static void addFeatureToExpression(ExpressionType expressionType, int featureValue, Object value) {
        FeatureMap featureMap = expressionType.getMixed();
        FeatureMap.Entry entry = FeatureMapUtil.createEntry((EStructuralFeature)expressionType.eClass().getEStructuralFeature(featureValue), (Object)value);
        featureMap.add((Object)entry);
    }

    public static void substituteFeatureInExpression(ExpressionType expressionType, int featureValue, int index, Object value) {
        FeatureMap featureMap = expressionType.getMixed();
        FeatureMap.Entry entry = FeatureMapUtil.createEntry((EStructuralFeature)expressionType.eClass().getEStructuralFeature(featureValue), (Object)value);
        featureMap.add(index, (Object)entry);
        featureMap.remove(index + 1);
    }

    public static void addTextValueToMemberUniqueName(MunType munType, String value) {
        FeatureMap featureMap = munType.getMixed();
        FeatureMap.Entry entry = FeatureMapUtil.createTextEntry((String)value);
        featureMap.add((Object)entry);
    }

    public static void addFeatureToMemberUniqueName(MunType munType, int featureValue, Object value) {
        FeatureMap featureMap = munType.getMixed();
        FeatureMap.Entry entry = FeatureMapUtil.createEntry((EStructuralFeature)munType.eClass().getEStructuralFeature(featureValue), (Object)value);
        featureMap.add((Object)entry);
    }

    public Object resolveProxy(Object object) {
        EObject obj = (EObject)object;
        if (obj.eIsProxy()) {
            return EcoreUtil.resolve((EObject)obj, (Resource)obj.eResource());
        }
        return obj;
    }

    public void createAllMandatory(Object obj, boolean recurseIntoNonMandatory) {
        EObject eObj = (EObject)obj;
        EFactory factory = eObj.eClass().getEPackage().getEFactoryInstance();
        this.createAllMandatory(eObj, factory, recurseIntoNonMandatory);
    }

    private void createAllMandatory(Object obj, EFactory factory, boolean recurseIntoNonMandatory) {
        EObject eObj = (EObject)obj;
        EList sfs = eObj.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature sf : sfs) {
            Object value;
            if (sf.isRequired() && !sf.isMany()) {
                if (!(sf.getEType() instanceof EClass)) continue;
                value = factory.create((EClass)sf.getEType());
                eObj.eSet(sf, value);
                this.createAllMandatory(value, factory, recurseIntoNonMandatory);
                continue;
            }
            if (!recurseIntoNonMandatory || !eObj.eIsSet(sf) || !((value = eObj.eGet(sf)) instanceof EObject)) continue;
            this.createAllMandatory((EObject)value, factory, recurseIntoNonMandatory);
        }
    }

    public void unparent(Object internal) {
        EObject eObj = (EObject)internal;
        EcoreUtil.remove((EObject)eObj);
    }

    public void reorderBefore(Object parent, Object toMove, Object reference) {
        if (toMove == reference) {
            return;
        }
        EObject eParent = (EObject)parent;
        EObject eToMove = (EObject)toMove;
        EObject eReference = (EObject)reference;
        EReference containingFeature = eToMove.eContainmentFeature();
        if (containingFeature instanceof BasicExtendedMetaData.EStructuralFeatureExtendedMetaData.Holder) {
            BasicExtendedMetaData.EStructuralFeatureExtendedMetaData.Holder holder = (BasicExtendedMetaData.EStructuralFeatureExtendedMetaData.Holder)containingFeature;
            BasicExtendedMetaData.EStructuralFeatureExtendedMetaData x = holder.getExtendedMetaData();
            EStructuralFeature group = null;
            if (x != null) {
                group = x.getGroup();
            }
            if (group != null) {
                FeatureMap featureMap = (FeatureMap)eParent.eGet(group);
                ListIterator iterator = featureMap.listIterator();
                FeatureMap.Entry referenceEntry = null;
                while (iterator.hasNext()) {
                    FeatureMap.Entry next = (FeatureMap.Entry)iterator.next();
                    if (next.getValue() == toMove) {
                        iterator.remove();
                        continue;
                    }
                    if (next.getValue() != reference) continue;
                    referenceEntry = next;
                }
                if (referenceEntry != null) {
                    int index = featureMap.indexOf(referenceEntry);
                    FeatureMap.Entry entry = FeatureMapUtil.createEntry((EStructuralFeature)containingFeature, (Object)eToMove);
                    featureMap.add(index, (Object)entry);
                } else {
                    FeatureMap.Entry entry = FeatureMapUtil.createEntry((EStructuralFeature)containingFeature, (Object)eToMove);
                    featureMap.add((Object)entry);
                }
                return;
            }
            Object obj = eParent.eGet((EStructuralFeature)containingFeature);
            List l = (List)obj;
            l.remove(toMove);
            int refIdx = -1;
            if (eReference != null) {
                refIdx = l.indexOf(eReference);
            }
            if (refIdx != -1) {
                l.add(refIdx, toMove);
            } else {
                l.add(toMove);
            }
            return;
        }
        FmMDException.ASSERT(false, "FAiled to handle reorder");
    }

    public boolean isValid(Object object) {
        return ((EObject)object).eResource() != null;
    }

    public static void replaceReferencesTo(Object session, Object refObj, Object replacedObj, Object startAt) {
        EObject modelEObj = (EObject)((EMFSession)session).getProject().getRootNamespace().getInternal();
        Collection references = EcoreUtil.UsageCrossReferencer.find((EObject)((EObject)refObj), (EObject)modelEObj);
        if (references != null) {
            for (EStructuralFeature.Setting setting : references) {
                if (setting.getEObject().eContainer() instanceof DeterminantType) continue;
                if (setting.getEObject() instanceof ExpressionType) {
                    ExpressionType et = (ExpressionType)setting.getEObject();
                    FeatureMap fm = et.getGroup();
                    int idx = 0;
                    while (idx < fm.size()) {
                        FeatureMap.Entry exprEntry = (FeatureMap.Entry)fm.get(idx);
                        if (exprEntry.getValue().equals(refObj)) {
                            FeatureMap.Entry entry = FeatureMapUtil.createEntry((EStructuralFeature)et.eClass().getEStructuralFeature(3), (Object)replacedObj);
                            fm.set(idx, (Object)entry);
                        }
                        ++idx;
                    }
                    continue;
                }
                setting.set(replacedObj);
                if (!(setting.getEObject() instanceof ShortcutType)) continue;
                ShortcutType sc = (ShortcutType)setting.getEObject();
                if (replacedObj instanceof DimensionType) {
                    sc.setTargetType("dimension");
                    continue;
                }
                if (replacedObj instanceof QuerySubjectType) {
                    sc.setTargetType("querySubject");
                    continue;
                }
                if (replacedObj instanceof QueryItemType) {
                    sc.setTargetType("queryItem");
                    continue;
                }
                if (!(replacedObj instanceof MeasureType)) continue;
                sc.setTargetType("measure");
            }
        }
    }

    static class ChildCopier
    extends EcoreUtil.Copier {
        private static final long serialVersionUID = -1038380675611695192L;

        public void copySourceChildren(EObject source, EObject destination) {
            this.put(source, destination);
            EList features = this.findCommonClass(source.eClass(), destination.eClass()).getEAllStructuralFeatures();
            for (EStructuralFeature feature : features) {
                if (!feature.isChangeable() || feature.isDerived()) continue;
                if (feature instanceof EAttribute) {
                    this.copyAttribute((EAttribute)feature, source, destination);
                    continue;
                }
                EReference ref = (EReference)feature;
                if (!ref.isContainment()) continue;
                this.copyContainment(ref, source, destination);
            }
            this.copyProxyURI(source, destination);
        }

        private EClass findCommonClass(EClass class1, EClass class2) {
            if (class1.equals(class2)) {
                return class1;
            }
            EList list1 = class1.getEAllSuperTypes();
            EList list2 = class2.getEAllSuperTypes();
            ListIterator list1Iter = list1.listIterator();
            ListIterator list2Iter = list2.listIterator();
            while (list2Iter.hasNext() && list2Iter.hasNext()) {
                EClass list2Item;
                EClass list1Item = (EClass)list1Iter.next();
                if (list1Item == (list2Item = (EClass)list2Iter.next())) continue;
                return (EClass)list1Iter.previous();
            }
            return (EClass)list1.get(list1.size() - 1);
        }

        public void copyReferences() {
            for (Map.Entry entry : this.entrySet()) {
                EObject eObject = (EObject)entry.getKey();
                EObject copyEObject = (EObject)entry.getValue();
                EClass eClass = this.findCommonClass(eObject.eClass(), copyEObject.eClass());
                int j = 0;
                int size = eClass.getFeatureCount();
                while (j < size) {
                    block9: {
                        EStructuralFeature eStructuralFeature;
                        block10: {
                            eStructuralFeature = eClass.getEStructuralFeature(j);
                            if (!eStructuralFeature.isChangeable() || eStructuralFeature.isDerived()) break block9;
                            if (!(eStructuralFeature instanceof EReference)) break block10;
                            EReference eReference = (EReference)eStructuralFeature;
                            if (!eReference.isContainment() && !eReference.isContainer()) {
                                this.copyReference(eReference, eObject, copyEObject);
                            }
                            break block9;
                        }
                        if (!FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature)) break block9;
                        FeatureMap featureMap = (FeatureMap)eObject.eGet(eStructuralFeature);
                        FeatureMap copyFeatureMap = (FeatureMap)copyEObject.eGet(this.getTarget(eStructuralFeature));
                        int copyFeatureMapSize = copyFeatureMap.size();
                        int k = 0;
                        int featureMapSize = featureMap.size();
                        while (k < featureMapSize) {
                            block8: {
                                block11: {
                                    Object copyReferencedEObject;
                                    EStructuralFeature feature;
                                    block12: {
                                        feature = featureMap.getEStructuralFeature(k);
                                        if (!(feature instanceof EReference)) break block11;
                                        Object referencedEObject = featureMap.getValue(k);
                                        copyReferencedEObject = this.get(referencedEObject);
                                        if (copyReferencedEObject != null || referencedEObject == null) break block12;
                                        EReference reference = (EReference)feature;
                                        if (!this.useOriginalReferences || reference.isContainment() || reference.getEOpposite() != null) break block8;
                                        copyReferencedEObject = referencedEObject;
                                    }
                                    if (!copyFeatureMap.add(feature, copyReferencedEObject)) {
                                        int l = 0;
                                        while (l < copyFeatureMapSize) {
                                            if (copyFeatureMap.getEStructuralFeature(l) == feature && copyFeatureMap.getValue(l) == copyReferencedEObject) {
                                                copyFeatureMap.move(copyFeatureMap.size() - 1, l);
                                                --copyFeatureMapSize;
                                                break block8;
                                            }
                                            ++l;
                                        }
                                    }
                                    break block8;
                                }
                                copyFeatureMap.add((Object)((FeatureMap.Entry)featureMap.get(k)));
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
        }
    }
}

