/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.platform.impl.project;

import com.ibm.cognos.fmeng.platform.ProjectAccess;
import com.ibm.cognos.fmeng.platform.impl.project.FmProjectAccess;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmPreferences;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FMProjectFileAccessImpl
extends FmProjectAccess
implements ProjectAccess {
    private String m_projectFile = null;
    private String m_modelFile = null;
    private String m_baseLocation = null;
    private String m_testMetadataFile = null;

    public FMProjectFileAccessImpl(String baseLocation) {
        File base = new File(baseLocation);
        if (baseLocation.endsWith(".cpf")) {
            this.m_projectFile = baseLocation;
            this.m_testMetadataFile = String.valueOf(base.getParent()) + File.separatorChar + "relationalPhysicalMetadata.xml";
            this.m_modelFile = String.valueOf(base.getParent()) + File.separatorChar + "model.xml";
        } else if (baseLocation.endsWith(".xml") || baseLocation.endsWith(".fmd")) {
            this.m_modelFile = baseLocation;
            this.m_projectFile = null;
        } else {
            this.m_modelFile = String.valueOf(baseLocation) + File.separatorChar + "model.xml";
            this.m_projectFile = String.valueOf(baseLocation) + File.separatorChar + base.getName() + ".cpf";
            this.m_testMetadataFile = String.valueOf(baseLocation) + File.separatorChar + "relationalPhysicalMetadata.xml";
        }
        this.initializeBaseLocation();
    }

    public FMProjectFileAccessImpl(String projectFile, String modelFile, String metadataFile) {
        if (!"".equals(projectFile)) {
            this.m_projectFile = projectFile;
        }
        this.m_modelFile = modelFile;
        if (metadataFile != null && metadataFile.length() != 0) {
            this.m_testMetadataFile = metadataFile;
        }
        this.initializeBaseLocation();
    }

    private void initializeBaseLocation() {
        File modelBase = new File(this.m_modelFile);
        File absoluteBase = new File(modelBase.getAbsolutePath());
        this.m_baseLocation = absoluteBase.getParent();
    }

    public String getFileName(ProjectAccess.ProjectFile file) {
        switch (file) {
            case CPF_FILE: {
                return this.m_projectFile;
            }
            case MODEL_XML: {
                return this.m_modelFile;
            }
            case TEST_PHYSICAL_FILE_RELATIONAL: {
                return this.m_testMetadataFile;
            }
        }
        return null;
    }

    public InputStream getRelativeFile(String fileName) {
        try {
            return new FileInputStream(new File(this.m_baseLocation, fileName));
        }
        catch (FileNotFoundException fnf) {
            throw new RuntimeException(fnf.getMessage(), fnf);
        }
    }

    public InputStream getRawFile(ProjectAccess.ProjectFile file) {
        try {
            File f;
            String filename = this.getFileName(file);
            if (filename != null && (f = new File(filename)).exists()) {
                FileInputStream is = new FileInputStream(filename);
                return is;
            }
            return null;
        }
        catch (FileNotFoundException fe) {
            throw new RuntimeException(fe.getMessage(), fe);
        }
    }

    public OutputStream getOutputStream(ProjectAccess.ProjectFile file) {
        try {
            switch (file) {
                case CPF_FILE: {
                    return new FileOutputStream(this.m_projectFile);
                }
                case MODEL_XML: {
                    return new FileOutputStream(this.m_modelFile);
                }
            }
        }
        catch (FileNotFoundException fnf) {
            throw new RuntimeException(fnf.getMessage(), fnf);
        }
        return null;
    }

    public void create() {
        if (this.m_projectFile != null) {
            File model = new File(this.m_modelFile);
            if (!model.exists()) {
                InputStream srcModelFile = this.getClass().getResourceAsStream("/templates/bmt/Cr1Model/model.xml");
                this.copyStream(srcModelFile, model);
            }
            if (this.m_projectFile != null) {
                InputStream srcProjFile = this.getClass().getResourceAsStream("/templates/bmt/Cr1Model/project.cpf");
                this.copyStream(srcProjFile, new File(this.m_projectFile));
            }
        } else {
            File model = new File(this.m_modelFile);
            InputStream srcModelFile = this.getClass().getResourceAsStream("/templates/bmt/Cr1Model/model.xml");
            this.copyStream(srcModelFile, model);
        }
    }

    private void copyStream(InputStream in, File destFile) {
        try {
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
            FileOutputStream out = new FileOutputStream(destFile);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            Object[] msgParams = new Object[]{destFile.getPath()};
            throw new FmMDException("BMT_MD_JAVA_IO_ERROR", msgParams, ex);
        }
    }

    public ProjectAccess getProjectFileAccess(String projectPath) {
        return new FMProjectFileAccessImpl(this.resolveToAbsolutePath(projectPath));
    }

    public boolean hasFile(ProjectAccess.ProjectFile file) {
        File actualFile;
        String filename = this.getFileName(file);
        return filename != null && (actualFile = new File(filename)).exists() && actualFile.length() != 0L;
    }

    private String resolveToAbsolutePath(String path) {
        if (path.startsWith(".")) {
            File modelFile = new File(this.m_baseLocation, path);
            return modelFile.getAbsolutePath();
        }
        try {
            File f = new File(path);
            File parent = f.getParentFile();
            parent.mkdirs();
            return f.getCanonicalPath();
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io);
        }
    }

    public void setBytes(ProjectAccess.ProjectFile file, byte[] bytes) {
    }

    public boolean hasHardCodedMetadataFile() {
        return this.m_testMetadataFile != null && this.m_testMetadataFile.length() != 0;
    }

    public String getPhysicalMetadataFileName(String cmDataSourceName, String catalogName, String schemaName) {
        if (this.m_testMetadataFile != null && this.m_testMetadataFile.length() != 0) {
            return this.m_testMetadataFile;
        }
        String dataDir = FmPreferences.getInstance().getDataDirectory();
        File dir = new File(dataDir);
        if (!dir.exists()) {
            dir.mkdir();
        }
        return String.valueOf(dataDir) + "/relmd_" + cmDataSourceName + "_" + catalogName + "_" + schemaName + ".xml";
    }

    public boolean ignoreCache() {
        return false;
    }

    public String toString() {
        return "file-based model: " + this.m_modelFile;
    }
}

