/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.platform.impl.project;

import com.ibm.cognos.fmeng.platform.ProjectAccess;
import com.ibm.cognos.fmeng.platform.impl.project.FmProjectAccess;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmPreferences;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FmInMemoryProjectAccessImpl
extends FmProjectAccess
implements ProjectAccess {
    byte[] m_model;
    boolean m_ignoreCache;

    public FmInMemoryProjectAccessImpl(boolean ignoreCache) {
        this.m_ignoreCache = ignoreCache;
    }

    public void create() {
        try {
            InputStream srcModelFile = this.getClass().getResourceAsStream("/templates/bmt/Cr1Model/model.xml");
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            this.copyStream(srcModelFile, outStream);
            this.m_model = outStream.toByteArray();
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io);
        }
    }

    public InputStream getRawFile(ProjectAccess.ProjectFile file) {
        switch (file) {
            case MODEL_XML: {
                return new ByteArrayInputStream(this.m_model);
            }
        }
        FmMDException.ASSERT(false, "Unsupported: getFile");
        return null;
    }

    public String getFileName(ProjectAccess.ProjectFile file) {
        switch (file) {
            case MODEL_XML: {
                return "memfile";
            }
        }
        FmMDException.ASSERT(false, "Unsupported: getFileName");
        return null;
    }

    public OutputStream getOutputStream(ProjectAccess.ProjectFile file) {
        switch (file) {
            // Empty switch
        }
        FmMDException.ASSERT(false, "Unsupported: getOutputStream");
        return null;
    }

    public ProjectAccess getProjectFileAccess(String projectPath) {
        FmMDException.ASSERT(false, "Unsupported: getProjectFileAccess");
        return null;
    }

    public InputStream getRelativeFile(String fileName) {
        FmMDException.ASSERT(false, "Unsupported: getRelativeFile");
        return null;
    }

    public boolean hasFile(ProjectAccess.ProjectFile file) {
        switch (file) {
            case CPF_FILE: {
                return false;
            }
            case MODEL_XML: {
                return true;
            }
        }
        return false;
    }

    public void setBytes(ProjectAccess.ProjectFile file, byte[] bytes) {
        switch (file) {
            case CPF_FILE: {
                break;
            }
            case MODEL_XML: {
                this.m_model = bytes;
            }
        }
    }

    public boolean hasHardCodedMetadataFile() {
        return false;
    }

    public boolean ignoreCache() {
        return this.m_ignoreCache;
    }

    public String getPhysicalMetadataFileName(String cmDataSourceName, String catalogName, String schemaName) {
        return String.valueOf(FmPreferences.getInstance().getDataDirectory()) + "/relmd_" + cmDataSourceName + "_" + catalogName + "_" + schemaName + ".xml";
    }

    public String toString() {
        return "in-memory model";
    }
}

