/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.platform.impl.project;

import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.platform.ProjectAccess;
import com.ibm.cognos.fmeng.platform.impl.UpgradeBase;
import com.ibm.cognos.fmeng.platform.impl.UpgradeGeneric;
import com.ibm.cognos.fmeng.platform.impl.UpgradeUpTo11;
import com.ibm.cognos.fmeng.platform.impl.UpgradeUpTo4;
import com.ibm.cognos.fmeng.platform.impl.UpgradeUpTo9;
import com.ibm.cognos.fmeng.utility.DebugUtil;
import com.ibm.cognos.fmeng.utility.ExtractNamespace;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmPreferences;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class FmProjectAccess
implements ProjectAccess {
    private int m_SourceVersion = -1;
    private int m_CurrentVersion = -1;

    protected void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[1024];
        int len = 0;
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
    }

    protected byte[] streamToBytes(InputStream in) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            int nRead = 0;
            byte[] data = new byte[16384];
            while ((nRead = in.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
        }
        catch (IOException e) {
            FmEngApplicationLog.getApplicationLog().logException(e);
        }
        return buffer.toByteArray();
    }

    public abstract void setBytes(ProjectAccess.ProjectFile var1, byte[] var2);

    public abstract String getPhysicalMetadataFileName(String var1, String var2, String var3);

    public abstract boolean ignoreCache();

    protected abstract InputStream getRawFile(ProjectAccess.ProjectFile var1);

    public InputStream getPhysicalMetadataFile(String cmDataSourceName, String catalogName, String schemaName) {
        if (this.ignoreCache()) {
            return null;
        }
        String relMdFileName = this.getPhysicalMetadataFileName(cmDataSourceName, catalogName, schemaName);
        try {
            File actualFile = new File(relMdFileName);
            return new FileInputStream(actualFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (NullPointerException nullPointerException) {}
        return null;
    }

    public OutputStream getPhysicalMetadataOutputStream(String cmDataSourceName, String catalogName, String schemaName) {
        if (this.ignoreCache()) {
            return null;
        }
        String relMdFileName = this.getPhysicalMetadataFileName(cmDataSourceName, catalogName, schemaName);
        try {
            File file = new File(relMdFileName);
            String dataDirString = FmPreferences.getInstance().getDataDirectory();
            File dataDir = new File(dataDirString);
            dataDir.mkdirs();
            if (!file.exists()) {
                file.createNewFile();
            }
            return new FileOutputStream(this.getPhysicalMetadataFileName(cmDataSourceName, catalogName, schemaName));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void deletePhysicalMetadataFile(String cmDsName, String catalog, String schema) {
        if (this.ignoreCache()) {
            return;
        }
        String relMdFileName = this.getPhysicalMetadataFileName(cmDsName, catalog, schema);
        File f = new File(relMdFileName);
        f.delete();
    }

    public void dumpToTemp(ProjectAccess.ProjectFile file, String prefix) {
        StringBuilder builder = new StringBuilder("..//temp//");
        builder.append(prefix);
        builder.append(System.nanoTime());
        builder.append(".xml");
        File blat = new File(builder.toString());
        try {
            FileOutputStream out = new FileOutputStream(blat);
            this.copyStream(this.getFile(file), out);
            out.close();
        }
        catch (FileNotFoundException e1) {
            FmEngApplicationLog.getApplicationLog().logException(e1);
        }
        catch (IOException e) {
            FmEngApplicationLog.getApplicationLog().logException(e);
        }
    }

    public int getSourceVersion() {
        return this.m_SourceVersion;
    }

    public int getCurrentVersion() {
        return this.m_CurrentVersion;
    }

    public InputStream getFile(ProjectAccess.ProjectFile file) {
        InputStream is = this.getRawFile(file);
        if (file != ProjectAccess.ProjectFile.MODEL_XML) {
            return is;
        }
        ExtractNamespace streamNamespace = new ExtractNamespace(is);
        ExtractNamespace currentNamespace = new ExtractNamespace("http://www.developer.cognos.com/schemas/bmt/60/13");
        if (!streamNamespace.isValid()) {
            throw new FmMDException("BMT_MD_BAD_MODEL", this.getFileName(ProjectAccess.ProjectFile.MODEL_XML));
        }
        if (!streamNamespace.getCanonicalNamespace().equals(currentNamespace.getCanonicalNamespace())) {
            throw new FmMDException("BMT_MD_BAD_MODEL", this.getFileName(ProjectAccess.ProjectFile.MODEL_XML));
        }
        if (streamNamespace.getMajor() < currentNamespace.getMajor()) {
            throw new FmMDException("BMT_MD_OLD_MODEL", this.getFileName(ProjectAccess.ProjectFile.MODEL_XML));
        }
        if (streamNamespace.getMajor() > currentNamespace.getMajor()) {
            throw new FmMDException("BMT_MD_NEWER_MODEL", this.getFileName(ProjectAccess.ProjectFile.MODEL_XML));
        }
        this.m_SourceVersion = streamNamespace.getMinor();
        this.m_CurrentVersion = currentNamespace.getMinor();
        is = this.getRawFile(file);
        if (this.m_SourceVersion == this.m_CurrentVersion) {
            return is;
        }
        if (this.m_SourceVersion > this.m_CurrentVersion) {
            throw new FmMDException("BMT_MD_NEWER_MODEL", this.getFileName(ProjectAccess.ProjectFile.MODEL_XML));
        }
        DebugUtil.GetInstance().debug("Start of upgrade", DebugUtil.CATEGORY.UPGRADE);
        DebugUtil.GetInstance().dumpMemory();
        File tempDir = new File("../temp");
        tempDir.mkdirs();
        InputStream oldIS = is;
        int sourceVersion = this.m_SourceVersion;
        while (sourceVersion < this.m_CurrentVersion) {
            UpgradeBase upgrader = this.getUpgrader(sourceVersion);
            File of = new File("..\\temp\\oldmodel_" + Long.toString(System.currentTimeMillis()) + "_" + Integer.toString(sourceVersion) + ".xml");
            sourceVersion = upgrader.upgrade(oldIS, of);
            of.deleteOnExit();
            try {
                oldIS = new FileInputStream(of);
            }
            catch (FileNotFoundException e) {
                FmEngApplicationLog.getApplicationLog().logException(e);
            }
        }
        FmMDException.ASSERT(oldIS != null, "Bad input stream");
        DebugUtil.GetInstance().debug("End of upgrade", DebugUtil.CATEGORY.UPGRADE);
        DebugUtil.GetInstance().dumpMemory();
        return oldIS;
    }

    private UpgradeBase getUpgrader(int oldVersion) {
        switch (oldVersion) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return new UpgradeUpTo4();
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return new UpgradeUpTo9();
            }
            case 9: 
            case 10: {
                return new UpgradeUpTo11();
            }
        }
        return new UpgradeGeneric(oldVersion);
    }
}

