/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.platform.impl.project;

import com.ibm.cognos.fmeng.platform.ProjectAccess;
import com.ibm.cognos.fmeng.platform.impl.project.Segment;
import com.ibm.cognos.fmeng.platform.impl.project.SegmentXLink;
import com.ibm.cognos.fmeng.utility.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectManager {
    private Document m_cpfDOM;
    private InputStream m_model;
    ProjectAccess m_access;

    public ProjectManager(ProjectAccess access) {
        this.m_access = access;
    }

    public void init() {
        if (this.m_access.hasFile(ProjectAccess.ProjectFile.CPF_FILE)) {
            InputStream cpfStream = this.m_access.getFile(ProjectAccess.ProjectFile.CPF_FILE);
            this.loadCPF(cpfStream);
        }
        if (this.m_access.hasFile(ProjectAccess.ProjectFile.MODEL_XML)) {
            InputStream modelStream = this.m_access.getFile(ProjectAccess.ProjectFile.MODEL_XML);
            this.setModel(modelStream);
        }
    }

    public ProjectAccess getAccess() {
        return this.m_access;
    }

    private void loadCPF(InputStream inStream) {
        try {
            SAXReader reader = new SAXReader();
            this.m_cpfDOM = reader.read(inStream);
            this.getModelSegments();
            this.populateModelStream();
        }
        catch (DocumentException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void setModel(InputStream inStream) {
        this.m_model = inStream;
    }

    public InputStream getModelStream() {
        return this.m_model;
    }

    void populateModelStream() {
        Element elm = (Element)this.m_cpfDOM.selectSingleNode("/Workspace/Model/Model_Data/Model_Segment");
        String model = elm.attributeValue("href");
        this.m_model = this.m_access.getRelativeFile(model);
    }

    public List<SegmentXLink> getModelSegments() {
        if (this.m_cpfDOM != null) {
            List list = this.m_cpfDOM.selectNodes("/Workspace/Model/Model_Data/SegmentLink");
            ArrayList<SegmentXLink> xLinks = new ArrayList<SegmentXLink>();
            for (Element elm : list) {
                SegmentXLink link = new SegmentXLink();
                this.populateLink(link, elm);
                xLinks.add(link);
            }
            return xLinks;
        }
        ArrayList<SegmentXLink> list = new ArrayList<SegmentXLink>(0);
        return list;
    }

    private void populateLink(SegmentXLink link, Element node) {
        Node from = node.selectSingleNode("@xl:from");
        Node to = node.selectSingleNode("@xl:to");
        link.setFrom(from.getText());
        link.setTo(to.getText());
    }

    public Segment getSegmentWithLabel(String label) {
        Node segment = this.m_cpfDOM.selectSingleNode("/Workspace/Model/Model_Data/Model_Segment[@xl:label='" + label + "']");
        if (segment == null) {
            segment = this.m_cpfDOM.selectSingleNode("/Workspace/Model/Model_Data/Project_Segment[@xl:label='" + label + "']");
            if (segment != null) {
                Segment seg = new Segment(Segment.SegmentType.eProjectSegement);
                this.populateSegment(seg, (Element)segment);
                return seg;
            }
            return null;
        }
        Segment seg = new Segment(Segment.SegmentType.eModelSegment);
        this.populateSegment(seg, (Element)segment);
        return seg;
    }

    private void populateSegment(Segment seg, Element node) {
        Node hrefId = node.selectSingleNode("@xl:hrefID");
        seg.setHrefId(hrefId.getText());
    }

    public ProjectManager getSegementManager(String projectPath) {
        ProjectManager proj = new ProjectManager(this.m_access.getProjectFileAccess(projectPath));
        proj.init();
        return proj;
    }

    public ProjectManager createNewProject(String cpfPath) {
        ProjectManager mgr = new ProjectManager(this.m_access.getProjectFileAccess(cpfPath));
        mgr.initializeDefaultModelFiles();
        mgr.init();
        return mgr;
    }

    private void initializeDefaultModelFiles() {
        char seperator = File.pathSeparatorChar;
        String projectPath = "../templates/bmt/Cr1Model/project.cpf";
        projectPath.replace('/', seperator);
        String modelPath = "../templates/bmt/Cr1Model/model.xml";
        modelPath.replace('/', seperator);
        try {
            FileInputStream inStream = new FileInputStream(projectPath);
            OutputStream outProj = this.m_access.getOutputStream(ProjectAccess.ProjectFile.CPF_FILE);
            FileUtils.copyStreams(inStream, outProj);
            FileInputStream inStreamModel = new FileInputStream(modelPath);
            OutputStream outModel = this.m_access.getOutputStream(ProjectAccess.ProjectFile.MODEL_XML);
            FileUtils.copyStreams(inStreamModel, outModel);
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io);
        }
    }

    public void updateAccess(ProjectAccess fileAccess) {
        this.m_access = fileAccess;
    }
}

