/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.utility;

import com.ibm.cognos.fmeng.fmmd.util.CmHelper;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.List;

public final class CMDataSourceResolver {
    private CmHelper mCMHelper = null;

    public CMDataSourceResolver(FMMDSession aSession) {
        this.mCMHelper = CmHelper.get(aSession, aSession.getPassport());
    }

    public ConnectionSpec resolveConnection(SelectionCriteria selectionParams) {
        ConnectionSpec outConnSpec = null;
        List<CmHelper.DSConnectionRecord> dsConnections = this.mCMHelper.queryDataSourceConnections(selectionParams.getCMDataSourceName());
        if (dsConnections.size() == 0) {
            FmMDException.ASSERT(false, "No connection found for data source:" + selectionParams.getCMDataSourceName());
        }
        outConnSpec = this.resolveSignon(selectionParams, dsConnections.get(0));
        return outConnSpec;
    }

    private ConnectionSpec resolveSignon(SelectionCriteria dsSelectionCriteria, CmHelper.DSConnectionRecord selectedConn) {
        ConnectionSpec outConnSpec = null;
        List<CmHelper.DSSignonRecord> dsSignons = this.mCMHelper.queryConnectionSignons(selectedConn.getSearchPath());
        outConnSpec = CMDataSourceResolver.makeConnectionSpec(dsSelectionCriteria, selectedConn, dsSignons.size() > 0 ? dsSignons.get(0) : null);
        return outConnSpec;
    }

    private static ConnectionSpec makeConnectionSpec(SelectionCriteria dsSelectionCriteria, CmHelper.DSConnectionRecord recordConnection, CmHelper.DSSignonRecord recordSignon) {
        ConnectionSpec outDSConn = new ConnectionSpec(dsSelectionCriteria.getCMDataSourceName());
        outDSConn.mConnectionName = recordConnection.getName();
        outDSConn.mConnectionString = recordConnection.getConnectionString();
        if (recordSignon != null) {
            outDSConn.mSignonUID = recordSignon.getUserName();
            outDSConn.mSignonPWD = recordSignon.getPassword();
        }
        return outDSConn;
    }

    public static final class ConnectionSpec {
        private String mDataSourceName = null;
        private String mDataSourceType = null;
        private String mConnectionName = null;
        private String mConnectionString = null;
        private String mSignonUID = null;
        private String mSignonPWD = null;

        private ConnectionSpec(String dataSourceName) {
            this.mDataSourceName = dataSourceName;
        }

        public String getLogicalName() {
            return this.mDataSourceName;
        }

        public String getDataSourceType() {
            if (this.mDataSourceType != null) {
                return this.mDataSourceType;
            }
            if (this.mConnectionString == null || this.mConnectionString.length() == 0) {
                return null;
            }
            int begin = this.mConnectionString.indexOf("LOCAL;");
            FmMDException.ASSERT(begin > 0, "Unexpected connection string format - missing LOCALE");
            int end = this.mConnectionString.indexOf(";", begin + 6);
            return this.mConnectionString.substring(begin + 6, end);
        }

        public String getConnectionName() {
            return this.mConnectionName;
        }

        public String getConnectionString() {
            return this.mConnectionString;
        }

        public String getSignonUserID() {
            return this.mSignonUID;
        }

        public String getSignonUserPWD() {
            return this.mSignonPWD;
        }
    }

    public static final class SelectionCriteria {
        private String mCMDataSourceName = null;
        private String mCMConnectionName = null;
        private String mCMConnectionPath = null;
        private String mCMSignonName = null;
        private String mCMSignonPath = null;
        private String mSignonUID = null;
        private String mSignonPWD = null;
        private String mCubeAuthPWD = null;
        private String mCubeAuthNamespace = null;

        public SelectionCriteria(String cmDataSourceName) {
            this.mCMDataSourceName = cmDataSourceName;
        }

        public String getCMDataSourceName() {
            return this.mCMDataSourceName;
        }

        public void setCMConnectionName(String cmConnectionName) {
            this.mCMConnectionName = cmConnectionName;
        }

        public String getCMConnectionName() {
            return this.mCMConnectionName;
        }

        public void setCMConnectionPath(String cmConnectionPath) {
            this.mCMConnectionPath = cmConnectionPath;
        }

        public String getCMConnectionPath() {
            return this.mCMConnectionPath;
        }

        public void setCMSignonName(String cmSignonName) {
            this.mCMSignonName = cmSignonName;
        }

        public String getCMSignonName() {
            return this.mCMSignonName;
        }

        public void setCMSignonPath(String cmSignonPath) {
            this.mCMSignonPath = cmSignonPath;
        }

        public String getCMSignonPath() {
            return this.mCMSignonPath;
        }

        public void setSignonUserID(String signonUID) {
            this.mSignonUID = signonUID;
        }

        public String getSignonUserID() {
            return this.mSignonUID;
        }

        public void setSignonPassword(String signonPWD) {
            this.mSignonPWD = signonPWD;
        }

        public String getSignonPassword() {
            return this.mSignonPWD;
        }

        public void setCubeAuthenticationPassword(String cubePWD) {
            this.mCubeAuthPWD = cubePWD;
        }

        public String getCubeAutnenticationPassword() {
            return this.mCubeAuthPWD;
        }

        public void setCubeAuthenticationNamespace(String cubeNamespace) {
            this.mCubeAuthNamespace = cubeNamespace;
        }

        public String getCubeAuthenticationNamespace() {
            return this.mCubeAuthNamespace;
        }
    }
}

