/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.utility;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmDbQuery;
import com.ibm.cognos.fmeng.fmmd.impl.task.ModelPublisher;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.DbQuery;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.FmUsage;
import com.ibm.cognos.fmeng.fmmd.model.ParameterMap;
import com.ibm.cognos.fmeng.fmmd.model.Project;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.metadata.MdBase;
import com.ibm.cognos.fmeng.metadata.MdCatalog;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdDatabase;
import com.ibm.cognos.fmeng.metadata.MdSchema;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.ProjectFactory;
import com.ibm.cognos.fmeng.utility.FmPreferences;
import com.ibm.cognos.fmeng.utility.soap.ReportServerRequestHelper;
import java.util.List;

public class DataSourceQuery {
    public void dumpTableDataToCSV(FMMDSession session, MdTable table, String csvFilePath) {
        FMMDSession newSession = FMMDSession.createFMMDSession(session);
        newSession.create(ProjectFactory.createInMemoryProject());
        newSession.setPassport(session.getPassport());
        Project project = newSession.getProject();
        ParameterMap governorMap = project.getGovernorParameterMap();
        governorMap.addEntry("maxRowsRetrieved", "60000");
        QuerySubject qs = this.createQuerySubject(project, table);
        ModelPublisher publisher = new ModelPublisher(newSession);
        String sModelPath = publisher.publishModelToCM("~~", "tmpPackage", Long.toString(System.nanoTime()), null);
        List<QueryItem> qis = qs.getAllQueryItems();
        ReportServerRequestHelper rsqh = new ReportServerRequestHelper(session);
        int maxRows = 5000;
        FmPreferences prefs = FmPreferences.getInstance();
        String prefValue = prefs.getFMPreference("AutoDesign", "maxRows");
        if (prefValue != null) {
            maxRows = Integer.valueOf(prefValue);
        }
        String xmlSpec = rsqh.buildReportRequest(sModelPath, "SimpleList", qis, maxRows);
        rsqh.runReportSpecificationSaveResultsToFile(session, xmlSpec, csvFilePath);
    }

    private QuerySubject createQuerySubject(Project project, MdTable table) {
        MdBase base = table.getParent();
        String schemaName = "";
        String catalogName = "";
        String dbName = "";
        while (base != null) {
            if (base instanceof MdSchema) {
                schemaName = base.getName();
            } else if (base instanceof MdCatalog) {
                catalogName = base.getName();
            } else if (base instanceof MdDatabase) {
                dbName = base.getName();
            }
            base = base.getParent();
        }
        DataSource dataSource = project.createDataSource(dbName);
        dataSource.setCatalogName(catalogName);
        dataSource.setSchemaName(schemaName);
        dataSource.setCmDataSourceName(dbName);
        QuerySubject qs = project.getRootNamespace().createDbQuerySubject(table.getName(), dataSource);
        DbQuery query = qs.getDBQuery();
        query.setSql("Select * from [" + dbName + "].\"" + table.getName() + "\"", QuerySubjectBase.TypeOfSql.cognosSQL);
        query.setTableType(FmDbQuery.TableType.table);
        List<MdColumn> columns = table.getColumns();
        for (MdColumn mdColumn : columns) {
            FmDatatype columnDataType = mdColumn.getDatatype();
            if (columnDataType == FmDatatype.BLOB) continue;
            QueryItem qi = qs.createExternalQueryItem(mdColumn.getName(), mdColumn.getName());
            qi.setDatatype(columnDataType);
            qi.setUsage(FmUsage.attribute);
        }
        return qs;
    }
}

